/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.util.SafeCloseable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL15C;

@Environment(value=EnvType.CLIENT)
public abstract class GpuMemory
implements SafeCloseable {
    public Thread thread = Thread.currentThread();
    public int binder;
    public int bindQuery;
    public long capacity;
    public int glID;

    public GpuMemory(long capacity, int binder, int bindQuery) {
        this.binder = binder;
        this.bindQuery = bindQuery;
        this.capacity = capacity;
        this.glID = this.nAllocate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nAllocate(boolean restore) {
        GLException.check();
        int oldID = restore ? GL15C.glGetInteger((int)this.bindQuery) : 0;
        GLException.check();
        int id = GL15C.glGenBuffers();
        try {
            GLException.check();
            GL15C.glBindBuffer((int)this.binder, (int)id);
            GLException.check();
            this.populateInitialData();
            GLException.check();
        }
        catch (Throwable throwable) {
            GL15C.glDeleteBuffers((int)id);
            AutoCodecUtil.rethrow((Throwable)throwable);
        }
        finally {
            if (restore) {
                GL15C.glBindBuffer((int)this.binder, (int)oldID);
            }
        }
        return id;
    }

    public abstract void populateInitialData();

    public void checkThread() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("Calling on wrong thread! Expected " + String.valueOf(this.thread) + ", got " + String.valueOf(Thread.currentThread()));
        }
    }

    public int ensureOpen() {
        int id = this.glID;
        if (id != 0) {
            return id;
        }
        throw new IllegalStateException("Already closed");
    }

    public SafeCloseable bind() {
        this.checkThread();
        int id = this.ensureOpen();
        int old = GL15C.glGetInteger((int)this.bindQuery);
        GLException.check();
        if (old == id) {
            return SafeCloseable.NOOP;
        }
        GL15C.glBindBuffer((int)this.binder, (int)id);
        GLException.check();
        return () -> {
            GLException.check();
            GL15C.glBindBuffer((int)this.binder, (int)old);
            GLException.check();
        };
    }

    @Override
    public void close() {
        this.checkThread();
        int glID = this.glID;
        if (glID != 0) {
            this.glID = 0;
            this.capacity = 0L;
            GL15C.glDeleteBuffers((int)glID);
        }
    }
}

