/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.autocodec.util.DFUVersions;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.rendering.lods.LightweightSection;
import builderb0y.bigglobe.util.AsyncRunner;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2804;
import net.minecraft.class_2841;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_6490;
import net.minecraft.class_6502;
import org.jetbrains.annotations.Nullable;

public class LightweightChunk {
    public final int minY;
    public final int maxY;
    public final class_1923 pos;
    public final BlockSegmentList[] columns;

    public LightweightChunk(class_5539 world, class_1923 pos) {
        this.minY = HeightLimitViewVersions.getMinY(world);
        this.maxY = HeightLimitViewVersions.getMaxY(world);
        this.pos = pos;
        this.columns = new BlockSegmentList[ColumnIndexRange.LOD4.end];
    }

    public void update(class_3218 world, class_2499 sectionsNBT, BlockSegmentList @Nullable [] cullingData) {
        int minChunkSectionY = this.minY >> 4;
        int maxChunkSectionY = this.maxY >> 4;
        LightweightSection[] sections = new LightweightSection[maxChunkSectionY - minChunkSectionY];
        try (AsyncRunner async = new AsyncRunner(BigGlobeThreadPool.lodExecutor());){
            for (class_2520 element : sectionsNBT) {
                class_2487 compound = (class_2487)element;
                async.submit(() -> {
                    class_2520 containerNBT;
                    class_2514 nbtNumber;
                    int y;
                    class_2520 patt0$temp = compound.method_10580("Y");
                    if (patt0$temp instanceof class_2514 && (y = (nbtNumber = (class_2514)patt0$temp).method_10701()) >= minChunkSectionY && y < maxChunkSectionY && (containerNBT = compound.method_10580("block_states")) != null) {
                        DataResult containerResult = class_2852.field_34576.parse((DynamicOps)class_2509.field_11560, (Object)containerNBT);
                        class_2841 container = (class_2841)DFUVersions.getResult((DataResult)containerResult);
                        if (container != null) {
                            byte[] byArray;
                            class_2520 patt1$temp = compound.method_10580("SkyLight");
                            if (patt1$temp instanceof class_2479) {
                                class_2479 byteArray = (class_2479)patt1$temp;
                                byArray = byteArray.method_10521();
                            } else {
                                byArray = null;
                            }
                            byte[] skylight = byArray;
                            sections[y - minChunkSectionY] = new LightweightSection((class_2841<class_2680>)container, skylight != null ? new class_2804(skylight) : null);
                        } else {
                            BigGlobeMod.LOGGER.error("Error while reading chunk data for LODs: " + DFUVersions.getMessage((DataResult)containerResult));
                        }
                    }
                });
            }
        }
        this.update(sections, cullingData);
    }

    public void update(final LightweightSection[] sections, final BlockSegmentList @Nullable [] cullingData) {
        final int minBlockY = this.minY;
        final int maxBlockY = this.maxY;
        final int minSectionY = minBlockY >> 4;
        final int maxSectionY = maxBlockY >> 4;
        final BlockSegmentList[] columns = this.columns;
        final int verticalCompression = BigGlobeConfig.INSTANCE.get().lodRendering.verticalCompression;
        final int caveCullingDepth = BigGlobeConfig.INSTANCE.get().lodRendering.caveCullingDepth;
        try (AsyncRunner async = BigGlobeThreadPool.lodRunner();){
            int columnIndex = 0;
            for (int lod = 0; lod <= 4; ++lod) {
                final int lod_ = lod;
                final int lodShift = 4 - lod;
                final int lodSize = 1 << lodShift;
                final int sectionOffset = LightweightSection.SectionIndexRange.VALUES[lod].start;
                for (int z = 0; z < lodSize; ++z) {
                    final int z_ = z;
                    int x = 0;
                    while (x < lodSize) {
                        final int x_ = x++;
                        final int columnIndex_ = columnIndex++;
                        async.submit(new Runnable(){
                            final /* synthetic */ LightweightChunk this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                int startY;
                                BlockSegmentList list = new BlockSegmentList(minBlockY >> lod_, (maxBlockY - 1 >> lod_) + 1);
                                int endY = startY = list.minY;
                                int prevLightLevel = 0;
                                class_2680 state = BlockStates.VOID_AIR;
                                for (int sectionY = minSectionY; sectionY < maxSectionY; ++sectionY) {
                                    LightweightSection.LightLevelStorage lightLevels;
                                    LightweightSection section = sections[sectionY - minSectionY];
                                    if (section == null) {
                                        if (state != BlockStates.AIR) {
                                            this.addSegment(list, startY, endY, state, prevLightLevel);
                                            state = BlockStates.AIR;
                                            startY = endY;
                                        }
                                        endY += lodSize;
                                        continue;
                                    }
                                    class_6490 storage = lod_ == 0 ? section.mainBlocks : section.lodBlocks;
                                    LightweightSection.LightLevelStorage lightLevelStorage = lightLevels = lod_ == 0 ? section.mainSkylight : section.lodSkylight;
                                    if (storage instanceof class_6502) {
                                        class_2680 newState = (class_2680)section.palette.method_12288(0);
                                        if (state != newState) {
                                            this.addSegment(list, startY, endY, state, prevLightLevel);
                                            state = newState;
                                            startY = endY;
                                        }
                                        if (lightLevels != null) {
                                            int index = (lodSize - 1 << (lodShift << 1) | z_ << lodShift | x_) + sectionOffset;
                                            prevLightLevel = lightLevels.get(index);
                                        }
                                        endY += lodSize;
                                        continue;
                                    }
                                    int id = -1;
                                    class_2680 newState = null;
                                    for (int localY = 0; localY < lodSize; ++localY) {
                                        int index = (localY << (lodShift << 1) | z_ << lodShift | x_) + sectionOffset;
                                        int newID = storage.method_15211(index);
                                        if (newID != id) {
                                            id = newID;
                                            newState = (class_2680)section.palette.method_12288(id);
                                        }
                                        if (newState != state) {
                                            this.addSegment(list, startY, endY, state, prevLightLevel);
                                            startY = endY;
                                            state = newState;
                                        }
                                        if (lightLevels != null) {
                                            prevLightLevel = lightLevels.get(index);
                                        }
                                        ++endY;
                                    }
                                }
                                this.addSegment(list, startY, endY, state, prevLightLevel);
                                if (cullingData != null) {
                                    this.cull(list, cullingData[columnIndex_]);
                                }
                                list.trim();
                                columns[columnIndex_] = list;
                            }

                            public void addSegment(BlockSegmentList list, int minY, int maxY, class_2680 state, int skylight) {
                                if (maxY == list.minY) {
                                    return;
                                }
                                if (BlockStateVersions.getCullingShape(state, (class_1922)class_2682.field_12294, class_2338.field_10980) == class_259.method_1077()) {
                                    int index = list.size();
                                    while (--index >= 0) {
                                        BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)list.get(index);
                                        if (segment.value == state) {
                                            list.size(index + 1);
                                            segment.maxY = maxY - 1;
                                            segment.skylightLevel = (byte)skylight;
                                            return;
                                        }
                                        if (segment.minY >= minY - verticalCompression && BlockStateVersions.getCullingShape((class_2680)segment.value, (class_1922)class_2682.field_12294, class_2338.field_10980) == class_259.method_1077()) continue;
                                        break;
                                    }
                                }
                                assert (list.isEmpty() || ((BlockSegmentList.LitSegment)list.getLast()).maxY() == minY);
                                BlockSegmentList.LitSegment segment = new BlockSegmentList.LitSegment(minY, maxY - 1);
                                segment.value = state;
                                segment.skylightLevel = (byte)skylight;
                                list.add(segment);
                            }

                            public void cull(BlockSegmentList real, BlockSegmentList cull) {
                                int size = cull.size();
                                for (int cullIndex = 0; cullIndex < size; ++cullIndex) {
                                    int topIndex;
                                    BlockSegmentList.LitSegment cullSegment = (BlockSegmentList.LitSegment)cull.get(cullIndex);
                                    if (BlockStateVersions.isOpaqueFullCube((class_2680)cullSegment.value, (class_1922)class_2682.field_12294, class_2338.field_10980)) continue;
                                    if (cullIndex == 0) {
                                        return;
                                    }
                                    for (topIndex = real.getSegmentIndex(cullSegment.minY - caveCullingDepth, false); topIndex >= 0 && !BlockStateVersions.isOpaqueFullCube((class_2680)((BlockSegmentList.LitSegment)real.get((int)topIndex)).value, (class_1922)class_2682.field_12294, class_2338.field_10980); --topIndex) {
                                    }
                                    if (--topIndex < 0) continue;
                                    BlockSegmentList.LitSegment top = (BlockSegmentList.LitSegment)real.get(topIndex);
                                    BlockSegmentList.LitSegment replacement = (BlockSegmentList.LitSegment)cull.get(cullIndex - 1);
                                    BlockSegmentList.LitSegment added = (BlockSegmentList.LitSegment)real.addSegment(real.minY, top.maxY, (class_2680)replacement.value);
                                    if (added != null) {
                                        added.skylightLevel = replacement.skylightLevel;
                                    }
                                    return;
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    public BlockSegmentList getColumn(int x, int z, int level) {
        int shift = 4 - level;
        int mask = (1 << shift) - 1;
        int packed = (z & mask) << shift | x & mask;
        ColumnIndexRange range = ColumnIndexRange.VALUES[level];
        assert (packed >= 0 && packed < range.end - range.start);
        return this.columns[packed + range.start];
    }

    public class_2680 getBlockState(int x, int y, int z) {
        BlockSegmentList column = this.columns[(z & 0xF) << 4 | x & 0xF];
        if (column == null) {
            return BlockStates.VOID_AIR;
        }
        class_2680 state = column.getBlockState(y);
        if (state == null) {
            return BlockStates.VOID_AIR;
        }
        return state;
    }

    public static enum ColumnIndexRange {
        LOD0(0, 256),
        LOD1(ColumnIndexRange.LOD0.end, ColumnIndexRange.LOD0.end + 64),
        LOD2(ColumnIndexRange.LOD1.end, ColumnIndexRange.LOD1.end + 16),
        LOD3(ColumnIndexRange.LOD2.end, ColumnIndexRange.LOD2.end + 4),
        LOD4(ColumnIndexRange.LOD3.end, ColumnIndexRange.LOD3.end + 1);

        public static final ColumnIndexRange[] VALUES;
        public final int start;
        public final int end;

        private ColumnIndexRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        static {
            VALUES = ColumnIndexRange.values();
        }
    }
}

