/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.perSection.SectionUtil;
import builderb0y.bigglobe.versions.BlockStateVersions;
import java.util.Arrays;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2804;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_3508;
import net.minecraft.class_6490;
import net.minecraft.class_6502;
import org.jetbrains.annotations.Nullable;

public class LightweightSection {
    public final class_2837<class_2680> palette;
    public final class_6490 mainBlocks;
    public final class_6490 lodBlocks;
    @Nullable
    public final LightLevelStorage mainSkylight;
    @Nullable
    public final LightLevelStorage lodSkylight;

    public LightweightSection(class_2841<class_2680> container, @Nullable class_2804 skylight) {
        this.palette = SectionUtil.palette(container);
        this.mainBlocks = SectionUtil.storage(container);
        if (this.mainBlocks instanceof class_6502) {
            this.lodBlocks = new class_6502(SectionIndexRange.LOD4.end);
        } else {
            this.lodBlocks = new class_3508(this.mainBlocks.method_34896(), SectionIndexRange.LOD4.end);
            CountsMap counts = new CountsMap();
            LightweightSection.mip((srcLod, srcIndex, srcShift, dstIndex) -> this.lodBlocks.method_15210(dstIndex, this.computeMostCommonBlock(srcLod == 0 ? this.mainBlocks : this.lodBlocks, counts, srcIndex, srcShift)));
        }
        LightLevelStorage lightLevelStorage = this.mainSkylight = skylight != null && skylight.field_12783 != null ? new LightLevelStorage(skylight) : null;
        if (this.mainSkylight == null) {
            this.lodSkylight = this.mainSkylight;
        } else {
            this.lodSkylight = LightLevelStorage.forLength(SectionIndexRange.LOD4.end);
            LightweightSection.mip((srcLod, srcIndex, srcShift, dstIndex) -> this.lodSkylight.set(dstIndex, LightweightSection.computeMaxLightLevel(srcLod == 0 ? this.mainSkylight : this.lodSkylight, srcIndex, srcShift)));
        }
    }

    public static void mip(Mipper mipper) {
        for (int srcLod = 0; srcLod < 4; ++srcLod) {
            int dstLod = srcLod + 1;
            int srcShift = 4 - srcLod;
            int dstShift = 4 - dstLod;
            int dstSectionSize = 1 << dstShift;
            int srcBase = SectionIndexRange.VALUES[srcLod].start;
            int dstBase = SectionIndexRange.VALUES[dstLod].start;
            int srcY = 0;
            for (int dstY = 0; dstY < dstSectionSize; ++dstY) {
                int srcZ = 0;
                for (int dstZ = 0; dstZ < dstSectionSize; ++dstZ) {
                    int srcX = 0;
                    for (int dstX = 0; dstX < dstSectionSize; ++dstX) {
                        int srcIndex = (srcY << (srcShift << 1) | srcZ << srcShift | srcX) + srcBase;
                        int dstIndex = (dstY << (dstShift << 1) | dstZ << dstShift | dstX) + dstBase;
                        mipper.mip(srcLod, srcIndex, srcShift, dstIndex);
                        srcX += 2;
                    }
                    srcZ += 2;
                }
                srcY += 2;
            }
        }
    }

    public int computeMostCommonBlock(class_6490 storage, CountsMap counts, int baseIndex, int shift) {
        int offsetX = 1;
        int offsetZ = 1 << shift;
        int offsetY = 1 << (shift << 1);
        counts.increment(storage.method_15211(baseIndex));
        counts.increment(storage.method_15211(baseIndex + offsetX));
        counts.increment(storage.method_15211(baseIndex + offsetZ));
        counts.increment(storage.method_15211(baseIndex + offsetZ + offsetX));
        counts.increment(storage.method_15211(baseIndex + offsetY));
        counts.increment(storage.method_15211(baseIndex + offsetY + offsetX));
        counts.increment(storage.method_15211(baseIndex + offsetY + offsetZ));
        counts.increment(storage.method_15211(baseIndex + offsetY + offsetZ + offsetX));
        int bestValue = counts.getMostCommonID(this.palette);
        counts.clear();
        return bestValue;
    }

    public static int computeMaxLightLevel(LightLevelStorage storage, int baseIndex, int shift) {
        int offsetX = 1;
        int offsetZ = 1 << shift;
        int offsetY = 1 << (shift << 1);
        int level = storage.get(baseIndex);
        level = Math.max(level, storage.get(baseIndex + offsetX));
        level = Math.max(level, storage.get(baseIndex + offsetZ));
        level = Math.max(level, storage.get(baseIndex + offsetZ + offsetX));
        level = Math.max(level, storage.get(baseIndex + offsetY));
        level = Math.max(level, storage.get(baseIndex + offsetY + offsetX));
        level = Math.max(level, storage.get(baseIndex + offsetY + offsetZ));
        level = Math.max(level, storage.get(baseIndex + offsetY + offsetZ + offsetX));
        return level;
    }

    public static enum SectionIndexRange {
        LOD0(0, 4096, false),
        LOD1(0, 512, true),
        LOD2(SectionIndexRange.LOD1.end, SectionIndexRange.LOD1.end + 64, true),
        LOD3(SectionIndexRange.LOD2.end, SectionIndexRange.LOD2.end + 8, true),
        LOD4(SectionIndexRange.LOD3.end, SectionIndexRange.LOD3.end + 1, true);

        public static final SectionIndexRange[] VALUES;
        public final int start;
        public final int end;
        public final boolean useLodStorage;

        private SectionIndexRange(int start, int end, boolean storage) {
            this.start = start;
            this.end = end;
            this.useLodStorage = storage;
        }

        static {
            VALUES = SectionIndexRange.values();
        }
    }

    public static class CountsMap {
        public final int[] counts = new int[8];

        public void increment(int id) {
            int[] counts = this.counts;
            int index = id & 7;
            while (true) {
                int value;
                if (((value = counts[index]) & 0xFFFF) == id) {
                    this.counts[index] = value += 65536;
                    return;
                }
                if (value == 0) {
                    this.counts[index] = value = id | 0x10000;
                    return;
                }
                index = index + 1 & 7;
            }
        }

        public void clear() {
            Arrays.fill(this.counts, 0);
        }

        public int getMostCommonID(class_2837<class_2680> palette) {
            int mostCommonId = 65535;
            class_2680 mostCommonState = BlockStates.AIR;
            for (int newValue : this.counts) {
                class_2680 state;
                int compare;
                if (newValue <= 65535 || (compare = CountsMap.compare(mostCommonState, state = (class_2680)palette.method_12288(newValue & 0xFFFF))) <= 0 && (compare != 0 || newValue <= mostCommonId)) continue;
                mostCommonId = newValue;
                mostCommonState = state;
            }
            if (mostCommonId == 65535) {
                throw new AssertionError();
            }
            return mostCommonId & 0xFFFF;
        }

        public static int compare(class_2680 oldState, class_2680 newState) {
            int compare = Boolean.compare(BlockStateVersions.getCullingShape(newState, (class_1922)class_2682.field_12294, class_2338.field_10980) == class_259.method_1077(), BlockStateVersions.getCullingShape(oldState, (class_1922)class_2682.field_12294, class_2338.field_10980) == class_259.method_1077());
            if (compare != 0) {
                return compare;
            }
            return Boolean.compare(CountsMap.isPlantLike(newState), CountsMap.isPlantLike(oldState));
        }

        public static boolean isPlantLike(class_2680 state) {
            return !state.method_26215() && state.method_26227().method_15759() != state;
        }
    }

    @FunctionalInterface
    public static interface Mipper {
        public void mip(int var1, int var2, int var3, int var4);
    }

    public static class LightLevelStorage {
        public final byte[] payload;

        public static LightLevelStorage forLength(int length) {
            return new LightLevelStorage(new byte[length + 1 >> 1]);
        }

        public LightLevelStorage(byte[] payload) {
            this.payload = payload;
        }

        public LightLevelStorage(class_2804 array) {
            this.payload = array.field_12783;
        }

        public int get(int index) {
            return this.payload[index >> 1] >> ((index & 1) << 2) & 0xF;
        }

        public void set(int index, int newValue) {
            int shift = (index & 1) << 2;
            this.payload[index >>= 1] = (byte)(this.payload[index] & ~(15 << shift) | newValue << shift);
        }
    }
}

