/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.rendering.GpuMemory;
import builderb0y.bigglobe.rendering.OutOfVramException;
import builderb0y.bigglobe.rendering.lods.CompactVertexFormat;
import builderb0y.bigglobe.util.SafeCloseable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class VertexHeap
extends GpuMemory {
    public static final boolean AGGRESSIVE_ASSERTS = false;
    public TreeMapHelper<SliceKey, Slice> byPosition = new TreeMapHelper(SliceKey.POSITION_FIRST);
    public TreeMapHelper<SliceKey, Slice> bySize = new TreeMapHelper(SliceKey.LENGTH_FIRST);

    public VertexHeap(CompactVertexFormat format, long quadCount) {
        super(quadCount * (long)format.byteStride * 4L, 34962, 34964);
        new Slice(this, new SliceKey(0L, this.capacity), false).addToTree();
    }

    @Override
    public void populateInitialData() {
        GL32C.glBufferData((int)this.binder, (long)this.capacity, (int)35048);
    }

    public boolean isEmpty() {
        return this.byPosition.isEmpty();
    }

    public long used() {
        Slice slice = this.byPosition.lastValue();
        return slice != null ? slice.key.end() : 0L;
    }

    public long reallyUsed() {
        return this.byPosition.values().stream().mapToLong(slice -> slice.key.length).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        block22: {
            this.checkThread();
            File root = new File("bigglobe_vertex_heap_dump");
            root.mkdir();
            for (File existing : root.listFiles()) {
                if (!existing.getPath().endsWith(".dat") || !existing.isFile()) continue;
                existing.delete();
            }
            if (this.isEmpty()) {
                BigGlobeMod.LOGGER.info("VertexHeap is empty. Nothing to dump.");
                return;
            }
            try (SafeCloseable $ = this.bind();){
                long heapPointer = GL32C.nglMapBuffer((int)this.binder, (int)35000);
                if (heapPointer != 0L) {
                    try {
                        int sliceIndex = 0;
                        for (Slice slice : this.byPosition.values()) {
                            String fileName = sliceIndex + " [" + slice.key.position() + " + " + slice.key.length + " = " + slice.key.end() + "].dat";
                            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(new File(root, fileName)));){
                                for (long byteIndex = 0L; byteIndex < slice.key.length; ++byteIndex) {
                                    ((OutputStream)stream).write(MemoryUtil.memGetByte((long)(heapPointer + slice.key.position + byteIndex)));
                                }
                            }
                            catch (IOException exception) {
                                BigGlobeMod.LOGGER.error("Failed to dump slice " + fileName + ":", (Throwable)exception);
                            }
                            ++sliceIndex;
                        }
                        break block22;
                    }
                    finally {
                        GL32C.glUnmapBuffer((int)this.binder);
                    }
                }
                BigGlobeMod.LOGGER.warn("Failed to map vertex heap for dumping");
            }
        }
    }

    public void assertAggressively() {
        Slice[] allSlices;
        for (Slice slice2 : allSlices = (Slice[])Stream.concat(this.byPosition.values().stream(), this.bySize.values().stream()).sorted(Comparator.comparing(slice -> slice.key, SliceKey.POSITION_FIRST)).toArray(Slice[]::new)) {
            assert ((slice2.inUse ? this.byPosition : this.bySize).get(slice2.key) == slice2) : "Mismatched slice!";
        }
        assert (allSlices[0].key.position() == 0L) : "First slice does not start at byte 0";
        int limit = allSlices.length - 1;
        for (int index = 0; index < limit; ++index) {
            Slice lower = allSlices[index];
            Slice higher = allSlices[index + 1];
            assert (lower.key.end() == higher.key.position()) : "Adjacent slices don't touch";
        }
        assert (allSlices[allSlices.length - 1].key.end() == this.capacity) : "Last slice does not end at capacity";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.checkThread();
        long oldUsed = this.used();
        long currentOffset = 0L;
        Slice slice = this.byPosition.firstValue();
        while (slice != null) {
            if (slice.key.position != currentOffset) {
                this.bySize.clear();
                try (SafeCloseable $ = this.bind();){
                    long heapPointer = GL32C.nglMapBufferRange((int)this.binder, (long)currentOffset, (long)(((SliceKey)this.byPosition.lastKey()).end() - currentOffset), (int)3) - currentOffset;
                    if (heapPointer != 0L) {
                        try {
                            while (slice != null) {
                                slice.move(heapPointer, currentOffset);
                                currentOffset += slice.key.length;
                                slice = this.byPosition.higherValue(slice.key);
                            }
                        }
                        finally {
                            if (!GL32C.glUnmapBuffer((int)this.binder)) {
                                throw new GLException("Failed to unmap buffer");
                            }
                        }
                    } else {
                        BigGlobeMod.LOGGER.warn("Failed to map vertex heap for de-fragmenting!");
                    }
                }
                if (currentOffset == this.capacity) break;
                new Slice(this, new SliceKey(currentOffset, this.capacity - currentOffset), false).addToTree();
                break;
            }
            currentOffset += slice.key.length();
            slice = this.byPosition.higherValue(slice.key);
        }
        BigGlobeMod.LOGGER.info("LOD VertexHeap de-fragmented " + (oldUsed - currentOffset) + " byte(s): " + oldUsed + " -> " + currentOffset);
    }

    @Nullable
    public Slice allocate(long address, long size) {
        this.checkThread();
        if (size <= 0L) {
            return null;
        }
        SliceKey replacementKey = new SliceKey(Long.MAX_VALUE, size);
        Slice slice = this.bySize.ceilingValue(replacementKey);
        if (slice == null) {
            this.cleanup();
            slice = this.bySize.ceilingValue(replacementKey);
            if (slice == null) {
                throw new OutOfVramException();
            }
        }
        assert (!slice.inUse) : "Node in use is in bySize tree!";
        long oldSize = slice.key.length;
        if (oldSize != size) {
            slice.removeFromTree();
            slice.inUse = true;
            slice.key = slice.key.withLength(size);
            slice.addToTree();
            new Slice(this, new SliceKey(slice.key.end(), oldSize - size), false).addToTree();
        } else {
            slice.setInUse(true);
        }
        try (SafeCloseable $ = this.bind();){
            GL32C.nglBufferSubData((int)this.binder, (long)slice.key.position, (long)size, (long)address);
        }
        return slice;
    }

    public void markUnused(Slice removed) {
        this.checkThread();
        if (!removed.inUse) {
            return;
        }
        Slice prev = null;
        if (removed.key.position() != 0L) {
            prev = this.byPosition.lowerValue(removed.key);
            if (prev == null) {
                prev = (Slice)this.bySize.get(new SliceKey(0L, removed.key.position()));
                assert (prev != null) : "Vacuum in vertex heap!";
            } else if (prev.inUse) {
                if (prev.key.end() != removed.key.position()) {
                    prev = (Slice)this.bySize.get(new SliceKey(prev.key.end(), removed.key.position() - prev.key.end()));
                    assert (prev != null) : "Vacuum in vertex heap!";
                } else {
                    prev = null;
                }
            }
        }
        Slice next = null;
        if (removed.key.end() != this.capacity) {
            next = this.byPosition.higherValue(removed.key);
            if (next == null) {
                next = (Slice)this.bySize.get(new SliceKey(removed.key.end(), this.capacity - removed.key.end()));
                assert (next != null) : "Vacuum in vertex heap!";
            } else if (next.inUse) {
                if (next.key.position() != removed.key.end()) {
                    next = (Slice)this.bySize.get(new SliceKey(removed.key.end(), next.key.position() - removed.key.end()));
                    assert (next != null) : "Vacuum in vertex heap!";
                } else {
                    next = null;
                }
            }
        }
        assert (prev == null || !prev.inUse);
        assert (next == null || !next.inUse);
        if (prev != null) {
            long newLength;
            if (next != null) {
                newLength = next.key.end() - prev.key.position();
                next.removeFromTree();
            } else {
                newLength = removed.key.end() - prev.key.position();
            }
            removed.removeFromTree();
            prev.removeFromTree();
            prev.key = prev.key.withLength(newLength);
            prev.addToTree();
        } else if (next != null) {
            long newLength = next.key.end() - removed.key.position();
            next.removeFromTree();
            removed.removeFromTree();
            removed.inUse = false;
            removed.key = removed.key.withLength(newLength);
            removed.addToTree();
        } else {
            removed.setInUse(false);
        }
    }

    public static class TreeMapHelper<K, V>
    extends TreeMap<K, V> {
        public TreeMapHelper(Comparator<? super K> comparator) {
            super(comparator);
        }

        public V firstValue() {
            Map.Entry entry = this.firstEntry();
            return entry != null ? (V)entry.getValue() : null;
        }

        public V lastValue() {
            Map.Entry entry = this.lastEntry();
            return entry != null ? (V)entry.getValue() : null;
        }

        public V lowerValue(K key) {
            Map.Entry entry = this.lowerEntry(key);
            return entry != null ? (V)entry.getValue() : null;
        }

        public V floorValue(K key) {
            Map.Entry entry = this.floorEntry(key);
            return entry != null ? (V)entry.getValue() : null;
        }

        public V higherValue(K key) {
            Map.Entry entry = this.higherEntry(key);
            return entry != null ? (V)entry.getValue() : null;
        }

        public V ceilingValue(K key) {
            Map.Entry entry = this.ceilingEntry(key);
            return entry != null ? (V)entry.getValue() : null;
        }
    }

    public record SliceKey(long position, long length) {
        public static final SliceKey ZERO = new SliceKey(0L, 0L);
        public static final Comparator<SliceKey> POSITION_FIRST = (slice1, slice2) -> {
            int compare = Long.compare(slice1.position, slice2.position);
            return compare != 0 ? compare : Long.compare(slice1.length, slice2.length);
        };
        public static final Comparator<SliceKey> LENGTH_FIRST = (slice1, slice2) -> {
            int compare = Long.compare(slice1.length, slice2.length);
            return compare != 0 ? compare : Long.compare(slice1.position, slice2.position);
        };

        public long end() {
            return this.position + this.length;
        }

        public SliceKey withPosition(long position) {
            return new SliceKey(position, this.length);
        }

        public SliceKey withLength(long length) {
            return new SliceKey(this.position, length);
        }
    }

    public static class Slice
    implements SafeCloseable {
        public final VertexHeap heap;
        public SliceKey key;
        public boolean inUse;

        public String toString() {
            return "Slice[" + this.key.position + " + " + this.key.length + " = " + this.key.end() + "] (" + (this.inUse ? "used" : "unused") + ")";
        }

        public Slice(VertexHeap heap, SliceKey key, boolean inUse) {
            this.heap = heap;
            this.key = key;
            this.inUse = inUse;
        }

        public void move(long heapPointer, long newPosition) {
            assert (this.inUse) : "Moving non-in-use slice!";
            long length = this.key.length;
            for (long offset = 0L; offset < length; offset += 4L) {
                MemoryUtil.memPutInt((long)(heapPointer + newPosition + offset), (int)MemoryUtil.memGetInt((long)(heapPointer + this.key.position + offset)));
            }
            this.removeFromTree();
            this.key = this.key.withPosition(newPosition);
            this.addToTree();
        }

        public void setInUse(boolean inUse) {
            if (this.inUse == inUse) {
                return;
            }
            this.removeFromTree();
            this.inUse = inUse;
            this.addToTree();
        }

        @Override
        public void close() {
            this.heap.markUnused(this);
        }

        public void addToTree() {
            (this.inUse ? this.heap.byPosition : this.heap.bySize).put(this.key, this);
        }

        public void removeFromTree() {
            (this.inUse ? this.heap.byPosition : this.heap.bySize).remove(this.key);
        }
    }
}

