/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.waypoints;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.rendering.EmptyVertexArray;
import builderb0y.bigglobe.rendering.FilteredTextureState;
import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.rendering.GlState;
import builderb0y.bigglobe.rendering.Matrices;
import builderb0y.bigglobe.rendering.MatrixStorageWorkaround;
import builderb0y.bigglobe.rendering.NativeMemory;
import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.TextureState;
import builderb0y.bigglobe.rendering.waypoints.ScratchColorBuffer;
import builderb0y.bigglobe.rendering.waypoints.WaypointWarpShader;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.versions.RenderVersions;
import java.util.TreeSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL32C;

public class WaypointWarpRenderer
implements SafeCloseable {
    public static WaypointWarpRenderer INSTANCE;
    public ScratchColorBuffer framebuffer;
    public WaypointWarpShader shader;
    public EmptyVertexArray vertices;
    public MatrixStorageWorkaround matrices;
    public NativeMemory waypointData;
    public WaypointWarpGlState glState;
    public TreeSet<VisibleWaypointData> visibleWaypoints;

    public static void init() {
        try {
            INSTANCE = new WaypointWarpRenderer();
            WorldRenderEvents.BEFORE_DEBUG_RENDER.register(context -> {
                WaypointWarpRenderer renderer = INSTANCE;
                if (renderer != null && !renderer.visibleWaypoints.isEmpty()) {
                    renderer.draw();
                    renderer.endFrame();
                }
            });
        }
        catch (Exception exception) {
            BigGlobeMod.LOGGER.error("Waypoint warp renderer unavailable:", (Throwable)exception);
        }
    }

    @Override
    public void close() {
        ResourceTracker.closeAll(this.framebuffer, this.shader, this.vertices, this.matrices, this.waypointData);
    }

    public WaypointWarpRenderer() {
        String message = GLException.checkMessage();
        if (message != null) {
            BigGlobeMod.LOGGER.warn("A GLException occurred just before setting up the waypoint warp renderer: " + message);
        }
        try {
            this.framebuffer = new ScratchColorBuffer();
            this.shader = new WaypointWarpShader();
            this.vertices = new EmptyVertexArray();
            this.matrices = new MatrixStorageWorkaround();
            this.waypointData = new NativeMemory(256L);
            this.glState = new WaypointWarpGlState();
            this.visibleWaypoints = new TreeSet();
        }
        catch (Throwable throwable) {
            this.close();
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }

    public void draw() {
        String existingMessage = GLException.checkMessage();
        if (existingMessage != null) {
            BigGlobeMod.LOGGER.warn("Caught GL exception from some other unknown mod right before waypoint warp rendering: " + existingMessage);
        }
        try {
            this.doDraw();
        }
        catch (RuntimeException exception) {
            BigGlobeMod.LOGGER.error("An exception occurred while rendering the waypoint warp effect. The waypoint warp effect will now disable itself to prevent further problems.", (Throwable)exception);
            this.close();
            INSTANCE = null;
        }
    }

    public void doDraw() {
        this.glState.capture();
        class_276 framebuffer = class_310.method_1551().method_1522();
        this.framebuffer.ensureSize(framebuffer.field_1482, framebuffer.field_1481);
        this.glState.setFramebuffer(this.framebuffer.fbo);
        this.glState.setViewport(0, 0, framebuffer.field_1482, framebuffer.field_1481);
        this.glState.setVao(this.vertices.vao);
        this.glState.setCullFace(false);
        this.glState.setDepthRead(false);
        this.glState.setDepthWrite(false);
        this.glState.setBlend(false);
        this.glState.setColorMask(true, true, true, true);
        this.glState.setProgram(this.shader.program);
        this.glState.colortex.set(RenderVersions.colorAttachment(framebuffer), 9729, 9729, 33648, 33648);
        GL32C.glUniform1i((int)this.shader.colortex, (int)0);
        this.glState.depthtex.set(RenderVersions.depthAttachment(framebuffer), 9729, 9729, 33648, 33648);
        GL32C.glUniform1i((int)this.shader.depthtex, (int)1);
        this.matrices.set(Matrices.modelView);
        GL32C.nglUniformMatrix4fv((int)this.shader.modelViewMatrix, (int)1, (boolean)false, (long)this.matrices.address());
        this.matrices.set(Matrices.modelViewInverse);
        GL32C.nglUniformMatrix4fv((int)this.shader.inverseModelViewMatrix, (int)1, (boolean)false, (long)this.matrices.address());
        this.matrices.set(Matrices.projection);
        GL32C.nglUniformMatrix4fv((int)this.shader.projectionMatrix, (int)1, (boolean)false, (long)this.matrices.address());
        this.matrices.set(Matrices.projectionInverse);
        GL32C.nglUniformMatrix4fv((int)this.shader.inverseProjectionMatrix, (int)1, (boolean)false, (long)this.matrices.address());
        GL32C.glUniform1f((int)this.shader.time, (float)Matrices.dayTimeInSeconds);
        int waypointCount = this.visibleWaypoints.size();
        GL32C.glUniform1i((int)this.shader.waypointCount, (int)waypointCount);
        for (VisibleWaypointData waypoint : this.visibleWaypoints) {
            this.waypointData.appendFloat((float)waypoint.x());
            this.waypointData.appendFloat((float)(waypoint.y() + 1.0));
            this.waypointData.appendFloat((float)waypoint.z());
            this.waypointData.appendFloat(waypoint.health() / 5.0f + (float)(Math.sin((double)waypoint.age() * 0.06283185307179587) * 0.125));
        }
        GL32C.nglUniform4fv((int)this.shader.waypoints, (int)waypointCount, (long)this.waypointData.address);
        this.waypointData.clear();
        GLException.check();
        GL32C.glDrawArrays((int)4, (int)0, (int)3);
        GLException.check();
        this.framebuffer.copyTo(RenderVersions.glID(framebuffer));
        GLException.check();
        this.glState.restore();
    }

    public void markWaypointVisible(double x, double y, double z, float age, float health) {
        this.visibleWaypoints.add(new VisibleWaypointData(x - Matrices.cameraX, y - Matrices.cameraY, z - Matrices.cameraZ, age, health));
        if (this.visibleWaypoints.size() > 16) {
            this.visibleWaypoints.pollLast();
        }
    }

    public void endFrame() {
        this.visibleWaypoints.clear();
    }

    public static class WaypointWarpGlState
    extends GlState {
        public FilteredTextureState colortex = TextureState._2D(33984);
        public FilteredTextureState depthtex = TextureState._2D(33985);

        @Override
        public void capture() {
            super.capture();
            this.colortex.capture();
            this.depthtex.capture();
        }

        @Override
        public void restore() {
            this.depthtex.restore();
            this.colortex.restore();
            super.restore();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record VisibleWaypointData(double x, double y, double z, float age, float health) implements Comparable<VisibleWaypointData>
    {
        public double squareDistanceToCamera() {
            return BigGlobeMath.squareD(this.x, this.y + 1.0, this.z);
        }

        @Override
        public int compareTo(@NotNull VisibleWaypointData that) {
            return Double.compare(this.squareDistanceToCamera(), that.squareDistanceToCamera());
        }
    }
}

