/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.scripting.wrappers.BlockStateWrapper;
import builderb0y.bigglobe.scripting.wrappers.BlockWrapper;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.scripting.wrappers.entries.BiomeEntry;
import builderb0y.bigglobe.scripting.wrappers.entries.ConfiguredFeatureEntry;
import builderb0y.bigglobe.scripting.wrappers.entries.EntryWrapper;
import builderb0y.bigglobe.scripting.wrappers.tags.BiomeTag;
import builderb0y.bigglobe.scripting.wrappers.tags.BlockTag;
import builderb0y.bigglobe.scripting.wrappers.tags.ConfiguredFeatureTag;
import builderb0y.bigglobe.scripting.wrappers.tags.TagWrapper;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.AbstractConstantFactory;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.Handlers;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.random.RandomGenerator;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MinecraftScriptEnvironment {
    public static final MutableScriptEnvironment BASE = new MutableScriptEnvironment().addType("Block", BlockWrapper.TYPE).addType("BlockTag", BlockTag.TYPE).addType("BlockState", BlockStateWrapper.TYPE).addType("Biome", BiomeEntry.TYPE).addType("BiomeTag", BiomeTag.TYPE).addType("ConfiguredFeature", ConfiguredFeatureEntry.TYPE).addType("ConfiguredFeatureTag", ConfiguredFeatureTag.TYPE).addType("Tag", TagWrapper.TYPE).addFieldInvokes(TagWrapper.class, "size", "isEmpty").addFieldInvokeStatic(BlockWrapper.class, "id").addFieldInvoke(EntryWrapper.class, "id").addFieldInvokes(BiomeEntry.class, "temperature", "downfall").addMethodInvokeStatics(BlockWrapper.class, "getDefaultState").addMethodMultiInvokeStatic(BlockWrapper.class, "getRandomState").addMethodInvokeSpecific(BlockTag.class, "random", class_2248.class, RandomGenerator.class).addMethodInvokeSpecific(BlockTag.class, "random", class_2248.class, Long.TYPE).addMethodInvokeStatics(BlockStateWrapper.class, "getBlock", "isAir", "isReplaceable", "hasWater", "hasLava", "hasSoulLava", "hasFluid", "blocksLight", "hasCollision", "hasFullCubeCollision", "hasFullCubeOutline", "rotate", "mirror", "with").addField(BlockStateWrapper.TYPE, null, new MutableScriptEnvironment.FieldHandler.Named("<property getter>", (parser, receiver, name, mode) -> mode.makeInvoker(parser, receiver, BlockStateWrapper.GET_PROPERTY, InsnTrees.ldc(name)))).addMethodInvokeSpecific(BiomeTag.class, "random", BiomeEntry.class, RandomGenerator.class).addMethodInvokeSpecific(BiomeTag.class, "random", BiomeEntry.class, Long.TYPE).addMethodInvokeSpecific(ConfiguredFeatureTag.class, "random", ConfiguredFeatureEntry.class, RandomGenerator.class).addMethodInvokeSpecific(ConfiguredFeatureTag.class, "random", ConfiguredFeatureEntry.class, Long.TYPE).addCastConstant(BlockWrapper.CONSTANT_FACTORY, true).addCastConstant(BlockStateWrapper.CONSTANT_FACTORY, true).addCastConstant(BiomeEntry.CONSTANT_FACTORY, true).addCastConstant(ConfiguredFeatureEntry.CONSTANT_FACTORY, true).configure(BlockTag.PARSER).addMethod(BlockStateWrapper.TYPE, "isIn", BlockStateWrapper.TAG_PARSER.makeIsIn()).configure(BiomeTag.PARSER).configure(ConfiguredFeatureTag.PARSER).addKeyword("BlockState", MinecraftScriptEnvironment.blockStateKeyword());
    public static final MethodInfo BOOTSTRAP_CONSTANT_STATE = MethodInfo.getMethod(MinecraftScriptEnvironment.class, "bootstrapConstantState");

    public static Consumer<MutableScriptEnvironment> create() {
        return environment -> environment.addAll(BASE);
    }

    public static Consumer<MutableScriptEnvironment> createWithRandom(InsnTree loadRandom) {
        return environment -> environment.configure(MinecraftScriptEnvironment.create()).addMethod(BlockWrapper.TYPE, "getRandomState", Handlers.builder(BlockWrapper.class, "getRandomState").addReceiverArgument(BlockWrapper.TYPE).addImplicitArgument(loadRandom).buildMethod()).addMethod(BlockTag.TYPE, "random", MinecraftScriptEnvironment.tagRandom(loadRandom, BlockTag.class, class_2248.class)).addMethod(BiomeTag.TYPE, "random", MinecraftScriptEnvironment.tagRandom(loadRandom, BiomeTag.class, BiomeEntry.class)).addMethod(ConfiguredFeatureTag.TYPE, "random", MinecraftScriptEnvironment.tagRandom(loadRandom, ConfiguredFeatureTag.class, ConfiguredFeatureEntry.class));
    }

    public static Consumer<MutableScriptEnvironment> createWithWorld(InsnTree loadWorld) {
        InsnTree loadRandom = InsnTrees.getField(loadWorld, FieldInfo.getField(WorldWrapper.class, "random"));
        return environment -> environment.configure(MinecraftScriptEnvironment.createWithRandom(loadRandom)).addVariable("worldSeed", WorldWrapper.INFO.seed(loadWorld)).addFunctionInvokes(loadWorld, WorldWrapper.class, "getBlockState", "setBlockState", "setBlockStateReplaceable", "setBlockStateNonReplaceable", "updateBlockState", "placeBlockState", "fillBlockState", "fillBlockStateReplaceable", "fillBlockStateNonReplaceable", "updateBlockStates", "placeFeature", "isYLevelValid", "isPositionValid", "getBlockData", "setBlockData", "mergeBlockData").addFunctionMultiInvokes(loadWorld, WorldWrapper.class, "transformX", "transformY", "transformZ").addVariableInvokes(loadWorld, WorldWrapper.class, "minValidYLevel", "maxValidYLevel").addFunctionMultiInvoke(loadWorld, WorldWrapper.class, "summon").addMethod(BlockStateWrapper.TYPE, "canPlaceAt", Handlers.builder(BlockStateWrapper.class, "canPlaceAt").addImplicitArgument(loadWorld).addReceiverArgument(BlockStateWrapper.TYPE).addArguments("III").buildMethod()).addMethod(BlockStateWrapper.TYPE, "canStayAt", Handlers.builder(BlockStateWrapper.class, "canStayAt").addImplicitArgument(loadWorld).addReceiverArgument(BlockStateWrapper.TYPE).addArguments("III").buildMethod());
    }

    public static MutableScriptEnvironment.KeywordHandler.Named blockStateKeyword() {
        return new MutableScriptEnvironment.KeywordHandler.Named("BlockState(block, property1: value1, property2: value2, ...)", (parser, name) -> {
            boolean nullable = parser.input.hasOperatorAfterWhitespace("?");
            if (parser.input.peekAfterWhitespace() != '(') {
                if (!nullable) return null;
                throw new ScriptParsingException("'BlockState?' must be followed by parentheses for nullable cast. If a nullable cast was not intended, remove the question mark.", parser.input);
            }
            parser.beginCodeBlock();
            InsnTree state = parser.nextScript();
            if (parser.input.hasOperatorAfterWhitespace(",")) {
                ConstantValue constantBlock = state.getConstantValue();
                if (constantBlock.isConstant() && constantBlock.getTypeInfo().equals(TypeInfos.STRING)) {
                    String blockName = (String)constantBlock.asJavaObject();
                    class_2960 identifier = IdentifierVersions.create(blockName);
                    if (!class_7923.field_41175.method_10250(identifier)) throw new ScriptParsingException("Unknown block: " + String.valueOf(identifier), parser.input);
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
                    Set properties = block.method_9595().method_11659().stream().map(class_2769::method_11899).collect(Collectors.toSet());
                    ArrayList<ConstantValue> constantProperties = new ArrayList<ConstantValue>(16);
                    constantProperties.add(constantBlock);
                    constantProperties.add(InsnTrees.constant(AbstractConstantFactory.flags(parser, nullable)));
                    record NonConstantProperty(String name, InsnTree value) {
                    }
                    ArrayList<NonConstantProperty> nonConstantProperties = new ArrayList<NonConstantProperty>(8);
                    do {
                        String property;
                        if (!properties.remove(property = parser.input.expectIdentifierAfterWhitespace())) {
                            throw new ScriptParsingException("Duplicate or unknown property: " + property, parser.input);
                        }
                        parser.input.expectOperatorAfterWhitespace(":");
                        InsnTree value = parser.nextScript();
                        ConstantValue constantValue = value.getConstantValue();
                        if (constantValue.isConstantOrDynamic()) {
                            constantProperties.add(InsnTrees.constant(property));
                            constantProperties.add(constantValue);
                            continue;
                        }
                        nonConstantProperties.add(new NonConstantProperty(property, value.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false)));
                    } while (parser.input.hasOperatorAfterWhitespace(","));
                    state = constantProperties.size() > 1 ? InsnTrees.ldc(BOOTSTRAP_CONSTANT_STATE, (ConstantValue[])constantProperties.toArray((IntFunction<T[]>)ConstantValue.ARRAY_FACTORY)) : BlockStateWrapper.DEFAULT_CONSTANT_FACTORY.create(parser, state, true, nullable).tree();
                    for (NonConstantProperty nonConstantProperty : nonConstantProperties) {
                        state = InsnTrees.invokeStatic(nullable ? BlockStateWrapper.WITH_NULLABLE : BlockStateWrapper.WITH, state, InsnTrees.ldc(nonConstantProperty.name), nonConstantProperty.value);
                    }
                } else {
                    state = InsnTrees.invokeStatic(nullable ? BlockWrapper.GET_DEFAULT_STATE_NULLABLE : BlockWrapper.GET_DEFAULT_STATE, BlockWrapper.CONSTANT_FACTORY.create(parser, state, false, nullable).tree());
                    HashSet<String> properties = new HashSet<String>(8);
                    do {
                        String property;
                        if (!properties.add(property = parser.input.expectIdentifierAfterWhitespace())) {
                            throw new ScriptParsingException("Duplicate property: " + property, parser.input);
                        }
                        parser.input.expectOperatorAfterWhitespace(":");
                        InsnTree value = parser.nextScript().cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false);
                        state = InsnTrees.invokeStatic(nullable ? BlockStateWrapper.WITH_NULLABLE : BlockStateWrapper.WITH, state, InsnTrees.ldc(property), value);
                    } while (parser.input.hasOperatorAfterWhitespace(","));
                }
            } else {
                state = BlockStateWrapper.CONSTANT_FACTORY.create(parser, state, false, nullable).tree();
            }
            parser.endCodeBlock();
            return state;
        });
    }

    public static MutableScriptEnvironment.MethodHandler.Named tagRandom(InsnTree loadRandom, Class<?> owner, Class<?> returnType) {
        return Handlers.builder(owner, "random").returnClass(returnType).addReceiverArgument(owner).addImplicitArgument(loadRandom).buildMethod();
    }

    public static class_2680 bootstrapConstantState(MethodHandles.Lookup caller, String name, Class<?> type, String id, int flags, Object ... properties) {
        int length = properties.length;
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("properties array length must be even.");
        }
        class_2680 state = BlockStateWrapper.getDefaultState(id, flags);
        class_2689 manager = state.method_26204().method_9595();
        for (int index = 0; index < length; index += 2) {
            class_2769 property = manager.method_11663((String)properties[index]);
            if (property == null) {
                throw new IllegalArgumentException("Cannot set property " + String.valueOf(properties[index]) + " as it does not exist in " + String.valueOf(state.method_26204()));
            }
            Comparable value = (Comparable)properties[index + 1];
            if (value instanceof String) {
                String string = (String)((Object)value);
                value = property.method_11900(string).orElse(null);
            } else if (value instanceof Integer) {
                Integer integer = (Integer)value;
                if (property.method_11902() == Boolean.class) {
                    value = Boolean.valueOf(integer != 0);
                }
            }
            if (!property.method_11902().isInstance(value)) {
                throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(properties[index + 1]) + " on " + String.valueOf(state.method_26204()) + ", it is not an allowed value");
            }
            state = (class_2680)state.method_11657(property, value);
        }
        return state;
    }
}

