/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.scripting.environments.RandomScriptEnvironment;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.environments.BuiltinScriptEnvironment;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import com.google.common.collect.ObjectArrays;

public class StatelessRandomScriptEnvironment {
    public static final MutableScriptEnvironment INSTANCE = new MutableScriptEnvironment().addMethod(InsnTrees.type(Long.TYPE), "newSeed", new MutableScriptEnvironment.MethodHandler.Named("long.newSeed(int...)", (parser, receiver, name, mode, arguments) -> {
        if (arguments.length == 0) {
            return new MutableScriptEnvironment.CastResult(InsnTrees.add(parser, receiver, InsnTrees.ldc(-7046029254386353131L)), false);
        }
        return RandomScriptEnvironment.createSeed(parser, (InsnTree[])ObjectArrays.concat((Object)receiver, (Object[])arguments));
    })).addMethodInvokeStatic("nextInt", RandomScriptEnvironment.PERMUTER_INFO.nextPositiveInt).addMethodInvokeStatic("nextInt", RandomScriptEnvironment.PERMUTER_INFO.nextIntBound).addMethodInvokeStatic("nextInt", RandomScriptEnvironment.PERMUTER_INFO.nextIntOriginBound).addMethodInvokeStatic("nextLong", RandomScriptEnvironment.PERMUTER_INFO.nextPositiveLong).addMethodInvokeStatic("nextLong", RandomScriptEnvironment.PERMUTER_INFO.nextLongBound).addMethodInvokeStatic("nextLong", RandomScriptEnvironment.PERMUTER_INFO.nextLongOriginBound).addMethodInvokeStatic("nextFloat", RandomScriptEnvironment.PERMUTER_INFO.nextPositiveFloat).addMethodInvokeStatic("nextFloat", RandomScriptEnvironment.PERMUTER_INFO.nextFloatBound).addMethodInvokeStatic("nextFloat", RandomScriptEnvironment.PERMUTER_INFO.nextFloatOriginBound).addMethodInvokeStatic("nextDouble", RandomScriptEnvironment.PERMUTER_INFO.nextPositiveDouble).addMethodInvokeStatic("nextDouble", RandomScriptEnvironment.PERMUTER_INFO.nextDoubleBound).addMethodInvokeStatic("nextDouble", RandomScriptEnvironment.PERMUTER_INFO.nextDoubleOriginBound).addMethodInvokeStatic("nextBoolean", RandomScriptEnvironment.PERMUTER_INFO.nextBoolean).addMethodInvokeStatic("nextBoolean", RandomScriptEnvironment.PERMUTER_INFO.nextChancedBooleanF).addMethodInvokeStatic("nextBoolean", RandomScriptEnvironment.PERMUTER_INFO.nextChancedBooleanD).addMethodInvokeStatic("roundInt", RandomScriptEnvironment.PERMUTER_INFO.roundRandomlyIF).addMethodInvokeStatic("roundInt", RandomScriptEnvironment.PERMUTER_INFO.roundRandomlyID).addMethodInvokeStatic("roundLong", RandomScriptEnvironment.PERMUTER_INFO.roundRandomlyLF).addMethodInvokeStatic("roundLong", RandomScriptEnvironment.PERMUTER_INFO.roundRandomlyLD).addMemberKeyword(TypeInfos.LONG, "if", new MutableScriptEnvironment.MemberKeywordHandler.Named("seed.if (chance: body)", (parser, receiver, name, mode) -> StatelessRandomScriptEnvironment.wrapSeedIf(parser, receiver, false, mode))).addMemberKeyword(TypeInfos.LONG, "unless", new MutableScriptEnvironment.MemberKeywordHandler.Named("seed.unless (chance: body)", (parser, receiver, name, mode) -> StatelessRandomScriptEnvironment.wrapSeedIf(parser, receiver, true, mode))).addMemberKeyword(TypeInfos.LONG, "switch", new MutableScriptEnvironment.MemberKeywordHandler.Named("seed.switch(case1, case2, ...) or seed.switch(weight1: case1, weight2: case2, ...)", RandomScriptEnvironment.randomSwitch()));

    public static InsnTree wrapSeedIf(ExpressionParser parser, InsnTree seed, boolean negate, ScriptEnvironment.MemberKeywordMode mode) throws ScriptParsingException {
        return mode.apply(seed, actualSeed -> StatelessRandomScriptEnvironment.seedIf(parser, actualSeed, negate));
    }

    public static InsnTree seedIf(ExpressionParser parser, InsnTree seed, boolean negate) throws ScriptParsingException {
        InsnTree conditionInsnTree;
        InsnTree body;
        parser.beginCodeBlock();
        InsnTree firstPart = parser.nextScript();
        if (parser.input.hasOperatorAfterWhitespace(":")) {
            TypeInfo.Sort sort = firstPart.getTypeInfo().getSort();
            if (sort != TypeInfo.Sort.FLOAT && sort != TypeInfo.Sort.DOUBLE) {
                throw new ScriptParsingException("seed." + (negate ? "unless" : "if") + "() chance should be float or double, but was " + String.valueOf(firstPart.getTypeInfo()), parser.input);
            }
            body = parser.nextScript();
            conditionInsnTree = sort == TypeInfo.Sort.FLOAT ? RandomScriptEnvironment.PERMUTER_INFO.nextChancedBooleanF(seed, firstPart) : RandomScriptEnvironment.PERMUTER_INFO.nextChancedBooleanD(seed, firstPart);
        } else {
            conditionInsnTree = RandomScriptEnvironment.PERMUTER_INFO.nextBoolean(seed);
            body = firstPart;
        }
        parser.endCodeBlock();
        ConditionTree conditionTree = InsnTrees.condition(parser, conditionInsnTree);
        if (negate) {
            conditionTree = InsnTrees.not(conditionTree);
        }
        if (parser.input.hasIdentifierAfterWhitespace("else")) {
            return InsnTrees.ifElse(parser, conditionTree, body, BuiltinScriptEnvironment.tryParenthesized(parser));
        }
        return InsnTrees.ifThen(conditionTree, body);
    }
}

