/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures;

import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.mixins.StructurePiece_DirectRotationSetter;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.structures.BigGlobeStructure;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.structures.LabyrinthLayout;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.DirectionVersions;
import builderb0y.bigglobe.versions.WallBlockVersions;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.random.RandomGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2544;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_39;
import net.minecraft.class_4778;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_7151;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class BiggerDesertPyramidStructure
extends BigGlobeStructure {
    public static final Codec<BiggerDesertPyramidStructure> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(BiggerDesertPyramidStructure.class).codec();

    public BiggerDesertPyramidStructure(class_3195.class_7302 config, @VerifyNullable ColumnScript.ColumnToIntScript.Holder surface_y) {
        super(config, null, surface_y);
    }

    @Override
    public int bigglobe_getMaxRadiusInChunks() {
        return 4;
    }

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2338 pos = this.randomBlockInSurface(context, 0);
        if (pos == null) {
            return Optional.empty();
        }
        long seed = BiggerDesertPyramidStructure.chunkSeed(context, -1579202771974043330L);
        return Optional.of(new class_3195.class_7150(pos, collector -> {
            Permuter permuter = new Permuter(seed);
            class_2470 rotation = Directions.ROTATIONS[permuter.nextInt() & 3];
            MainPiece mainPiece = new MainPiece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_PIECE_TYPE, pos.method_10263(), pos.method_10264(), pos.method_10260(), rotation);
            collector.method_35462((class_3443)mainPiece);
            UndergroundLayout layout = new UndergroundLayout((RandomGenerator)permuter, mainPiece);
            layout.generate();
            layout.addTo((class_6626)collector);
        }));
    }

    public class_7151<?> method_41618() {
        return BigGlobeStructures.BIGGER_DESERT_PYRAMID_TYPE;
    }

    public static class_2680 smoothBottomStairs(class_2350 direction) {
        return BiggerDesertPyramidStructure.stairs(class_2246.field_10549, direction, class_2760.field_12617);
    }

    public static class_2680 smoothTopStairs(class_2350 direction) {
        return BiggerDesertPyramidStructure.stairs(class_2246.field_10549, direction, class_2760.field_12619);
    }

    public static class_2680 smoothStairs(class_2350 direction, class_2760 half, class_2778 shape) {
        return BiggerDesertPyramidStructure.stairs(class_2246.field_10549, direction, half, shape);
    }

    public static class_2680 plainBottomStairs(class_2350 direction) {
        return BiggerDesertPyramidStructure.stairs(class_2246.field_10142, direction, class_2760.field_12617);
    }

    public static class_2680 plainTopStairs(class_2350 direction) {
        return BiggerDesertPyramidStructure.stairs(class_2246.field_10142, direction, class_2760.field_12619);
    }

    public static class_2680 plainStairs(class_2350 direction, class_2760 half, class_2778 shape) {
        return BiggerDesertPyramidStructure.stairs(class_2246.field_10142, direction, half, shape);
    }

    public static class_2680 bottomStairs(class_2248 stairs, class_2350 direction) {
        return BiggerDesertPyramidStructure.stairs(stairs, direction, class_2760.field_12617, class_2778.field_12710);
    }

    public static class_2680 topStairs(class_2248 stairs, class_2350 direction) {
        return BiggerDesertPyramidStructure.stairs(stairs, direction, class_2760.field_12619, class_2778.field_12710);
    }

    public static class_2680 stairs(class_2248 stairs, class_2350 direction, class_2760 half) {
        return BiggerDesertPyramidStructure.stairs(stairs, direction, half, class_2778.field_12710);
    }

    public static class_2680 stairs(class_2248 stairs, class_2350 facing, class_2760 half, class_2778 shape) {
        return (class_2680)((class_2680)((class_2680)stairs.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)facing)).method_11657((class_2769)class_2510.field_11572, (Comparable)half)).method_11657((class_2769)class_2510.field_11565, (Comparable)shape);
    }

    public static class MainPiece
    extends class_3443 {
        public MainPiece(class_3773 type, int x, int y, int z, class_2470 rotation) {
            super(type, 0, switch (rotation) {
                default -> throw new IncompatibleClassChangeError();
                case class_2470.field_11467 -> new class_3341(x - 21, y - 16, z - 36, x + 21, y + 27, z + 21);
                case class_2470.field_11463 -> new class_3341(x - 21, y - 16, z - 21, x + 36, y + 27, z + 21);
                case class_2470.field_11464 -> new class_3341(x - 21, y - 16, z - 21, x + 21, y + 27, z + 36);
                case class_2470.field_11465 -> new class_3341(x - 36, y - 16, z - 21, x + 21, y + 27, z + 21);
            });
            ((StructurePiece_DirectRotationSetter)((Object)this)).bigglobe_setRotationDirect(rotation);
        }

        public MainPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, nbt);
            class_2520 class_25202 = nbt.method_10580("rot");
            if (class_25202 instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                ((StructurePiece_DirectRotationSetter)((Object)this)).bigglobe_setRotationDirect(Directions.ROTATIONS[number.method_10698()]);
            }
        }

        public void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10567("rot", (byte)this.method_16888().ordinal());
        }

        public Coordinator coordinator(class_5281 world, class_3341 chunkBox) {
            return Coordinator.forWorld(world, 18).inBox(chunkBox, false).translate(this.x(), this.y(), this.z()).rotate1x(this.method_16888());
        }

        public int x() {
            int minX = this.field_15315.method_35415();
            return minX + (this.method_16888() == class_2470.field_11465 ? 36 : 21);
        }

        public int y() {
            return this.field_15315.method_35416() + 16;
        }

        public int z() {
            int minZ = this.field_15315.method_35417();
            return minZ + (this.method_16888() == class_2470.field_11467 ? 36 : 21);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            int y;
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator flipX = root.flip2X();
            Coordinator flipXZ = flipX.flip2Z();
            Coordinator rot4 = root.rotate4x90();
            root.setBlockStateCuboid(-21, -16, -21, 21, -1, 21, BlockStates.SANDSTONE);
            root.setBlockStateCuboid(-20, 0, -20, 20, 0, 20, BlockStates.SANDSTONE);
            root.setBlockState(0, -1, 0, class_2246.field_10409.method_9564());
            rot4.flip2X().setBlockStateLine(1, -1, 2, 0, 0, 1, 2, class_2246.field_10184.method_9564());
            rot4.flip2X().setBlockStateLine(2, -1, 4, 0, 0, 1, 2, class_2246.field_10184.method_9564());
            rot4.setBlockState(0, -1, 5, class_2246.field_10235.method_9564());
            rot4.setBlockState(4, -1, 4, class_2246.field_10235.method_9564());
            root.setBlockStateCuboid(-10, 0, -10, 10, 0, 10, BlockStates.AIR);
            root.setBlockStateCuboid(-1, 0, 11, 1, 0, 19, BlockStates.AIR);
            root.setBlockStateLine(-1, 0, 20, 1, 0, 0, 3, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11035));
            flipX.setBlockStateLine(2, 0, 14, 0, 0, -1, 3, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11034));
            flipX.setBlockState(2, 0, 11, BiggerDesertPyramidStructure.smoothStairs(class_2350.field_11035, class_2760.field_12617, class_2778.field_12708));
            flipX.setBlockStateLine(3, 0, 11, 1, 0, 0, 8, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11035));
            flipX.setBlockState(11, 0, 11, BiggerDesertPyramidStructure.smoothStairs(class_2350.field_11035, class_2760.field_12617, class_2778.field_12712));
            root.flip4XZ().setBlockStateLine(11, 0, 10, 0, 0, -1, 8, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11034));
            flipX.setBlockState(11, 0, -11, BiggerDesertPyramidStructure.smoothStairs(class_2350.field_11043, class_2760.field_12617, class_2778.field_12713));
            root.setBlockStateLine(-10, 0, -11, 1, 0, 0, 21, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11043));
            for (int y2 = 1; y2 <= 15; ++y2) {
                rot4.setBlockStateLine(-20 + y2, y2, -20 + y2, 1, 0, 0, 20 - y2 << 1, BlockStates.SANDSTONE);
                root.setBlockStateCuboid(-19 + y2, y2, -19 + y2, 19 - y2, y2, 19 - y2, BlockStates.AIR);
            }
            root.setBlockStateCuboid(-4, 16, -4, 4, 16, 4, BlockStates.SANDSTONE);
            flipX.setBlockStateCuboid(16, 1, -18, 18, 1, -2, BlockStates.SANDSTONE);
            flipX.setBlockStateCuboid(16, 2, -17, 17, 2, -2, BlockStates.SANDSTONE);
            flipX.setBlockStateLine(16, 3, -16, 0, 0, 1, 15, BlockStates.SANDSTONE);
            root.setBlockStateCuboid(-15, 1, -18, 15, 1, -16, BlockStates.SANDSTONE);
            root.setBlockStateCuboid(-15, 2, -17, 15, 2, -16, BlockStates.SANDSTONE);
            root.setBlockStateLine(-15, 3, -16, 1, 0, 0, 31, BlockStates.SANDSTONE);
            Coordinator tower = flipX.translate(17, 0, 17);
            Coordinator rotatedTower = tower.rotate4x90();
            rotatedTower.setBlockStateCuboid(-3, 1, 3, 2, 16, 3, BlockStates.SANDSTONE);
            rotatedTower.setBlockStateLine(-3, 1, 3, 0, 1, 0, 9, BlockStates.CUT_SANDSTONE);
            rotatedTower.setBlockStateLine(-3, 15, 3, 0, 1, 0, 2, BlockStates.CUT_SANDSTONE);
            rotatedTower.setBlockState(0, 12, 3, class_2246.field_10409.method_9564());
            rotatedTower.flip2X().setBlockStateLine(1, 9, 3, 0, 1, 0, 2, class_2246.field_10184.method_9564());
            rotatedTower.flip2X().setBlockStateLine(2, 11, 3, 0, 1, 0, 3, class_2246.field_10184.method_9564());
            rotatedTower.flip2X().setBlockStateLine(1, 14, 3, 0, 1, 0, 2, class_2246.field_10184.method_9564());
            tower.setBlockStateCuboid(-2, 10, -2, 2, 16, 2, BlockStates.SANDSTONE);
            tower.setBlockStateCuboid(-2, 1, -2, 2, 9, 2, BlockStates.AIR);
            rotatedTower.setBlockStateLine(-1, 9, -2, 1, 0, 0, 3, BiggerDesertPyramidStructure.plainTopStairs(class_2350.field_11043));
            rotatedTower.setBlockState(-2, 9, -2, BiggerDesertPyramidStructure.plainStairs(class_2350.field_11043, class_2760.field_12619, class_2778.field_12712));
            tower.setBlockStateCuboid(-1, 9, -1, 1, 9, 1, (class_2680)class_2246.field_10262.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
            flipX.setBlockStateLine(14, 6, 17, 0, 1, 0, 2, BlockStates.AIR);
            flipX.setBlockStateLine(17, 6, 14, 0, 1, 0, 2, BlockStates.AIR);
            flipX.setBlockStateLine(15, 5, 20, 1, 0, 0, 5, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(20, 5, 15, 0, 0, 1, 5, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(16, 7, 20, 1, 0, 0, 3, BlockStates.CHISELED_SANDSTONE);
            flipX.setBlockStateLine(20, 7, 16, 0, 0, 1, 3, BlockStates.CHISELED_SANDSTONE);
            flipX.stack(2, 0, 0, 2).setBlockStateLine(16, 0, 21, 0, 1, 0, BlockStates.CUT_SANDSTONE, BlockStates.CUT_SANDSTONE, BlockStates.CUT_SANDSTONE, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11043));
            flipX.stack(0, 0, 2, 2).setBlockStateLine(21, 0, 16, 0, 1, 0, BlockStates.CUT_SANDSTONE, BlockStates.CUT_SANDSTONE, BlockStates.CUT_SANDSTONE, BiggerDesertPyramidStructure.smoothBottomStairs(class_2350.field_11039));
            for (y = 0; y < 3; ++y) {
                rotatedTower.setBlockStateLine(-2 + y, 17 + y, 3 - y, 1, 0, 0, 5 - (y << 1), BiggerDesertPyramidStructure.bottomStairs(class_2246.field_10245, class_2350.field_11043));
                rotatedTower.setBlockState(3 - y, 17 + y, 3 - y, BiggerDesertPyramidStructure.stairs(class_2246.field_10245, class_2350.field_11043, class_2760.field_12617, class_2778.field_12708));
                tower.setBlockStateCuboid(-2 + y, 17 + y, -2 + y, 2 - y, 17 + y, 2 - y, class_2246.field_9978.method_9564());
            }
            tower.setBlockState(0, 20, 0, class_2246.field_10601.method_9564());
            flipX.setBlockStateLine(19, 1, 17, 0, 1, 1, 2, BiggerDesertPyramidStructure.plainBottomStairs(class_2350.field_11035));
            flipX.setBlockState(19, 1, 18, BlockStates.SANDSTONE);
            flipX.setBlockState(19, 1, 19, BlockStates.SANDSTONE);
            flipX.setBlockState(19, 2, 19, BlockStates.SANDSTONE);
            flipX.stack(-1, 1, 0, 3).setBlockStateLine(18, 2, 19, 0, 1, 0, BiggerDesertPyramidStructure.plainTopStairs(class_2350.field_11034), BiggerDesertPyramidStructure.plainBottomStairs(class_2350.field_11039));
            flipX.setBlockStateLine(15, 5, 19, 0, 0, -1, 5, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(16, 5, 15, 1, 0, 0, 4, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(16, 5, 18, 0, 0, -1, 2, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11039));
            flipX.setBlockState(16, 5, 16, BiggerDesertPyramidStructure.smoothStairs(class_2350.field_11043, class_2760.field_12619, class_2778.field_12712));
            flipX.setBlockStateLine(17, 5, 16, 1, 0, 0, 3, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11043));
            flipX.setBlockState(16, 6, 18, (class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.NORTH_SHAPE, (Comparable)class_4778.field_22179));
            flipX.setBlockState(16, 6, 17, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.NORTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.setBlockState(16, 6, 16, (class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179));
            flipX.setBlockStateLine(17, 6, 16, 1, 0, 0, 3, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.setBlockStateCuboid(2, 1, 16, 13, 5, 18, BlockStates.SANDSTONE);
            flipX.setBlockStateCuboid(16, 1, 2, 18, 5, 13, BlockStates.SANDSTONE);
            flipX.setBlockStateCuboid(8, 0, -1, 18, 5, 1, BlockStates.SANDSTONE);
            root.setBlockStateCuboid(-1, 5, 16, 1, 5, 19, BlockStates.SANDSTONE);
            flipX.setBlockStateCuboid(4, 1, 17, 14, 3, 17, BlockStates.AIR);
            flipX.setBlockStateCuboid(17, 1, 4, 17, 3, 14, BlockStates.AIR);
            flipX.stack(4, 0, 0, 3).setBlockStateLine(4, 1, 16, 0, 1, 0, BlockStates.AIR, BlockStates.AIR, BiggerDesertPyramidStructure.plainTopStairs(class_2350.field_11043));
            flipX.stack(0, 0, 4, 3).setBlockStateLine(16, 1, 4, 0, 1, 0, BlockStates.AIR, BlockStates.AIR, BiggerDesertPyramidStructure.plainTopStairs(class_2350.field_11039));
            root.setBlockStateCuboid(-1, 1, 16, 1, 4, 20, BlockStates.AIR);
            flipX.setBlockStateLine(2, 1, 19, 0, 1, 0, 4, BlockStates.SANDSTONE);
            flipX.setBlockStateLine(2, 0, 20, 0, 1, 0, 7, BlockStates.CUT_SANDSTONE);
            root.stack(0, 2, 0, 2).setBlockStateLine(-1, 5, 20, 1, 0, 0, 3, BlockStates.CUT_SANDSTONE);
            root.setBlockStateLine(-1, 6, 20, 1, 0, 0, BlockStates.CHISELED_SANDSTONE, class_2246.field_10409.method_9564(), BlockStates.CHISELED_SANDSTONE);
            flipX.stack(0, 0, -5, 2).setBlockState(1, 4, 20, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034));
            flipX.setBlockStateLine(1, 4, 19, 0, 0, -1, 4, BiggerDesertPyramidStructure.plainTopStairs(class_2350.field_11034));
            flipX.stack(4, 0, 0, 2).setBlockStateLine(6, 1, 19, 0, 1, 0, 4, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(2, 5, 19, 1, 0, 0, 12, BlockStates.CUT_SANDSTONE);
            flipX.stack(4, 0, 0, 3).setBlockStateCuboid(3, 1, 19, 5, 3, 19, BlockStates.AIR);
            flipX.stack(4, 0, 0, 3).setBlockStateLine(3, 4, 19, 1, 0, 0, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11039), BlockStates.AIR, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034));
            root.setBlockStateLine(-13, 6, 19, 1, 0, 0, 27, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.setBlockStateLine(2, 0, 15, 0, 1, 0, 5, BlockStates.CUT_SANDSTONE);
            flipX.stack(4, 0, 0, 2).setBlockStateLine(6, 1, 15, 0, 1, 0, 4, BlockStates.CUT_SANDSTONE);
            flipX.stack(4, 0, 0, 3).setBlockStateLine(3, 4, 15, 1, 0, 0, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11039), null, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034));
            root.setBlockStateLine(-14, 5, 15, 1, 0, 0, 29, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateCuboid(11, 6, -1, 14, 9, 1, BlockStates.AIR);
            flipX.stack(0, 0, -1, 3).setBlockStateLine(14, 6, 1, -1, 1, 0, 4, BlockStates.AIR);
            flipXZ.setBlockStateLine(14, 6, 2, 0, 1, 0, 5, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateCuboid(14, 10, -1, 14, 11, 1, BlockStates.CUT_SANDSTONE);
            flipXZ.setBlockState(13, 8, 2, BlockStates.SANDSTONE);
            flipXZ.setBlockState(13, 9, 2, BlockStates.SANDSTONE);
            flipXZ.setBlockState(12, 9, 2, BlockStates.SANDSTONE);
            flipX.setBlockStateCuboid(11, 10, -1, 13, 10, 1, BlockStates.SANDSTONE);
            flipXZ.setBlockState(14, 9, 1, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11035));
            flipXZ.setBlockStateLine(13, 9, 1, -1, 0, 0, 3, BiggerDesertPyramidStructure.plainTopStairs(class_2350.field_11035));
            flipX.stack(0, 0, -4, 4).setBlockStateLine(19, 1, 10, 0, 1, 0, 4, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(19, 5, 13, 0, 0, -1, 16, BlockStates.CUT_SANDSTONE);
            flipX.stack(0, 0, -4, 4).setBlockStateCuboid(19, 1, 11, 19, 3, 13, BlockStates.AIR);
            flipX.stack(0, 0, -4, 4).setBlockStateLine(19, 4, 13, 0, 0, -1, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11035), null, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11043));
            flipX.setBlockState(18, 4, -2, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034));
            flipX.setBlockStateLine(18, 5, -2, -1, 0, 0, 12, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(19, 6, 13, 0, 0, -1, 15, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.NORTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.setBlockState(19, 6, -2, (class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179));
            flipX.setBlockStateLine(18, 6, -2, -1, 0, 0, 4, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.setBlockStateLine(7, 5, -1, 0, 0, 1, 3, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(7, 5, 2, 1, 0, 0, 9, BlockStates.CUT_SANDSTONE);
            flipX.setBlockStateLine(15, 5, 3, 0, 0, 1, 11, BlockStates.CUT_SANDSTONE);
            flipXZ.stack(4, 0, 0, 2).setBlockStateLine(7, 0, -2, 0, 1, 0, 5, BlockStates.CUT_SANDSTONE);
            flipXZ.stack(0, 0, 4, 3).setBlockStateLine(15, 1, 2, 0, 1, 0, 4, BlockStates.CUT_SANDSTONE);
            flipXZ.stack(0, 0, -4, 3).setBlockStateLine(15, 4, 13, 0, 0, -1, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11035), null, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11043));
            flipXZ.stack(-4, 0, 0, 2).setBlockStateLine(14, 4, 2, -1, 0, 0, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034), null, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11039));
            flipXZ.setBlockState(7, 4, 1, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11035));
            flipXZ.setBlockStateLine(13, 6, -2, -1, 0, 0, 6, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipXZ.setBlockState(7, 6, -2, (class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179));
            flipX.setBlockStateLine(7, 6, -1, 0, 0, 1, 3, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.NORTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.multiTranslate(14, 1, -15, 15, 1, -15, 15, 1, -14).setBlockStateLine(0, 0, 0, 0, 1, 0, 4, BlockStates.SANDSTONE);
            flipX.setBlockStateLine(14, 1, -14, 0, 1, 0, 5, BlockStates.CUT_SANDSTONE);
            root.stack(4, 0, 0, 6).setBlockStateLine(-10, 1, -15, 0, 1, 0, 4, BlockStates.CUT_SANDSTONE);
            root.stack(4, 0, 0, 7).setBlockStateLine(-13, 4, -15, 1, 0, 0, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11039), null, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034));
            flipXZ.setBlockStateLine(7, 0, 7, 0, 1, 0, 13, BlockStates.CUT_SANDSTONE);
            flipXZ.setBlockStateLine(7, 0, 8, 0, 1, 0, 12, BlockStates.SANDSTONE);
            flipXZ.setBlockStateLine(7, 0, 9, 0, 1, 0, 11, BlockStates.CUT_SANDSTONE);
            flipXZ.setBlockStateLine(8, 0, 7, 0, 1, 0, 12, BlockStates.SANDSTONE);
            flipXZ.setBlockStateLine(8, 0, 8, 0, 1, 0, 12, BlockStates.SANDSTONE);
            flipXZ.setBlockStateLine(8, 0, 9, 0, 1, 0, 11, BlockStates.SANDSTONE);
            flipXZ.setBlockStateLine(9, 0, 7, 0, 1, 0, 11, BlockStates.CUT_SANDSTONE);
            flipXZ.setBlockStateLine(9, 0, 8, 0, 1, 0, 11, BlockStates.SANDSTONE);
            flipXZ.setBlockStateLine(9, 0, 9, 0, 1, 0, 11, BlockStates.CUT_SANDSTONE);
            rot4.stack(4, 0, 0, 2).setBlockStateLine(0, 17, 4, 0, 1, 0, 5, BlockStates.CUT_SANDSTONE);
            Coordinator.combine(root, root.rotate1x(class_2470.field_11463), root.rotate1x(class_2470.field_11465)).flip2X().setBlockStateLine(1, 17, 4, 1, 0, 0, 3, (class_2680)((class_2680)((class_2680)class_2246.field_10630.method_9564().method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179)).method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179)).method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.FALSE));
            flipX.setBlockStateLine(1, 17, -4, 1, 0, 0, 3, BlockStates.AIR);
            rot4.flip2X().setBlockStateCuboid(1, 18, 4, 3, 20, 4, BlockStates.AIR);
            rot4.setBlockStateLine(-3, 22, 4, 1, 0, 0, 8, BlockStates.CUT_SANDSTONE);
            rot4.flip2X().setBlockStateLine(1, 21, 4, 1, 0, 0, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11039), BlockStates.AIR, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11034));
            rot4.setBlockStateLine(-2, 22, -3, 1, 0, 0, 5, BiggerDesertPyramidStructure.smoothTopStairs(class_2350.field_11043));
            rot4.setBlockState(-3, 22, -3, BiggerDesertPyramidStructure.smoothStairs(class_2350.field_11043, class_2760.field_12619, class_2778.field_12712));
            root.setBlockStateCuboid(-2, 22, -2, 2, 22, 2, (class_2680)class_2246.field_10262.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
            for (y = 0; y < 4; ++y) {
                rot4.setBlockStateLine(-3 + y, 23 + y, 4 - y, 1, 0, 0, 7 - (y << 1), BiggerDesertPyramidStructure.bottomStairs(class_2246.field_10245, class_2350.field_11043));
                rot4.setBlockState(4 - y, 23 + y, 4 - y, BiggerDesertPyramidStructure.stairs(class_2246.field_10245, class_2350.field_11043, class_2760.field_12617, class_2778.field_12708));
                root.setBlockStateCuboid(-3 + y, 23 + y, -3 + y, 3 - y, 23 + y, 3 - y, class_2246.field_9978.method_9564());
            }
            root.setBlockState(0, 27, 0, class_2246.field_10601.method_9564());
            for (int z = -36; z <= -5; ++z) {
                for (int x = -4; x <= 4; ++x) {
                    int height = z + 37;
                    if (Math.abs(x) == 4) {
                        ++height;
                    }
                    int y3 = height >> 1;
                    root.setBlockState(x, y3, z, (height & 1) == 0 ? class_2246.field_10007.method_9564() : BlockStates.SANDSTONE);
                    int minY = Math.max(z + 21, 0);
                    while (--y3 >= minY) {
                        root.setBlockState(x, y3, z, BlockStates.SANDSTONE);
                    }
                }
            }
        }
    }

    public static class UndergroundLayout
    extends LabyrinthLayout {
        public int centerX;
        public int centerY;
        public int centerZ;

        public UndergroundLayout(RandomGenerator random, MainPiece mainPiece) {
            super(random, 363);
            this.centerX = mainPiece.x();
            this.centerY = mainPiece.y();
            this.centerZ = mainPiece.z();
            class_2338 center = new class_2338(this.centerX, this.centerY, this.centerZ);
            class_2470 rotation = mainPiece.method_16888();
            UndergroundRoomPiece topLeftRoom = this.newRoom();
            UndergroundRoomPiece topRightRoom = this.newRoom();
            UndergroundRoomPiece middleLeftRoom = this.newRoom();
            UndergroundRoomPiece middleRightRoom = this.newRoom();
            UndergroundRoomPiece bottomLeftRoom = this.newRoom();
            UndergroundRoomPiece bottomRightRoom = this.newRoom();
            topLeftRoom.setPos(new class_2338(16, -2, 0).method_10070(rotation).method_10081((class_2382)center));
            topRightRoom.setPos(new class_2338(-16, -2, 0).method_10070(rotation).method_10081((class_2382)center));
            middleLeftRoom.setPos(new class_2338(12, -4, 0).method_10070(rotation).method_10081((class_2382)center));
            middleRightRoom.setPos(new class_2338(-12, -4, 0).method_10070(rotation).method_10081((class_2382)center));
            bottomLeftRoom.setPos(new class_2338(8, -6, 0).method_10070(rotation).method_10081((class_2382)center));
            bottomRightRoom.setPos(new class_2338(-8, -6, 0).method_10070(rotation).method_10081((class_2382)center));
            topLeftRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11039), middleLeftRoom);
            middleLeftRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11034), topLeftRoom);
            middleLeftRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11039), bottomLeftRoom);
            bottomLeftRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11034), middleLeftRoom);
            topRightRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11034), middleRightRoom);
            middleRightRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11039), topRightRoom);
            middleRightRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11034), bottomRightRoom);
            bottomRightRoom.setConnectedRoom(rotation.method_10503(class_2350.field_11039), middleRightRoom);
            this.rooms.add((Object)topLeftRoom);
            this.rooms.add((Object)topRightRoom);
            this.rooms.add((Object)middleLeftRoom);
            this.rooms.add((Object)middleRightRoom);
            this.rooms.add((Object)bottomLeftRoom);
            this.rooms.add((Object)bottomRightRoom);
            this.activeRooms.add((Object)bottomLeftRoom);
            this.activeRooms.add((Object)bottomRightRoom);
            UndergroundHallPiece topLeftHall = UndergroundLayout.hall(new class_2338(17, -2, 1).method_10070(rotation).method_10081((class_2382)center), rotation.method_10503(class_2350.field_11035));
            UndergroundHallPiece topRightHall = UndergroundLayout.hall(new class_2338(-17, -2, 1).method_10070(rotation).method_10081((class_2382)center), rotation.method_10503(class_2350.field_11035));
            this.halls.add((Object)topLeftHall);
            this.halls.add((Object)topRightHall);
        }

        public static UndergroundHallPiece hall(class_2338 pos, class_2350 direction) {
            return new UndergroundHall2Piece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_HALL2_PIECE_TYPE, pos.method_10263(), pos.method_10264(), pos.method_10260(), direction);
        }

        @Override
        public void generate() {
            super.generate();
            for (LabyrinthLayout.RoomPiece room : this.rooms) {
                ((UndergroundRoomPiece)room).maybeAddChest(this.random);
            }
        }

        @Override
        public UndergroundRoomPiece newRoom() {
            return new UndergroundRoomPiece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_ROOM_PIECE_TYPE);
        }

        @Override
        public UndergroundHallPiece newHall(LabyrinthLayout.RoomPiece from, LabyrinthLayout.RoomPiece to, class_2350 direction) {
            int x = from.x() + to.x() >> 1;
            int y = Math.min(from.y(), to.y());
            int z = from.z() + to.z() >> 1;
            return switch (to.y() - from.y()) {
                case -2 -> new UndergroundHall2Piece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_HALL2_PIECE_TYPE, x, y, z, direction.method_10153());
                case -1 -> new UndergroundHall1Piece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_HALL1_PIECE_TYPE, x, y, z, direction.method_10153());
                case 0 -> new UndergroundHall0Piece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_HALL0_PIECE_TYPE, x, y, z, direction);
                case 1 -> new UndergroundHall1Piece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_HALL1_PIECE_TYPE, x, y, z, direction);
                case 2 -> new UndergroundHall2Piece(BigGlobeStructures.BIGGER_DESERT_PYRAMID_UNDERGROUND_HALL2_PIECE_TYPE, x, y, z, direction);
                default -> throw new IllegalArgumentException(Integer.toString(to.y() - from.y()));
            };
        }

        @Override
        public int distanceBetweenRooms() {
            return 4;
        }

        @Override
        public boolean isValidPosition(LabyrinthLayout.RoomPiece next) {
            return next.x() >= this.centerX - 20 && next.x() <= this.centerX + 20 && next.y() >= this.centerY - 16 && next.y() <= this.centerY - 6 && next.z() >= this.centerZ - 20 && next.z() <= this.centerZ + 20 && (next.x() != this.centerX || next.z() != this.centerZ);
        }

        @Override
        public int maxHeightDifference() {
            return 2;
        }

        @Override
        public double mergeChance() {
            return 0.25;
        }

        public void addTo(class_6626 collector) {
            for (LabyrinthLayout.LabyrinthPiece room : this.rooms) {
                collector.method_35462((class_3443)room);
            }
            for (LabyrinthLayout.LabyrinthPiece hall : this.halls) {
                collector.method_35462((class_3443)hall);
            }
        }
    }

    public static class UndergroundHall2Piece
    extends UndergroundHallPiece {
        public UndergroundHall2Piece(class_3773 type, int x, int y, int z, class_2350 direction) {
            super(type, 0, new class_3341(x - 1, y, z - 1, x + 1, y + 6, z + 1));
            this.method_14926(direction);
        }

        public UndergroundHall2Piece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            root.stack(2, 1, 0, 2).setBlockStateLine(-1, 1, 0, 0, 1, 0, class_2246.field_10007.method_9564(), BlockStates.AIR, BlockStates.AIR, (class_2680)class_2246.field_10007.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
            root.setBlockStateLine(0, 2, 0, 0, 1, 0, 3, BlockStates.AIR);
        }
    }

    public static class UndergroundHall1Piece
    extends UndergroundHallPiece {
        public UndergroundHall1Piece(class_3773 type, int x, int y, int z, class_2350 direction) {
            super(type, 0, new class_3341(x - 1, y, z - 1, x + 1, y + 5, z + 1));
            this.method_14926(direction);
        }

        public UndergroundHall1Piece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            root.stack(2, 1, 0, 2).setBlockStateLine(-1, 1, 0, 0, 1, 0, 3, BlockStates.AIR);
            root.setBlockStateLine(0, 1, 0, 0, 1, 0, class_2246.field_10007.method_9564(), BlockStates.AIR, BlockStates.AIR, (class_2680)class_2246.field_10007.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
        }
    }

    public static class UndergroundHall0Piece
    extends UndergroundHallPiece {
        public UndergroundHall0Piece(class_3773 type, int x, int y, int z, class_2350 direction) {
            super(type, 0, new class_3341(x - 1, y, z - 1, x + 1, y + 4, z + 1));
            this.method_14926(direction);
        }

        public UndergroundHall0Piece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            this.coordinator(world, chunkBox).setBlockStateCuboid(-1, 1, 0, 1, 3, 0, BlockStates.AIR);
        }
    }

    public static abstract class UndergroundHallPiece
    extends UndergroundPiece
    implements LabyrinthLayout.HallPiece {
        public UndergroundHallPiece(class_3773 type, int length, class_3341 boundingBox) {
            super(type, length, boundingBox);
        }

        public UndergroundHallPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, nbt);
        }

        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
        }

        @Override
        public Coordinator coordinator(class_5281 world, class_3341 limit) {
            return super.coordinator(world, limit).rotate1x(Directions.rotationOf(Directions.POSITIVE_X, this.method_14934()));
        }
    }

    public static class UndergroundRoomPiece
    extends UndergroundPiece
    implements LabyrinthLayout.RoomPiece {
        public final UndergroundRoomPiece[] connections = new UndergroundRoomPiece[4];
        public long chestSeed;

        public UndergroundRoomPiece(class_3773 type) {
            super(type, 0, null);
            this.setPos(0, 0, 0);
        }

        public UndergroundRoomPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, nbt);
            class_2520 class_25202 = nbt.method_10580("chestSeed");
            if (class_25202 instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                this.chestSeed = number.method_10699();
            }
        }

        @MustBeInvokedByOverriders
        public void method_14943(class_6625 context, class_2487 nbt) {
            if (this.hasChest()) {
                nbt.method_10544("chestSeed", this.chestSeed);
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            root.setBlockStateLine(0, 1, 0, 0, 1, 0, 3, BlockStates.AIR);
            class_2350 chestDirection = this.method_14934();
            if (chestDirection != null) {
                long chestSeed = this.chestSeed;
                root.setBlockStateAndBlockEntity(chestDirection.method_10148(), 1, chestDirection.method_10165(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)chestDirection.method_10153()), class_2595.class, (pos, chest) -> chest.method_54867(class_39.field_885, chestSeed));
                root.setBlockState(chestDirection.method_10148(), 2, chestDirection.method_10165(), BiggerDesertPyramidStructure.plainTopStairs(chestDirection));
            }
        }

        public void maybeAddChest(RandomGenerator random) {
            class_2350 direction;
            int bits = random.nextInt();
            if ((bits & 0x111100) == 0 && this.getConnectedRoom(direction = Directions.HORIZONTAL[bits & 3]) == null) {
                this.setChest(direction, random.nextLong());
            }
        }

        @Override
        public void setPos(int x, int y, int z) {
            this.field_15315 = new class_3341(x - 1, y, z - 1, x + 1, y + 4, z + 1);
        }

        public boolean hasChest() {
            return this.method_14934() != null;
        }

        public void setChest(class_2350 direction, long chestSeed) {
            this.method_14926(direction);
            this.chestSeed = chestSeed;
        }

        @Override
        public LabyrinthLayout.RoomPiece getConnectedRoom(class_2350 direction) {
            return this.connections[DirectionVersions.horizontal(direction)];
        }

        @Override
        public void setConnectedRoom(class_2350 direction, LabyrinthLayout.RoomPiece connection) {
            this.connections[DirectionVersions.horizontal((class_2350)direction)] = (UndergroundRoomPiece)connection;
        }
    }

    public static abstract class UndergroundPiece
    extends class_3443
    implements LabyrinthLayout.LabyrinthPiece {
        public UndergroundPiece(class_3773 type, int length, class_3341 boundingBox) {
            super(type, length, boundingBox);
        }

        public UndergroundPiece(class_3773 type, class_2487 nbt) {
            super(type, nbt);
        }

        public Coordinator coordinator(class_5281 world, class_3341 limit) {
            return Coordinator.forWorld(world, 2).inBox(limit, false).translate(this.x(), this.y(), this.z());
        }

        @Override
        public class_3341 boundingBox() {
            return this.field_15315;
        }
    }
}

