/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.dungeons;

import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.mixins.MobSpawnerLogic_GettersAndSettersForEverything;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.structures.LabyrinthLayout;
import builderb0y.bigglobe.structures.RawGenerationStructure;
import builderb0y.bigglobe.structures.dungeons.AbstractDungeonStructure;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.BlockStateVersions;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.random.RandomGenerator;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3773;
import net.minecraft.class_39;
import net.minecraft.class_4778;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import org.jetbrains.annotations.Nullable;

public class LargeDungeonStructure
extends AbstractDungeonStructure {
    public static final Codec<LargeDungeonStructure> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(LargeDungeonStructure.class).codec();

    public LargeDungeonStructure(class_3195.class_7302 config, @VerifyNullable ColumnScript.ColumnToIntScript.Holder min_y, @VerifyNullable ColumnScript.ColumnToIntScript.Holder surface_y, @VerifyNullable DelayedEntryList<class_2975<?, ?>> room_decorators, IRandomList<class_6880<class_1299<?>>> spawner_entries, List<AbstractDungeonStructure.Palette> palettes) {
        super(config, min_y, surface_y, room_decorators, spawner_entries, palettes);
    }

    @Override
    public AbstractDungeonStructure.DungeonLayout layout(ScriptedColumn column, int y, RandomGenerator random) {
        return new Layout(column, y, random, this.room_decorators, this.spawner_entries, LargeDungeonStructure.getActualEntry(this));
    }

    public class_7151<?> method_41618() {
        return BigGlobeStructures.LARGE_DUNGEON_TYPE;
    }

    public static class Layout
    extends AbstractDungeonStructure.DungeonLayout {
        public Layout(ScriptedColumn column, int y, RandomGenerator random, @Nullable DelayedEntryList<class_2975<?, ?>> roomDecorators, IRandomList<class_6880<class_1299<?>>> spawnerEntries, class_6880<class_3195> owningStructure) {
            super(column, y, random, (random.nextInt() & 0x7F) + 64, roomDecorators, spawnerEntries, owningStructure);
        }

        @Override
        public int distanceBetweenRooms() {
            return 12;
        }

        @Override
        public boolean isValidPosition(LabyrinthLayout.RoomPiece next) {
            return BigGlobeMath.squareI(next.x() - this.centerX, next.z() - this.centerZ) < this.random.nextInt(3072);
        }

        @Override
        public int maxHeightDifference() {
            return 3;
        }

        @Override
        public AbstractDungeonStructure.RoomDungeonPiece newRoom() {
            return new Room((class_3773)BigGlobeStructures.LARGE_DUNGEON_ROOM_TYPE, (class_6880<class_3195>)this.owningStructure, this.paletteIndex, this.random, this.roomDecorators);
        }

        @Override
        public AbstractDungeonStructure.HallDungeonPiece newHall(LabyrinthLayout.RoomPiece room1, LabyrinthLayout.RoomPiece room2, class_2350 direction) {
            return Hall.create((Room)room1, (Room)room2, direction, this.random);
        }
    }

    public static class Hall3
    extends Hall {
        public Hall3(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall3(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator coordinator = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            this.wall(coordinator).setBlockStateLine(-1, 1, 0, 2, 7, 0, 2, palette.mainSupplier());
            this.wall(coordinator).setBlockStateCuboid(-1, 2, 0, 1, 7, 0, palette.mainSupplier());
            this.center(coordinator).setBlockStateLine(-2, 1, 0, 2, 1, 0, 3, palette.slabSupplier(class_2771.field_12681));
            this.center(coordinator).setBlockStateLine(-2, 6, 0, 2, 1, 0, 3, palette.slabSupplier(class_2771.field_12679));
            this.center(coordinator).stack(2, 1, 0, 2).stack(0, 6, 0, 2).setBlockState(-1, 1, 0, palette.mainSupplier());
            this.center(coordinator).stack(2, 1, 0, 3).setBlockStateLine(-2, 2, 0, 0, 1, 0, 4, BlockStates.AIR);
            this.center(coordinator).stack(2, 1, 0, 2).setBlockStateLine(-1, 2, 0, 0, 1, 0, 5, BlockStates.AIR);
        }
    }

    public static class Hall2
    extends Hall {
        public Hall2(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall2(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator coordinator = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            this.wall(coordinator).stack(1, 6, 0, 2).setBlockStateLine(-1, 1, 0, 1, 0, 0, 2, palette.mainSupplier());
            this.wall(coordinator).setBlockStateCuboid(-1, 2, 0, 1, 6, 0, palette.mainSupplier());
            this.center(coordinator).setBlockStateLine(-1, 1, 0, 2, 1, 0, 2, palette.slabSupplier(class_2771.field_12681));
            this.center(coordinator).setBlockStateLine(-1, 6, 0, 2, 1, 0, 2, palette.slabSupplier(class_2771.field_12679));
            this.center(coordinator).setBlockStateLine(0, 1, 0, 0, 6, 0, 2, palette.mainSupplier());
            this.center(coordinator).stack(2, 1, 0, 3).setBlockStateLine(-2, 1, 0, 0, 1, 0, 5, BlockStates.AIR);
            this.center(coordinator).stack(2, 1, 0, 2).setBlockStateLine(-1, 2, 0, 0, 1, 0, 4, BlockStates.AIR);
            if (this.hasBars()) {
                this.center(coordinator).setBlockStateLine(0, 2, 0, 0, 1, 0, 5, palette.barsSupplier(true, false, true, false));
            }
        }
    }

    public static class Hall1
    extends Hall {
        public Hall1(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall1(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator coordinator = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            this.wall(coordinator).stack(2, 7, 0, 2).setBlockState(-1, 0, 0, palette.mainSupplier());
            this.wall(coordinator).setBlockStateCuboid(-1, 1, 0, 1, 6, 0, palette.mainSupplier());
            this.center(coordinator).setBlockState(0, 1, 0, palette.slabSupplier(class_2771.field_12681));
            this.center(coordinator).setBlockState(0, 6, 0, palette.slabSupplier(class_2771.field_12679));
            this.center(coordinator).stack(2, 1, 0, 2).stack(0, 6, 0, 2).setBlockState(-1, 0, 0, palette.mainSupplier());
            this.center(coordinator).stack(1, 0, 0, 2).stack(3, 1, 0, 2).setBlockStateLine(-2, 1, 0, 0, 1, 0, 5, BlockStates.AIR);
            this.center(coordinator).setBlockStateLine(0, 2, 0, 0, 1, 0, 4, BlockStates.AIR);
        }
    }

    public static class Hall0
    extends Hall {
        public Hall0(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall0(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator coordinator = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            this.wall(coordinator).setBlockStateCuboid(-1, 0, 0, 1, 6, 0, palette.mainSupplier());
            this.center(coordinator).stack(0, 6, 0, 2).setBlockStateLine(-1, 0, 0, 1, 0, 0, 3, palette.mainSupplier());
            this.center(coordinator).setBlockStateCuboid(-2, 1, 0, 2, 5, 0, BlockStates.AIR);
            if (this.hasBars()) {
                this.center(coordinator).setBlockStateLine(0, 1, 0, 0, 1, 0, 5, palette.barsSupplier(true, false, true, false));
            }
        }
    }

    public static abstract class Hall
    extends AbstractDungeonStructure.HallDungeonPiece {
        public Hall(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, 0, new class_3341(x - 4, y, z - 4, x + 4, y + 7, z + 4), owningStructure, paletteIndex);
            this.method_14926(direction);
            this.setBars((random.nextInt() & 3) == 0);
            int width = random.nextInt(7) + 1;
            int position = random.nextInt(8 - width) - 3;
            this.setLeft(position);
            this.setRight(position + width - 1);
        }

        public Hall(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public static Hall create(Room from, Room to, class_2350 direction, RandomGenerator random) {
            return Hall.create(from.x() + to.x() >> 1, Math.min(from.y(), to.y()), from.z() + to.z() >> 1, (class_6880<class_3195>)from.owningStructure, from.paletteIndex, direction, to.y() - from.y(), random);
        }

        public static Hall create(int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, int step, RandomGenerator random) {
            return switch (step) {
                case -3 -> new Hall3(BigGlobeStructures.LARGE_DUNGEON_HALL3_TYPE, x, y, z, owningStructure, paletteIndex, direction.method_10153(), random);
                case -2 -> new Hall2(BigGlobeStructures.LARGE_DUNGEON_HALL2_TYPE, x, y, z, owningStructure, paletteIndex, direction.method_10153(), random);
                case -1 -> new Hall1(BigGlobeStructures.LARGE_DUNGEON_HALL1_TYPE, x, y, z, owningStructure, paletteIndex, direction.method_10153(), random);
                case 0 -> new Hall0(BigGlobeStructures.LARGE_DUNGEON_HALL0_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                case 1 -> new Hall1(BigGlobeStructures.LARGE_DUNGEON_HALL1_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                case 2 -> new Hall2(BigGlobeStructures.LARGE_DUNGEON_HALL2_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                case 3 -> new Hall3(BigGlobeStructures.LARGE_DUNGEON_HALL3_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                default -> throw new IllegalArgumentException(Integer.toString(step));
            };
        }

        public Coordinator wall(Coordinator base) {
            return base.multiTranslate(0, 0, this.getLeft() - 1, 0, 0, this.getRight() + 1);
        }

        public Coordinator center(Coordinator base) {
            return base.stack(0, 0, 1, this.getRight() - this.getLeft() + 1).translate(0, 0, this.getLeft());
        }
    }

    public static class TrapPiece
    extends AbstractDungeonStructure.DecorationDungeonPiece {
        public static final class_2680 HOOK_STATE = BlockStates.of("minecraft:tripwire_hook[attached=true,facing=north,powered=false]");
        public static final class_2680 TRIPWIRE_STATE = BlockStates.of("minecraft:tripwire[attached=true,disarmed=false,east=false,north=true,powered=false,south=true,west=false]");

        public TrapPiece(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 orientation) {
            super(type, 0, new class_3341(x - 4, y, z - 4, x + 4, y + 1, z + 4), owningStructure, paletteIndex);
            this.method_14926(orientation);
        }

        public TrapPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public Coordinator coordinator(class_5281 world, class_3341 limit) {
            return super.coordinator(world, limit).rotate1x(Directions.rotationOf(class_2350.field_11043, this.method_14934()));
        }

        @Override
        public Coordinator coordinator(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            return super.coordinator(context).rotate1x(Directions.rotationOf(Directions.POSITIVE_X, this.method_14934()));
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            long seed = Permuter.permute(6905787473737715268L, this.x(), this.y(), this.z());
            Coordinator root = this.coordinator(world, chunkBox);
            for (int row = -3; row <= 3; row += 2) {
                Coordinator translated = root.translate(row, 0, 0);
                translated.flip2Z().setBlockState(0, 0, 3, HOOK_STATE);
                translated.setBlockStateLine(0, 0, 2, 0, 0, -1, 5, TRIPWIRE_STATE);
                (Permuter.toBoolean(Permuter.permute(seed, row)) ? translated.flip1Z() : translated).setBlockStateAndBlockEntity(0, 1, 4, (class_2680)class_2246.field_10200.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043), class_2601.class, this::initDispenser);
            }
        }

        public void initDispenser(class_2338.class_2339 pos, class_2601 dispenser) {
            dispenser.method_54867(class_39.field_751, Permuter.permute(-9159203327347141718L, (class_2382)pos));
        }
    }

    public static class SpawnerPiece
    extends AbstractDungeonStructure.SpawnerDungeonPiece {
        public static final int BARS_BIT = 2;

        public SpawnerPiece(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_6880<class_1299<?>> spawnerType, RandomGenerator random) {
            super(type, 0, new class_3341(x - 1, y, z - 1, x + 1, y + 3, z + 1), owningStructure, paletteIndex, spawnerType);
            this.setBars(random.nextBoolean());
        }

        public SpawnerPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public boolean hasBars() {
            return (this.variant & 2) != 0;
        }

        public void setBars(boolean bars) {
            this.variant = (byte)(bars ? this.variant | 2 : this.variant & 0xFFFFFFFD);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            AbstractDungeonStructure.Palette palette = this.palette();
            root.setBlockState(0, 0, 0, palette.mainSupplier());
            root.setBlockStateAndBlockEntity(0, 1, 0, class_2246.field_10260.method_9564(), class_2636.class, this::initSpawner);
            root.setBlockState(0, 2, 0, palette.mainSupplier());
            root.setBlockState(0, 3, 0, palette.slabSupplier(class_2771.field_12681));
            if (this.hasBars()) {
                root.rotate4x90().setBlockStateLine(0, 0, 1, 0, 1, 0, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11043, class_2778.field_12710), palette.barsSupplier(false, true, false, true), palette.stairsSupplier(class_2760.field_12619, class_2350.field_11043, class_2778.field_12710));
                root.rotate4x90().setBlockStateLine(1, 0, 1, 0, 1, 0, palette.mainSupplier(), palette.wallSupplier(class_4778.field_22180, class_4778.field_22178, class_4778.field_22178, class_4778.field_22180, true), palette.stairsSupplier(class_2760.field_12617, class_2350.field_11043, class_2778.field_12708));
            } else {
                root.rotate4x90().setBlockStateLine(0, 0, 1, 0, 1, 0, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11043, class_2778.field_12710), null, palette.stairsSupplier(class_2760.field_12619, class_2350.field_11043, class_2778.field_12710));
                root.rotate4x90().setBlockStateLine(1, 0, 1, 0, 1, 0, palette.mainSupplier(), palette.wallSupplier(class_4778.field_22178, class_4778.field_22178, class_4778.field_22178, class_4778.field_22178, true), palette.stairsSupplier(class_2760.field_12617, class_2350.field_11043, class_2778.field_12708));
            }
        }

        @Override
        public void initSpawner(class_2338 pos, class_2636 spawner) {
            super.initSpawner(pos, spawner);
            MobSpawnerLogic_GettersAndSettersForEverything logic = (MobSpawnerLogic_GettersAndSettersForEverything)spawner.method_11390();
            logic.bigglobe_setRequiredPlayerRange(32);
            logic.bigglobe_setMaxNearbyEntities(6);
            logic.bigglobe_setSpawnCount(4);
        }
    }

    public static class ChestPiece
    extends AbstractDungeonStructure.ChestDungeonPiece {
        public ChestPiece(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 facing, long seed) {
            super(type, 0, new class_3341(x - 2, y, z - 2, x + 2, y + 1, z + 2), owningStructure, paletteIndex, facing, seed);
        }

        public ChestPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            AbstractDungeonStructure.Palette palette = this.palette();
            Coordinator root = this.coordinator(world, chunkBox);
            root.setBlockState(0, 0, 0, palette.mainSupplier());
            root.setBlockStateAndBlockEntity(0, 1, 0, class_2246.field_10034.method_9564(), class_2595.class, this::initChest);
            root.flip2X().setBlockStateLine(1, 0, 0, 0, 1, 0, palette.mainSupplier(), palette.slabSupplier(class_2771.field_12681));
            root.flip2Z().setBlockState(0, 0, 1, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11043, class_2778.field_12710));
            root.flip4XZ().setBlockState(1, 0, 1, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11039, class_2778.field_12709));
            root.flip2X().setBlockState(2, 0, 0, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11039, class_2778.field_12710));
        }
    }

    public static class Room
    extends AbstractDungeonStructure.RoomDungeonPiece {
        public Room(class_3773 type, class_6880<class_3195> owningStructure, int paletteIndex, RandomGenerator random, @Nullable DelayedEntryList<class_2975<?, ?>> decorators) {
            super(type, 0, null, owningStructure, paletteIndex, decorators);
            this.setPit((random.nextInt() & 7) == 0);
            this.setPos(0, 0, 0);
        }

        public Room(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void setPos(int x, int y, int z) {
            this.field_15315 = new class_3341(x - 4, this.hasPit() ? y - 2 : y, z - 4, x + 4, y + 6, z + 4);
        }

        @Override
        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            super.method_14931(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
            if (!this.hasPit() && this.support) {
                class_3341 intersection = WorldUtil.intersection(this.field_15315, chunkBox);
                if (intersection == null) {
                    return;
                }
                class_2338.class_2339 pos = new class_2338.class_2339();
                CoordinateFunctions.CoordinateSupplier<class_2680> mainBlock = this.palette().mainSupplier();
                int centerX = this.x();
                int centerZ = this.z();
                pos.method_33099(intersection.method_35417());
                while (pos.method_10260() <= intersection.method_35420()) {
                    pos.method_33097(intersection.method_35415());
                    while (pos.method_10263() <= intersection.method_35418()) {
                        int gap = Math.min(Math.abs(pos.method_10263() - centerX), Math.abs(pos.method_10260() - centerZ));
                        if (gap > 1) {
                            pos.method_33098(this.y() - 1);
                            if (BlockStateVersions.isReplaceable(world.method_8320((class_2338)pos))) {
                                world.method_8652((class_2338)pos, mainBlock.get(pos), 3);
                                if (gap > 2) {
                                    while (!world.method_31606((class_2338)pos.method_33098(pos.method_10264() - 1)) && BlockStateVersions.isReplaceable(world.method_8320((class_2338)pos))) {
                                        world.method_8652((class_2338)pos, mainBlock.get(pos), 3);
                                    }
                                }
                            }
                        }
                        pos.method_33097(pos.method_10263() + 1);
                    }
                    pos.method_33099(pos.method_10260() + 1);
                }
            }
        }

        @Override
        public void addDecorations(LabyrinthLayout layout) {
            super.addDecorations(layout);
            if (this.hasPit()) {
                layout.decorations.add((Object)new AbstractDungeonStructure.PitDungeonPiece(BigGlobeStructures.DUNGEON_PIT_TYPE, this.x(), this.y(), this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, layout.random.nextInt(4), layout.random));
                this.decorators = null;
            } else {
                class_2350 orientation = this.getHallwayDirection();
                if (orientation != null) {
                    layout.decorations.add((Object)new TrapPiece(BigGlobeStructures.LARGE_DUNGEON_TRAP_TYPE, this.x(), this.y() + 1, this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, orientation));
                    this.decorators = null;
                } else {
                    orientation = this.getDeadEndDirection();
                    if (orientation != null) {
                        if (layout.random.nextBoolean()) {
                            layout.decorations.add((Object)new ChestPiece(BigGlobeStructures.LARGE_DUNGEON_CHEST_TYPE, this.x(), this.y() + 1, this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, orientation, layout.random.nextLong()));
                            this.decorators = null;
                        }
                    } else if ((layout.random.nextInt() & 7) == 0) {
                        layout.decorations.add((Object)new SpawnerPiece(BigGlobeStructures.LARGE_DUNGEON_SPAWNER_TYPE, this.x(), this.y() + 1, this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, (class_6880)((Layout)layout).spawnerEntries.getRandomElement(layout.random), layout.random));
                        this.decorators = null;
                    }
                }
            }
        }

        @Nullable
        public class_2350 getHallwayDirection() {
            AbstractDungeonStructure.RoomDungeonPiece north = this.getConnectedRoom(class_2350.field_11043);
            AbstractDungeonStructure.RoomDungeonPiece south = this.getConnectedRoom(class_2350.field_11035);
            AbstractDungeonStructure.RoomDungeonPiece east = this.getConnectedRoom(class_2350.field_11034);
            AbstractDungeonStructure.RoomDungeonPiece west = this.getConnectedRoom(class_2350.field_11039);
            if (north != null && south != null && east == null && west == null) {
                return class_2350.field_11034;
            }
            if (north == null && south == null && east != null && west != null) {
                return class_2350.field_11043;
            }
            return null;
        }
    }
}

