/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.scripted;

import builderb0y.autocodec.annotations.DefaultInt;
import builderb0y.autocodec.annotations.ForceOrdinal;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.codecs.UseSuperClass;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.mixinInterfaces.NbtCompoundExtensions;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.scripting.wrappers.entries.StructurePlacementScriptEntry;
import builderb0y.bigglobe.structures.BigGlobeStructure;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.structures.RawGenerationStructure;
import builderb0y.bigglobe.structures.scripted.StructureLayoutScript;
import builderb0y.bigglobe.structures.scripted.StructurePlacementScript;
import builderb0y.bigglobe.util.CheckedList;
import builderb0y.bigglobe.util.SymmetricOffset;
import builderb0y.bigglobe.util.Symmetry;
import builderb0y.bigglobe.util.WorldOrChunk;
import builderb0y.bigglobe.util.WorldUtil;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.random.RandomGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_7151;

public class ScriptedStructure
extends BigGlobeStructure
implements RawGenerationStructure {
    public static final Codec<ScriptedStructure> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(ScriptedStructure.class).codec();
    public final StructureLayoutScript.Holder layout;
    public final @DefaultInt(value=8) int max_radius_in_chunks;

    public ScriptedStructure(class_3195.class_7302 config, StructureLayoutScript.Holder layout, int max_radius_in_chunks) {
        super(config, null, null);
        this.layout = layout;
        this.max_radius_in_chunks = max_radius_in_chunks;
    }

    @Override
    public int bigglobe_getMaxRadiusInChunks() {
        return this.max_radius_in_chunks;
    }

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2794 class_27942 = context.comp_562();
        if (!(class_27942 instanceof BigGlobeScriptedChunkGenerator)) {
            return Optional.empty();
        }
        BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
        Permuter permuter = Permuter.from((class_5819)context.comp_566());
        int x = context.comp_568().method_8326() | permuter.nextInt(16);
        int z = context.comp_568().method_8328() | permuter.nextInt(16);
        boolean distantHorizons = DistantHorizonsCompat.isOnDistantHorizonThread();
        ScriptedColumn.Hints hints = ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints(distantHorizons);
        ScriptedColumnLookup.Impl lookup = new ScriptedColumnLookup.Impl(generator.columnEntryRegistry.columnFactory, new ScriptedColumn.Params(generator.columnSeed, 0, 0, context.comp_569(), hints, generator.compiledWorldTraits));
        CheckedList<class_3443> pieces = new CheckedList<class_3443>(class_3443.class);
        this.layout.layout(lookup, x, z, generator.columnSeed, permuter, pieces);
        class_6626 collector = new class_6626();
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (class_3443 piece : pieces) {
            collector.method_35462(piece);
            minY = Math.min(minY, piece.method_14935().method_35416());
            maxY = Math.max(maxY, piece.method_14935().method_35419());
        }
        return Optional.of(new class_3195.class_7150(new class_2338(x, maxY + minY + 1 >> 1, z), Either.right((Object)collector)));
    }

    public class_7151<?> method_41618() {
        return BigGlobeStructures.SCRIPTED;
    }

    public static class Piece
    extends class_3443
    implements RawGenerationStructure.RawGenerationStructurePiece {
        public final class_3341 originalBoundingBox;
        public SymmetricOffset transformation;
        public final StructurePlacementScriptEntry placement;
        public final class_2487 data;

        public String toString() {
            return "ScriptedStructurePiece: { original bounding box: " + String.valueOf(this.originalBoundingBox) + ", current bounding box: " + String.valueOf(this.field_15315) + ", transformation: " + String.valueOf(this.transformation) + ", placement: " + this.placement.id() + ", data: " + String.valueOf(this.data) + " }";
        }

        public Piece(class_3773 type, class_3341 boundingBox, StructurePlacementScriptEntry placement, class_2487 data) {
            super(type, 0, boundingBox);
            this.originalBoundingBox = boundingBox;
            this.placement = placement;
            this.data = data;
            this.transformation = SymmetricOffset.IDENTITY;
        }

        public Piece(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, StructurePlacementScriptEntry placement, class_2487 data) {
            this(BigGlobeStructures.SCRIPTED_PIECE, new class_3341(minX, minY, minZ, maxX, maxY, maxZ), placement, data);
        }

        public Piece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, nbt);
            SerialData data;
            try {
                data = (SerialData)BigGlobeAutoCodec.AUTO_CODEC.decode(SerialData.CODER, (Object)nbt, (DynamicOps)class_2509.field_11560);
            }
            catch (DecodeException exception) {
                throw new RuntimeException(exception);
            }
            this.originalBoundingBox = data.OBB;
            SymmetricOffset symmetricOffset = this.transformation = data.transform != null ? data.transform : SymmetricOffset.IDENTITY;
            if (data.rot != null && data.rot != class_2470.field_11467) {
                this.transformation = this.transformation.rotateAround(this.originalBoundingBox.method_35415() + this.originalBoundingBox.method_35418() + 1 >> 1, this.originalBoundingBox.method_35417() + this.originalBoundingBox.method_35420() + 1 >> 1, Symmetry.of(data.rot));
            }
            this.updateBoundingBox();
            this.placement = StructurePlacementScriptEntry.of(data.script, 0);
            this.data = data.data;
        }

        public void method_14943(class_6625 context, class_2487 nbt) {
            for (Map.Entry<String, class_2520> entry : ((NbtCompoundExtensions)BigGlobeAutoCodec.AUTO_CODEC.encode(SerialData.CODER, (Object)this.serialize(), (DynamicOps)class_2509.field_11560)).bigglobe_getEntrySet()) {
                nbt.method_10566(entry.getKey(), entry.getValue());
            }
        }

        public SerialData serialize() {
            return new SerialData(this.placement.id(), this.transformation, null, this.originalBoundingBox, this.data);
        }

        public Piece symmetrify(Symmetry symmetry) {
            return this.symmetrifyAround(this.field_15315.method_35415() + this.field_15315.method_35418() + 1 >> 1, this.field_15315.method_35417() + this.field_15315.method_35420() + 1 >> 1, symmetry);
        }

        public Piece withRotation(int rotation) {
            return this.symmetrify(Symmetry.rotation(rotation));
        }

        public Piece rotateAround(int x, int z, int rotation) {
            return this.symmetrifyAround(x, z, Symmetry.rotation(rotation));
        }

        public Piece symmetrifyAround(int x, int z, Symmetry symmetry) {
            this.setTransformation(this.transformation.rotateAround(x, z, symmetry));
            return this;
        }

        public Piece rotateRandomly(RandomGenerator random) {
            return this.symmetrify(Symmetry.VALUES[random.nextInt(4)]);
        }

        public Piece rotateAndFlipRandomly(RandomGenerator random) {
            return this.symmetrify(Symmetry.VALUES[random.nextInt(8)]);
        }

        public Piece rotateRandomly(long seed) {
            return this.symmetrify(Symmetry.VALUES[Permuter.nextBoundedInt(seed, 4)]);
        }

        public Piece rotateAndFlipRandomly(long seed) {
            return this.symmetrify(Symmetry.VALUES[Permuter.nextBoundedInt(seed, 8)]);
        }

        public Piece offset(int x, int y, int z) {
            this.method_14922(x, y, z);
            return this;
        }

        public void method_14922(int x, int y, int z) {
            this.setTransformation(this.transformation.offset(x, y, z));
        }

        public Symmetry symmetry() {
            return this.transformation.symmetry();
        }

        public int offsetX() {
            return this.transformation.offsetX();
        }

        public int offsetY() {
            return this.transformation.offsetY();
        }

        public int offsetZ() {
            return this.transformation.offsetZ();
        }

        public StructurePlacementScriptEntry placement() {
            return this.placement;
        }

        public void setTransformation(SymmetricOffset transformation) {
            this.transformation = transformation;
            this.updateBoundingBox();
        }

        public void updateBoundingBox() {
            class_2338.class_2339 pos1 = WorldWrapper.Coordination.rotate(new class_2338.class_2339(this.originalBoundingBox.method_35415(), this.originalBoundingBox.method_35416(), this.originalBoundingBox.method_35417()), this.transformation);
            class_2338.class_2339 pos2 = WorldWrapper.Coordination.rotate(new class_2338.class_2339(this.originalBoundingBox.method_35418(), this.originalBoundingBox.method_35419(), this.originalBoundingBox.method_35420()), this.transformation);
            this.field_15315 = WorldUtil.createBlockBox(pos1.method_10263(), pos1.method_10264(), pos1.method_10260(), pos2.method_10263(), pos2.method_10264(), pos2.method_10260());
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            StructurePlacementScript.Holder rawPlacement = ((CombinedStructureScripts)this.placement.entry.comp_349()).raw_placement;
            if (rawPlacement == null) {
                return;
            }
            int minX = this.originalBoundingBox.method_35415();
            int minY = this.originalBoundingBox.method_35416();
            int minZ = this.originalBoundingBox.method_35417();
            int maxX = this.originalBoundingBox.method_35418();
            int maxY = this.originalBoundingBox.method_35419();
            int maxZ = this.originalBoundingBox.method_35420();
            int midX = minX + maxX + 1 >> 1;
            int midY = minY + maxY + 1 >> 1;
            int midZ = minZ + maxZ + 1 >> 1;
            class_3341 chunkBox = WorldUtil.chunkBox(context.chunk);
            int effectiveMinX = Math.max(this.field_15315.method_35415(), chunkBox.method_35415());
            int effectiveMinY = Math.max(this.field_15315.method_35416(), chunkBox.method_35416());
            int effectiveMinZ = Math.max(this.field_15315.method_35417(), chunkBox.method_35417());
            int effectiveMaxX = Math.min(this.field_15315.method_35418(), chunkBox.method_35418());
            int effectiveMaxY = Math.min(this.field_15315.method_35419(), chunkBox.method_35419());
            int effectiveMaxZ = Math.min(this.field_15315.method_35420(), chunkBox.method_35420());
            rawPlacement.place(new WorldWrapper(new WorldOrChunk.ChunkDelegator(context.chunk, context.columnSeed), context.generator, new Permuter(context.pieceSeed), new WorldWrapper.Coordination(this.transformation, new class_3341(effectiveMinX, effectiveMinY, effectiveMinZ, effectiveMaxX, effectiveMaxY, effectiveMaxZ), chunkBox), ScriptedColumn.ColumnUsage.RAW_GENERATION.maybeDhHints(context.distantHorizons)), minX, minY, minZ, maxX, maxY, maxZ, midX, midY, midZ, chunkBox.method_35415(), chunkBox.method_35416(), chunkBox.method_35417(), chunkBox.method_35418(), chunkBox.method_35419(), chunkBox.method_35420(), this);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            if (!(chunkGenerator instanceof BigGlobeScriptedChunkGenerator)) {
                return;
            }
            BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)chunkGenerator;
            int minX = this.originalBoundingBox.method_35415();
            int minY = this.originalBoundingBox.method_35416();
            int minZ = this.originalBoundingBox.method_35417();
            int maxX = this.originalBoundingBox.method_35418();
            int maxY = this.originalBoundingBox.method_35419();
            int maxZ = this.originalBoundingBox.method_35420();
            int midX = minX + maxX + 1 >> 1;
            int midY = minY + maxY + 1 >> 1;
            int midZ = minZ + maxZ + 1 >> 1;
            int effectiveMinX = Math.max(this.field_15315.method_35415(), chunkBox.method_35415());
            int effectiveMinY = Math.max(this.field_15315.method_35416(), chunkBox.method_35416());
            int effectiveMinZ = Math.max(this.field_15315.method_35417(), chunkBox.method_35417());
            int effectiveMaxX = Math.min(this.field_15315.method_35418(), chunkBox.method_35418());
            int effectiveMaxY = Math.min(this.field_15315.method_35419(), chunkBox.method_35419());
            int effectiveMaxZ = Math.min(this.field_15315.method_35420(), chunkBox.method_35420());
            Permuter permuter = Permuter.from(random);
            ((CombinedStructureScripts)this.placement.object()).placement.place(new WorldWrapper(new WorldOrChunk.WorldDelegator(world), generator, permuter, new WorldWrapper.Coordination(this.transformation, new class_3341(effectiveMinX, effectiveMinY, effectiveMinZ, effectiveMaxX, effectiveMaxY, effectiveMaxZ), WorldUtil.surroundingChunkBox(chunkPos, (class_5539)world)), ScriptedColumn.ColumnUsage.FEATURES.maybeDhHints()), minX, minY, minZ, maxX, maxY, maxZ, midX, midY, midZ, chunkBox.method_35415(), chunkBox.method_35416(), chunkBox.method_35417(), chunkBox.method_35418(), chunkBox.method_35419(), chunkBox.method_35420(), this);
        }

        public record SerialData(String script, @VerifyNullable SymmetricOffset transform, @VerifyNullable @ForceOrdinal(value=true) class_2470 rot, class_3341 OBB, @UseSuperClass(value=class_2520.class) class_2487 data) {
            public static final AutoCoder<SerialData> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(SerialData.class);
        }
    }

    public record CombinedStructureScripts(StructurePlacementScript.Holder placement,  @VerifyNullable StructurePlacementScript.Holder raw_placement) {
    }
}

