/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees.decoration;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.trees.TreeGenerator;
import builderb0y.bigglobe.trees.decoration.ShelfPlacer;
import builderb0y.bigglobe.trees.decoration.TrunkLayerDecorator;
import builderb0y.bigglobe.trees.trunks.TrunkConfig;
import java.util.random.RandomGenerator;
import net.minecraft.class_2338;

public class ShelfDecorator
implements TrunkLayerDecorator {
    public static final ShelfDecorator EMPTY = new ShelfDecorator(new RandomList<ShelfPlacer>(0), 0.0, 0.0);
    public final IRandomList.KnownTotalWeightRandomList<ShelfPlacer> placers;
    public final double maxHeightFrac;
    public final double density;
    public double probability;

    public ShelfDecorator(IRandomList.KnownTotalWeightRandomList<ShelfPlacer> placers, double maxHeightFrac, double density) {
        if (placers.contains(null)) {
            throw new IllegalArgumentException("placers contains null");
        }
        this.placers = placers;
        this.maxHeightFrac = maxHeightFrac;
        this.density = density;
    }

    @Override
    public void decorate(TreeGenerator generator, TrunkConfig trunk, int y) {
        if (this.placers.isEmptyOrWeightless()) {
            return;
        }
        if (generator.trunk.currentFracY >= this.maxHeightFrac) {
            return;
        }
        double probability = this.probability;
        if (Permuter.nextChancedBoolean((RandomGenerator)generator.random, probability / (probability + 1.0))) {
            ShelfPlacer placer = (ShelfPlacer)this.placers.getRandomElement(generator.random);
            if (placer == null) {
                throw new AssertionError((Object)"placer is null");
            }
            double angle = generator.random.nextDouble(Math.PI * 2);
            double distanceFromCenter = generator.trunk.currentRadius + 1.0;
            double centerX = Math.cos(angle) * distanceFromCenter + generator.trunk.currentX;
            double centerZ = Math.sin(angle) * distanceFromCenter + generator.trunk.currentZ;
            double shelfRadius = distanceFromCenter * (generator.random.nextDouble() * 0.5 + 0.5);
            double shelfRadius2 = shelfRadius * shelfRadius;
            int minX = BigGlobeMath.ceilI(centerX - shelfRadius);
            int maxX = BigGlobeMath.floorI(centerX + shelfRadius);
            int minZ = BigGlobeMath.ceilI(centerZ - shelfRadius);
            int maxZ = BigGlobeMath.floorI(centerZ + shelfRadius);
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            class_2338.class_2339 offsetPos = new class_2338.class_2339();
            mutablePos.method_33098(y);
            for (int x = minX; x <= maxX; ++x) {
                mutablePos.method_33097(x);
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(BigGlobeMath.squareD((double)x - centerX, (double)z - centerZ) < shelfRadius2)) continue;
                    mutablePos.method_33099(z);
                    if (!generator.canShelfReplace(generator.worldQueue.method_8320((class_2338)mutablePos))) continue;
                    placer.queueBlockAt(generator, (class_2338)mutablePos, offsetPos);
                }
            }
            this.probability = 0.0;
        } else {
            this.probability = probability + this.density;
        }
    }
}

