/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees.trunks;

import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.trees.trunks.TrunkConfig;
import builderb0y.bigglobe.trees.trunks.TrunkThicknessScript;
import java.util.random.RandomGenerator;
import net.minecraft.class_2338;

public class TwistedTrunkConfig
extends TrunkConfig {
    public final double waveAngleStart;
    public final double waveAngleSpeed;

    public TwistedTrunkConfig(double startX, int startY, double startZ, int height, double waveAngleStart, double waveAngleSpeed, TrunkThicknessScript thicknessScript, boolean requireValidGround, boolean canGenerateInLiquid) {
        super(startX, startY, startZ, height, thicknessScript, requireValidGround, canGenerateInLiquid);
        this.waveAngleStart = waveAngleStart;
        this.waveAngleSpeed = waveAngleSpeed;
    }

    public static TwistedTrunkConfig create(class_2338 origin, int height, double startSize, RandomGenerator random, TrunkThicknessScript thicknessScript, boolean requireValidGround, boolean canGenerateInLiquid) {
        return new TwistedTrunkConfig((double)origin.method_10263() + random.nextDouble() - 0.5, origin.method_10264(), (double)origin.method_10260() + random.nextDouble() - 0.5, height, random.nextDouble(Math.PI * 2), TwistedTrunkConfig.randomTwistSpeed(random), thicknessScript, requireValidGround, canGenerateInLiquid);
    }

    public static double randomTwistSpeed(RandomGenerator random) {
        double speed = Interpolator.smooth(random.nextDouble()) * 16.0 - 8.0;
        return random.nextBoolean() ? -speed : speed;
    }

    @Override
    public void setFrac(double fracY) {
        super.setFrac(fracY);
        double bulge = fracY * (1.0 - fracY);
        double angle = fracY * this.waveAngleSpeed + this.waveAngleStart;
        double amplitude = bulge * this.baseRadius * 3.0;
        this.currentX = this.startX + Math.cos(angle) * amplitude;
        this.currentZ = this.startZ + Math.sin(angle) * amplitude;
    }
}

