/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.util.AsyncRunner;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BigGlobeThreadPool {
    public static final AtomicBoolean BUSY = new AtomicBoolean(false);
    public static final LinkedBlockingDeque<Runnable> TASKS = new LinkedBlockingDeque();
    public static final ThreadPoolExecutor POOL;
    public static final Executor MAIN_EXECUTOR;
    public static final Executor LOD_EXECUTOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkThreads() {
        int threads = BigGlobeConfig.INSTANCE.get().threads();
        ThreadPoolExecutor threadPoolExecutor = POOL;
        synchronized (threadPoolExecutor) {
            if (threads < POOL.getMaximumPoolSize()) {
                POOL.setCorePoolSize(threads);
                POOL.setMaximumPoolSize(threads);
            } else if (threads > POOL.getMaximumPoolSize()) {
                POOL.setMaximumPoolSize(threads);
                POOL.setCorePoolSize(threads);
                POOL.prestartAllCoreThreads();
            }
        }
    }

    public static void onMainTaskStarted() {
        BUSY.set(true);
    }

    public static Executor mainExecutor() {
        BigGlobeThreadPool.checkThreads();
        BigGlobeThreadPool.onMainTaskStarted();
        return MAIN_EXECUTOR;
    }

    public static Executor lodExecutor() {
        BigGlobeThreadPool.checkThreads();
        return LOD_EXECUTOR;
    }

    public static AsyncRunner mainRunner() {
        return new AsyncRunner(BigGlobeThreadPool.mainExecutor());
    }

    public static AsyncRunner lodRunner() {
        return new AsyncRunner(BigGlobeThreadPool.lodExecutor());
    }

    public static AsyncRunner runner(boolean distantHorizons) {
        return distantHorizons ? BigGlobeThreadPool.lodRunner() : BigGlobeThreadPool.mainRunner();
    }

    public static AsyncRunner autoRunner() {
        return BigGlobeThreadPool.runner(DistantHorizonsCompat.isOnDistantHorizonThread());
    }

    public static Executor executor(boolean distantHorizons) {
        return distantHorizons ? BigGlobeThreadPool.lodExecutor() : BigGlobeThreadPool.mainExecutor();
    }

    public static Executor autoExecutor() {
        return BigGlobeThreadPool.executor(DistantHorizonsCompat.isOnDistantHorizonThread());
    }

    public static boolean isBusy() {
        return BUSY.getAndSet(false);
    }

    static {
        int threads = Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        POOL = new ThreadPoolExecutor(threads, threads, 1L, TimeUnit.SECONDS, TASKS, task -> {
            Thread thread = new Thread(task, "Big Globe Worker Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((thread_, exception) -> {
                BigGlobeMod.LOGGER.error("An unexpected exception occurred in " + String.valueOf(thread) + ": ", exception);
                POOL.prestartAllCoreThreads();
            });
            return thread;
        });
        POOL.prestartAllCoreThreads();
        MAIN_EXECUTOR = TASKS::addFirst;
        LOD_EXECUTOR = TASKS::addLast;
    }
}

