/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.autocodec.annotations.SingletonArray;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.columns.scripted.ColumnEntryRegistry;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.util.DelayedEntry;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.random.RandomGenerator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedEntryList<T>
implements ColumnEntryRegistry.DelayedCompileable {
    public static final Comparator<class_6880<?>> COMPARATOR = Comparator.comparing(UnregisteredObjectException::getID);
    @Nullable
    public final BetterRegistry<T> resolver;
    @NotNull
    public final class_5321<class_2378<T>> registryKey;
    public final @SingletonArray @NotNull List<DelayedEntry> delayedEntries;
    public SortedEncodings sortedEncodings;
    public boolean compileCalled = true;
    @Nullable
    public List<class_6880<T>> entryList;
    @Nullable
    public Set<class_6880<T>> entrySet;
    @Nullable
    public List<T> objectList;
    @Nullable
    public Set<T> objectSet;
    @Nullable
    public class_6885<T> tag;

    public DelayedEntryList(class_5321<class_2378<T>> key) {
        this.resolver = null;
        this.registryKey = key;
        this.delayedEntries = Collections.emptyList();
        this.sortedEncodings = new SortedEncodings(Collections.emptyList());
        this.entryList = Collections.emptyList();
        this.entrySet = Collections.emptySet();
        this.objectList = Collections.emptyList();
        this.objectSet = Collections.emptySet();
        this.tag = class_6885.method_40246((class_6880[])new class_6880[0]);
    }

    public DelayedEntryList(@NotNull BetterRegistry<T> resolver, @SingletonArray @NotNull List<DelayedEntry> delayedEntries) {
        this.resolver = resolver;
        this.registryKey = resolver.getKey();
        this.delayedEntries = delayedEntries;
    }

    public DelayedEntryList(@NotNull BetterRegistry<T> resolver, @NotNull class_6885<T> list) {
        this.resolver = resolver;
        this.registryKey = resolver.getKey();
        Optional key = list.method_45925();
        if (key.isPresent()) {
            this.delayedEntries = Collections.singletonList(new DelayedEntry("#" + ((class_6862)key.get()).comp_327().toString()));
        } else {
            this.delayedEntries = list.method_40239().map(UnregisteredObjectException::getID).map(id -> new DelayedEntry((class_2960)id, false)).toList();
            this.entryList = list.method_40239().toList();
        }
    }

    public static <T> DelayedEntryList<T> empty(class_5321<class_2378<T>> key) {
        return new DelayedEntryList<T>(key);
    }

    public static <T> DelayedEntryList<T> emptyOnClient(class_5321<class_2378<T>> key, boolean client, String ... ids) {
        return client ? DelayedEntryList.empty(key) : DelayedEntryList.create(key, false, ids);
    }

    public static <T> DelayedEntryList<T> create(class_5321<class_2378<T>> key, boolean client, String ... args) {
        List<DelayedEntry> list = Arrays.stream(args).filter(Objects::nonNull).map(DelayedEntry::new).toList();
        return list.isEmpty() ? DelayedEntryList.empty(key) : new DelayedEntryList<T>(BigGlobeMod.getSidedRegistry(key, client), list);
    }

    public static <T> DelayedEntryList<T> create(class_5321<class_2378<T>> registryKey, boolean client, String input) {
        if (input == null) {
            return DelayedEntryList.empty(registryKey);
        }
        return new DelayedEntryList<T>(BigGlobeMod.getSidedRegistry(registryKey, client), Collections.singletonList(new DelayedEntry(input)));
    }

    public static <T> DelayedEntryList<T> create(BetterRegistry<T> registry, String input) {
        if (input == null) {
            return DelayedEntryList.empty(registry.getKey());
        }
        return new DelayedEntryList<T>(registry, Collections.singletonList(new DelayedEntry(input)));
    }

    public boolean isResolved() {
        return this.entryList != null;
    }

    public List<class_6880<T>> entryList() {
        List<class_6880<T>> entryList = this.entryList;
        if (entryList == null) {
            entryList = this.entryList = this.resolve();
        }
        return entryList;
    }

    public Set<class_6880<T>> entrySet() {
        Set<class_6880<T>> entrySet = this.entrySet;
        if (entrySet == null) {
            entrySet = this.entrySet = Set.copyOf(this.entryList());
        }
        return entrySet;
    }

    public List<T> objectList() {
        List<Object> objectList = this.objectList;
        if (objectList == null) {
            objectList = this.objectList = this.entryList().stream().map(class_6880::comp_349).toList();
        }
        return objectList;
    }

    public Set<T> objectSet() {
        Set<T> objectSet = this.objectSet;
        if (objectSet == null) {
            objectSet = this.objectSet = this.entryList().stream().map(class_6880::comp_349).collect(Collectors.toUnmodifiableSet());
        }
        return objectSet;
    }

    public class_6885<T> tag() {
        if (this.tag == null) {
            this.tag = class_6885.method_40242(this.entryList());
        }
        return this.tag;
    }

    public Stream<class_6880<T>> entryStream() {
        return this.entryList().stream();
    }

    public Stream<T> objectStream() {
        return this.entryList().stream().map(class_6880::comp_349);
    }

    public boolean contains(T object) {
        return this.objectSet().contains(object);
    }

    public boolean contains(class_6880<T> entry) {
        return this.entrySet().contains(entry);
    }

    public int size() {
        return this.entryList().size();
    }

    public boolean isEmpty() {
        return this.entryList().isEmpty();
    }

    public T randomObject(RandomGenerator random) {
        return (T)Permuter.choose(random, this.entryList()).comp_349();
    }

    public class_6880<T> randomEntry(RandomGenerator random) {
        return Permuter.choose(random, this.entryList());
    }

    public T randomObject(long seed) {
        return (T)Permuter.choose(seed, this.entryList()).comp_349();
    }

    public class_6880<T> randomEntry(long seed) {
        return Permuter.choose(seed, this.entryList());
    }

    public List<class_6880<T>> resolve() {
        if (this.resolver == null) {
            throw new IllegalStateException("Can't resolve DelayedEntryList with no registry!");
        }
        if (!this.compileCalled) {
            BigGlobeMod.LOGGER.warn("Something is trying to resolve a DelayedEntryList too early!", (Throwable)new IllegalStateException("Stack trace"));
        }
        List entryList = this.entryList = this.delayedEntries.stream().flatMap(element -> {
            if (element.isTag()) {
                class_6862 key = class_6862.method_40092(this.registryKey, (class_2960)element.id);
                class_6885<T> resolution = this.resolver.requireTag(key);
                if (resolution.method_40247() == 0 && BigGlobeConfig.INSTANCE.get().dataPackDebugging.emptyTags) {
                    BigGlobeMod.LOGGER.warn("Empty tag: " + String.valueOf(key));
                }
                return resolution.method_40239();
            }
            return Stream.of(this.resolver.requireById(element.id));
        }).collect(Collector.of(() -> new TreeSet(COMPARATOR), TreeSet::add, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        }, List::copyOf, new Collector.Characteristics[0]));
        this.objectList = null;
        this.objectSet = null;
        this.entrySet = null;
        return entryList;
    }

    @Override
    public void compile(ColumnEntryRegistry registry) {
        if (!this.compileCalled) {
            this.compileCalled = true;
            this.resolve();
        }
    }

    @Override
    public void delay() {
        ColumnEntryRegistry.Loading.get().addTag(this);
    }

    public SortedEncodings getSortedEncodings() {
        if (this.sortedEncodings == null) {
            this.sortedEncodings = new SortedEncodings(this.delayedEntries);
        }
        return this.sortedEncodings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DelayedEntryList)) return false;
        DelayedEntryList that = (DelayedEntryList)obj;
        if (this.registryKey != that.registryKey) return false;
        if (!this.getSortedEncodings().equals(that.getSortedEncodings())) return false;
        return true;
    }

    public int hashCode() {
        return this.getSortedEncodings().hashCode();
    }

    public String toString() {
        List<DelayedEntry> entries = this.delayedEntries;
        int size = entries.size();
        StringBuilder builder = new StringBuilder(size + 1 << 6).append(this.registryKey.method_29177());
        if (size == 0) {
            return builder.append("[]").toString();
        }
        builder.append("[ ").append(entries.get((int)0).encoding);
        for (int index = 1; index < size; ++index) {
            builder.append(", ").append(entries.get(index));
        }
        return builder.append(" ]").toString();
    }

    public static class SortedEncodings {
        public final String[] array;
        public final int hashCode;

        public SortedEncodings(List<DelayedEntry> entries) {
            this.array = (String[])entries.stream().map(DelayedEntry::encoding).sorted().toArray(String[]::new);
            this.hashCode = Arrays.hashCode(this.array);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SortedEncodings) {
                String[] b;
                String[] a;
                int length;
                SortedEncodings that = (SortedEncodings)obj;
                if (this.hashCode == that.hashCode && (length = (a = this.array).length) == (b = that.array).length) {
                    for (int index = 0; index < length; ++index) {
                        if (a[index] == b[index]) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "[ ", " ]").setEmptyValue("[]");
            for (String string : this.array) {
                joiner.add(string);
            }
            return joiner.toString();
        }
    }
}

