/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkedArrayList<T>
implements Cloneable {
    public static boolean ASSERTS = false;
    @Nullable
    public Node<T> first;
    @Nullable
    public Node<T> last;
    public int size;
    @Nullable
    public Node<T>[] arrayCache;
    @Nullable
    public NodeList nodeList;
    @Nullable
    public ElementList elementList;

    public static <T> LinkedArrayList<T> empty() {
        return new LinkedArrayList<T>();
    }

    public static <T> LinkedArrayList<T> ofNode(Node<T> node) {
        LinkedArrayList<T> list = new LinkedArrayList<T>();
        list.last = node.initListIndex(0);
        list.first = list.last;
        list.size = 1;
        if (ASSERTS) {
            list.checkLinks();
        }
        return list;
    }

    public static <T> LinkedArrayList<T> ofElement(T element) {
        return LinkedArrayList.ofNode(new Node<T>(element));
    }

    @SafeVarargs
    public static <T> LinkedArrayList<T> ofNodes(Node<T> ... nodes) {
        LinkedArrayList<T> list = new LinkedArrayList<T>();
        int length = nodes.length;
        if (length == 0) {
            return list;
        }
        list.size = length--;
        list.first = nodes[0].initListIndex(0);
        list.last = nodes[length];
        list.arrayCache = nodes;
        int i = 0;
        while (i < length) {
            LinkedArrayList.link(nodes[i++], nodes[i].initListIndex(i));
        }
        if (ASSERTS) {
            list.checkLinks();
        }
        return list;
    }

    public static <T> LinkedArrayList<T> ofNodes(Collection<? extends Node<T>> nodes) {
        LinkedArrayList<T> list = new LinkedArrayList<T>();
        int size = nodes.size();
        if (size == 0) {
            return list;
        }
        list.size = size;
        Iterator<Node<T>> iterator = nodes.iterator();
        list.first = iterator.next().initListIndex(0);
        Node<T> current = list.first;
        for (int i = 1; i < size; ++i) {
            Node<T> node = current;
            current = iterator.next().initListIndex(i);
            LinkedArrayList.link(node, current);
        }
        list.last = current;
        if (ASSERTS) {
            list.checkLinks();
        }
        return list;
    }

    @SafeVarargs
    public static <T> LinkedArrayList<T> ofElements(T ... elements) {
        LinkedArrayList<T> list = new LinkedArrayList<T>();
        int length = elements.length;
        if (length == 0) {
            return list;
        }
        list.size = length;
        list.first = new Node<T>(elements[0]).initListIndex(0);
        Node<T> current = list.first;
        for (int i = 1; i < length; ++i) {
            Node<T> node = current;
            current = new Node<T>(elements[i]).initListIndex(i);
            LinkedArrayList.link(node, current);
        }
        list.last = current;
        if (ASSERTS) {
            list.checkLinks();
        }
        return list;
    }

    public static <T> LinkedArrayList<T> ofElements(Collection<? extends T> elements) {
        LinkedArrayList<T> list = new LinkedArrayList<T>();
        int size = elements.size();
        if (size == 0) {
            return list;
        }
        list.size = size;
        Iterator<T> iterator = elements.iterator();
        list.first = new Node<T>(iterator.next());
        Node<T> current = list.first;
        for (int i = 1; i < size; ++i) {
            Node<T> node = current;
            current = new Node<T>(iterator.next()).initListIndex(i);
            LinkedArrayList.link(node, current);
        }
        list.last = current;
        if (ASSERTS) {
            list.checkLinks();
        }
        return list;
    }

    public static <T> LinkedArrayList<T> ofNodeRange(Node<T> fromHere, Node<T> toHere, int count) {
        LinkedArrayList<T> list = new LinkedArrayList<T>();
        list.first = fromHere;
        list.last = toHere;
        list.size = count;
        if (ASSERTS) {
            list.checkLinks();
        }
        return list;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isNotEmpty() {
        return this.size != 0;
    }

    @NotNull
    public Node<T> getFirstNode() {
        Node<T> first = this.first;
        if (first != null) {
            return first;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    public Node<T> peekFirstNode() {
        return this.first;
    }

    public T getFirstElement() {
        return this.getFirstNode().element;
    }

    @Nullable
    public T peekFirstElement() {
        Node<T> first = this.first;
        return first != null ? (T)first.element : null;
    }

    @NotNull
    public Node<T> getLastNode() {
        Node<T> last = this.last;
        if (last != null) {
            return last;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    public Node<T> peekLastNode() {
        return this.last;
    }

    public T getLastElement() {
        return this.getLastNode().element;
    }

    @Nullable
    public T peekLastElement() {
        Node<T> last = this.last;
        return last != null ? (T)last.element : null;
    }

    public Node<T> getNode(int index, boolean cache) {
        Node<T> node;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        Node<T>[] array = this.getArrayCache(cache);
        if (array != null) {
            return array[index];
        }
        if (index < this.size() >> 1) {
            node = this.getFirstNode();
            for (int i = 0; i < index; ++i) {
                node = node.getNext();
            }
        } else {
            node = this.getLastNode();
            int i = this.size();
            while (--i > index) {
                node = node.getPrev();
            }
        }
        return node;
    }

    public T getElement(int index, boolean cache) {
        return this.getNode((int)index, (boolean)cache).element;
    }

    public int indexOfNode(Node<?> node, boolean cache) {
        if (this.isEmpty()) {
            return -1;
        }
        if (!node.isInList()) {
            return -1;
        }
        Node<T>[] array = this.getArrayCache(cache);
        if (array != null) {
            int index = node.index;
            return index >= 0 && index < array.length && array[index] == node ? index : -1;
        }
        if (node.index < this.size() >> 1) {
            int index = 0;
            Node<T> test = this.first;
            while (test != null) {
                if (test == node) {
                    return index;
                }
                test = test.next;
                ++index;
            }
        } else {
            int index = this.size() - 1;
            Node<T> test = this.last;
            while (test != null) {
                if (test == node) {
                    return index;
                }
                test = test.prev;
                --index;
            }
        }
        return -1;
    }

    @Nullable
    public Node<T> getFirstNodeFor(Object element, int index) {
        if (index < 0) {
            index = 0;
        } else if (index >= this.size()) {
            return null;
        }
        Node<T>[] arrayCache = this.getArrayCache(false);
        if (arrayCache != null) {
            int length = arrayCache.length;
            if (element != null) {
                while (index < length) {
                    if (element.equals(arrayCache[index].element)) {
                        return arrayCache[index];
                    }
                    ++index;
                }
            } else {
                while (index < length) {
                    if (arrayCache[index].element == null) {
                        return arrayCache[index];
                    }
                    ++index;
                }
            }
        } else if (element != null) {
            Node<T> node = this.getNode(index, false);
            while (node != null) {
                if (element.equals(node.element)) {
                    return node;
                }
                node = node.next;
                ++index;
            }
        } else {
            Node<T> node = this.getNode(index, false);
            while (node != null) {
                if (node.element == null) {
                    return node;
                }
                node = node.next;
                ++index;
            }
        }
        return null;
    }

    @Nullable
    public Node<T> getLastNodeFor(Object element, int index) {
        Node<T>[] arrayCache;
        if (index < 0) {
            return null;
        }
        if (index >= this.size()) {
            index = this.size() - 1;
        }
        if ((arrayCache = this.getArrayCache(false)) != null) {
            if (element != null) {
                while (index >= 0) {
                    if (element.equals(arrayCache[index].element)) {
                        return arrayCache[index];
                    }
                    --index;
                }
            } else {
                while (index >= 0) {
                    if (arrayCache[index].element == null) {
                        return arrayCache[index];
                    }
                    --index;
                }
            }
        } else if (element != null) {
            Node<T> node = this.getNode(index, false);
            while (node != null) {
                if (element.equals(node.element)) {
                    return node;
                }
                --index;
                node = node.prev;
            }
        } else {
            Node<T> node = this.getNode(index, false);
            while (node != null) {
                if (node.element == null) {
                    return node;
                }
                --index;
                node = node.prev;
            }
        }
        return null;
    }

    public int indexOfElement(Object element, int index) {
        Node<T> node = this.getFirstNodeFor(element, index);
        return node != null ? node.index : -1;
    }

    public int lastIndexOfElement(Object element, int index) {
        Node<T> node = this.getLastNodeFor(element, index);
        return node != null ? node.index : -1;
    }

    public boolean containsNode(Node<?> node, boolean cache) {
        return this.indexOfNode(node, cache) != -1;
    }

    @Contract(value="true -> !null")
    public Node<T>[] getArrayCache(boolean create) {
        if (this.arrayCache == null) {
            if (this.isEmpty()) {
                this.arrayCache = Node.EMPTY_ARRAY;
            } else if (create) {
                this.arrayCache = this.toNodeArray(Node.EMPTY_ARRAY);
            }
        }
        if (ASSERTS) {
            this.checkLinks();
        }
        return this.arrayCache;
    }

    public <T1> T1[] toNodeArray(T1[] a) {
        int size = this.size();
        T1[] array = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Node<T>[] arrayCache = this.arrayCache;
        if (arrayCache != null) {
            System.arraycopy(arrayCache, 0, array, 0, size);
        } else {
            int index = 0;
            Node<T> node = this.first;
            while (node != null) {
                node.index = index++;
                array[node.index] = node;
                node = node.next;
            }
            assert (index == size);
        }
        if (array.length > size) {
            array[size] = null;
        }
        if (ASSERTS) {
            this.checkLinks();
        }
        return array;
    }

    public <T1> T1[] toElementArray(T1[] a) {
        int size = this.size();
        T1[] array = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Node<T>[] arrayCache = this.arrayCache;
        if (arrayCache != null) {
            for (int i = 0; i < size; ++i) {
                array[i] = arrayCache[i].element;
            }
        } else {
            int index = 0;
            Node<T> node = this.first;
            while (node != null) {
                node.index = index++;
                array[node.index] = node.element;
                node = node.next;
            }
            assert (index == size);
        }
        if (array.length > size) {
            array[size] = null;
        }
        if (ASSERTS) {
            this.checkLinks();
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toElementArray(new Object[this.size()]));
    }

    public NodeList nodes() {
        return this.nodeList != null ? this.nodeList : (this.nodeList = new NodeList());
    }

    public ElementList elements() {
        return this.elementList != null ? this.elementList : (this.elementList = new ElementList());
    }

    public LinkedArrayList<T> clone() {
        try {
            Object currentCopy;
            LinkedArrayList clone = (LinkedArrayList)super.clone();
            if (clone.isEmpty()) {
                return clone;
            }
            clone.arrayCache = null;
            clone.nodeList = null;
            clone.elementList = null;
            int index = 0;
            Node<T> lastOriginal = clone.getLastNode();
            Node<T> currentOriginal = clone.getFirstNode();
            clone.first = currentCopy = currentOriginal.clone();
            while (currentOriginal != lastOriginal) {
                Node<T> nextOriginal = currentOriginal.getNext();
                Object nextCopy = nextOriginal.clone();
                LinkedArrayList.link(currentCopy, nextCopy);
                currentOriginal = nextOriginal;
                currentCopy = nextCopy;
                ++index;
            }
            clone.last = currentCopy;
            if (ASSERTS) {
                clone.checkLinks();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public void addNodeToStart(Node<T> toAdd) {
        toAdd.initListIndex(0);
        this.arrayCache = null;
        Node<T> first = this.first;
        if (first == null) {
            this.last = toAdd;
            this.first = this.last;
        } else {
            this.first = toAdd;
            LinkedArrayList.link(this.first, first);
        }
        ++this.size;
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void addElementToStart(T element) {
        this.addNodeToStart(new Node<T>(element));
    }

    public void addListToStart(LinkedArrayList<T> toAdd) {
        if (toAdd.isEmpty()) {
            return;
        }
        this.arrayCache = null;
        toAdd.arrayCache = null;
        Node<T> first = this.first;
        this.first = toAdd.first;
        if (first == null) {
            this.last = toAdd.last;
        } else {
            LinkedArrayList.link(toAdd.last, first);
        }
        this.size += toAdd.size;
        toAdd.size = 0;
        toAdd.last = null;
        toAdd.first = null;
        if (ASSERTS) {
            this.checkLinks();
        }
        if (ASSERTS) {
            toAdd.checkLinks();
        }
    }

    public void addNodeToEnd(Node<T> toAdd) {
        toAdd.initListIndex(this.size());
        this.arrayCache = null;
        Node<T> last = this.last;
        if (last == null) {
            this.last = toAdd;
            this.first = this.last;
        } else {
            this.last = toAdd;
            LinkedArrayList.link(last, this.last);
        }
        ++this.size;
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void addElementToEnd(T element) {
        this.addNodeToEnd(new Node<T>(element));
    }

    public void addListToEnd(LinkedArrayList<T> toAdd) {
        if (toAdd.isEmpty()) {
            return;
        }
        this.arrayCache = null;
        toAdd.arrayCache = null;
        Node<T> last = this.last;
        this.last = toAdd.last;
        if (last == null) {
            this.first = toAdd.first;
        } else {
            LinkedArrayList.link(last, toAdd.first);
        }
        this.size += toAdd.size;
        toAdd.size = 0;
        toAdd.last = null;
        toAdd.first = null;
        if (ASSERTS) {
            this.checkLinks();
        }
        if (ASSERTS) {
            toAdd.checkLinks();
        }
    }

    public void insertNodeBefore(Node<T> existingNode, Node<T> toInsert) {
        existingNode.ensureInList();
        if (existingNode == this.first) {
            this.addNodeToStart(toInsert);
        } else {
            toInsert.initListIndex(Math.max(existingNode.index - 1, 0));
            this.arrayCache = null;
            Node<T> prev = existingNode.getPrev();
            LinkedArrayList.link(prev, toInsert);
            LinkedArrayList.link(toInsert, existingNode);
            ++this.size;
            if (ASSERTS) {
                this.checkLinks();
            }
        }
    }

    public void insertElementBefore(Node<T> existingNode, T toInsert) {
        this.insertNodeBefore(existingNode, new Node<T>(toInsert));
    }

    public void insertListBefore(Node<T> existingNode, LinkedArrayList<T> toInsert) {
        if (existingNode == this.first) {
            this.addListToStart(toInsert);
        } else {
            if (toInsert.isEmpty()) {
                return;
            }
            this.arrayCache = null;
            toInsert.arrayCache = null;
            Node<T> prev = existingNode.getPrev();
            LinkedArrayList.link(prev, toInsert.getFirstNode());
            LinkedArrayList.link(toInsert.getLastNode(), existingNode);
            this.size += toInsert.size;
            toInsert.size = 0;
            toInsert.last = null;
            toInsert.first = null;
            if (ASSERTS) {
                this.checkLinks();
            }
            if (ASSERTS) {
                toInsert.checkLinks();
            }
        }
    }

    public void insertNodeAfter(Node<T> existingNode, Node<T> toInsert) {
        existingNode.ensureInList();
        if (existingNode == this.last) {
            this.addNodeToEnd(toInsert);
        } else {
            toInsert.initListIndex(existingNode.index + 1);
            this.arrayCache = null;
            Node<T> next = existingNode.getNext();
            LinkedArrayList.link(existingNode, toInsert);
            LinkedArrayList.link(toInsert, next);
            ++this.size;
            if (ASSERTS) {
                this.checkLinks();
            }
        }
    }

    public void insertElementAfter(Node<T> existingNode, T toInsert) {
        this.insertNodeAfter(existingNode, new Node<T>(toInsert));
    }

    public void insertListAfter(Node<T> existingNode, LinkedArrayList<T> toInsert) {
        if (existingNode == this.last) {
            this.addListToEnd(toInsert);
        } else {
            if (toInsert.isEmpty()) {
                return;
            }
            this.arrayCache = null;
            toInsert.arrayCache = null;
            Node<T> next = existingNode.getNext();
            LinkedArrayList.link(existingNode, toInsert.getFirstNode());
            LinkedArrayList.link(toInsert.getLastNode(), next);
            this.size += toInsert.size;
            toInsert.size = 0;
            toInsert.last = null;
            toInsert.first = null;
            if (ASSERTS) {
                this.checkLinks();
            }
            if (ASSERTS) {
                toInsert.checkLinks();
            }
        }
    }

    public Node<T> removeFirstNode() {
        Node<T> node = this.getFirstNode();
        this.first = node.next;
        LinkedArrayList.link(null, this.first);
        if (--this.size == 0) {
            this.last = null;
        }
        node.removedFromList();
        if (ASSERTS) {
            this.checkLinks();
        }
        return node;
    }

    public T removeFirstElement() {
        return this.removeFirstNode().element;
    }

    public Node<T> removeLastNode() {
        Node<T> node = this.getLastNode();
        this.last = node.prev;
        LinkedArrayList.link(this.last, null);
        if (--this.size == 0) {
            this.first = null;
        }
        node.removedFromList();
        if (ASSERTS) {
            this.checkLinks();
        }
        return node;
    }

    public T removeLastElement() {
        return this.removeLastNode().element;
    }

    public void removeNode(Node<T> toRemove) {
        toRemove.ensureInList();
        this.arrayCache = null;
        Node prev = toRemove.prev;
        Node next = toRemove.next;
        --this.size;
        LinkedArrayList.link(prev, next);
        if (toRemove == this.first) {
            this.first = next;
        }
        if (toRemove == this.last) {
            this.last = prev;
        }
        toRemove.removedFromList();
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void removeNodeRange(Node<T> fromHere, Node<T> toHere) {
        fromHere.ensureInList();
        toHere.ensureInList();
        this.arrayCache = null;
        Node prev = fromHere.prev;
        Node next = toHere.next;
        this.size -= LinkedArrayList.countAndRemove(fromHere, toHere);
        LinkedArrayList.link(prev, next);
        if (fromHere == this.first) {
            this.first = next;
        }
        if (toHere == this.last) {
            this.last = prev;
        }
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void replaceNode(Node<T> replaceThis, Node<T> withThis) {
        replaceThis.ensureInList();
        if (this.arrayCache != null) {
            assert (this.arrayCache[replaceThis.index] == replaceThis);
            this.arrayCache[replaceThis.index] = withThis.initListIndex(replaceThis.index);
        } else {
            withThis.initListIndex(replaceThis.index);
        }
        Node prev = replaceThis.prev;
        Node next = replaceThis.next;
        replaceThis.removedFromList();
        LinkedArrayList.link(prev, withThis);
        LinkedArrayList.link(withThis, next);
        if (replaceThis == this.first) {
            this.first = withThis;
        }
        if (replaceThis == this.last) {
            this.last = withThis;
        }
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void replaceNode(Node<T> replaceThis, LinkedArrayList<T> withThis) {
        switch (withThis.size()) {
            case 0: {
                this.removeNode(replaceThis);
                break;
            }
            case 1: {
                this.replaceNode(replaceThis, withThis.removeFirstNode());
                break;
            }
            default: {
                this.arrayCache = null;
                withThis.arrayCache = null;
                Node prev = replaceThis.prev;
                Node next = replaceThis.next;
                LinkedArrayList.link(prev, withThis.first);
                LinkedArrayList.link(withThis.last, next);
                if (replaceThis == this.first) {
                    this.first = withThis.first;
                }
                if (replaceThis == this.last) {
                    this.last = withThis.last;
                }
                replaceThis.removedFromList();
                this.size += withThis.size() - 1;
                withThis.size = 0;
                withThis.last = null;
                withThis.first = null;
                if (!ASSERTS) break;
                this.checkLinks();
            }
        }
        if (ASSERTS) {
            withThis.checkLinks();
        }
    }

    public void replaceNodeRange(Node<T> fromHere, Node<T> toHere, Node<T> withThis) {
        if (fromHere == toHere) {
            this.replaceNode(fromHere, withThis);
            return;
        }
        fromHere.ensureInList();
        toHere.ensureInList();
        withThis.initListIndex(fromHere.index);
        this.arrayCache = null;
        Node prev = fromHere.prev;
        Node next = toHere.next;
        this.size += 1 - LinkedArrayList.countAndRemove(fromHere, toHere);
        if (fromHere == this.first) {
            this.first = withThis;
        }
        if (toHere == this.last) {
            this.last = withThis;
        }
        LinkedArrayList.link(prev, withThis);
        LinkedArrayList.link(withThis, next);
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void replaceNodeRange(Node<T> fromHere, Node<T> toHere, LinkedArrayList<T> withThis) {
        switch (withThis.size()) {
            case 0: {
                this.removeNodeRange(fromHere, toHere);
                break;
            }
            case 1: {
                this.replaceNodeRange(fromHere, toHere, withThis.removeFirstNode());
                break;
            }
            default: {
                this.arrayCache = null;
                withThis.arrayCache = null;
                Node prev = fromHere.prev;
                Node next = toHere.next;
                this.size += withThis.size() - LinkedArrayList.countAndRemove(fromHere, toHere);
                LinkedArrayList.link(prev, withThis.first);
                LinkedArrayList.link(withThis.last, next);
                if (fromHere == this.first) {
                    this.first = withThis.first;
                }
                if (toHere == this.last) {
                    this.last = withThis.last;
                }
                withThis.size = 0;
                withThis.last = null;
                withThis.first = null;
                if (!ASSERTS) break;
                this.checkLinks();
            }
        }
        if (ASSERTS) {
            withThis.checkLinks();
        }
    }

    public LinkedArrayList<T> slice(Node<T> fromHere, Node<T> toHere) {
        int removed = LinkedArrayList.count(fromHere, toHere);
        assert (removed > 0) : removed;
        if (removed == 1) {
            assert (fromHere == toHere);
            this.removeNode(fromHere);
            return LinkedArrayList.ofNode(fromHere);
        }
        this.arrayCache = null;
        this.size -= removed;
        if (this.first == fromHere) {
            this.first = toHere.next;
        }
        if (this.last == toHere) {
            this.last = fromHere.prev;
        }
        LinkedArrayList.link(fromHere.prev, toHere.next);
        if (ASSERTS) {
            this.checkLinks();
        }
        return LinkedArrayList.ofNodeRange(fromHere, toHere, removed);
    }

    public LinkedArrayList<T> copyOfNodeRange(Node<T> fromHere, Node<T> toHere) {
        LinkedArrayList<T> copy = new LinkedArrayList<T>();
        int index = 0;
        Node<T> currentOriginal = fromHere;
        Node currentCopy = new Node(currentOriginal.element).initListIndex(0);
        copy.first = currentCopy;
        while (true) {
            ++index;
            if (currentOriginal == toHere) break;
            Node<T> nextOriginal = currentOriginal.getNext();
            Node nextCopy = new Node(nextOriginal.element).initListIndex(index);
            LinkedArrayList.link(currentCopy, nextCopy);
            currentOriginal = nextOriginal;
            currentCopy = nextCopy;
        }
        copy.last = currentCopy;
        copy.size = index;
        if (ASSERTS) {
            copy.checkLinks();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortNodes(@Nullable Comparator<? super Node<T>> comparator) {
        if (this.size() <= 1) {
            return;
        }
        Node<T>[] array = this.getArrayCache(true);
        try {
            Arrays.sort(array, comparator);
        }
        catch (Throwable throwable) {
            int length = array.length;
            array[0].index = 0;
            this.first = array[0];
            array[0].prev = null;
            int index = 1;
            while (index < length) {
                Node<T> current = array[index];
                current.prev = array[index - 1];
                array[index - 1].next = current;
                current.index = index++;
            }
            this.last = array[length - 1];
            array[length - 1].next = null;
            if (ASSERTS) {
                this.checkLinks();
            }
            throw throwable;
        }
        int length = array.length;
        array[0].index = 0;
        this.first = array[0];
        array[0].prev = null;
        int index = 1;
        while (index < length) {
            Node<T> current = array[index];
            current.prev = array[index - 1];
            array[index - 1].next = current;
            current.index = index++;
        }
        this.last = array[length - 1];
        array[length - 1].next = null;
        if (ASSERTS) {
            this.checkLinks();
        }
    }

    public void sortElements(@Nullable Comparator<? super T> comparator) {
        this.sortNodes(Comparator.comparing(Node::getElement, comparator != null ? comparator : Comparator.naturalOrder()));
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        LinkedArrayList.countAndRemove(this.first, this.last);
        this.last = null;
        this.first = null;
        this.size = 0;
        this.arrayCache = null;
    }

    public static <T> Iterator<Node<T>> nodeIteratorStartingAt(Node<T> start) {
        NodeIterator iterator = new NodeIterator();
        iterator.next = start;
        return iterator;
    }

    public static <T> Iterator<Node<T>> nodeIteratorEndingAt(Node<T> end) {
        DescendingNodeIterator iterator = new DescendingNodeIterator();
        iterator.prev = end;
        return iterator;
    }

    public static <T> Iterator<T> elementIteratorStartingAt(Node<T> start) {
        ElementIterator iterator = new ElementIterator();
        iterator.next = start;
        return iterator;
    }

    public static <T> Iterator<T> elementIteratorEndingAt(Node<T> end) {
        DescendingElementIterator iterator = new DescendingElementIterator();
        iterator.prev = end;
        return iterator;
    }

    public static <T> Spliterator<Node<T>> nodeSpliteratorStartingAt(Node<T> start) {
        return Spliterators.spliteratorUnknownSize(LinkedArrayList.nodeIteratorStartingAt(start), 16);
    }

    public static <T> Spliterator<Node<T>> nodeSpliteratorEndingAt(Node<T> end) {
        return Spliterators.spliteratorUnknownSize(LinkedArrayList.nodeIteratorEndingAt(end), 16);
    }

    public static <T> Spliterator<T> elementSpliteratorStartingAt(Node<T> start) {
        return Spliterators.spliteratorUnknownSize(LinkedArrayList.elementIteratorStartingAt(start), 16);
    }

    public static <T> Spliterator<T> elementSpliteratorEndingAt(Node<T> end) {
        return Spliterators.spliteratorUnknownSize(LinkedArrayList.elementIteratorEndingAt(end), 16);
    }

    public static <T> Stream<Node<T>> nodeStreamStartingAt(Node<T> start) {
        return StreamSupport.stream(LinkedArrayList.nodeSpliteratorStartingAt(start), false);
    }

    public static <T> Stream<Node<T>> nodeStreamEndingAt(Node<T> end) {
        return StreamSupport.stream(LinkedArrayList.nodeSpliteratorEndingAt(end), false);
    }

    public static <T> Stream<T> elementStreamStartingAt(Node<T> start) {
        return StreamSupport.stream(LinkedArrayList.elementSpliteratorStartingAt(start), false);
    }

    public static <T> Stream<T> elementStreamEndingAt(Node<T> end) {
        return StreamSupport.stream(LinkedArrayList.elementSpliteratorEndingAt(end), false);
    }

    public static <T> Collector<T, LinkedArrayList<T>, LinkedArrayList<T>> collector() {
        return Collector.of(LinkedArrayList::new, LinkedArrayList::addElementToEnd, (list1, list2) -> {
            list1.addListToEnd((LinkedArrayList)list2);
            return list1;
        }, new Collector.Characteristics[0]);
    }

    public static void checkAssertsEnabled() {
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!asserts) {
            throw new AssertionError((Object)"Asserts must be enabled in LinkedArrayList. Please add -ea to your JVM arguments.");
        }
    }

    public void checkLinks() {
        LinkedArrayList.checkAssertsEnabled();
        Object[] arrayCache = this.arrayCache;
        if (arrayCache != null) assert (arrayCache.length == this.size()) : "arrayCache is wrong length. Size: " + this.size() + ", Array: " + Arrays.toString(arrayCache);
        if (this.isEmpty()) {
            assert (this.first == null) : "List is empty, but first is " + String.valueOf(this.first);
            assert (this.last == null) : "List is empty, but last is " + String.valueOf(this.last);
        } else {
            Node next;
            Node<T> current = this.first;
            assert (current != null) : "No first entry";
            assert (current.isInList()) : String.valueOf(current) + " not in list";
            assert (current.prev == null) : "First entry had previous: " + String.valueOf(current.prev);
            if (arrayCache != null) {
                assert (current.index == 0) : "current.index should be 0, but it was " + current.index;
                assert (arrayCache[0] == current) : "current: " + String.valueOf(current) + ", array: " + String.valueOf(arrayCache[0]);
            }
            int actualSize = 1;
            while ((next = current.next) != null) {
                assert (next.isInList()) : String.valueOf(next) + " not in list";
                assert (next.prev == current) : "current: " + String.valueOf(current) + ", next: " + String.valueOf(next) + ", next.prev: " + String.valueOf(next.prev);
                if (arrayCache != null) {
                    assert (next.index == actualSize) : "next.index should be " + actualSize + " but it was " + current.index;
                    assert (arrayCache[actualSize] == next) : "next: " + String.valueOf(next) + ", array: " + String.valueOf(arrayCache[actualSize]);
                }
                ++actualSize;
                current = next;
            }
            assert (this.size() == actualSize) : "size: " + this.size() + ", actualSize: " + actualSize;
            assert (current == this.last) : "current: " + String.valueOf(current) + ", last: " + String.valueOf(this.last);
        }
    }

    public static <T> int count(Node<T> start, Node<T> end) {
        int count = 1;
        for (Node<T> node = start; node != end; node = node.getNext()) {
            ++count;
        }
        return count;
    }

    public static <T> int countAndRemove(Node<T> start, Node<T> end) {
        int count = 1;
        for (Node<T> node = start; node != end; node = node.removeAndGetNext()) {
            ++count;
        }
        end.removedFromList();
        return count;
    }

    public static <T> void link(@Nullable Node<T> node1, @Nullable Node<T> node2) {
        if (node1 == node2) {
            if (node1 == null) {
                return;
            }
            throw new IllegalArgumentException("Cannot link " + String.valueOf(node1) + " to itself");
        }
        if (node1 != null && node1.next != node2) {
            if (node1.next != null) {
                node1.next.prev = null;
            }
            node1.next = node2;
        }
        if (node2 != null && node2.prev != node1) {
            if (node2.prev != null) {
                node2.prev.next = null;
            }
            node2.prev = node1;
        }
    }

    public static class Node<T>
    implements Cloneable {
        public static final Node[] EMPTY_ARRAY = new Node[0];
        public static final int NOT_IN_LIST = -1;
        public T element;
        @Nullable
        public Node<T> prev;
        @Nullable
        public Node<T> next;
        public int index = -1;

        public Node(T element) {
            this.element = element;
        }

        @NotNull
        public Node<T> getPrev() {
            Node<T> prev = this.prev;
            if (prev != null) {
                return prev;
            }
            throw new NoSuchElementException("No node before " + String.valueOf(this));
        }

        @NotNull
        public Node<T> getNext() {
            Node<T> next = this.next;
            if (next != null) {
                return next;
            }
            throw new NoSuchElementException("No node after " + String.valueOf(this));
        }

        public T getElement() {
            return this.element;
        }

        public Node<T> clone() {
            try {
                Node clone = (Node)super.clone();
                clone.prev = null;
                clone.next = null;
                clone.index = -1;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }

        public boolean isInList() {
            return this.index != -1;
        }

        public boolean isNotInList() {
            return this.index == -1;
        }

        public void ensureInList() {
            if (this.isNotInList()) {
                throw new IllegalStateException(String.valueOf(this) + " is not in any list");
            }
        }

        public void ensureNotInList() {
            if (this.isInList()) {
                throw new IllegalStateException(String.valueOf(this) + " is already in another list");
            }
            if (this.prev != null || this.next != null) {
                throw new IllegalStateException(String.valueOf(this) + " has dangling links: " + String.valueOf(this.prev) + " and " + String.valueOf(this.next));
            }
        }

        public Node<T> initListIndex(int index) {
            this.ensureNotInList();
            this.index = index;
            return this;
        }

        public void removedFromList() {
            this.ensureInList();
            this.index = -1;
            this.next = null;
            this.prev = null;
        }

        public Node<T> removeAndGetNext() {
            Node<T> next = this.getNext();
            this.removedFromList();
            return next;
        }

        public int hashCode() {
            return Objects.hashCode(this.element);
        }

        public boolean equals(Node<?> that) {
            return Objects.equals(this.element, that.element);
        }

        public boolean equals(Object that) {
            return that instanceof Node && this.equals((Node)that);
        }

        public String toString() {
            StringBuilder s = new StringBuilder(64);
            if (this.prev != null) {
                this.prev.toString0(s).append(" <- ");
            }
            this.toString0(s);
            if (this.next != null) {
                this.next.toString0(s.append(" -> "));
            }
            return s.toString();
        }

        public StringBuilder toString0(StringBuilder s) {
            return s.append(this.getClass().getSimpleName()).append(": { ").append(this.element).append(" }");
        }
    }

    public class NodeList
    extends AbstractList<Node<T>>
    implements Deque<Node<T>>,
    Cloneable {
        @Override
        public NodeList reversed() {
            throw new UnsupportedOperationException("todo: support reversing.");
        }

        public final LinkedArrayList<T> backingList() {
            return LinkedArrayList.this;
        }

        @Override
        public void addFirst(Node<T> node) {
            LinkedArrayList.this.addNodeToStart(node);
        }

        @Override
        public void addLast(Node<T> node) {
            LinkedArrayList.this.addNodeToEnd(node);
        }

        @Override
        public boolean offerFirst(Node<T> node) {
            LinkedArrayList.this.addNodeToStart(node);
            return true;
        }

        @Override
        public boolean offerLast(Node<T> node) {
            LinkedArrayList.this.addNodeToEnd(node);
            return true;
        }

        @Override
        public Node<T> removeFirst() {
            return LinkedArrayList.this.removeFirstNode();
        }

        @Override
        public Node<T> removeLast() {
            return LinkedArrayList.this.removeLastNode();
        }

        @Override
        @Nullable
        public Node<T> pollFirst() {
            return this.isEmpty() ? null : LinkedArrayList.this.removeFirstNode();
        }

        @Override
        @Nullable
        public Node<T> pollLast() {
            return this.isEmpty() ? null : LinkedArrayList.this.removeLastNode();
        }

        @Override
        public Node<T> getFirst() {
            return LinkedArrayList.this.getFirstNode();
        }

        @Override
        public Node<T> getLast() {
            return LinkedArrayList.this.getLastNode();
        }

        @Override
        public Node<T> peekFirst() {
            return LinkedArrayList.this.first;
        }

        @Override
        public Node<T> peekLast() {
            return LinkedArrayList.this.last;
        }

        @Override
        public boolean removeFirstOccurrence(Object object) {
            if (object instanceof Node && LinkedArrayList.this.containsNode((Node)object, false)) {
                LinkedArrayList.this.removeNode((Node)object);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeLastOccurrence(Object object) {
            if (object instanceof Node && LinkedArrayList.this.containsNode((Node)object, false)) {
                LinkedArrayList.this.removeNode((Node)object);
                return true;
            }
            return false;
        }

        @Override
        public boolean offer(Node<T> node) {
            return this.offerLast(node);
        }

        @Override
        public Node<T> remove() {
            return this.removeFirst();
        }

        @Override
        public Node<T> poll() {
            return this.pollFirst();
        }

        @Override
        public Node<T> element() {
            return this.getFirst();
        }

        @Override
        public Node<T> peek() {
            return this.peekFirst();
        }

        @Override
        public void push(Node<T> node) {
            this.addFirst(node);
        }

        @Override
        public Node<T> pop() {
            return this.removeFirst();
        }

        @Override
        @NotNull
        public Iterator<Node<T>> descendingIterator() {
            DescendingNodeIterator iterator = new DescendingNodeIterator();
            iterator.prev = LinkedArrayList.this.last;
            return iterator;
        }

        @Override
        public int size() {
            return LinkedArrayList.this.size;
        }

        @Override
        public boolean isEmpty() {
            return LinkedArrayList.this.size == 0;
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Node && LinkedArrayList.this.containsNode((Node)object, true);
        }

        @Override
        @NotNull
        public Iterator<Node<T>> iterator() {
            NodeIterator iterator = new NodeIterator();
            iterator.next = LinkedArrayList.this.first;
            return iterator;
        }

        @Override
        public void forEach(Consumer<? super Node<T>> action) {
            Node node = LinkedArrayList.this.first;
            while (node != null) {
                action.accept(node);
                node = node.next;
            }
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return LinkedArrayList.this.toNodeArray(new Object[this.size()]);
        }

        @Override
        @NotNull
        public <T1> T1[] toArray(@NotNull T1[] array) {
            return LinkedArrayList.this.toNodeArray(array);
        }

        @Override
        public boolean add(Node<T> node) {
            LinkedArrayList.this.addNodeToEnd(node);
            return true;
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                LinkedArrayList.this.removeNode((Node)object);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> collection) {
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Node<T>> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection == this) {
                throw new IllegalArgumentException("Cannot add list to itself");
            }
            LinkedArrayList.this.addListToEnd(LinkedArrayList.ofNodes(collection.toArray(Node.EMPTY_ARRAY)));
            return true;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends Node<T>> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection == this) {
                throw new IllegalArgumentException("Cannot add list to itself");
            }
            LinkedArrayList.this.insertListBefore(LinkedArrayList.this.getNode(index, false), LinkedArrayList.ofNodes(collection.toArray(Node.EMPTY_ARRAY)));
            return true;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection == this) {
                LinkedArrayList.this.clear();
                return true;
            }
            return this.removeIf((Predicate)collection::contains);
        }

        @Override
        public boolean removeIf(Predicate<? super Node<T>> filter) {
            boolean removed = false;
            Node node = LinkedArrayList.this.first;
            while (node != null) {
                Node next = node.next;
                if (filter.test(node)) {
                    LinkedArrayList.this.removeNode(node);
                    removed = true;
                }
                node = next;
            }
            return removed;
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> collection) {
            if (collection == this || this.isEmpty()) {
                return false;
            }
            if (collection.isEmpty()) {
                this.clear();
                return true;
            }
            return this.removeIf((Predicate)node -> !collection.contains(node));
        }

        @Override
        public void replaceAll(UnaryOperator<Node<T>> operator) {
            Node currentCopy;
            if (this.isEmpty()) {
                return;
            }
            LinkedArrayList.this.arrayCache = null;
            Node currentOriginal = LinkedArrayList.this.getFirstNode();
            Node lastOriginal = LinkedArrayList.this.getLastNode();
            LinkedArrayList.this.first = currentCopy = (Node)operator.apply(currentOriginal);
            while (currentOriginal != lastOriginal) {
                Node nextOriginal = currentOriginal.getNext();
                Node nextCopy = (Node)operator.apply(nextOriginal);
                LinkedArrayList.link(currentCopy, nextCopy);
                currentOriginal = nextOriginal;
                currentCopy = nextCopy;
            }
            LinkedArrayList.this.last = currentCopy;
            if (ASSERTS) {
                LinkedArrayList.this.checkLinks();
            }
        }

        @Override
        public void sort(Comparator<? super Node<T>> comparator) {
            LinkedArrayList.this.sortNodes(comparator);
        }

        @Override
        public void clear() {
            LinkedArrayList.this.clear();
        }

        @Override
        public Node<T> get(int index) {
            return LinkedArrayList.this.getNode(index, true);
        }

        @Override
        public Node<T> set(int index, Node<T> node) {
            Node original = LinkedArrayList.this.getNode(index, true);
            LinkedArrayList.this.replaceNode(original, node);
            return original;
        }

        @Override
        public void add(int index, Node<T> node) {
            LinkedArrayList.this.insertNodeBefore(LinkedArrayList.this.getNode(index, false), node);
        }

        @Override
        public Node<T> remove(int index) {
            Node node = LinkedArrayList.this.getNode(index, false);
            LinkedArrayList.this.removeNode(node);
            return node;
        }

        @Override
        public int indexOf(Object object) {
            return object instanceof Node ? LinkedArrayList.this.indexOfNode((Node)object, true) : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return object instanceof Node ? LinkedArrayList.this.indexOfNode((Node)object, true) : -1;
        }

        @Override
        @NotNull
        public ListIterator<Node<T>> listIterator() {
            NodeListIterator iterator = new NodeListIterator();
            iterator.next = LinkedArrayList.this.first;
            return iterator;
        }

        @Override
        @NotNull
        public ListIterator<Node<T>> listIterator(int index) {
            Node node = LinkedArrayList.this.getNode(index, false);
            NodeListIterator iterator = new NodeListIterator();
            iterator.next = node;
            iterator.prev = node.prev;
            return iterator;
        }

        @Override
        public Spliterator<Node<T>> spliterator() {
            int size = LinkedArrayList.this.size;
            if (size == 0) {
                return Spliterators.emptySpliterator();
            }
            Object[] arrayCache = LinkedArrayList.this.arrayCache;
            if (arrayCache != null) {
                return Spliterators.spliterator(arrayCache, 16464);
            }
            return new NodeSpliterator(LinkedArrayList.this.getFirstNode(), size);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IndexOutOfBoundsException(toIndex + " < " + fromIndex);
            }
            if (toIndex == fromIndex) {
                return;
            }
            LinkedArrayList.this.removeNodeRange(LinkedArrayList.this.getNode(fromIndex, false), LinkedArrayList.this.getNode(toIndex - 1, false));
        }

        public NodeList clone() {
            return ((LinkedArrayList)LinkedArrayList.this.clone()).nodes();
        }
    }

    public class ElementList
    extends AbstractList<T>
    implements Deque<T>,
    Cloneable {
        @Override
        public ElementList reversed() {
            throw new UnsupportedOperationException("todo: support reversing.");
        }

        public final LinkedArrayList<T> backingList() {
            return LinkedArrayList.this;
        }

        @Override
        public void addFirst(T element) {
            LinkedArrayList.this.addElementToStart(element);
        }

        @Override
        public void addLast(T element) {
            LinkedArrayList.this.addElementToEnd(element);
        }

        @Override
        public boolean offerFirst(T element) {
            LinkedArrayList.this.addElementToStart(element);
            return true;
        }

        @Override
        public boolean offerLast(T element) {
            LinkedArrayList.this.addElementToEnd(element);
            return true;
        }

        @Override
        public T removeFirst() {
            return LinkedArrayList.this.removeFirstElement();
        }

        @Override
        public T removeLast() {
            return LinkedArrayList.this.removeLastElement();
        }

        @Override
        @Nullable
        public T pollFirst() {
            return this.isEmpty() ? null : (Object)LinkedArrayList.this.removeFirstElement();
        }

        @Override
        @Nullable
        public T pollLast() {
            return this.isEmpty() ? null : (Object)LinkedArrayList.this.removeLastElement();
        }

        @Override
        public T getFirst() {
            return LinkedArrayList.this.getFirstElement();
        }

        @Override
        public T getLast() {
            return LinkedArrayList.this.getLastElement();
        }

        @Override
        public T peekFirst() {
            Node node = LinkedArrayList.this.first;
            return node != null ? (Object)node.element : null;
        }

        @Override
        public T peekLast() {
            Node node = LinkedArrayList.this.last;
            return node != null ? (Object)node.element : null;
        }

        @Override
        public boolean removeFirstOccurrence(Object object) {
            Node node = LinkedArrayList.this.getFirstNodeFor(object, 0);
            if (node == null) {
                return false;
            }
            LinkedArrayList.this.removeNode(node);
            return true;
        }

        @Override
        public boolean removeLastOccurrence(Object object) {
            Node node = LinkedArrayList.this.getLastNodeFor(object, this.size() - 1);
            if (node == null) {
                return false;
            }
            LinkedArrayList.this.removeNode(node);
            return true;
        }

        @Override
        public boolean offer(T element) {
            return this.offerLast((T)element);
        }

        @Override
        public T remove() {
            return this.removeFirst();
        }

        @Override
        public T poll() {
            return this.pollFirst();
        }

        @Override
        public T element() {
            return this.getFirst();
        }

        @Override
        public T peek() {
            return this.peekFirst();
        }

        @Override
        public void push(T element) {
            this.addFirst((T)element);
        }

        @Override
        public T pop() {
            return this.removeFirst();
        }

        @Override
        @NotNull
        public Iterator<T> descendingIterator() {
            DescendingElementIterator iterator = new DescendingElementIterator();
            iterator.prev = LinkedArrayList.this.last;
            return iterator;
        }

        @Override
        public int size() {
            return LinkedArrayList.this.size;
        }

        @Override
        public boolean isEmpty() {
            return LinkedArrayList.this.size == 0;
        }

        @Override
        public boolean contains(Object object) {
            return LinkedArrayList.this.getFirstNodeFor(object, 0) != null;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            ElementIterator iterator = new ElementIterator();
            iterator.next = LinkedArrayList.this.first;
            return iterator;
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Node node = LinkedArrayList.this.first;
            while (node != null) {
                action.accept(node.element);
                node = node.next;
            }
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return LinkedArrayList.this.toElementArray(new Object[this.size()]);
        }

        @Override
        @NotNull
        public <T1> T1[] toArray(@NotNull T1[] array) {
            return LinkedArrayList.this.toElementArray(array);
        }

        @Override
        public boolean add(T element) {
            LinkedArrayList.this.addElementToEnd(element);
            return true;
        }

        @Override
        public boolean remove(Object object) {
            return this.removeFirstOccurrence(object);
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> collection) {
            for (Object object : collection) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection == this) {
                throw new IllegalArgumentException("Cannot add list to itself");
            }
            LinkedArrayList.this.addListToEnd(LinkedArrayList.ofNodes((Node[])collection.stream().map(Node::new).toArray(Node[]::new)));
            return true;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection == this) {
                throw new IllegalArgumentException("Cannot add list to itself");
            }
            LinkedArrayList.this.insertListBefore(LinkedArrayList.this.getNode(index, false), LinkedArrayList.ofNodes((Node[])collection.stream().map(Node::new).toArray(Node[]::new)));
            return true;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection == this) {
                LinkedArrayList.this.clear();
                return true;
            }
            return this.removeIf((Predicate)collection::contains);
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            boolean removed = false;
            Node node = LinkedArrayList.this.first;
            while (node != null) {
                Node next = node.next;
                if (filter.test(node.element)) {
                    LinkedArrayList.this.removeNode(node);
                    removed = true;
                }
                node = next;
            }
            return removed;
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> collection) {
            if (collection == this || this.isEmpty()) {
                return false;
            }
            if (collection.isEmpty()) {
                this.clear();
                return true;
            }
            return this.removeIf((Predicate)element -> !collection.contains(element));
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            Node node = LinkedArrayList.this.first;
            while (node != null) {
                node.element = operator.apply(node.element);
                node = node.next;
            }
        }

        @Override
        public void sort(Comparator<? super T> comparator) {
            LinkedArrayList.this.sortElements(comparator);
        }

        @Override
        public void clear() {
            LinkedArrayList.this.clear();
        }

        @Override
        public T get(int index) {
            return LinkedArrayList.this.getElement(index, true);
        }

        @Override
        public T set(int index, T element) {
            Node node = LinkedArrayList.this.getNode(index, true);
            Object oldValue = node.element;
            node.element = element;
            return oldValue;
        }

        @Override
        public void add(int index, T element) {
            LinkedArrayList.this.insertElementBefore(LinkedArrayList.this.getNode(index, false), element);
        }

        @Override
        public T remove(int index) {
            Node node = LinkedArrayList.this.getNode(index, false);
            LinkedArrayList.this.removeNode(node);
            return node.element;
        }

        @Override
        public int indexOf(Object object) {
            return LinkedArrayList.this.indexOfElement(object, 0);
        }

        @Override
        public int lastIndexOf(Object object) {
            return LinkedArrayList.this.lastIndexOfElement(object, this.size() - 1);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            ElementListIterator iterator = new ElementListIterator();
            iterator.next = LinkedArrayList.this.first;
            return iterator;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            Node node = LinkedArrayList.this.getNode(index, false);
            ElementListIterator iterator = new ElementListIterator();
            iterator.next = node;
            iterator.prev = node.prev;
            return iterator;
        }

        @Override
        public Spliterator<T> spliterator() {
            int size = LinkedArrayList.this.size;
            if (size == 0) {
                return Spliterators.emptySpliterator();
            }
            Object[] arrayCache = LinkedArrayList.this.arrayCache;
            if (arrayCache != null) {
                return Spliterators.spliterator(arrayCache, 16464);
            }
            return new ElementSpliterator(LinkedArrayList.this.getFirstNode(), size);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return super.subList(fromIndex, toIndex);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IndexOutOfBoundsException(toIndex + " < " + fromIndex);
            }
            if (toIndex == fromIndex) {
                return;
            }
            LinkedArrayList.this.removeNodeRange(LinkedArrayList.this.getNode(fromIndex, false), LinkedArrayList.this.getNode(toIndex - 1, false));
        }

        public ElementList clone() {
            return ((LinkedArrayList)LinkedArrayList.this.clone()).elements();
        }
    }

    public static class NodeIterator<T>
    extends BaseIterator<T>
    implements Iterator<Node<T>> {
        @Override
        public boolean hasNext() {
            return this.baseHasNext();
        }

        @Override
        public Node<T> next() {
            return this.nextNode();
        }

        @Override
        public void forEachRemaining(Consumer<? super Node<T>> action) {
            this.forNextNodes(action);
        }
    }

    public static class DescendingNodeIterator<T>
    extends BaseIterator<T>
    implements Iterator<Node<T>> {
        @Override
        public boolean hasNext() {
            return this.baseHasPrev();
        }

        @Override
        public Node<T> next() {
            return this.prevNode();
        }

        @Override
        public void forEachRemaining(Consumer<? super Node<T>> action) {
            this.forPrevNodes(action);
        }
    }

    public static class ElementIterator<T>
    extends BaseIterator<T>
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return this.baseHasNext();
        }

        @Override
        public T next() {
            return this.nextElement();
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.forNextElements(action);
        }
    }

    public static class DescendingElementIterator<T>
    extends BaseIterator<T>
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return this.baseHasPrev();
        }

        @Override
        public T next() {
            return this.prevElement();
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.forPrevElements(action);
        }
    }

    public static class ElementSpliterator<T>
    extends BaseSpliterator<T>
    implements Spliterator<T> {
        public ElementSpliterator(Node<T> head, int remaining) {
            super(head, remaining);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.advanceElement(action);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.forAllElements(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            int toSkip = this.remaining >> 1;
            return toSkip != 0 ? new ElementSpliterator(this.skip(toSkip), toSkip) : null;
        }
    }

    public static class NodeSpliterator<T>
    extends BaseSpliterator<T>
    implements Spliterator<Node<T>> {
        public NodeSpliterator(Node<T> head, int remaining) {
            super(head, remaining);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Node<T>> action) {
            return this.advanceNode(action);
        }

        @Override
        public void forEachRemaining(Consumer<? super Node<T>> action) {
            this.forAllNodes(action);
        }

        @Override
        public Spliterator<Node<T>> trySplit() {
            int toSkip = this.remaining >> 1;
            return toSkip != 0 ? new NodeSpliterator(this.skip(toSkip), toSkip) : null;
        }
    }

    public static class BaseSpliterator<T> {
        public Node<T> head;
        public int remaining;

        public BaseSpliterator(Node<T> head, int remaining) {
            this.head = head;
            this.remaining = remaining;
        }

        public Node<T> nextNode() {
            int remaining = this.remaining;
            if (remaining == 0) {
                return null;
            }
            this.remaining = remaining - 1;
            Node<T> node = this.head;
            this.head = node.next;
            return node;
        }

        public boolean advanceNode(Consumer<? super Node<T>> action) {
            Node<T> node = this.nextNode();
            if (node == null) {
                return false;
            }
            action.accept(node);
            return true;
        }

        public boolean advanceElement(Consumer<? super T> action) {
            Node<T> node = this.nextNode();
            if (node == null) {
                return false;
            }
            action.accept(node.element);
            return true;
        }

        public void forAllNodes(Consumer<? super Node<T>> action) {
            Node<T> node = this.head;
            int remaining = this.remaining;
            while (remaining-- != 0) {
                action.accept(node);
                node = node.getNext();
            }
            this.head = null;
            this.remaining = 0;
        }

        public void forAllElements(Consumer<? super T> action) {
            Node<T> node = this.head;
            int remaining = this.remaining;
            while (remaining-- != 0) {
                action.accept(node.element);
                node = node.getNext();
            }
            this.head = null;
            this.remaining = 0;
        }

        public Node<T> skip(int count) {
            Node<T> head;
            Node<T> tail = head = this.head;
            int i = count;
            while (i-- != 0) {
                tail = tail.getNext();
            }
            this.remaining -= count;
            this.head = tail;
            return head;
        }

        public long estimateSize() {
            return this.remaining;
        }

        public long getExactSizeIfKnown() {
            return this.remaining;
        }

        public int characteristics() {
            return 16464;
        }
    }

    public class ElementListIterator
    extends BaseListIterator
    implements ListIterator<T> {
        @Override
        public boolean hasNext() {
            return this.baseHasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseHasPrev();
        }

        @Override
        public T next() {
            return this.nextElement();
        }

        @Override
        public T previous() {
            return this.prevElement();
        }

        @Override
        public void set(T replacement) {
            this.setElement(replacement);
        }

        @Override
        public void add(T toAdd) {
            this.addElement(toAdd);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.forNextElements(action);
        }
    }

    public class NodeListIterator
    extends BaseListIterator
    implements ListIterator<Node<T>> {
        @Override
        public boolean hasNext() {
            return this.baseHasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseHasPrev();
        }

        @Override
        public Node<T> next() {
            return this.nextNode();
        }

        @Override
        public Node<T> previous() {
            return this.prevNode();
        }

        @Override
        public void set(Node<T> node) {
            this.setNode(node);
        }

        @Override
        public void add(Node<T> node) {
            this.addNode(node);
        }

        @Override
        public void forEachRemaining(Consumer<? super Node<T>> action) {
            this.forNextNodes(action);
        }
    }

    public class BaseListIterator
    extends BaseIterator<T> {
        public int nextIndex() {
            Node node = this.next;
            return node != null ? LinkedArrayList.this.indexOfNode(node, true) : LinkedArrayList.this.size();
        }

        public int previousIndex() {
            Node node = this.prev;
            return node != null ? LinkedArrayList.this.indexOfNode(node, true) : -1;
        }

        public void remove() {
            Node node = this.current;
            if (node == null) {
                throw new NoSuchElementException();
            }
            Node prev = node.prev;
            Node next = node.next;
            LinkedArrayList.this.removeNode(node);
            this.prev = prev;
            this.next = next;
            this.current = null;
        }

        public void setNode(Node<T> replacement) {
            Node node = this.current;
            if (node == null) {
                throw new IllegalStateException();
            }
            LinkedArrayList.this.replaceNode(node, replacement);
            this.current = replacement;
        }

        public void setElement(T replacement) {
            Node node = this.current;
            if (node == null) {
                throw new IllegalStateException();
            }
            node.element = replacement;
        }

        public void addNode(Node<T> toAdd) {
            if (this.next != null) {
                LinkedArrayList.this.insertNodeBefore(this.next, toAdd);
            } else {
                LinkedArrayList.this.addNodeToEnd(toAdd);
            }
            this.prev = toAdd;
            this.current = null;
        }

        public void addElement(T toAdd) {
            this.addNode(new Node(toAdd));
        }
    }

    public static class BaseIterator<T> {
        @Nullable
        public Node<T> prev;
        @Nullable
        public Node<T> next;
        @Nullable
        public Node<T> current;

        public boolean baseHasNext() {
            return this.next != null;
        }

        public Node<T> nextNode() throws NoSuchElementException {
            Node<T> node = this.next;
            if (node == null) {
                throw new NoSuchElementException();
            }
            this.prev = node;
            this.next = node.next;
            this.current = node;
            return node;
        }

        public T nextElement() throws NoSuchElementException {
            return this.nextNode().element;
        }

        public boolean baseHasPrev() {
            return this.prev != null;
        }

        public Node<T> prevNode() throws NoSuchElementException {
            Node<T> node = this.prev;
            if (node == null) {
                throw new NoSuchElementException();
            }
            this.prev = node.prev;
            this.next = node;
            this.current = node;
            return node;
        }

        public T prevElement() throws NoSuchElementException {
            return this.prevNode().element;
        }

        public void forNextNodes(Consumer<? super Node<T>> action) {
            Node<T> node = this.next;
            if (node == null) {
                return;
            }
            while (true) {
                action.accept(node);
                Node next = node.next;
                if (next == null) break;
                node = next;
            }
            this.prev = node;
            this.current = node;
            this.next = null;
        }

        public void forNextElements(Consumer<? super T> action) {
            Node<T> node = this.next;
            if (node == null) {
                return;
            }
            while (true) {
                action.accept(node.element);
                Node next = node.next;
                if (next == null) break;
                node = next;
            }
            this.prev = node;
            this.current = node;
            this.next = null;
        }

        public void forPrevNodes(Consumer<? super Node<T>> action) {
            Node<T> node = this.prev;
            if (node == null) {
                return;
            }
            while (true) {
                action.accept(node);
                Node prev = node.prev;
                if (prev == null) break;
                node = prev;
            }
            this.prev = null;
            this.current = node;
            this.next = node;
        }

        public void forPrevElements(Consumer<? super T> action) {
            Node<T> node = this.prev;
            if (node == null) {
                return;
            }
            while (true) {
                action.accept(node.element);
                Node prev = node.prev;
                if (prev == null) break;
                node = prev;
            }
            this.prev = null;
            this.current = node;
            this.next = node;
        }
    }
}

