/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.bigglobe.math.BigGlobeMath;
import java.util.random.RandomGenerator;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Symmetry {
    IDENTITY{

        @Override
        public int getX(int x, int z) {
            return x;
        }

        @Override
        public int getZ(int x, int z) {
            return z;
        }

        @Override
        public double getX(double x, double z) {
            return x;
        }

        @Override
        public double getZ(double x, double z) {
            return z;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state;
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return after;
        }

        @Override
        public Symmetry compose(Symmetry before) {
            return before;
        }

        @Override
        public int bulkAndThen(int after) {
            return after;
        }

        @Override
        public int bulkCompose(int before) {
            return before;
        }
    }
    ,
    ROTATE_90{

        @Override
        public int getX(int x, int z) {
            return -z;
        }

        @Override
        public int getZ(int x, int z) {
            return x;
        }

        @Override
        public double getX(double x, double z) {
            return -z;
        }

        @Override
        public double getZ(double x, double z) {
            return x;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26186(class_2470.field_11463);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> ROTATE_90;
                case ROTATE_90 -> ROTATE_180;
                case ROTATE_180 -> ROTATE_270;
                case ROTATE_270 -> IDENTITY;
                case FLIP_0 -> FLIP_45;
                case FLIP_45 -> FLIP_90;
                case FLIP_90 -> FLIP_135;
                case FLIP_135 -> FLIP_0;
            };
        }
    }
    ,
    ROTATE_180{

        @Override
        public int getX(int x, int z) {
            return -x;
        }

        @Override
        public int getZ(int x, int z) {
            return -z;
        }

        @Override
        public double getX(double x, double z) {
            return -x;
        }

        @Override
        public double getZ(double x, double z) {
            return -z;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26186(class_2470.field_11464);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> ROTATE_180;
                case ROTATE_90 -> ROTATE_270;
                case ROTATE_180 -> IDENTITY;
                case ROTATE_270 -> ROTATE_90;
                case FLIP_0 -> FLIP_90;
                case FLIP_45 -> FLIP_135;
                case FLIP_90 -> FLIP_0;
                case FLIP_135 -> FLIP_45;
            };
        }
    }
    ,
    ROTATE_270{

        @Override
        public int getX(int x, int z) {
            return z;
        }

        @Override
        public int getZ(int x, int z) {
            return -x;
        }

        @Override
        public double getX(double x, double z) {
            return z;
        }

        @Override
        public double getZ(double x, double z) {
            return -x;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26186(class_2470.field_11465);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> ROTATE_270;
                case ROTATE_90 -> IDENTITY;
                case ROTATE_180 -> ROTATE_90;
                case ROTATE_270 -> ROTATE_180;
                case FLIP_0 -> FLIP_135;
                case FLIP_45 -> FLIP_0;
                case FLIP_90 -> FLIP_45;
                case FLIP_135 -> FLIP_90;
            };
        }
    }
    ,
    FLIP_0{

        @Override
        public int getX(int x, int z) {
            return -x;
        }

        @Override
        public int getZ(int x, int z) {
            return z;
        }

        @Override
        public double getX(double x, double z) {
            return -x;
        }

        @Override
        public double getZ(double x, double z) {
            return z;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26185(class_2415.field_11301);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> FLIP_0;
                case ROTATE_90 -> FLIP_135;
                case ROTATE_180 -> FLIP_90;
                case ROTATE_270 -> FLIP_45;
                case FLIP_0 -> IDENTITY;
                case FLIP_45 -> ROTATE_270;
                case FLIP_90 -> ROTATE_180;
                case FLIP_135 -> ROTATE_90;
            };
        }
    }
    ,
    FLIP_45{

        @Override
        public int getX(int x, int z) {
            return z;
        }

        @Override
        public int getZ(int x, int z) {
            return x;
        }

        @Override
        public double getX(double x, double z) {
            return z;
        }

        @Override
        public double getZ(double x, double z) {
            return x;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26186(class_2470.field_11463).method_26185(class_2415.field_11301);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> FLIP_45;
                case ROTATE_90 -> FLIP_0;
                case ROTATE_180 -> FLIP_135;
                case ROTATE_270 -> FLIP_90;
                case FLIP_0 -> ROTATE_90;
                case FLIP_45 -> IDENTITY;
                case FLIP_90 -> ROTATE_270;
                case FLIP_135 -> ROTATE_180;
            };
        }
    }
    ,
    FLIP_90{

        @Override
        public int getX(int x, int z) {
            return x;
        }

        @Override
        public int getZ(int x, int z) {
            return -z;
        }

        @Override
        public double getX(double x, double z) {
            return x;
        }

        @Override
        public double getZ(double x, double z) {
            return -z;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26185(class_2415.field_11300);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> FLIP_90;
                case ROTATE_90 -> FLIP_45;
                case ROTATE_180 -> FLIP_0;
                case ROTATE_270 -> FLIP_135;
                case FLIP_0 -> ROTATE_180;
                case FLIP_45 -> ROTATE_90;
                case FLIP_90 -> IDENTITY;
                case FLIP_135 -> ROTATE_270;
            };
        }
    }
    ,
    FLIP_135{

        @Override
        public int getX(int x, int z) {
            return -z;
        }

        @Override
        public int getZ(int x, int z) {
            return -x;
        }

        @Override
        public double getX(double x, double z) {
            return -z;
        }

        @Override
        public double getZ(double x, double z) {
            return -x;
        }

        @Override
        public class_2680 apply(class_2680 state) {
            return state.method_26186(class_2470.field_11463).method_26185(class_2415.field_11300);
        }

        @Override
        public Symmetry andThen(Symmetry after) {
            return switch (after) {
                default -> throw new IncompatibleClassChangeError();
                case IDENTITY -> FLIP_135;
                case ROTATE_90 -> FLIP_90;
                case ROTATE_180 -> FLIP_45;
                case ROTATE_270 -> FLIP_0;
                case FLIP_0 -> ROTATE_270;
                case FLIP_45 -> ROTATE_180;
                case FLIP_90 -> ROTATE_90;
                case FLIP_135 -> IDENTITY;
            };
        }
    };

    public byte[] bulkAndThen;
    public byte[] bulkCompose;
    public static final Symmetry[] VALUES;

    public static Symmetry of(class_2470 rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> IDENTITY;
            case class_2470.field_11463 -> ROTATE_90;
            case class_2470.field_11464 -> ROTATE_180;
            case class_2470.field_11465 -> ROTATE_270;
        };
    }

    public static Symmetry of(class_2415 mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case class_2415.field_11302 -> IDENTITY;
            case class_2415.field_11300 -> FLIP_90;
            case class_2415.field_11301 -> FLIP_0;
        };
    }

    public static Symmetry rotation(int degrees) {
        return switch (BigGlobeMath.modulus_BP(degrees, 360)) {
            case 90 -> ROTATE_90;
            case 180 -> ROTATE_180;
            case 270 -> ROTATE_270;
            default -> IDENTITY;
        };
    }

    public static Symmetry randomRotation(RandomGenerator random) {
        return VALUES[random.nextInt(4)];
    }

    public static Symmetry flip(int degrees) {
        return switch (BigGlobeMath.modulus_BP(degrees, 180)) {
            case 0 -> FLIP_0;
            case 45 -> FLIP_45;
            case 90 -> FLIP_90;
            case 135 -> FLIP_135;
            default -> IDENTITY;
        };
    }

    public static Symmetry randomFlip(RandomGenerator random) {
        return VALUES[random.nextInt(4, 8)];
    }

    public static Symmetry randomRotationAndFlip(RandomGenerator random) {
        return VALUES[random.nextInt(8)];
    }

    public boolean isFlipped() {
        return this.ordinal() >= 4;
    }

    public abstract int getX(int var1, int var2);

    public abstract int getZ(int var1, int var2);

    public abstract double getX(double var1, double var3);

    public abstract double getZ(double var1, double var3);

    public abstract class_2680 apply(class_2680 var1);

    public abstract Symmetry andThen(Symmetry var1);

    public Symmetry compose(Symmetry before) {
        return before.andThen(this);
    }

    public Symmetry inverse() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> IDENTITY;
            case 1 -> ROTATE_270;
            case 2 -> ROTATE_180;
            case 3 -> ROTATE_90;
            case 4 -> FLIP_0;
            case 5 -> FLIP_45;
            case 6 -> FLIP_90;
            case 7 -> FLIP_135;
        };
    }

    public int bulkAndThen(int after) {
        int output;
        if (after == 0 || after == 255) {
            return after;
        }
        if (this.bulkAndThen == null) {
            this.bulkAndThen = new byte[256];
        }
        if ((output = this.bulkAndThen[after]) == 0) {
            for (int index = 0; index < 8; ++index) {
                if ((after & 1 << index) == 0) continue;
                output |= this.andThen(VALUES[index]).flag();
            }
            this.bulkAndThen[after] = (byte)output;
        } else {
            output &= 0xFF;
        }
        return output;
    }

    public int bulkCompose(int before) {
        int output;
        if (before == 0 || before == 255) {
            return before;
        }
        if (this.bulkCompose == null) {
            this.bulkCompose = new byte[256];
        }
        if ((output = this.bulkCompose[before]) == 0) {
            for (int index = 0; index < 8; ++index) {
                if ((before & 1 << index) == 0) continue;
                output |= VALUES[index].andThen(this).flag();
            }
            this.bulkCompose[before] = (byte)output;
        } else {
            output &= 0xFF;
        }
        return output;
    }

    public int flag() {
        return 1 << this.ordinal();
    }

    static {
        VALUES = Symmetry.values();
    }
}

