/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.bigglobe.scripting.ScriptLogger;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConstantFactory
implements MutableScriptEnvironment.FunctionHandler {
    public static final int CLIENT = 1;
    public static final int NULLABLE = 2;
    public final TypeInfo inType;
    public final TypeInfo outType;

    public static int flags(ExpressionParser parser, boolean nullable) {
        int flags = 0;
        if ((parser.flags & 1) != 0) {
            flags |= 1;
        }
        if (nullable) {
            flags |= 2;
        }
        return flags;
    }

    public AbstractConstantFactory(TypeInfo inType, TypeInfo outType) {
        this.inType = inType;
        this.outType = outType;
    }

    @Override
    @Nullable
    public MutableScriptEnvironment.CastResult create(ExpressionParser parser, String name, InsnTree ... arguments) throws ScriptParsingException {
        if (arguments.length != 1) {
            return null;
        }
        return this.create(parser, arguments[0], false, false);
    }

    public MutableScriptEnvironment.CastResult create(ExpressionParser parser, InsnTree argument, boolean implicit, boolean nullable) {
        if (argument.getTypeInfo().equals(this.inType)) {
            if (argument.getConstantValue().isConstant()) {
                return new MutableScriptEnvironment.CastResult(this.createConstant(argument.getConstantValue(), AbstractConstantFactory.flags(parser, nullable)), true);
            }
            if (implicit) {
                ScriptLogger.LOGGER.warn(ScriptParsingException.appendContext("Non-constant " + this.inType.getClassName() + " input for implicit cast to " + this.outType.getClassName() + ". This will be worse on performance. Use an explicit cast to suppress this warning.", parser.input));
            }
            return new MutableScriptEnvironment.CastResult(this.createNonConstant(argument, AbstractConstantFactory.flags(parser, nullable)), true);
        }
        if (argument.getTypeInfo().equals(this.outType)) {
            return new MutableScriptEnvironment.CastResult(argument, false);
        }
        throw new InvalidOperandException("Must be a " + this.inType.getClassName() + " or a " + this.outType.getClassName() + "; was " + String.valueOf(argument.getTypeInfo()));
    }

    public abstract InsnTree createConstant(ConstantValue var1, int var2);

    public abstract InsnTree createNonConstant(InsnTree var1, int var2);
}

