/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.scripting.bytecode.AbstractConstantFactory;
import builderb0y.scripting.bytecode.ConstantFactory;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.D2ZInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.F2ZInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.OpcodeCastInsnTree;
import builderb0y.scripting.environments.BuiltinScriptEnvironment;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.MethodHandles;

public class CastingSupport {
    public static final MutableScriptEnvironment.CastHandlerData I2B = CastingSupport.data(TypeInfos.INT, TypeInfos.BYTE, false, CastingSupport.opcode(145));
    public static final MutableScriptEnvironment.CastHandlerData I2S = CastingSupport.data(TypeInfos.INT, TypeInfos.SHORT, false, CastingSupport.opcode(147));
    public static final MutableScriptEnvironment.CastHandlerData I2C = CastingSupport.data(TypeInfos.INT, TypeInfos.CHAR, false, CastingSupport.opcode(146));
    public static final MutableScriptEnvironment.CastHandlerData I2L = CastingSupport.data(TypeInfos.INT, TypeInfos.LONG, true, CastingSupport.opcode(133));
    public static final MutableScriptEnvironment.CastHandlerData I2F = CastingSupport.data(TypeInfos.INT, TypeInfos.FLOAT, true, CastingSupport.opcode(134));
    public static final MutableScriptEnvironment.CastHandlerData I2D = CastingSupport.data(TypeInfos.INT, TypeInfos.DOUBLE, true, CastingSupport.opcode(135));
    public static final MutableScriptEnvironment.CastHandlerData L2I = CastingSupport.data(TypeInfos.LONG, TypeInfos.INT, false, CastingSupport.opcode(136));
    public static final MutableScriptEnvironment.CastHandlerData L2F = CastingSupport.data(TypeInfos.LONG, TypeInfos.FLOAT, true, CastingSupport.opcode(137));
    public static final MutableScriptEnvironment.CastHandlerData L2D = CastingSupport.data(TypeInfos.LONG, TypeInfos.DOUBLE, true, CastingSupport.opcode(138));
    public static final MutableScriptEnvironment.CastHandlerData F2I = CastingSupport.data(TypeInfos.FLOAT, TypeInfos.INT, false, CastingSupport.invokeStatic(MethodInfo.findMethod(CastingSupport.class, "floorInt", Integer.TYPE, Float.TYPE)));
    public static final MutableScriptEnvironment.CastHandlerData F2L = CastingSupport.data(TypeInfos.FLOAT, TypeInfos.LONG, false, CastingSupport.invokeStatic(MethodInfo.findMethod(CastingSupport.class, "floorLong", Long.TYPE, Float.TYPE)));
    public static final MutableScriptEnvironment.CastHandlerData F2D = CastingSupport.data(TypeInfos.FLOAT, TypeInfos.DOUBLE, true, CastingSupport.opcode(141));
    public static final MutableScriptEnvironment.CastHandlerData D2I = CastingSupport.data(TypeInfos.DOUBLE, TypeInfos.INT, false, CastingSupport.invokeStatic(MethodInfo.findMethod(CastingSupport.class, "floorInt", Integer.TYPE, Double.TYPE)));
    public static final MutableScriptEnvironment.CastHandlerData D2L = CastingSupport.data(TypeInfos.DOUBLE, TypeInfos.LONG, false, CastingSupport.invokeStatic(MethodInfo.findMethod(CastingSupport.class, "floorLong", Long.TYPE, Double.TYPE)));
    public static final MutableScriptEnvironment.CastHandlerData D2F = CastingSupport.data(TypeInfos.DOUBLE, TypeInfos.FLOAT, false, CastingSupport.opcode(144));
    public static final MutableScriptEnvironment.CastHandlerData F2Z = CastingSupport.data(TypeInfos.FLOAT, TypeInfos.BOOLEAN, false, (parser, value, to, implicit, nullable) -> new F2ZInsnTree(value));
    public static final MutableScriptEnvironment.CastHandlerData D2Z = CastingSupport.data(TypeInfos.DOUBLE, TypeInfos.BOOLEAN, false, (parser, value, to, implicit, nullable) -> new D2ZInsnTree(value));
    public static final FieldInfo TRUE_FIELD = FieldInfo.getField(Boolean.class, "TRUE");
    public static final FieldInfo FALSE_FIELD = FieldInfo.getField(Boolean.class, "FALSE");
    public static final MethodInfo BOOLEAN_VALUE_OF = MethodInfo.findMethod(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
    public static final AbstractConstantFactory BYTE_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeByte"), MethodInfo.findMethod(Byte.class, "valueOf", Byte.class, Byte.TYPE), TypeInfos.BYTE, TypeInfos.BYTE_WRAPPER, false);
    public static final AbstractConstantFactory SHORT_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeShort"), MethodInfo.findMethod(Short.class, "valueOf", Short.class, Short.TYPE), TypeInfos.SHORT, TypeInfos.SHORT_WRAPPER, false);
    public static final AbstractConstantFactory INT_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeInt"), MethodInfo.findMethod(Integer.class, "valueOf", Integer.class, Integer.TYPE), TypeInfos.INT, TypeInfos.INT_WRAPPER, false);
    public static final AbstractConstantFactory LONG_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeLong"), MethodInfo.findMethod(Long.class, "valueOf", Long.class, Long.TYPE), TypeInfos.LONG, TypeInfos.LONG_WRAPPER, false);
    public static final AbstractConstantFactory FLOAT_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeFloat"), MethodInfo.findMethod(Float.class, "valueOf", Float.class, Float.TYPE), TypeInfos.FLOAT, TypeInfos.FLOAT_WRAPPER, false);
    public static final AbstractConstantFactory DOUBLE_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeDouble"), MethodInfo.findMethod(Double.class, "valueOf", Double.class, Double.TYPE), TypeInfos.DOUBLE, TypeInfos.DOUBLE_WRAPPER, false);
    public static final AbstractConstantFactory CHAR_CONSTANT_FACTORY = new ConstantFactory(MethodInfo.getMethod(CastingSupport.class, "makeChar"), MethodInfo.findMethod(Character.class, "valueOf", Character.class, Character.TYPE), TypeInfos.CHAR, TypeInfos.CHAR_WRAPPER, false);
    public static final AbstractConstantFactory BOOLEAN_CONSTANT_FACTORY = new AbstractConstantFactory(TypeInfos.BOOLEAN, TypeInfos.BOOLEAN_WRAPPER){

        @Override
        public InsnTree createConstant(ConstantValue constant, int flags) {
            return InsnTrees.getStatic(constant.asBoolean() ? TRUE_FIELD : FALSE_FIELD);
        }

        @Override
        public InsnTree createNonConstant(InsnTree tree, int flags) {
            return InsnTrees.invokeStatic(BOOLEAN_VALUE_OF, tree);
        }
    };

    @Deprecated
    public static InsnTree primitiveCast(InsnTree value, TypeInfo type) {
        if (value.getTypeInfo().equals(type)) {
            return value;
        }
        class HelperParserHolder {
            public static final ExpressionParser PRIMITIVE_CAST_HELPER = new ExpressionParser("", null, null, 0);

            HelperParserHolder() {
            }
        }
        InsnTree casted = BuiltinScriptEnvironment.INSTANCE.cast(HelperParserHolder.PRIMITIVE_CAST_HELPER, value, type, false, false);
        if (casted != null) {
            return casted;
        }
        throw new IllegalArgumentException("Can't primitively cast " + value.describe() + " to " + String.valueOf(type));
    }

    public static MutableScriptEnvironment.CastHandler opcode(int opcode) {
        return (parser, value, to, implicit, nullable) -> new OpcodeCastInsnTree(value, opcode, to);
    }

    public static MutableScriptEnvironment.CastHandler invokeVirtual(MethodInfo method) {
        if (method.isStatic()) {
            throw new IllegalArgumentException("Static method: " + String.valueOf(method));
        }
        return (parser, value, to, implicit, nullable) -> InsnTrees.invokeInstance(value, method, new InsnTree[0]);
    }

    public static MutableScriptEnvironment.CastHandler invokeStatic(MethodInfo method) {
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Non-static method: " + String.valueOf(method));
        }
        return (parser, value, to, implicit, nullable) -> InsnTrees.invokeStatic(method, value);
    }

    public static MutableScriptEnvironment.CastHandler invoke(Class<?> in, String name) {
        MethodInfo method = MethodInfo.getMethod(in, name);
        return method.isStatic() ? CastingSupport.invokeStatic(method) : CastingSupport.invokeVirtual(method);
    }

    public static MutableScriptEnvironment.CastHandlerData data(TypeInfo from, TypeInfo to, boolean implicit, MutableScriptEnvironment.CastHandler caster) {
        return new MutableScriptEnvironment.CastHandlerData(from, to, implicit, caster);
    }

    public static MutableScriptEnvironment.CastHandler allOf(MutableScriptEnvironment.CastHandlerData ... casters) {
        return new MutableScriptEnvironment.MultiCastHandler(casters);
    }

    public static boolean F2Z(float value) {
        return value == value;
    }

    public static boolean D2Z(double value) {
        return value == value;
    }

    public static int floorInt(long value) {
        return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (value <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    public static int floorInt(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MIN_VALUE && (float)result > value ? result - 1 : result;
    }

    public static int floorInt(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MIN_VALUE && (double)result > value ? result - 1 : result;
    }

    public static long floorLong(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        return result != Long.MIN_VALUE && (float)result > value ? result - 1L : result;
    }

    public static long floorLong(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        return result != Long.MIN_VALUE && (double)result > value ? result - 1L : result;
    }

    public static int ceilInt(long value) {
        return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (value <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    public static int ceilInt(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MAX_VALUE && (float)result < value ? result + 1 : result;
    }

    public static int ceilInt(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MAX_VALUE && (double)result < value ? result + 1 : result;
    }

    public static long ceilLong(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        return result != Long.MAX_VALUE && (float)result < value ? result + 1L : result;
    }

    public static long ceilLong(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        return result != Long.MAX_VALUE && (double)result < value ? result + 1L : result;
    }

    public static int roundInt(long value) {
        return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (value <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    public static int roundInt(float value) {
        return CastingSupport.floorInt(value + 0.5f);
    }

    public static int roundInt(double value) {
        return CastingSupport.floorInt(value + 0.5);
    }

    public static long roundLong(float value) {
        return CastingSupport.floorLong(value + 0.5f);
    }

    public static long roundLong(double value) {
        return CastingSupport.floorLong(value + 0.5);
    }

    public static int lowerInt(int value) {
        return value == Integer.MIN_VALUE ? Integer.MIN_VALUE : value - 1;
    }

    public static int lowerInt(long value) {
        return value <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value - 1);
    }

    public static int lowerInt(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MIN_VALUE && (double)result >= (double)value ? result - 1 : result;
    }

    public static int lowerInt(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MIN_VALUE && (double)result >= value ? result - 1 : result;
    }

    public static long lowerLong(int value) {
        return (long)value - 1L;
    }

    public static long lowerLong(long value) {
        return value == Long.MIN_VALUE ? Long.MIN_VALUE : value - 1L;
    }

    public static long lowerLong(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        if (!(Math.abs(value) < 9.223372E18f)) {
            return result;
        }
        return value <= 0.0f || !CastingSupport.needsRounding(value) ? result - 1L : result;
    }

    public static long lowerLong(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        if (!(Math.abs(value) < 9.223372036854776E18)) {
            return result;
        }
        return value <= 0.0 || !CastingSupport.needsRounding(value) ? result - 1L : result;
    }

    public static int higherInt(int value) {
        return value == Integer.MAX_VALUE ? Integer.MAX_VALUE : value + 1;
    }

    public static int higherInt(long value) {
        return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value + 1);
    }

    public static int higherInt(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MAX_VALUE && (double)result <= (double)value ? result + 1 : result;
    }

    public static int higherInt(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to int");
        }
        int result = (int)value;
        return result != Integer.MAX_VALUE && (double)result <= value ? result + 1 : result;
    }

    public static long higherLong(int value) {
        return (long)value + 1L;
    }

    public static long higherLong(long value) {
        return value == Long.MAX_VALUE ? Long.MAX_VALUE : value + 1L;
    }

    public static long higherLong(float value) {
        if (Float.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        if (!((double)Math.abs(value) < 9.223372036854776E18)) {
            return value == -9.223372E18f ? result + 1L : result;
        }
        return value >= 0.0f || !CastingSupport.needsRounding(value) ? result + 1L : result;
    }

    public static long higherLong(double value) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Attempt to cast NaN to long");
        }
        long result = (long)value;
        if (!(Math.abs(value) < 9.223372036854776E18)) {
            return value == -9.223372036854776E18 ? result + 1L : result;
        }
        return value >= 0.0 || !CastingSupport.needsRounding(value) ? result + 1L : result;
    }

    public static int truncInt(long value) {
        return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (value <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    public static boolean needsRounding(float value) {
        int exponent = Math.getExponent(value);
        if (exponent < 0) {
            return true;
        }
        if (exponent >= 23) {
            return false;
        }
        return (Float.floatToRawIntBits(value) & 0x7FFFFF >>> exponent) != 0;
    }

    public static boolean needsRounding(double value) {
        int exponent = Math.getExponent(value);
        if (exponent < 0) {
            return true;
        }
        if (exponent >= 52) {
            return false;
        }
        return (Double.doubleToRawLongBits(value) & 0xFFFFFFFFFFFFFL >>> exponent) != 0L;
    }

    public static Byte makeByte(MethodHandles.Lookup caller, String name, Class<?> type, int value) {
        return BigGlobeMath.toByteExact(value);
    }

    public static Short makeShort(MethodHandles.Lookup caller, String name, Class<?> type, int value) {
        return BigGlobeMath.toShortExact(value);
    }

    public static Integer makeInt(MethodHandles.Lookup caller, String name, Class<?> type, int value) {
        return value;
    }

    public static Long makeLong(MethodHandles.Lookup caller, String name, Class<?> type, long value) {
        return value;
    }

    public static Float makeFloat(MethodHandles.Lookup caller, String name, Class<?> type, float value) {
        return Float.valueOf(value);
    }

    public static Double makeDouble(MethodHandles.Lookup caller, String name, Class<?> type, double value) {
        return value;
    }

    public static Character makeChar(MethodHandles.Lookup caller, String name, Class<?> type, int value) {
        return Character.valueOf(BigGlobeMath.toCharExact(value));
    }

    public static Boolean makeBoolean(MethodHandles.Lookup caller, String name, Class<?> type, int value) {
        return switch (value) {
            case 0 -> Boolean.FALSE;
            case 1 -> Boolean.TRUE;
            default -> throw new IllegalArgumentException("Not a boolean: " + value);
        };
    }
}

