/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.util.FakeRegistry;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.AbstractConstantFactory;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7876;

public class ConstantFactory
extends AbstractConstantFactory {
    public static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public final MethodInfo constantMethod;
    public final MethodInfo variableMethod;
    public final MethodHandle validator;
    public final boolean hasFlags;

    public ConstantFactory(Class<?> owner, String name, Class<?> inType, Class<?> outType) {
        super(InsnTrees.type(inType), InsnTrees.type(outType));
        this.constantMethod = MethodInfo.findMethod(owner, name, outType, MethodHandles.Lookup.class, String.class, Class.class, inType, Integer.TYPE);
        this.variableMethod = MethodInfo.findMethod(owner, name, outType, inType, Integer.TYPE);
        try {
            this.validator = MethodHandles.lookup().findStatic(owner, name, MethodType.methodType(outType, inType, Integer.TYPE));
        }
        catch (Exception exception) {
            throw AutoCodecUtil.rethrow((Throwable)exception);
        }
        this.hasFlags = true;
    }

    public ConstantFactory(MethodInfo constantMethod, MethodInfo variableMethod, TypeInfo inType, TypeInfo outType, boolean hasFlags) {
        super(inType, outType);
        this.constantMethod = constantMethod;
        this.variableMethod = variableMethod;
        this.validator = null;
        this.hasFlags = hasFlags;
    }

    public static <T> class_6880<T> getEntry(class_5321<class_2378<T>> registryKey, String id, int flags) {
        if (id == null) {
            return null;
        }
        try {
            return BigGlobeMod.getSidedRegistry(registryKey, (flags & 1) != 0).requireByName(id);
        }
        catch (RuntimeException exception) {
            if ((flags & 2) != 0) {
                return null;
            }
            throw exception;
        }
    }

    public static <T> class_6880<T> getEntryServerOnly(class_5321<class_2378<T>> registryKey, String id, int flags, T defaultValue) {
        if (id == null) {
            return null;
        }
        try {
            if ((flags & 1) != 0) {
                return new FakeRegistry.RegistryEntryImpl<T>(new class_7876<T>(){}, registryKey, IdentifierVersions.create(id), defaultValue);
            }
            return BigGlobeMod.getRegistry(registryKey).requireByName(id);
        }
        catch (RuntimeException exception) {
            if ((flags & 2) != 0) {
                return null;
            }
            throw exception;
        }
    }

    public static ConstantFactory autoOfString() {
        Class<?> caller = STACK_WALKER.getCallerClass();
        return new ConstantFactory(caller, "of", String.class, caller);
    }

    @Override
    public InsnTree createConstant(ConstantValue constant, int flags) {
        if (this.hasFlags) {
            if ((flags & 2) == 0) {
                try {
                    this.validator.invoke(constant.asJavaObject(), flags);
                }
                catch (Throwable exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            return InsnTrees.ldc(this.constantMethod, constant, InsnTrees.constant(flags));
        }
        return InsnTrees.ldc(this.constantMethod, constant);
    }

    @Override
    public InsnTree createNonConstant(InsnTree tree, int flags) {
        if (this.hasFlags) {
            return InsnTrees.invokeStatic(this.variableMethod, tree, InsnTrees.ldc(flags));
        }
        return InsnTrees.invokeStatic(this.variableMethod, tree);
    }
}

