/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.UserMethodDefiner;
import builderb0y.scripting.util.TypeMerger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class DelayedMethod {
    public String methodName;
    public TypeInfo returnType;
    public Map<LazyVarInfo, Boolean> capturedVariables;
    public List<LazyVarInfo> userParameters;
    @Nullable
    public InsnTree body;
    @Nullable
    public MethodInfo methodInfo;

    public DelayedMethod(UserMethodDefiner spec) {
        this.methodName = spec.methodName;
        this.returnType = spec.returnType;
        this.capturedVariables = new HashMap<LazyVarInfo, Boolean>(spec.builtinParameters.size() + spec.capturedVariables.size());
        for (LoadInsnTree builtin : spec.builtinParameters) {
            this.capturedVariables.put(builtin.variable, Boolean.TRUE);
        }
        for (LoadInsnTree captured : spec.capturedVariables) {
            this.capturedVariables.put(captured.variable, Boolean.FALSE);
        }
        this.userParameters = spec.streamUserParameters().toList();
    }

    public void configureEnvironment(ExpressionParser parser) {
        parser.environment.user().delayedMethods.add(this);
        for (LazyVarInfo variable : this.userParameters) {
            parser.environment.user().reserveAndAssignVariable(variable.name, variable.type);
        }
    }

    public void onVariableUsed(LazyVarInfo info) {
        this.capturedVariables.replace(info, Boolean.TRUE);
    }

    public Stream<LazyVarInfo> streamCapturedArgs() {
        if (this.body == null) {
            throw new IllegalStateException("body not parsed yet!");
        }
        return this.capturedVariables.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey);
    }

    public MethodCompileContext createMethod(ExpressionParser parser) {
        if (this.body == null) {
            throw new IllegalStateException("body not parsed yet!");
        }
        MethodCompileContext method = parser.clazz.newMethod(parser.method.info.access(), this.methodName + "_" + parser.clazz.memberUniquifier++, this.returnType, (LazyVarInfo[])Stream.concat(this.userParameters.stream(), this.streamCapturedArgs()).toArray((IntFunction<A[]>)LazyVarInfo.ARRAY_FACTORY));
        this.methodInfo = method.info;
        return method;
    }

    public void emitMethod(MethodCompileContext method) {
        this.body.emitBytecode(method);
        method.endCode();
    }

    public static class MemorizingSupplier<T>
    implements Supplier<T> {
        public final Supplier<? extends T> delegate;
        public T value;

        public MemorizingSupplier(Supplier<? extends T> delegate) {
            this.delegate = delegate;
        }

        public static <T> MemorizingSupplier<T> of(Supplier<T> supplier) {
            MemorizingSupplier<T> memorizingSupplier;
            if (supplier instanceof MemorizingSupplier) {
                MemorizingSupplier memorizing = (MemorizingSupplier)supplier;
                memorizingSupplier = memorizing;
            } else {
                memorizingSupplier = new MemorizingSupplier<T>(supplier);
            }
            return memorizingSupplier;
        }

        @Override
        public T get() {
            return this.value == null ? (this.value = this.delegate.get()) : this.value;
        }
    }

    public static class LazyElvisInsnTree
    implements InsnTree {
        public Supplier<? extends InsnTree> delegate;
        public TypeInfo type;

        public LazyElvisInsnTree(Supplier<? extends InsnTree> delegate, TypeInfo type) {
            this.delegate = MemorizingSupplier.of(delegate);
            this.type = type;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            this.delegate.get().emitBytecode(method);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }
    }

    public static class LazyInvokeInsnTree
    implements InsnTree {
        public Supplier<? extends InsnTree> delegate;
        public TypeInfo type;

        public LazyInvokeInsnTree(Supplier<? extends InsnTree> delegate, TypeInfo type) {
            this.delegate = MemorizingSupplier.of(delegate);
            this.type = type;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            this.delegate.get().emitBytecode(method);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        public InsnTree elvis(ExpressionParser parser, InsnTree alternative) {
            return new LazyElvisInsnTree(() -> this.delegate.get().elvis(parser, alternative), alternative.jumpsUnconditionally() ? this.type : TypeMerger.computeMostSpecificType(this.type, alternative.getTypeInfo()));
        }

        @Override
        public boolean canBeStatement() {
            return true;
        }
    }
}

