/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.AbstractConstantFactory;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.util.TypeInfos;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class FieldConstantFactory
extends AbstractConstantFactory {
    public static final MethodInfo ENUM_VALUE_OF = MethodInfo.getMethod(Enum.class, "valueOf");
    public final Map<String, InsnTree> lookup;
    public final UnaryOperator<InsnTree> nonConstantGetter;

    public FieldConstantFactory(TypeInfo outType, Map<String, InsnTree> constantLookup, UnaryOperator<InsnTree> getter) {
        super(TypeInfos.STRING, outType);
        this.lookup = constantLookup;
        this.nonConstantGetter = getter;
    }

    public static <E extends Enum<E>> FieldConstantFactory forEnum(Class<E> enumClass) {
        return FieldConstantFactory.forEnum(enumClass, Enum::name);
    }

    public static <E extends Enum<E>> FieldConstantFactory forEnum(Class<E> enumClass, Function<E, String> nameGetter) {
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        HashMap<String, InsnTree> lookup = new HashMap<String, InsnTree>(enums.length);
        for (Enum enum_ : enums) {
            lookup.put(nameGetter.apply(enum_), InsnTrees.getStatic(FieldInfo.getField(enumClass, enum_.name())));
        }
        return new FieldConstantFactory(InsnTrees.type(enumClass), lookup, tree -> InsnTrees.invokeStatic(ENUM_VALUE_OF, InsnTrees.ldc(InsnTrees.type(enumClass)), tree));
    }

    @Override
    public InsnTree createConstant(ConstantValue constant, int flags) {
        return this.lookup.get(constant.asJavaObject());
    }

    @Override
    public InsnTree createNonConstant(InsnTree tree, int flags) {
        return (InsnTree)this.nonConstantGetter.apply(tree);
    }
}

