/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.autocodec.util.HashStrategies;
import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.scripting.bytecode.ClassType;
import builderb0y.scripting.util.ArrayBuilder;
import builderb0y.scripting.util.CollectionTransformer;
import builderb0y.scripting.util.TypeInfos;
import it.unimi.dsi.fastutil.Hash;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeInfo {
    public static final ClassValue<TypeInfo> CACHE = new ClassValue<TypeInfo>(){

        @Override
        protected TypeInfo computeValue(Class<?> type) {
            return TypeInfo.convert(type);
        }
    };
    public static final ObjectArrayFactory<TypeInfo> ARRAY_FACTORY = new ObjectArrayFactory(TypeInfo.class);
    public static final TypeInfo[] ANNOTATION_INTERFACES = TypeInfo.allOf(Annotation.class);
    public static final TypeInfo[] ARRAY_INTERFACES = TypeInfo.allOf(Cloneable.class, Serializable.class);
    @NotNull
    public final ClassType type;
    @Deprecated
    @NotNull
    public final org.objectweb.asm.Type name;
    @Nullable
    public final TypeInfo superClass;
    @NotNull
    public final @NotNull TypeInfo @NotNull [] superInterfaces;
    @Nullable
    public final TypeInfo componentType;
    public final boolean isGeneric;
    public final boolean isFinal;
    public Set<TypeInfo> allAssignableTypes;
    public Set<TypeInfo> allCastableTypes;

    public TypeInfo(@NotNull ClassType type, @NotNull org.objectweb.asm.Type name, @Nullable TypeInfo superClass, @NotNull @NotNull TypeInfo @NotNull [] superInterfaces, @Nullable TypeInfo componentType, boolean isGeneric, boolean isFinal) {
        this.type = type;
        this.name = name;
        this.superClass = superClass;
        this.superInterfaces = superInterfaces;
        this.componentType = componentType;
        this.isGeneric = isGeneric;
        this.isFinal = isFinal;
    }

    @Contract(value="null -> null; !null -> !null")
    public static TypeInfo of(@Nullable Class<?> clazz) {
        return clazz == null ? null : CACHE.get(clazz);
    }

    public static TypeInfo[] allOf(Class<?> ... classes) {
        return CollectionTransformer.convertArray(classes, ARRAY_FACTORY, TypeInfo::of);
    }

    public static TypeInfo[] allOf(Type ... types) {
        return CollectionTransformer.convertArray(types, ARRAY_FACTORY, TypeInfo::of);
    }

    public static ParsedTypeInfo parseNext(CharSequence input, int start) {
        char first = input.charAt(start);
        return switch (first) {
            case 'B' -> new ParsedTypeInfo(TypeInfos.BYTE, start + 1);
            case 'S' -> new ParsedTypeInfo(TypeInfos.SHORT, start + 1);
            case 'I' -> new ParsedTypeInfo(TypeInfos.INT, start + 1);
            case 'J' -> new ParsedTypeInfo(TypeInfos.LONG, start + 1);
            case 'F' -> new ParsedTypeInfo(TypeInfos.FLOAT, start + 1);
            case 'D' -> new ParsedTypeInfo(TypeInfos.DOUBLE, start + 1);
            case 'C' -> new ParsedTypeInfo(TypeInfos.CHAR, start + 1);
            case 'Z' -> new ParsedTypeInfo(TypeInfos.BOOLEAN, start + 1);
            case 'L' -> {
                int end = ++start;
                while (input.charAt(end) != ';') {
                    ++end;
                }
                yield new ParsedTypeInfo(TypeInfo.parseInternalName(input, start, end), end + 1);
            }
            case '[' -> {
                ParsedTypeInfo result = TypeInfo.parseNext(input, start + 1);
                yield new ParsedTypeInfo(TypeInfo.makeArray(result.type), result.endIndex);
            }
            default -> throw new IllegalArgumentException(input.toString());
        };
    }

    public static TypeInfo parseInternalName(CharSequence internalName, int start, int end) {
        char[] chars = new char[end - start];
        for (int index = start; index < end; ++index) {
            char c = internalName.charAt(index);
            chars[index - start] = c == '/' ? 46 : (int)c;
        }
        String name = new String(chars);
        try {
            return TypeInfo.of(Class.forName(name));
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Cannot find class " + name, exception);
        }
    }

    public static TypeInfo parse(char c) {
        return switch (c) {
            case 'B' -> TypeInfos.BYTE;
            case 'S' -> TypeInfos.SHORT;
            case 'I' -> TypeInfos.INT;
            case 'J' -> TypeInfos.LONG;
            case 'F' -> TypeInfos.FLOAT;
            case 'D' -> TypeInfos.DOUBLE;
            case 'C' -> TypeInfos.CHAR;
            case 'Z' -> TypeInfos.BOOLEAN;
            default -> throw new IllegalArgumentException(String.valueOf(c));
        };
    }

    public static TypeInfo parse(CharSequence input) {
        return TypeInfo.parseNext((CharSequence)input, (int)0).type;
    }

    public static TypeInfo[] parseAll(CharSequence input) {
        ArrayBuilder array = new ArrayBuilder();
        int index = 0;
        while (index < input.length()) {
            ParsedTypeInfo next = TypeInfo.parseNext(input, index);
            array.add(next.type);
            index = next.endIndex;
        }
        return (TypeInfo[])array.toArray((IntFunction<T1[]>)ARRAY_FACTORY);
    }

    public static TypeInfo[] parseObjects(Object ... objects) {
        ArrayBuilder<TypeInfo> array = new ArrayBuilder<TypeInfo>();
        int start = -1;
        for (Object object : objects) {
            if (object instanceof CharSequence) {
                CharSequence string = (CharSequence)object;
                start = array.size();
                array.add((T[])TypeInfo.parseAll(string));
                continue;
            }
            if (object instanceof Character) {
                Character character = (Character)object;
                start = array.size();
                array.add(TypeInfo.parse(character.charValue()));
                continue;
            }
            if (object instanceof Type) {
                Type type = (Type)object;
                start = array.size();
                array.add(TypeInfo.of(type));
                continue;
            }
            if (object instanceof TypeInfo) {
                TypeInfo type = (TypeInfo)object;
                start = array.size();
                array.add(type);
                continue;
            }
            if (object instanceof Integer) {
                Integer count = (Integer)object;
                if (count == 0) {
                    array.subList(start, array.size()).clear();
                    continue;
                }
                List last = List.copyOf(array.subList(start, array.size()));
                for (int loop = 1; loop < count; ++loop) {
                    array.addAll(last);
                }
                continue;
            }
            throw new IllegalArgumentException("Unrecognized object: " + String.valueOf(object));
        }
        return (TypeInfo[])array.toArray((IntFunction<T1[]>)ARRAY_FACTORY);
    }

    public static TypeInfo of(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return TypeInfo.of(clazz);
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return TypeInfo.of(variable.getBounds()[0]).generic();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            return TypeInfo.of(parameterized.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            return TypeInfo.makeArray(TypeInfo.of(array.getGenericComponentType())).generic();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return TypeInfo.of(wildcard.getUpperBounds()[0]).generic();
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }

    public static TypeInfo convert(Class<?> clazz) {
        org.objectweb.asm.Type name = org.objectweb.asm.Type.getType(clazz);
        if (clazz.isPrimitive()) {
            return TypeInfo.makePrimitive(name);
        }
        if (clazz.isArray()) {
            return TypeInfo.makeArray(name, TypeInfo.of(clazz.getComponentType()));
        }
        if (clazz.isAnnotation()) {
            return TypeInfo.makeAnnotation(name);
        }
        if (clazz.isInterface()) {
            return TypeInfo.makeInterface(name, TypeInfo.allOf(clazz.getInterfaces()));
        }
        if (clazz.isEnum()) {
            return TypeInfo.makeEnum(name, TypeInfo.allOf(clazz.getInterfaces()));
        }
        if (clazz.isRecord()) {
            return TypeInfo.makeRecord(name, TypeInfo.allOf(clazz.getInterfaces()));
        }
        return TypeInfo.makeClass(name, TypeInfo.of(clazz.getSuperclass()), TypeInfo.allOf(clazz.getInterfaces()), Modifier.isFinal(clazz.getModifiers()));
    }

    public TypeInfo generic() {
        return this.isGeneric ? this : new TypeInfo(this.type, this.name, this.superClass, this.superInterfaces, this.componentType, true, this.isFinal);
    }

    public TypeInfo notGeneric() {
        return !this.isGeneric ? this : new TypeInfo(this.type, this.name, this.superClass, this.superInterfaces, this.componentType, false, this.isFinal);
    }

    public Sort getSort() {
        return switch (this.name.getSort()) {
            case 0 -> Sort.VOID;
            case 1 -> Sort.BOOLEAN;
            case 3 -> Sort.BYTE;
            case 2 -> Sort.CHAR;
            case 4 -> Sort.SHORT;
            case 5 -> Sort.INT;
            case 7 -> Sort.LONG;
            case 6 -> Sort.FLOAT;
            case 8 -> Sort.DOUBLE;
            case 10 -> Sort.OBJECT;
            case 9 -> Sort.ARRAY;
            default -> throw new AssertionError(this.name);
        };
    }

    public Class<?> toClass() {
        Class<Object> clazz;
        switch (this.getSort().ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 2: {
                Class<Byte> clazz2;
                clazz = clazz2 = Byte.TYPE;
                break;
            }
            case 4: {
                Class<Short> clazz3 = Short.TYPE;
                clazz = clazz3;
                break;
            }
            case 5: {
                Class<Integer> clazz4 = Integer.TYPE;
                clazz = clazz4;
                break;
            }
            case 6: {
                Class<Long> clazz5 = Long.TYPE;
                clazz = clazz5;
                break;
            }
            case 7: {
                Class<Float> clazz6 = Float.TYPE;
                clazz = clazz6;
                break;
            }
            case 8: {
                Class<Double> clazz7 = Double.TYPE;
                clazz = clazz7;
                break;
            }
            case 3: {
                Class<Character> clazz8 = Character.TYPE;
                clazz = clazz8;
                break;
            }
            case 1: {
                Class<Boolean> clazz9 = Boolean.TYPE;
                clazz = clazz9;
                break;
            }
            case 0: {
                Class<Void> clazz10 = Void.TYPE;
                clazz = clazz10;
                break;
            }
            case 9: 
            case 10: {
                try {
                    Class<?> clazz11 = Class.forName(this.getClassName());
                    clazz = clazz11;
                    break;
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalArgumentException(String.valueOf(this) + " does not correspond to a currently defined class.", exception);
                }
            }
        }
        return clazz;
    }

    public Class<?> toClass(ClassLoader classLoader) {
        Class<Object> clazz;
        switch (this.getSort().ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 2: {
                Class<Byte> clazz2;
                clazz = clazz2 = Byte.TYPE;
                break;
            }
            case 4: {
                Class<Short> clazz3 = Short.TYPE;
                clazz = clazz3;
                break;
            }
            case 5: {
                Class<Integer> clazz4 = Integer.TYPE;
                clazz = clazz4;
                break;
            }
            case 6: {
                Class<Long> clazz5 = Long.TYPE;
                clazz = clazz5;
                break;
            }
            case 7: {
                Class<Float> clazz6 = Float.TYPE;
                clazz = clazz6;
                break;
            }
            case 8: {
                Class<Double> clazz7 = Double.TYPE;
                clazz = clazz7;
                break;
            }
            case 3: {
                Class<Character> clazz8 = Character.TYPE;
                clazz = clazz8;
                break;
            }
            case 1: {
                Class<Boolean> clazz9 = Boolean.TYPE;
                clazz = clazz9;
                break;
            }
            case 0: {
                Class<Void> clazz10 = Void.TYPE;
                clazz = clazz10;
                break;
            }
            case 9: 
            case 10: {
                try {
                    Class<?> clazz11 = Class.forName(this.getClassName(), false, classLoader);
                    clazz = clazz11;
                    break;
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalArgumentException(String.valueOf(this) + " does not correspond to a currently defined class in " + String.valueOf(classLoader), exception);
                }
            }
        }
        return clazz;
    }

    public org.objectweb.asm.Type toAsmType() {
        return this.name;
    }

    public String getInternalName() {
        return this.name.getInternalName();
    }

    public String getClassName() {
        return this.name.getClassName();
    }

    public String getDescriptor() {
        return this.name.getDescriptor();
    }

    public String getSimpleName() {
        char c;
        if (this.isPrimitive()) {
            return this.getSort().name().toLowerCase(Locale.ROOT);
        }
        String name = this.getInternalName();
        int start = name.length();
        while (--start >= 0 && (c = name.charAt(start)) != '/' && c != '$') {
        }
        return name.substring(start + 1);
    }

    public String getSimpleClassName() {
        if (this.isPrimitive()) {
            return this.getSort().name().toLowerCase(Locale.ROOT);
        }
        String internalName = this.getInternalName();
        return internalName.substring(internalName.lastIndexOf(47) + 1);
    }

    public int getOpcode(int base) {
        return this.name.getOpcode(base);
    }

    public int getSize() {
        return this.name.getSize();
    }

    public static TypeInfo makeAnnotation(org.objectweb.asm.Type name) {
        return new TypeInfo(ClassType.ANNOTATION, name, TypeInfos.OBJECT, ANNOTATION_INTERFACES, null, false, false);
    }

    public static TypeInfo makeArray(org.objectweb.asm.Type name, TypeInfo componentType) {
        return new TypeInfo(ClassType.ARRAY, name, TypeInfos.OBJECT, ARRAY_INTERFACES, componentType, componentType.isGeneric, false);
    }

    public static TypeInfo makeArray(TypeInfo componentType) {
        return TypeInfo.makeArray(org.objectweb.asm.Type.getType((String)("[" + componentType.name.getDescriptor())), componentType);
    }

    public static TypeInfo makeClass(org.objectweb.asm.Type name, TypeInfo superClass, TypeInfo[] superInterfaces, boolean isFinal) {
        return new TypeInfo(ClassType.CLASS, name, superClass, superInterfaces, null, false, isFinal);
    }

    public static TypeInfo makeEnum(org.objectweb.asm.Type name, TypeInfo[] superInterfaces) {
        return new TypeInfo(ClassType.ENUM, name, TypeInfos.ENUM, superInterfaces, null, false, true);
    }

    public static TypeInfo makeInterface(org.objectweb.asm.Type name, TypeInfo[] superInterfaces) {
        return new TypeInfo(ClassType.INTERFACE, name, TypeInfos.OBJECT, superInterfaces, null, false, false);
    }

    public static TypeInfo makePrimitive(org.objectweb.asm.Type name) {
        return new TypeInfo(ClassType.PRIMITIVE, name, null, (TypeInfo[])ARRAY_FACTORY.empty(), null, false, true);
    }

    public static TypeInfo makeRecord(org.objectweb.asm.Type name, TypeInfo[] superInterfaces) {
        return new TypeInfo(ClassType.CLASS, name, TypeInfos.RECORD, superInterfaces, null, false, true);
    }

    public Set<TypeInfo> getAllAssignableTypes() {
        Set<TypeInfo> set = this.allAssignableTypes;
        if (set == null) {
            set = new LinkedHashSet<TypeInfo>(8);
            this.recursiveAddTypes(set, false);
            this.allAssignableTypes = set;
        }
        return set;
    }

    @Deprecated
    public Set<TypeInfo> getAllCastableTypes() {
        Set<TypeInfo> set = this.allCastableTypes;
        if (set == null) {
            set = new HashSet<TypeInfo>(8);
            this.recursiveAddTypes(set, true);
            this.allCastableTypes = set;
        }
        return set;
    }

    public void recursiveAddTypes(Set<TypeInfo> set, boolean autoCast) {
        if (!set.add(this)) {
            return;
        }
        if (this.superClass != null) {
            this.superClass.recursiveAddTypes(set, autoCast);
        }
        for (TypeInfo superInterface : this.superInterfaces) {
            superInterface.recursiveAddTypes(set, autoCast);
        }
        if (this.componentType != null) {
            this.componentType.getAllAssignableTypes().stream().map(TypeInfo::makeArray).forEach(set::add);
        }
        if (autoCast) {
            switch (this.getSort().ordinal()) {
                case 1: {
                    set.add(TypeInfos.BYTE);
                }
                case 2: {
                    set.add(TypeInfos.CHAR);
                }
                case 3: {
                    set.add(TypeInfos.SHORT);
                }
                case 4: {
                    set.add(TypeInfos.INT);
                }
                case 5: {
                    set.add(TypeInfos.LONG);
                }
                case 6: {
                    set.add(TypeInfos.FLOAT);
                }
                case 7: {
                    set.add(TypeInfos.DOUBLE);
                }
                case 8: {
                    this.box().recursiveAddTypes(set, true);
                    break;
                }
                case 9: {
                    if (!this.isWrapper()) break;
                    this.unbox().recursiveAddTypes(set, true);
                    break;
                }
                case 0: 
                case 10: {
                    break;
                }
            }
            set.add(TypeInfos.VOID);
        }
    }

    public boolean extendsOrImplements(TypeInfo that) {
        return this.getAllAssignableTypes().contains(that);
    }

    @Deprecated
    public boolean canBeCastTo(TypeInfo that) {
        return this.getAllCastableTypes().contains(that);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof TypeInfo)) return false;
        TypeInfo that = (TypeInfo)object;
        if (this.type != that.type) return false;
        if (!this.name.equals((Object)that.name)) return false;
        if (!Objects.equals(this.superClass, that.superClass)) return false;
        if (!HashStrategies.unorderedArrayEqualsAuto((Hash.Strategy)HashStrategies.defaultStrategy(), (Object[])this.superInterfaces, (Object[])that.superInterfaces)) return false;
        if (!Objects.equals(this.componentType, that.componentType)) return false;
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        if (this.isGeneric) {
            builder.append("generic ");
        }
        builder.append(this.type.name().toLowerCase(Locale.ROOT)).append(' ').append(this.getSimpleClassName());
        return builder.toString();
    }

    public boolean isVoid() {
        return this.getSort() == Sort.VOID;
    }

    public boolean isValue() {
        return this.getSort() != Sort.VOID;
    }

    public boolean isPrimitive() {
        return this.getSort().ordinal() <= Sort.DOUBLE.ordinal();
    }

    public boolean isPrimitiveValue() {
        int ordinal = this.getSort().ordinal();
        return ordinal >= Sort.BOOLEAN.ordinal() && ordinal <= Sort.DOUBLE.ordinal();
    }

    public boolean isNumber() {
        int ordinal = this.getSort().ordinal();
        return ordinal >= Sort.BYTE.ordinal() && ordinal <= Sort.DOUBLE.ordinal();
    }

    public boolean isInteger() {
        int ordinal = this.getSort().ordinal();
        return ordinal >= Sort.BYTE.ordinal() && ordinal <= Sort.LONG.ordinal();
    }

    public boolean isSingleWidthInt() {
        int ordinal = this.getSort().ordinal();
        return ordinal >= Sort.BYTE.ordinal() && ordinal <= Sort.INT.ordinal();
    }

    public boolean isFloat() {
        int ordinal = this.getSort().ordinal();
        return ordinal >= Sort.FLOAT.ordinal() && ordinal <= Sort.DOUBLE.ordinal();
    }

    public boolean isSingleWidth() {
        Sort sort = this.getSort();
        return sort != Sort.LONG && sort != Sort.DOUBLE;
    }

    public boolean isDoubleWidth() {
        Sort sort = this.getSort();
        return sort == Sort.LONG || sort == Sort.DOUBLE;
    }

    public boolean isObject() {
        return this.getSort().ordinal() >= Sort.OBJECT.ordinal();
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public boolean isWrapper() {
        return TypeInfos.UNBOXING.containsKey(this);
    }

    public TypeInfo box() {
        return TypeInfos.box(this);
    }

    public TypeInfo unbox() {
        return TypeInfos.unbox(this);
    }

    public record ParsedTypeInfo(TypeInfo type, int endIndex) {
    }

    public static enum Sort {
        VOID(TypeInfos.VOID),
        BOOLEAN(TypeInfos.BOOLEAN),
        BYTE(TypeInfos.BYTE),
        CHAR(TypeInfos.CHAR),
        SHORT(TypeInfos.SHORT),
        INT(TypeInfos.INT),
        LONG(TypeInfos.LONG),
        FLOAT(TypeInfos.FLOAT),
        DOUBLE(TypeInfos.DOUBLE),
        OBJECT(null),
        ARRAY(null);

        public static final Sort[] VALUES;
        public final TypeInfo canonicalInstance;

        private Sort(TypeInfo canonicalInstance) {
            this.canonicalInstance = canonicalInstance;
        }

        static {
            VALUES = Sort.values();
        }
    }
}

