/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree;

import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.scripting.bytecode.BytecodeEmitter;
import builderb0y.scripting.bytecode.CastingSupport;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.Typeable;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Objects;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public interface ConstantValue
extends Typeable,
BytecodeEmitter {
    public static final ObjectArrayFactory<ConstantValue> ARRAY_FACTORY = new ObjectArrayFactory(ConstantValue.class);

    public static ConstantValue notConstant() {
        return NonConstantValue.INSTANCE;
    }

    public static ConstantValue of(byte value) {
        return new IntConstantValue(value);
    }

    public static ConstantValue of(short value) {
        return new IntConstantValue(value);
    }

    public static ConstantValue of(int value) {
        return new IntConstantValue(value);
    }

    public static ConstantValue of(long value) {
        return new LongConstantValue(value);
    }

    public static ConstantValue of(float value) {
        return new FloatConstantValue(value);
    }

    public static ConstantValue of(double value) {
        return new DoubleConstantValue(value);
    }

    public static ConstantValue of(char value) {
        return new IntConstantValue(value);
    }

    public static ConstantValue of(boolean value) {
        return new IntConstantValue(value);
    }

    public static ConstantValue of(String value) {
        return value == null ? new NullConstantValue(TypeInfos.STRING) : new StringConstantValue(value);
    }

    public static ConstantValue of(TypeInfo value) {
        return new ClassConstantValue(Objects.requireNonNull(value, "Attempt to LDC null.class"));
    }

    public static ConstantValue ofNull(TypeInfo type) {
        return type.isPrimitive() ? InsnTrees.constantAbsent(type) : new NullConstantValue(type);
    }

    public static ConstantValue ofManual(Object object, TypeInfo type) {
        return object == null ? ConstantValue.ofNull(type) : new ManualConstantValue(object, type);
    }

    public static ConstantValue of(Object object, TypeInfo type) {
        if (object == null) {
            return ConstantValue.ofNull(type);
        }
        if (object instanceof String) {
            String s = (String)object;
            if (type.equals(TypeInfos.STRING)) {
                return ConstantValue.of(s);
            }
        }
        if (object instanceof TypeInfo) {
            TypeInfo t = (TypeInfo)object;
            if (type.equals(TypeInfos.CLASS)) {
                return ConstantValue.of(t);
            }
        }
        if (object instanceof Character) {
            Character c = (Character)object;
            object = (int)c.charValue();
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (type.isNumber()) {
                return switch (type.getSort()) {
                    default -> throw new IncompatibleClassChangeError();
                    case TypeInfo.Sort.BYTE -> ConstantValue.of(number.byteValue());
                    case TypeInfo.Sort.SHORT -> ConstantValue.of(number.shortValue());
                    case TypeInfo.Sort.INT -> ConstantValue.of(number.intValue());
                    case TypeInfo.Sort.LONG -> ConstantValue.of(number.longValue());
                    case TypeInfo.Sort.FLOAT -> ConstantValue.of(number.floatValue());
                    case TypeInfo.Sort.DOUBLE -> ConstantValue.of(number.doubleValue());
                    case TypeInfo.Sort.CHAR -> ConstantValue.of((char)number.intValue());
                    case TypeInfo.Sort.VOID, TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY, TypeInfo.Sort.BOOLEAN -> throw new IllegalArgumentException(type.toString());
                };
            }
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            if (type.getSort() == TypeInfo.Sort.BOOLEAN) {
                return ConstantValue.of(bool);
            }
        }
        if (TypeInfo.of(object.getClass()).extendsOrImplements(type)) {
            return new ManualConstantValue(object, type);
        }
        throw new ClassCastException("Cannot create constant of type " + String.valueOf(type) + " from " + String.valueOf(object));
    }

    public static ConstantValue dynamic(MethodInfo bootstrapMethod, ConstantValue ... bootstrapArgs) {
        return new DynamicConstantValue(bootstrapMethod.returnType, bootstrapMethod, bootstrapArgs);
    }

    public static ConstantValue dynamic(TypeInfo type, MethodInfo bootstrapMethod, ConstantValue ... bootstrapArgs) {
        return new DynamicConstantValue(type, bootstrapMethod, bootstrapArgs);
    }

    public byte asByte();

    public short asShort();

    public int asInt();

    public long asLong();

    public float asFloat();

    public double asDouble();

    public char asChar();

    public boolean asBoolean();

    @Override
    public TypeInfo getTypeInfo();

    default public Number asNumber() {
        return switch (this.getTypeInfo().getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.BYTE -> this.asByte();
            case TypeInfo.Sort.SHORT -> this.asShort();
            case TypeInfo.Sort.INT -> this.asInt();
            case TypeInfo.Sort.LONG -> this.asLong();
            case TypeInfo.Sort.FLOAT -> Float.valueOf(this.asFloat());
            case TypeInfo.Sort.DOUBLE -> this.asDouble();
            case TypeInfo.Sort.CHAR -> (int)this.asChar();
            case TypeInfo.Sort.BOOLEAN -> this.asBoolean() ? (byte)1 : 0;
            case TypeInfo.Sort.VOID, TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> throw new IllegalStateException(this.getTypeInfo().toString());
        };
    }

    default public Object asJavaObject() {
        return switch (this.getTypeInfo().getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.BYTE -> this.asByte();
            case TypeInfo.Sort.SHORT -> this.asShort();
            case TypeInfo.Sort.INT -> this.asInt();
            case TypeInfo.Sort.LONG -> this.asLong();
            case TypeInfo.Sort.FLOAT -> Float.valueOf(this.asFloat());
            case TypeInfo.Sort.DOUBLE -> this.asDouble();
            case TypeInfo.Sort.CHAR -> Character.valueOf(this.asChar());
            case TypeInfo.Sort.BOOLEAN -> Boolean.valueOf(this.asBoolean());
            case TypeInfo.Sort.VOID, TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> throw new IllegalStateException(this.getTypeInfo().toString());
        };
    }

    default public Object asAsmObject() {
        return switch (this.getTypeInfo().getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.BYTE, TypeInfo.Sort.SHORT, TypeInfo.Sort.INT, TypeInfo.Sort.CHAR, TypeInfo.Sort.BOOLEAN -> this.asInt();
            case TypeInfo.Sort.LONG -> this.asLong();
            case TypeInfo.Sort.FLOAT -> Float.valueOf(this.asFloat());
            case TypeInfo.Sort.DOUBLE -> this.asDouble();
            case TypeInfo.Sort.VOID, TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> throw new IllegalStateException(this.getTypeInfo().toString());
        };
    }

    default public boolean isConstant() {
        return true;
    }

    default public boolean isConstantOrDynamic() {
        return this.isConstant();
    }

    @Override
    public void emitBytecode(MethodCompileContext var1);

    public static byte toByte(int value) {
        byte b = (byte)value;
        if (value == b) {
            return b;
        }
        throw new ClassCastException("Value is outside of byte range: " + value);
    }

    public static short toShort(int value) {
        short s = (short)value;
        if (value == s) {
            return s;
        }
        throw new ClassCastException("Value is outside of short range: " + value);
    }

    public static char toChar(int value) {
        char c = (char)value;
        if (value == c) {
            return c;
        }
        throw new ClassCastException("Value is outside of char range: " + value);
    }

    public static int toInt(long value) {
        int i = (int)value;
        if (value == (long)i) {
            return i;
        }
        throw new ClassCastException("Value is outside of int range: " + value);
    }

    public static int toInt(float value) {
        int i = (int)value;
        if (value == (float)i) {
            return i;
        }
        throw new ClassCastException("Value is outside of int range: " + value);
    }

    public static int toInt(double value) {
        int i = (int)value;
        if (value == (double)i) {
            return i;
        }
        throw new ClassCastException("Value is outside of int range: " + value);
    }

    public static long toLong(float value) {
        long i = (long)value;
        if (value == (float)i) {
            return i;
        }
        throw new ClassCastException("Value is outside of int range: " + value);
    }

    public static long toLong(double value) {
        long i = (long)value;
        if (value == (double)i) {
            return i;
        }
        throw new ClassCastException("Value is outside of int range: " + value);
    }

    public static class NonConstantValue
    implements ConstantValue {
        public static final NonConstantValue INSTANCE = new NonConstantValue();

        @Override
        public byte asByte() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short asShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int asInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float asFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double asDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char asChar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeInfo getTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number asNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object asJavaObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object asAsmObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        public String toString() {
            return "NonConstantValue";
        }
    }

    public static class IntConstantValue
    implements ConstantValue {
        public final int value;
        public final TypeInfo type;

        public IntConstantValue(int value, TypeInfo type) {
            this.value = value;
            this.type = type;
        }

        public IntConstantValue(boolean value) {
            this(value ? 1 : 0, TypeInfos.BOOLEAN);
        }

        public IntConstantValue(byte value) {
            this(value, TypeInfos.BYTE);
        }

        public IntConstantValue(char value) {
            this(value, TypeInfos.CHAR);
        }

        public IntConstantValue(short value) {
            this(value, TypeInfos.SHORT);
        }

        public IntConstantValue(int value) {
            this(value, TypeInfos.INT);
        }

        @Override
        public byte asByte() {
            return ConstantValue.toByte(this.value);
        }

        @Override
        public short asShort() {
            return ConstantValue.toShort(this.value);
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        @Override
        public char asChar() {
            return ConstantValue.toChar(this.value);
        }

        @Override
        public boolean asBoolean() {
            return this.value != 0;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            int intValue = this.value;
            if (intValue >= -1 && intValue <= 5) {
                method.node.visitInsn(intValue - -1 + 2);
            } else if (intValue >= -128 && intValue <= 127) {
                method.node.visitIntInsn(16, intValue);
            } else if (intValue >= Short.MIN_VALUE && intValue <= Short.MAX_VALUE) {
                method.node.visitIntInsn(17, intValue);
            } else {
                method.node.visitLdcInsn((Object)intValue);
            }
        }

        public String toString() {
            return this.value + " of type " + this.getTypeInfo().getClassName();
        }
    }

    public static class LongConstantValue
    implements ConstantValue {
        public final long value;

        public LongConstantValue(long value) {
            this.value = value;
        }

        @Override
        public byte asByte() {
            return ConstantValue.toByte(ConstantValue.toInt(this.value));
        }

        @Override
        public short asShort() {
            return ConstantValue.toShort(ConstantValue.toInt(this.value));
        }

        @Override
        public int asInt() {
            return ConstantValue.toInt(this.value);
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        @Override
        public char asChar() {
            return ConstantValue.toChar(ConstantValue.toInt(this.value));
        }

        @Override
        public boolean asBoolean() {
            return this.value != 0L;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TypeInfos.LONG;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            long longValue = this.value;
            if (longValue == 0L) {
                method.node.visitInsn(9);
            } else if (longValue == 1L) {
                method.node.visitInsn(10);
            } else {
                method.node.visitLdcInsn((Object)longValue);
            }
        }

        public String toString() {
            return this.value + " of type " + this.getTypeInfo().getClassName();
        }
    }

    public static class FloatConstantValue
    implements ConstantValue {
        public final float value;

        public FloatConstantValue(float value) {
            this.value = value;
        }

        @Override
        public byte asByte() {
            return ConstantValue.toByte(ConstantValue.toInt(this.value));
        }

        @Override
        public short asShort() {
            return ConstantValue.toShort(ConstantValue.toInt(this.value));
        }

        @Override
        public int asInt() {
            return ConstantValue.toInt(this.value);
        }

        @Override
        public long asLong() {
            return ConstantValue.toLong(this.value);
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        @Override
        public char asChar() {
            return ConstantValue.toChar(ConstantValue.toInt(this.value));
        }

        @Override
        public boolean asBoolean() {
            return CastingSupport.F2Z(this.value);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TypeInfos.FLOAT;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            float floatValue = this.value;
            if (Float.floatToRawIntBits(floatValue) == 0) {
                method.node.visitInsn(11);
            } else if (floatValue == 1.0f) {
                method.node.visitInsn(12);
            } else if (floatValue == 2.0f) {
                method.node.visitInsn(13);
            } else {
                method.node.visitLdcInsn((Object)Float.valueOf(floatValue));
            }
        }

        public String toString() {
            return this.value + " of type " + this.getTypeInfo().getClassName();
        }
    }

    public static class DoubleConstantValue
    implements ConstantValue {
        public final double value;

        public DoubleConstantValue(double value) {
            this.value = value;
        }

        @Override
        public byte asByte() {
            return ConstantValue.toByte(ConstantValue.toInt(this.value));
        }

        @Override
        public short asShort() {
            return ConstantValue.toShort(ConstantValue.toInt(this.value));
        }

        @Override
        public int asInt() {
            return ConstantValue.toInt(this.value);
        }

        @Override
        public long asLong() {
            return ConstantValue.toLong(this.value);
        }

        @Override
        public float asFloat() {
            return (float)this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        @Override
        public char asChar() {
            return ConstantValue.toChar(ConstantValue.toInt(this.value));
        }

        @Override
        public boolean asBoolean() {
            return CastingSupport.D2Z(this.value);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TypeInfos.DOUBLE;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            double doubleValue = this.value;
            if (Double.doubleToRawLongBits(doubleValue) == 0L) {
                method.node.visitInsn(14);
            } else if (doubleValue == 1.0) {
                method.node.visitInsn(15);
            } else {
                method.node.visitLdcInsn((Object)doubleValue);
            }
        }

        public String toString() {
            return this.value + " of type " + this.getTypeInfo().getClassName();
        }
    }

    public static class NullConstantValue
    implements ConstantValue {
        public final TypeInfo type;

        public NullConstantValue(TypeInfo type) {
            this.type = type;
        }

        @Override
        public byte asByte() {
            return 0;
        }

        @Override
        public short asShort() {
            return 0;
        }

        @Override
        public int asInt() {
            return 0;
        }

        @Override
        public long asLong() {
            return 0L;
        }

        @Override
        public float asFloat() {
            return 0.0f;
        }

        @Override
        public double asDouble() {
            return 0.0;
        }

        @Override
        public char asChar() {
            return '\u0000';
        }

        @Override
        public boolean asBoolean() {
            return false;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        public Number asNumber() {
            return 0;
        }

        @Override
        public Object asJavaObject() {
            return null;
        }

        @Override
        public Object asAsmObject() {
            throw new UnsupportedOperationException("Must use ACONST_NULL, not LDC NULL.");
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            method.node.visitInsn(1);
        }

        public String toString() {
            return "null of type " + this.getTypeInfo().getClassName();
        }
    }

    public static class StringConstantValue
    implements ConstantValue {
        public final String value;

        public StringConstantValue(String value) {
            this.value = value;
        }

        @Override
        public byte asByte() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public short asShort() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public int asInt() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public long asLong() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public float asFloat() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public double asDouble() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public char asChar() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public boolean asBoolean() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public Number asNumber() {
            throw new ClassCastException("Not a number (is a String)");
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TypeInfos.STRING;
        }

        @Override
        public Object asJavaObject() {
            return this.value;
        }

        @Override
        public Object asAsmObject() {
            return this.value;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            method.node.visitLdcInsn((Object)this.value);
        }

        public String toString() {
            return "\"" + this.value + "\" of type " + this.getTypeInfo().getClassName();
        }
    }

    public static class ClassConstantValue
    implements ConstantValue {
        public static final Handle PRIMITIVE_CLASS = new Handle(6, Type.getInternalName(ConstantBootstraps.class), "primitiveClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), Type.getType(String.class), Type.getType(Class.class)}), false);
        public final TypeInfo value;

        public ClassConstantValue(TypeInfo value) {
            this.value = value;
        }

        @Override
        public byte asByte() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public short asShort() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public int asInt() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public long asLong() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public float asFloat() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public double asDouble() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public char asChar() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public boolean asBoolean() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public Number asNumber() {
            throw new ClassCastException("Not a number (is a Class)");
        }

        @Override
        public TypeInfo getTypeInfo() {
            return TypeInfos.CLASS;
        }

        @Override
        public Object asJavaObject() {
            return this.value;
        }

        @Override
        public Object asAsmObject() {
            if (this.value.isPrimitive()) {
                return new ConstantDynamic(this.value.getDescriptor(), TypeInfos.CLASS.getDescriptor(), PRIMITIVE_CLASS, new Object[0]);
            }
            return this.value.toAsmType();
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            method.node.visitLdcInsn(this.asAsmObject());
        }

        public String toString() {
            return this.value.getClassName();
        }
    }

    public static class ManualConstantValue
    extends NonConstantValue {
        public final Object value;
        public final TypeInfo type;

        public ManualConstantValue(Object value, TypeInfo type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public Object asJavaObject() {
            return this.value;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            method.clazz.newConstant(this.value, this.type).emitBytecode(method);
        }

        @Override
        public boolean isConstantOrDynamic() {
            return true;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value) + " of type " + String.valueOf(this.type);
        }
    }

    public static class DynamicConstantValue
    extends NonConstantValue {
        public final TypeInfo type;
        public final MethodInfo bootstrapMethod;
        public final ConstantValue[] bootstrapArgs;
        public final ConstantDynamic dynamic;

        public DynamicConstantValue(TypeInfo type, MethodInfo bootstrapMethod, ConstantValue ... bootstrapArgs) {
            this.type = type;
            this.bootstrapMethod = bootstrapMethod;
            this.bootstrapArgs = bootstrapArgs;
            this.dynamic = new ConstantDynamic(bootstrapMethod.name, type.getDescriptor(), new Handle(6, bootstrapMethod.owner.getInternalName(), bootstrapMethod.name, bootstrapMethod.getDescriptor(), bootstrapMethod.isInterface()), Arrays.stream(bootstrapArgs).map(ConstantValue::asAsmObject).toArray());
        }

        @Override
        public Object asAsmObject() {
            return this.dynamic;
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            method.node.visitLdcInsn((Object)this.dynamic);
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        public boolean isConstantOrDynamic() {
            return true;
        }

        @Override
        public String toString() {
            return this.dynamic.toString();
        }
    }
}

