/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree;

import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.scripting.bytecode.BytecodeEmitter;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.Typeable;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.instructions.casting.IdentityCastInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.OpcodeCastInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.elvis.ElvisInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;

public interface InsnTree
extends Opcodes,
Typeable,
BytecodeEmitter {
    public static final ObjectArrayFactory<InsnTree> ARRAY_FACTORY = new ObjectArrayFactory(InsnTree.class);

    @Override
    public void emitBytecode(MethodCompileContext var1);

    @Override
    public TypeInfo getTypeInfo();

    default public ConstantValue getConstantValue() {
        return ConstantValue.notConstant();
    }

    default public InsnTree cast(ExpressionParser parser, TypeInfo type, CastMode mode, boolean nullable) {
        if (this.getTypeInfo().extendsOrImplements(type)) {
            return mode.implicit ? this : new IdentityCastInsnTree(this, type);
        }
        if (type.isVoid()) {
            return this.asStatement();
        }
        if (this.jumpsUnconditionally()) {
            return InsnTrees.wrapIdentityCast(this, type);
        }
        if (this.getTypeInfo().isGeneric || type.isGeneric) {
            mode = mode.toExplicit();
        }
        return this.doCast(parser, type, mode, nullable);
    }

    default public InsnTree doCast(ExpressionParser parser, TypeInfo type, CastMode mode, boolean nullable) {
        InsnTree tree = parser.environment.cast(parser, this, type, mode.implicit, nullable);
        return tree != null ? tree : (InsnTree)mode.handleFailure(this.getTypeInfo(), type);
    }

    default public boolean jumpsUnconditionally() {
        return false;
    }

    default public boolean canBeStatement() {
        return false;
    }

    default public InsnTree asStatement() {
        if (this.canBeStatement()) {
            if (this.getTypeInfo().isVoid()) {
                return this;
            }
            return new OpcodeCastInsnTree(this, this.getTypeInfo().isDoubleWidth() ? 88 : 87, TypeInfos.VOID);
        }
        throw new IllegalArgumentException("Not a statement: " + this.describe());
    }

    default public InsnTree update(ExpressionParser parser, UpdateOp op, UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
        throw new ScriptParsingException("Attempt to update non-assignable value", parser.input);
    }

    default public InsnTree elvis(ExpressionParser parser, InsnTree alternative) {
        return ElvisInsnTree.create(parser, this, alternative);
    }

    default public String describe() {
        String className = this.getClass().getName();
        StringBuilder builder = new StringBuilder(64).append(className, className.lastIndexOf(46) + 1, className.length()).append(" of type ").append(this.getTypeInfo().getClassName());
        ConstantValue constant = this.getConstantValue();
        if (constant.isConstantOrDynamic()) {
            builder.append(" (constant: ").append(constant).append(')');
        } else {
            builder.append(" (not constant)");
        }
        return builder.toString();
    }

    public static enum CastMode {
        EXPLICIT_THROW(false, false),
        EXPLICIT_NULL(false, true),
        IMPLICIT_THROW(true, false),
        IMPLICIT_NULL(true, true);

        public final boolean implicit;
        public final boolean nullable;

        private CastMode(boolean implicit, boolean nullable) {
            this.implicit = implicit;
            this.nullable = nullable;
        }

        public CastMode toExplicit() {
            return this.nullable ? EXPLICIT_NULL : EXPLICIT_THROW;
        }

        public CastMode toImplicit() {
            return this.nullable ? IMPLICIT_NULL : IMPLICIT_THROW;
        }

        public CastMode toNullable() {
            return this.implicit ? IMPLICIT_NULL : EXPLICIT_NULL;
        }

        public CastMode toThrowing() {
            return this.implicit ? IMPLICIT_THROW : EXPLICIT_THROW;
        }

        @Nullable
        public <T> T handleFailure(TypeInfo from, TypeInfo to) {
            if (this.nullable) {
                return null;
            }
            throw new ClassCastException("Can't " + (this.implicit ? "implicitly" : "explicitly") + " cast " + String.valueOf(from) + " to " + String.valueOf(to));
        }
    }

    public static enum UpdateOrder {
        VOID,
        PRE,
        POST;

    }

    public static enum UpdateOp {
        ASSIGN((parser, oldValue, newValue) -> InsnTrees.seq(oldValue.asStatement(), newValue)),
        ADD(InsnTrees::add),
        SUBTRACT(InsnTrees::sub),
        MULTIPLY(InsnTrees::mul),
        DIVIDE(InsnTrees::div),
        MODULO(InsnTrees::mod),
        POWER(InsnTrees::pow),
        BITWISE_AND(InsnTrees::band),
        BITWISE_OR(InsnTrees::bor),
        BITWISE_XOR(InsnTrees::bxor),
        AND(InsnTrees::and),
        OR(InsnTrees::or),
        XOR(InsnTrees::xor),
        SIGNED_LEFT_SHIFT(InsnTrees::shl),
        SIGNED_RIGHT_SHIFT(InsnTrees::shr),
        UNSIGNED_LEFT_SHIFT(InsnTrees::ushl),
        UNSIGNED_RIGHT_SHIFT(InsnTrees::ushr);

        public final UpdateConstructor constructor;

        private UpdateOp(UpdateConstructor constructor) {
            this.constructor = constructor;
        }

        public InsnTree createUpdater(ExpressionParser parser, TypeInfo leftType, InsnTree rightValue) throws ScriptParsingException {
            return this.constructor.construct(parser, InsnTrees.getFromStack(leftType), rightValue).cast(parser, leftType, CastMode.IMPLICIT_THROW, false);
        }

        @FunctionalInterface
        public static interface UpdateConstructor {
            public InsnTree construct(ExpressionParser var1, InsnTree var2, InsnTree var3) throws ScriptParsingException;
        }
    }
}

