/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class ConstantConditionTree
implements ConditionTree {
    public static final ConstantConditionTree TRUE = new ConstantConditionTree(true);
    public static final ConstantConditionTree FALSE = new ConstantConditionTree(false);
    public final boolean value;

    public ConstantConditionTree(boolean value) {
        this.value = value;
    }

    public static ConstantConditionTree of(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
        ConditionTree.checkLabels(ifTrue, ifFalse);
        if (this.value) {
            if (ifTrue != null) {
                method.node.visitJumpInsn(167, ifTrue);
            }
        } else if (ifFalse != null) {
            method.node.visitJumpInsn(167, ifFalse);
        }
    }
}

