/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;

public class FloatCompareConditionTree
extends IntCompareConditionTree {
    public final int toIntOpcode;

    public FloatCompareConditionTree(InsnTree left, InsnTree right, int opcode, int toIntOpcode) {
        super(left, right, opcode);
        this.toIntOpcode = toIntOpcode;
    }

    public static ConditionTree createFloat(InsnTree left, InsnTree right, int compare, int toInt, FloatBiPredicate ifConstant) {
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return ConstantConditionTree.of(ifConstant.test(leftConstant.asFloat(), rightConstant.asFloat()));
        }
        return new FloatCompareConditionTree(left, right, compare, toInt);
    }

    public static ConditionTree equal(InsnTree left, InsnTree right) {
        return FloatCompareConditionTree.createFloat(left, right, 153, 149, (l, r) -> l == r);
    }

    public static ConditionTree notEqual(InsnTree left, InsnTree right) {
        return FloatCompareConditionTree.createFloat(left, right, 154, 149, (l, r) -> l != r);
    }

    public static ConditionTree lessThan(InsnTree left, InsnTree right) {
        return FloatCompareConditionTree.createFloat(left, right, 155, 150, (l, r) -> l < r);
    }

    public static ConditionTree greaterThan(InsnTree left, InsnTree right) {
        return FloatCompareConditionTree.createFloat(left, right, 157, 149, (l, r) -> l > r);
    }

    public static ConditionTree lessThanOrEqual(InsnTree left, InsnTree right) {
        return FloatCompareConditionTree.createFloat(left, right, 158, 150, (l, r) -> l <= r);
    }

    public static ConditionTree greaterThanOrEqual(InsnTree left, InsnTree right) {
        return FloatCompareConditionTree.createFloat(left, right, 156, 149, (l, r) -> l >= r);
    }

    @Override
    public void toInt(MethodCompileContext method) {
        method.node.visitInsn(this.toIntOpcode);
    }

    @FunctionalInterface
    public static interface FloatBiPredicate {
        public boolean test(float var1, float var2);
    }
}

