/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class IntCompareZeroConditionTree
implements ConditionTree {
    public final InsnTree condition;
    public final int trueOpcode;

    public IntCompareZeroConditionTree(InsnTree condition, int trueOpcode) {
        this.condition = condition;
        this.trueOpcode = trueOpcode;
    }

    public static ConditionTree equalZero(InsnTree condition) {
        return new IntCompareZeroConditionTree(condition, 153);
    }

    public static ConditionTree notEqualZero(InsnTree condition) {
        return new IntCompareZeroConditionTree(condition, 154);
    }

    public static ConditionTree lessThanZero(InsnTree condition) {
        return new IntCompareZeroConditionTree(condition, 155);
    }

    public static ConditionTree greaterThanZero(InsnTree condition) {
        return new IntCompareZeroConditionTree(condition, 157);
    }

    public static ConditionTree lessThanOrEqualToZero(InsnTree condition) {
        return new IntCompareZeroConditionTree(condition, 158);
    }

    public static ConditionTree greaterThanOrEqualToZero(InsnTree condition) {
        return new IntCompareZeroConditionTree(condition, 156);
    }

    @Override
    public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
        ConditionTree.checkLabels(ifTrue, ifFalse);
        this.condition.emitBytecode(method);
        if (ifTrue != null) {
            method.node.visitJumpInsn(this.trueOpcode, ifTrue);
            if (ifFalse != null) {
                method.node.visitJumpInsn(167, ifFalse);
            }
        } else {
            method.node.visitJumpInsn(ConditionTree.negateOpcode(this.trueOpcode), ifFalse);
        }
    }
}

