/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.NullCompareConditionTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.ArrayExtensions;
import builderb0y.scripting.util.TypeInfos;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class ObjectCompareConditionTree
implements ConditionTree {
    public static final MethodInfo COMPARE_G = new MethodInfo(-2147483639, InsnTrees.type(ObjectCompareConditionTree.class), "compareG", TypeInfos.INT, TypeInfos.COMPARABLE, TypeInfos.COMPARABLE);
    public static final MethodInfo COMPARE_L = new MethodInfo(-2147483639, InsnTrees.type(ObjectCompareConditionTree.class), "compareL", TypeInfos.INT, TypeInfos.COMPARABLE, TypeInfos.COMPARABLE);
    public final InsnTree loader;
    public final int opcode;

    public ObjectCompareConditionTree(InsnTree loader, int opcode) {
        this.loader = loader;
        this.opcode = opcode;
    }

    public static ConditionTree equal(ExpressionParser parser, InsnTree left, InsnTree right) {
        return ObjectCompareConditionTree.tryNull(parser, left, right, true);
    }

    public static ConditionTree notEqual(ExpressionParser parser, InsnTree left, InsnTree right) {
        return ObjectCompareConditionTree.tryNull(parser, left, right, false);
    }

    public static ConditionTree lessThan(ExpressionParser parser, InsnTree left, InsnTree right) {
        return new ObjectCompareConditionTree(InsnTrees.invokeStatic(COMPARE_G, left.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false), right.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false)), 155);
    }

    public static ConditionTree greaterThan(ExpressionParser parser, InsnTree left, InsnTree right) {
        return new ObjectCompareConditionTree(InsnTrees.invokeStatic(COMPARE_L, left.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false), right.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false)), 157);
    }

    public static ConditionTree lessThanOrEqual(ExpressionParser parser, InsnTree left, InsnTree right) {
        return new ObjectCompareConditionTree(InsnTrees.invokeStatic(COMPARE_G, left.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false), right.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false)), 158);
    }

    public static ConditionTree greaterThanOrEqual(ExpressionParser parser, InsnTree left, InsnTree right) {
        return new ObjectCompareConditionTree(InsnTrees.invokeStatic(COMPARE_L, left.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false), right.cast(parser, TypeInfos.COMPARABLE, InsnTree.CastMode.IMPLICIT_THROW, false)), 156);
    }

    @Override
    public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
        ConditionTree.checkLabels(ifTrue, ifFalse);
        this.loader.emitBytecode(method);
        if (ifTrue != null) {
            method.node.visitJumpInsn(this.opcode, ifTrue);
            if (ifFalse != null) {
                method.node.visitJumpInsn(167, ifFalse);
            }
        } else {
            method.node.visitJumpInsn(ConditionTree.negateOpcode(this.opcode), ifFalse);
        }
    }

    public static ConditionTree tryNull(ExpressionParser parser, InsnTree left, InsnTree right, boolean equal) {
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && leftConstant.asJavaObject() == null) {
            if (rightConstant.isConstant() && rightConstant.asJavaObject() == null) {
                return ConstantConditionTree.of(equal);
            }
            return new NullCompareConditionTree(right.cast(parser, TypeInfos.OBJECT, InsnTree.CastMode.IMPLICIT_THROW, false), equal ? 198 : 199);
        }
        if (rightConstant.isConstant() && rightConstant.asJavaObject() == null) {
            return new NullCompareConditionTree(left.cast(parser, TypeInfos.OBJECT, InsnTree.CastMode.IMPLICIT_THROW, false), equal ? 198 : 199);
        }
        if (left.getTypeInfo().extendsOrImplements(right.getTypeInfo()) || right.getTypeInfo().extendsOrImplements(left.getTypeInfo()) || left.getTypeInfo().type.isInterface || right.getTypeInfo().type.isInterface) {
            return new ObjectCompareConditionTree(ObjectCompareConditionTree.equalLoader(parser, left, right), equal ? 154 : 153);
        }
        throw new IllegalArgumentException("Can't compare " + String.valueOf(left.getTypeInfo()) + " and " + String.valueOf(right.getTypeInfo()));
    }

    public static InsnTree equalLoader(ExpressionParser parser, InsnTree left, InsnTree right) {
        return ArrayExtensions.computeEquals(parser, left, right);
    }

    public static int compareG(Comparable a, Comparable b) {
        return a == null || b == null ? 1 : a.compareTo(b);
    }

    public static int compareL(Comparable a, Comparable b) {
        return a == null || b == null ? -1 : a.compareTo(b);
    }
}

