/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import builderb0y.scripting.util.TypeMerger;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.objectweb.asm.Label;

public class SwitchInsnTree
implements InsnTree {
    public InsnTree value;
    public Int2ObjectSortedMap<InsnTree> cases;
    public TypeInfo type;

    public SwitchInsnTree(InsnTree value, Int2ObjectSortedMap<InsnTree> cases, TypeInfo type) {
        this.value = value;
        this.cases = cases;
        this.type = type;
    }

    public static SwitchInsnTree create(ExpressionParser parser, InsnTree value, Int2ObjectSortedMap<InsnTree> cases) {
        if (!value.getTypeInfo().isSingleWidthInt()) {
            throw new InvalidOperandException("Switch value must be single-width int");
        }
        if (cases.isEmpty()) {
            throw new IllegalArgumentException("Switch must have at least one case");
        }
        TypeInfo type = SwitchInsnTree.computeType(cases);
        Int2ObjectAVLTreeMap runtimeCases = new Int2ObjectAVLTreeMap();
        for (Int2ObjectMap.Entry entry : cases.int2ObjectEntrySet()) {
            runtimeCases.put(entry.getIntKey(), (Object)((InsnTree)entry.getValue()).cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false));
        }
        if (cases.defaultReturnValue() != null) {
            runtimeCases.defaultReturnValue((Object)((InsnTree)cases.defaultReturnValue()).cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false));
        }
        return new SwitchInsnTree(value, (Int2ObjectSortedMap<InsnTree>)runtimeCases, type);
    }

    public static TypeInfo computeType(Int2ObjectMap<InsnTree> cases) {
        InsnTree defaultCase = (InsnTree)cases.defaultReturnValue();
        if (defaultCase == null) {
            return TypeInfos.VOID;
        }
        return TypeMerger.computeMostSpecificType((TypeInfo[])Stream.concat(Stream.of(defaultCase), cases.values().stream()).filter(tree -> !tree.jumpsUnconditionally()).map(InsnTree::getTypeInfo).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY));
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        Reference2ObjectOpenHashMap starts = new Reference2ObjectOpenHashMap(this.cases.size());
        this.cases.values().forEach(arg_0 -> SwitchInsnTree.lambda$emitBytecode$0((Reference2ObjectMap)starts, arg_0));
        InsnTree defaultCase = (InsnTree)this.cases.defaultReturnValue();
        if (defaultCase != null) {
            starts.computeIfAbsent((Object)defaultCase, $ -> InsnTrees.label());
        }
        Label end = InsnTrees.label();
        int minKey = this.cases.firstIntKey();
        int maxKey = this.cases.lastIntKey();
        long range = (long)maxKey - (long)minKey + 1L;
        int occupancy = this.cases.size();
        if (occupancy > 65536) {
            throw new IllegalArgumentException("Too many cases!");
        }
        this.value.emitBytecode(method);
        if ((long)occupancy < range >> 2) {
            method.node.visitLookupSwitchInsn((Label)starts.getOrDefault((Object)defaultCase, (Object)end), this.cases.keySet().toIntArray(), (Label[])this.cases.values().stream().map(arg_0 -> ((Reference2ObjectMap)starts).get(arg_0)).toArray(Label[]::new));
        } else {
            int intRange = Math.toIntExact(range);
            Label[] labels = new Label[intRange];
            for (Int2ObjectMap.Entry entry : this.cases.int2ObjectEntrySet()) {
                labels[entry.getIntKey() - minKey] = (Label)starts.get(entry.getValue());
            }
            Label defaultLabel = (Label)starts.getOrDefault((Object)defaultCase, (Object)end);
            for (int index = 0; index < intRange; ++index) {
                if (labels[index] != null) continue;
                labels[index] = defaultLabel;
            }
            method.node.visitTableSwitchInsn(minKey, maxKey, defaultLabel, labels);
        }
        for (Map.Entry entry : starts.entrySet()) {
            method.node.visitLabel((Label)entry.getValue());
            ((InsnTree)entry.getKey()).emitBytecode(method);
            method.node.visitJumpInsn(167, end);
        }
        method.node.visitLabel(end);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.type;
    }

    @Override
    public boolean jumpsUnconditionally() {
        InsnTree defaultCase = (InsnTree)this.cases.defaultReturnValue();
        return defaultCase != null && defaultCase.jumpsUnconditionally() && this.cases.values().stream().allMatch(InsnTree::jumpsUnconditionally);
    }

    public SwitchInsnTree mapCases(UnaryOperator<InsnTree> mapper, TypeInfo type) {
        Reference2ReferenceOpenHashMap lookup = new Reference2ReferenceOpenHashMap(this.cases.size());
        Int2ObjectAVLTreeMap newCases = new Int2ObjectAVLTreeMap();
        for (Int2ObjectMap.Entry entry : this.cases.int2ObjectEntrySet()) {
            InsnTree mapped = (InsnTree)lookup.computeIfAbsent((Object)((InsnTree)entry.getValue()), mapper);
            if (mapped == null) {
                return null;
            }
            newCases.put(entry.getIntKey(), (Object)mapped);
        }
        if (this.cases.defaultReturnValue() != null) {
            InsnTree mapped = (InsnTree)lookup.computeIfAbsent((Object)((InsnTree)this.cases.defaultReturnValue()), mapper);
            if (mapped == null) {
                return null;
            }
            newCases.defaultReturnValue((Object)mapped);
        }
        return new SwitchInsnTree(this.value, (Int2ObjectSortedMap<InsnTree>)newCases, type);
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        return this.mapCases(branch -> branch.cast(parser, type, mode, nullable), type);
    }

    @Override
    public boolean canBeStatement() {
        InsnTree defaultCase = (InsnTree)this.cases.defaultReturnValue();
        return (defaultCase == null || defaultCase.canBeStatement()) && this.cases.values().stream().allMatch(InsnTree::canBeStatement);
    }

    @Override
    public InsnTree asStatement() {
        return this.mapCases(InsnTree::asStatement, TypeInfos.VOID);
    }

    private static /* synthetic */ void lambda$emitBytecode$0(Reference2ObjectMap starts, InsnTree body) {
        starts.computeIfAbsent((Object)body, $ -> InsnTrees.label());
    }
}

