/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow.loop;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.util.TypeInfos;

public class DoWhileInsnTree
implements InsnTree {
    public ScopeContext.LoopName loopName;
    public ConditionTree condition;
    public InsnTree body;

    public DoWhileInsnTree(ScopeContext.LoopName loopName, ConditionTree condition, InsnTree body) {
        this.loopName = loopName;
        this.condition = condition;
        if (!body.canBeStatement()) {
            throw new IllegalArgumentException("Body is not a statement");
        }
        this.body = body.asStatement();
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        ScopeContext.Scope scope = method.scopes.pushLoop(this.loopName);
        this.body.emitBytecode(method);
        this.condition.emitBytecode(method, scope.start.getLabel(), null);
        method.scopes.popLoop();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return TypeInfos.VOID;
    }

    @Override
    public boolean canBeStatement() {
        return true;
    }
}

