/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow.loop;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclareAssignInsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public class WhileInsnTree
implements InsnTree {
    public ScopeContext.LoopName loopName;
    public ConditionTree condition;
    public InsnTree body;

    public WhileInsnTree(ScopeContext.LoopName loopName, ConditionTree condition, InsnTree body) {
        this.loopName = loopName;
        this.condition = condition;
        this.body = body.asStatement();
    }

    public static InsnTree createRepeat(ExpressionParser parser, ScopeContext.LoopName loopName, InsnTree times, InsnTree body) {
        InsnTree loadLimit;
        InsnTree init;
        times = times.cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false);
        LazyVarInfo counter = new LazyVarInfo(parser.method.mangleName("counter"), TypeInfos.INT);
        if (times.getConstantValue().isConstant()) {
            init = new VariableDeclareAssignInsnTree(counter, InsnTrees.ldc(0));
            loadLimit = times;
        } else {
            LazyVarInfo limit = new LazyVarInfo(parser.method.mangleName("limit"), TypeInfos.INT);
            init = InsnTrees.seq((InsnTree)new VariableDeclareAssignInsnTree(limit, times), (InsnTree)new VariableDeclareAssignInsnTree(counter, InsnTrees.ldc(0)));
            loadLimit = InsnTrees.load(limit);
        }
        return InsnTrees.for_(loopName, init, InsnTrees.lt(parser, InsnTrees.load(counter), loadLimit), InsnTrees.inc(counter, 1), body);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        ScopeContext.Scope scope = method.scopes.pushLoop(this.loopName);
        this.condition.emitBytecode(method, null, scope.end.getLabel());
        this.body.emitBytecode(method);
        method.node.visitJumpInsn(167, scope.start.getLabel());
        method.scopes.popLoop();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return TypeInfos.VOID;
    }

    @Override
    public boolean canBeStatement() {
        return true;
    }
}

