/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.fields;

import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractObjectUpdaterInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;

public abstract class AbstractInstanceGetFieldInsnTree
implements InsnTree {
    public InsnTree object;
    public FieldInfo field;

    public AbstractInstanceGetFieldInsnTree(InsnTree object, FieldInfo field) {
        AbstractInstanceGetFieldInsnTree.check(object, field);
        this.object = object;
        this.field = field;
    }

    public static void check(InsnTree object, FieldInfo field) {
        if (field.isStatic()) {
            throw new IllegalArgumentException("Static field: " + String.valueOf(field));
        }
        if (!object.getTypeInfo().extendsOrImplements(field.owner)) {
            throw new IllegalArgumentException("Can't get field " + String.valueOf(field) + " from object of type " + String.valueOf(object.getTypeInfo()));
        }
    }

    public abstract InsnTree constructUpdater(InsnTree.UpdateOrder var1, boolean var2, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters var3);

    @Override
    public InsnTree update(ExpressionParser parser, InsnTree.UpdateOp op, InsnTree.UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
        if (this.field.isFinal()) {
            throw new ScriptParsingException("Can't write to final field: " + String.valueOf(this.field), parser.input);
        }
        if (op == InsnTree.UpdateOp.ASSIGN) {
            InsnTree cast = rightValue.cast(parser, this.field.type, InsnTree.CastMode.IMPLICIT_THROW, false);
            return this.constructUpdater(order, true, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters.forField(this.object, this.field, cast));
        }
        InsnTree updater = op.createUpdater(parser, this.getTypeInfo(), rightValue);
        return this.constructUpdater(order, false, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters.forField(this.object, this.field, updater));
    }
}

