/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.invokers;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.BaseInvokeInsnTree;

public class NewInsnTree
extends BaseInvokeInsnTree {
    public NewInsnTree(MethodInfo constructor, InsnTree ... args) {
        super(constructor, args);
        NewInsnTree.checkConstructor(constructor);
        NewInsnTree.checkArguments(constructor.paramTypes, args);
    }

    public static void checkConstructor(MethodInfo constructor) {
        if (constructor.isStatic() || !constructor.name.equals("<init>") || !constructor.returnType.isVoid()) {
            throw new IllegalArgumentException(constructor.toString());
        }
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        method.node.visitTypeInsn(187, this.method.owner.getInternalName());
        method.node.visitInsn(89);
        super.emitBytecode(method);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.method.owner;
    }

    @Override
    public InsnTree asStatement() {
        return new UnusedNewInsnTree(this.method, this.args);
    }

    public static class UnusedNewInsnTree
    extends BaseInvokeInsnTree {
        public UnusedNewInsnTree(MethodInfo constructor, InsnTree ... args) {
            super(constructor, args);
            NewInsnTree.checkConstructor(constructor);
            UnusedNewInsnTree.checkArguments(constructor.paramTypes, args);
        }

        @Override
        public void emitBytecode(MethodCompileContext method) {
            method.node.visitTypeInsn(187, this.method.owner.getInternalName());
            super.emitBytecode(method);
        }
    }
}

