/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.update;

import builderb0y.scripting.bytecode.BytecodeEmitter;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractUpdaterInsnTree;

public class VariableUpdaterInsnTree
extends AbstractUpdaterInsnTree {
    public VariableUpdaterEmitters emitters;

    public VariableUpdaterInsnTree(AbstractUpdaterInsnTree.CombinedMode mode, VariableUpdaterEmitters emitters) {
        super(mode);
        this.emitters = emitters;
    }

    public VariableUpdaterInsnTree(InsnTree.UpdateOrder order, boolean isAssignment, VariableUpdaterEmitters emitters) {
        super(order, isAssignment);
        this.emitters = emitters;
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        switch (this.mode) {
            case VOID: {
                this.emitGet(method);
                this.emitUpdate(method);
                this.emitSet(method);
                break;
            }
            case PRE: {
                this.emitGet(method);
                method.node.visitInsn(this.getPreType().isDoubleWidth() ? 92 : 89);
                this.emitUpdate(method);
                this.emitSet(method);
                break;
            }
            case POST: {
                this.emitGet(method);
                this.emitUpdate(method);
                method.node.visitInsn(this.getPostType().isDoubleWidth() ? 92 : 89);
                this.emitSet(method);
                break;
            }
            case VOID_ASSIGN: {
                this.emitUpdate(method);
                this.emitSet(method);
                break;
            }
            case PRE_ASSIGN: {
                this.emitGet(method);
                this.emitUpdate(method);
                this.emitSet(method);
                break;
            }
            case POST_ASSIGN: {
                this.emitUpdate(method);
                method.node.visitInsn(this.getPostType().isDoubleWidth() ? 92 : 89);
                this.emitSet(method);
            }
        }
    }

    public void emitGet(MethodCompileContext method) {
        this.emitters.getter.emitBytecode(method);
    }

    public void emitSet(MethodCompileContext method) {
        this.emitters.setter.emitBytecode(method);
    }

    public void emitUpdate(MethodCompileContext method) {
        this.emitters.updater.emitBytecode(method);
    }

    @Override
    public TypeInfo getPreType() {
        return this.emitters.preType;
    }

    @Override
    public TypeInfo getPostType() {
        return this.emitters.postType;
    }

    @Override
    public InsnTree asStatement() {
        return this.mode.isVoid() ? this : new VariableUpdaterInsnTree(this.mode.asVoid(), this.emitters);
    }

    public record VariableUpdaterEmitters(BytecodeEmitter getter, BytecodeEmitter setter, BytecodeEmitter updater, TypeInfo preType, TypeInfo postType) {
        public static VariableUpdaterEmitters forLazyVariable(LazyVarInfo variable, InsnTree updater) {
            return new VariableUpdaterEmitters(variable::emitLoad, variable::emitStore, updater, variable.type, updater.getTypeInfo());
        }

        public static VariableUpdaterEmitters forField(FieldInfo field, InsnTree updater) {
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Non-static field: " + String.valueOf(field));
            }
            return new VariableUpdaterEmitters(field::emitGet, field::emitPut, updater, field.type, updater.getTypeInfo());
        }
    }
}

