/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.bigglobe.scripting.ScriptLogger;
import builderb0y.scripting.bytecode.ConstantFactory;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.Typeable;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.BaseInvokeInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.ReflectionData;
import com.google.common.collect.ObjectArrays;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Handlers {
    public static Builder builder(Class<?> in, String name) {
        return new ReflectiveBuilder(in, name);
    }

    public static Builder inCaller(String name) {
        return new ReflectiveBuilder(ConstantFactory.STACK_WALKER.getCallerClass(), name);
    }

    public static Builder builder(MethodInfo method) {
        return new ManualBuilder(method);
    }

    public static class ReflectiveBuilder
    extends Builder {
        public final Class<?> in;
        public final String name;
        public Class<?> returnClass;
        public TypeInfo returnType;
        public Method cachedMethod;
        public MethodInfo cachedMethodInfo;

        public ReflectiveBuilder(Class<?> in, String name) {
            this.in = in;
            this.name = name;
        }

        @Override
        public Builder invalidateCache() {
            this.cachedMethod = null;
            this.cachedMethodInfo = null;
            return this;
        }

        public Method resolveRaw() {
            return this.cachedMethod != null ? this.cachedMethod : (this.cachedMethod = ReflectionData.forClass(this.in).findDeclaredMethod(this.name, method -> {
                List arguments;
                if (this.returnClass != null && this.returnClass != method.getReturnType()) {
                    return false;
                }
                Object[] actualTypes = method.getParameterTypes();
                if (!Modifier.isStatic(method.getModifiers())) {
                    actualTypes = (Class[])ObjectArrays.concat(method.getDeclaringClass(), (Object[])actualTypes);
                }
                if (actualTypes.length != (arguments = this.arguments).size()) {
                    return false;
                }
                int size = arguments.size();
                for (int index = 0; index < size; ++index) {
                    if (actualTypes[index] == ((Argument)arguments.get(index)).getTypeInfo().toClass()) continue;
                    return false;
                }
                return true;
            }));
        }

        @Override
        public MethodInfo resolve() {
            if (this.cachedMethodInfo != null) {
                return this.cachedMethodInfo;
            }
            MethodInfo method = MethodInfo.forMethod(this.resolveRaw());
            if (this.pure) {
                method = method.pure();
            }
            this.cachedMethodInfo = method;
            return this.cachedMethodInfo;
        }

        @Override
        public Builder returnClass(Class<?> clazz) {
            this.returnClass = clazz;
            this.returnType = InsnTrees.type(clazz);
            return this.invalidateCache();
        }

        @Override
        public Builder returnType(TypeInfo type) {
            this.returnType = type;
            this.returnClass = type.toClass();
            return this.invalidateCache();
        }

        public String toString() {
            return this.in.getName() + "." + this.name + this.arguments.stream().map((Function<Argument, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lbuilderb0y/scripting/environments/Handlers$Argument;)Ljava/lang/String;)()).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static class ManualBuilder
    extends Builder {
        public final MethodInfo methodInfo;

        public ManualBuilder(MethodInfo methodInfo) {
            this.methodInfo = methodInfo;
        }

        @Override
        public Builder invalidateCache() {
            return this;
        }

        @Override
        public MethodInfo resolve() {
            return this.methodInfo;
        }

        @Override
        public Builder returnClass(Class<?> clazz) {
            throw new UnsupportedOperationException("You already specified an exact method.");
        }

        @Override
        public Builder returnType(TypeInfo type) {
            throw new UnsupportedOperationException("You already specified an exact method.");
        }

        public String toString() {
            return this.methodInfo.owner.getClassName() + "." + this.methodInfo.name + this.arguments.stream().map((Function<Argument, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lbuilderb0y/scripting/environments/Handlers$Argument;)Ljava/lang/String;)()).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static class ReceiverArgument
    implements Argument {
        public final TypeInfo type;

        public ReceiverArgument(Class<?> clazz) {
            this(InsnTrees.type(clazz));
        }

        public ReceiverArgument(TypeInfo type) {
            this.type = type;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        @Nullable
        public MutableScriptEnvironment.CastResult getFrom(ExpressionParser parser, InsnTree receiver, InsnTree[] providedArgs) {
            InsnTree castReceiver = receiver.cast(parser, this.type, InsnTree.CastMode.IMPLICIT_NULL, false);
            if (castReceiver == null) {
                return null;
            }
            return new MutableScriptEnvironment.CastResult(castReceiver, castReceiver != receiver);
        }

        @Override
        public void addToIndex(int toAdd) {
        }

        @Override
        public boolean usesReceiver() {
            return true;
        }

        @Override
        public boolean usesArguments() {
            return false;
        }

        public String toString() {
            return "Receiver: " + String.valueOf(this.type);
        }
    }

    public static class ImplicitArgument
    implements Argument {
        public final InsnTree tree;
        public final TypeInfo type;

        public ImplicitArgument(InsnTree tree) {
            this.tree = tree;
            this.type = tree.getTypeInfo();
        }

        public ImplicitArgument(InsnTree tree, TypeInfo type) {
            if (!tree.getTypeInfo().extendsOrImplements(type)) {
                throw new IllegalArgumentException(String.valueOf(tree) + " is not a subclass of " + String.valueOf(type));
            }
            this.tree = tree;
            this.type = type;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        @Nullable
        public MutableScriptEnvironment.CastResult getFrom(ExpressionParser parser, InsnTree receiver, InsnTree[] providedArgs) {
            return new MutableScriptEnvironment.CastResult(this.tree, false);
        }

        @Override
        public void addToIndex(int toAdd) {
        }

        @Override
        public boolean usesReceiver() {
            return false;
        }

        @Override
        public boolean usesArguments() {
            return false;
        }

        public String toString() {
            return "Implicit: " + this.tree.describe();
        }
    }

    public static class RequiredArgument
    implements Argument {
        public final TypeInfo type;
        public int requiredIndex;

        public RequiredArgument(Class<?> clazz, int requiredIndex) {
            this(InsnTrees.type(clazz), requiredIndex);
        }

        public RequiredArgument(TypeInfo type, int requiredIndex) {
            this.type = type;
            this.requiredIndex = requiredIndex;
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.type;
        }

        @Override
        @Nullable
        public MutableScriptEnvironment.CastResult getFrom(ExpressionParser parser, InsnTree receiver, InsnTree[] providedArgs) {
            InsnTree argument = providedArgs[this.requiredIndex];
            InsnTree castArgument = argument.cast(parser, this.type, InsnTree.CastMode.IMPLICIT_NULL, false);
            if (castArgument == null) {
                return null;
            }
            return new MutableScriptEnvironment.CastResult(castArgument, castArgument != argument);
        }

        @Override
        public void addToIndex(int toAdd) {
            this.requiredIndex += toAdd;
        }

        @Override
        public boolean usesReceiver() {
            return false;
        }

        @Override
        public boolean usesArguments() {
            return true;
        }

        public String toString() {
            return "Required: " + String.valueOf(this.type);
        }
    }

    public static interface Argument
    extends Typeable {
        @Nullable
        public MutableScriptEnvironment.CastResult getFrom(ExpressionParser var1, InsnTree var2, InsnTree[] var3);

        public void addToIndex(int var1);

        public boolean usesReceiver();

        public boolean usesArguments();
    }

    public static abstract class Builder
    implements Argument {
        public final List<Argument> arguments = new ArrayList<Argument>(8);
        public int currentRequiredIndex;
        public boolean addedAsNested;
        public boolean pure;
        public Callback callback;

        public abstract Builder invalidateCache();

        public abstract MethodInfo resolve();

        public abstract Builder returnClass(Class<?> var1);

        public abstract Builder returnType(TypeInfo var1);

        public Builder addReceiverArgument(Class<?> clazz) {
            if (this.usesArguments() || this.usesReceiver()) {
                throw new IllegalArgumentException("Receiver argument must be the first argument.");
            }
            this.arguments.add(new ReceiverArgument(clazz));
            return this.invalidateCache();
        }

        public Builder addReceiverArgument(TypeInfo type) {
            if (this.usesArguments() || this.usesReceiver()) {
                throw new IllegalArgumentException("Receiver argument must be the first argument.");
            }
            this.arguments.add(new ReceiverArgument(type));
            return this.invalidateCache();
        }

        public Builder addRequiredArgument(Class<?> clazz) {
            this.arguments.add(new RequiredArgument(clazz, this.currentRequiredIndex++));
            return this.invalidateCache();
        }

        public Builder addRequiredArgument(TypeInfo type) {
            this.arguments.add(new RequiredArgument(type, this.currentRequiredIndex++));
            return this.invalidateCache();
        }

        public Builder addImplicitArgument(InsnTree tree) {
            this.arguments.add(new ImplicitArgument(tree));
            return this.invalidateCache();
        }

        public Builder addImplicitArgumentOfType(InsnTree tree, Class<?> type) {
            this.arguments.add(new ImplicitArgument(tree, InsnTrees.type(type)));
            return this.invalidateCache();
        }

        public Builder addNestedArgument(Builder builder) {
            if (this.usesReceiver() && builder.usesReceiver()) {
                throw new IllegalArgumentException("Attempt to add receiver argument twice.");
            }
            builder.addedAsNested = true;
            builder.addToIndex(this.currentRequiredIndex++);
            this.arguments.add(builder);
            return this.invalidateCache();
        }

        @Deprecated
        public Builder addArguments() {
            return this;
        }

        public Builder addArguments(Object ... args) {
            for (Object arg : args) {
                if (arg instanceof Class) {
                    Class clazz = (Class)arg;
                    this.addRequiredArgument(clazz);
                    continue;
                }
                if (arg instanceof TypeInfo) {
                    TypeInfo type = (TypeInfo)arg;
                    this.addRequiredArgument(type);
                    continue;
                }
                if (arg instanceof InsnTree) {
                    InsnTree tree = (InsnTree)arg;
                    this.addImplicitArgument(tree);
                    continue;
                }
                if (arg instanceof Builder) {
                    Builder builder = (Builder)arg;
                    this.addNestedArgument(builder);
                    continue;
                }
                if (arg instanceof ReceiverArgument) {
                    ReceiverArgument argument = (ReceiverArgument)arg;
                    this.addReceiverArgument(argument.type);
                    continue;
                }
                if (arg instanceof Character) {
                    Character character = (Character)arg;
                    this.addRequiredArgument(TypeInfo.parse(character.charValue()));
                    continue;
                }
                if (arg instanceof CharSequence) {
                    CharSequence string = (CharSequence)arg;
                    for (TypeInfo type : TypeInfo.parseAll(string)) {
                        this.addRequiredArgument(type);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized argument: " + String.valueOf(arg));
            }
            return this.invalidateCache();
        }

        public Builder callback(Callback callback) {
            this.callback = this.callback == null ? callback : Callback.combine(this.callback, callback);
            return this;
        }

        public MutableScriptEnvironment.VariableHandler.Named buildVariable() {
            if (this.usesReceiver() || this.usesArguments()) {
                throw new IllegalStateException("Can't build variable when builder requires receiver or arguments.");
            }
            boolean deprecated = this.resolve().isDeprecated();
            return new MutableScriptEnvironment.VariableHandler.Named(this.toString(), (parser, name) -> {
                MutableScriptEnvironment.CastResult result = this.getFrom(parser, null, (InsnTree[])InsnTree.ARRAY_FACTORY.empty());
                if (result == null) {
                    return null;
                }
                if (deprecated) {
                    ScriptLogger.LOGGER.warn("A script used a deprecated variable: " + name + "\n" + parser.input.getSourceForError() + " <--- HERE");
                }
                return result.tree();
            });
        }

        public MutableScriptEnvironment.FieldHandler.Named buildField() {
            if (this.usesArguments()) {
                throw new IllegalStateException("Can't build field when builder requires arguments.");
            }
            if (!this.usesReceiver()) {
                throw new IllegalStateException("Can't build field without receiver.");
            }
            boolean deprecated = this.resolve().isDeprecated();
            return new MutableScriptEnvironment.FieldHandler.Named(this.toString(), (parser, receiver, name, mode) -> {
                MutableScriptEnvironment.CastResult result = this.getFrom(parser, receiver, (InsnTree[])InsnTree.ARRAY_FACTORY.empty());
                if (result == null) {
                    return null;
                }
                if (deprecated) {
                    ScriptLogger.LOGGER.warn("A script used a deprecated field: " + name + "\n" + parser.input.getSourceForError() + " <--- HERE");
                }
                BaseInvokeInsnTree invoker = (BaseInvokeInsnTree)result.tree();
                if (invoker.method.isStatic()) {
                    return mode.makeInvoker(parser, invoker.method, invoker.args);
                }
                return mode.makeInvoker(parser, invoker.args[0], invoker.method, Arrays.copyOfRange(invoker.args, 1, invoker.args.length));
            });
        }

        public MutableScriptEnvironment.FunctionHandler.Named buildFunction() {
            if (this.usesReceiver()) {
                throw new IllegalStateException("Can't build function when builder requires receiver.");
            }
            boolean deprecated = this.resolve().isDeprecated();
            return new MutableScriptEnvironment.FunctionHandler.Named(this.toString(), (parser, name, arguments) -> {
                MutableScriptEnvironment.CastResult result = this.getFrom(parser, null, arguments);
                if (result == null) {
                    return null;
                }
                if (deprecated) {
                    ScriptLogger.LOGGER.warn("A script used a deprecated function: " + name + "\n" + parser.input.getSourceForError() + " <--- HERE");
                }
                return result;
            });
        }

        public MutableScriptEnvironment.MethodHandler.Named buildMethod() {
            if (!this.usesReceiver()) {
                throw new IllegalStateException("Can't build method without receiver.");
            }
            boolean deprecated = this.resolve().isDeprecated();
            return new MutableScriptEnvironment.MethodHandler.Named(this.toString(), (parser, receiver, name, mode, arguments) -> {
                MutableScriptEnvironment.CastResult result = this.getFrom(parser, receiver, arguments);
                if (result == null) {
                    return null;
                }
                if (deprecated) {
                    ScriptLogger.LOGGER.warn("A script used a deprecated method: " + name + "\n" + parser.input.getSourceForError() + " <--- HERE");
                }
                BaseInvokeInsnTree invoker = (BaseInvokeInsnTree)result.tree();
                return new MutableScriptEnvironment.CastResult(mode.makeInvoker(parser, invoker.method, invoker.args), result.requiredCasting());
            });
        }

        @Override
        public TypeInfo getTypeInfo() {
            return this.resolve().returnType;
        }

        @Override
        @Nullable
        public MutableScriptEnvironment.CastResult getFrom(ExpressionParser parser, InsnTree receiver, InsnTree[] providedArgs) {
            int fromLength = providedArgs.length;
            if (!this.addedAsNested && this.currentRequiredIndex != fromLength) {
                return null;
            }
            int toLength = this.arguments.size();
            InsnTree[] runtimeArgs = new InsnTree[toLength];
            boolean requiredCasting = false;
            for (int index = 0; index < toLength; ++index) {
                MutableScriptEnvironment.CastResult castResult = this.arguments.get(index).getFrom(parser, receiver, providedArgs);
                if (castResult == null) {
                    return null;
                }
                runtimeArgs[index] = castResult.tree();
                requiredCasting |= castResult.requiredCasting();
            }
            MethodInfo resolution = this.resolve();
            if (resolution.isStatic()) {
                MutableScriptEnvironment.CastResult result = new MutableScriptEnvironment.CastResult(InsnTrees.invokeStatic(resolution, runtimeArgs), requiredCasting);
                if (this.callback != null) {
                    this.callback.onReferenced(parser, result);
                }
                return result;
            }
            InsnTree runtimeReceiver = runtimeArgs[0];
            runtimeArgs = Arrays.copyOfRange(runtimeArgs, 1, toLength);
            MutableScriptEnvironment.CastResult result = new MutableScriptEnvironment.CastResult(InsnTrees.invokeInstance(runtimeReceiver, resolution, runtimeArgs), requiredCasting);
            if (this.callback != null) {
                this.callback.onReferenced(parser, result);
            }
            return result;
        }

        @Override
        public void addToIndex(int toAdd) {
            for (Argument argument : this.arguments) {
                argument.addToIndex(toAdd);
            }
        }

        @Override
        public boolean usesReceiver() {
            for (Argument argument : this.arguments) {
                if (argument.usesReceiver()) {
                    return true;
                }
                if (!argument.usesArguments()) continue;
                return false;
            }
            return false;
        }

        @Override
        public boolean usesArguments() {
            for (Argument argument : this.arguments) {
                if (!argument.usesArguments()) continue;
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void onReferenced(ExpressionParser var1, MutableScriptEnvironment.CastResult var2);

        public static Callback combine(Callback a, Callback b) {
            return (parser, result) -> {
                a.onReferenced(parser, result);
                b.onReferenced(parser, result);
            };
        }
    }
}

