/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.scripting.bytecode.AbstractConstantFactory;
import builderb0y.scripting.bytecode.CastingSupport;
import builderb0y.scripting.bytecode.FieldConstantFactory;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.IdentityCastInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.OpcodeCastInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.invokers.GetterSetterInsnTree;
import builderb0y.scripting.environments.Handlers;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.ReflectionData;
import builderb0y.scripting.util.TypeInfos;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class MutableScriptEnvironment
implements ScriptEnvironment {
    public static final Predicate<Method> IS_STATIC = method -> Modifier.isStatic(method.getModifiers());
    public static final Predicate<Method> IS_INSTANCE = method -> !Modifier.isStatic(method.getModifiers());
    public static final Predicate<Method> NO_ARGS = method -> method.getParameterCount() == 0;
    public Map<String, VariableHandler.Named> variables = new HashMap<String, VariableHandler.Named>(16);
    public Map<NamedType, FieldHandler.Named> fields = new HashMap<NamedType, FieldHandler.Named>(16);
    public Map<String, List<FunctionHandler.Named>> functions = new HashMap<String, List<FunctionHandler.Named>>(64);
    public Map<NamedType, List<MethodHandler.Named>> methods = new HashMap<NamedType, List<MethodHandler.Named>>(64);
    public Map<NamedType, List<FunctionHandler.Named>> qualifiedFunctions = new HashMap<NamedType, List<FunctionHandler.Named>>(64);
    public Map<String, TypeInfo> types = new HashMap<String, TypeInfo>(16);
    public Map<String, KeywordHandler.Named> keywords = new HashMap<String, KeywordHandler.Named>(16);
    public Map<NamedType, List<MemberKeywordHandler.Named>> memberKeywords = new HashMap<NamedType, List<MemberKeywordHandler.Named>>(16);
    public Map<TypeInfo, Map<TypeInfo, CastHandlerHolder>> casters = new HashMap<TypeInfo, Map<TypeInfo, CastHandlerHolder>>(64);

    public static ScriptEnvironment.IdentifierDescriptor prefix(final String type, String name, final String descriptor, final Object value) {
        return new ScriptEnvironment.IdentifierDescriptor(name != null ? name : "<any name>", new Object(){

            public String toString() {
                return type + " " + descriptor + ": " + String.valueOf(value);
            }
        });
    }

    @Override
    public Stream<ScriptEnvironment.IdentifierDescriptor> listIdentifiers() {
        return Stream.of(this.variables.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Variable", (String)entry.getKey(), (String)entry.getKey(), entry.getValue())), this.fields.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Field", ((NamedType)entry.getKey()).name, ((NamedType)entry.getKey()).toString(), entry.getValue())), this.functions.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(handler -> MutableScriptEnvironment.prefix("Function", (String)entry.getKey(), (String)entry.getKey(), handler))), this.methods.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(handler -> MutableScriptEnvironment.prefix("Method", ((NamedType)entry.getKey()).name, ((NamedType)entry.getKey()).toString(), handler))), this.types.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Type", (String)entry.getKey(), (String)entry.getKey(), entry.getValue())), this.keywords.entrySet().stream().map(entry -> MutableScriptEnvironment.prefix("Keyword", (String)entry.getKey(), (String)entry.getKey(), entry.getValue())), this.memberKeywords.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(handler -> MutableScriptEnvironment.prefix("Member keyword", ((NamedType)entry.getKey()).name, ((NamedType)entry.getKey()).toString(), handler)))).flatMap(Function.identity());
    }

    public MutableScriptEnvironment addAllVariables(MutableScriptEnvironment that) {
        if (!that.variables.isEmpty()) {
            for (Map.Entry<String, VariableHandler.Named> entry : that.variables.entrySet()) {
                if (this.variables.putIfAbsent(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Variable '" + entry.getKey() + "' is already defined in this scope");
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllFields(MutableScriptEnvironment that) {
        if (!that.fields.isEmpty()) {
            for (Map.Entry<NamedType, FieldHandler.Named> entry : that.fields.entrySet()) {
                if (this.fields.putIfAbsent(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Field '" + String.valueOf(entry.getKey()) + "' is already defined in this scope");
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllFunctions(MutableScriptEnvironment that) {
        if (!that.functions.isEmpty()) {
            for (Map.Entry<String, List<FunctionHandler.Named>> entry : that.functions.entrySet()) {
                this.functions.compute(entry.getKey(), (key, list) -> {
                    if (list != null) {
                        list.addAll((Collection)entry.getValue());
                    } else {
                        list = new ArrayList((Collection)entry.getValue());
                    }
                    return list;
                });
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllMethods(MutableScriptEnvironment that) {
        if (!that.methods.isEmpty()) {
            for (Map.Entry<NamedType, List<MethodHandler.Named>> entry : that.methods.entrySet()) {
                this.methods.compute(entry.getKey(), (key, list) -> {
                    if (list != null) {
                        list.addAll((Collection)entry.getValue());
                    } else {
                        list = new ArrayList((Collection)entry.getValue());
                    }
                    return list;
                });
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllQualifiedFunctions(MutableScriptEnvironment that) {
        if (!that.qualifiedFunctions.isEmpty()) {
            for (Map.Entry<NamedType, List<FunctionHandler.Named>> entry : that.qualifiedFunctions.entrySet()) {
                this.qualifiedFunctions.compute(entry.getKey(), (key, list) -> {
                    if (list != null) {
                        list.addAll((Collection)entry.getValue());
                    } else {
                        list = new ArrayList((Collection)entry.getValue());
                    }
                    return list;
                });
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllTypes(MutableScriptEnvironment that) {
        if (!that.types.isEmpty()) {
            for (Map.Entry<String, TypeInfo> entry : that.types.entrySet()) {
                if (this.types.putIfAbsent(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Type '" + entry.getKey() + "' is already defined in this scope");
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllKeywords(MutableScriptEnvironment that) {
        if (!that.keywords.isEmpty()) {
            for (Map.Entry<String, KeywordHandler.Named> entry : that.keywords.entrySet()) {
                if (this.keywords.putIfAbsent(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Keyword '" + entry.getKey() + "' is already defined in this scope");
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllMemberKeywords(MutableScriptEnvironment that) {
        if (!that.memberKeywords.isEmpty()) {
            for (Map.Entry<NamedType, List<MemberKeywordHandler.Named>> entry : that.memberKeywords.entrySet()) {
                this.memberKeywords.compute(entry.getKey(), (key, list) -> {
                    if (list != null) {
                        list.addAll((Collection)entry.getValue());
                    } else {
                        list = new ArrayList((Collection)entry.getValue());
                    }
                    return list;
                });
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAllCasters(MutableScriptEnvironment that) {
        if (!that.casters.isEmpty()) {
            for (Map.Entry<TypeInfo, Map<TypeInfo, CastHandlerHolder>> entry : that.casters.entrySet()) {
                Map<TypeInfo, CastHandlerHolder> from = this.casters.get(entry.getKey());
                Map<TypeInfo, CastHandlerHolder> to = entry.getValue();
                if (from == null) {
                    this.casters.put(entry.getKey(), new HashMap<TypeInfo, CastHandlerHolder>(to));
                    continue;
                }
                for (Map.Entry<TypeInfo, CastHandlerHolder> entry2 : to.entrySet()) {
                    if (from.putIfAbsent(entry2.getKey(), entry2.getValue()) == null) continue;
                    throw new IllegalArgumentException("Caster " + String.valueOf(entry.getKey()) + " -> " + String.valueOf(entry2.getKey()) + " (" + String.valueOf(entry2.getValue()) + ") is already present in this environment");
                }
            }
        }
        return this;
    }

    public MutableScriptEnvironment addAll(MutableScriptEnvironment that) {
        return this.addAllVariables(that).addAllFields(that).addAllFunctions(that).addAllMethods(that).addAllQualifiedFunctions(that).addAllTypes(that).addAllKeywords(that).addAllMemberKeywords(that).addAllCasters(that);
    }

    public MutableScriptEnvironment multiAddAll(MutableScriptEnvironment ... environments) {
        for (MutableScriptEnvironment environment : environments) {
            this.addAll(environment);
        }
        return this;
    }

    public MutableScriptEnvironment configure(Consumer<MutableScriptEnvironment> configurator) {
        configurator.accept(this);
        return this;
    }

    public MutableScriptEnvironment addVariable(String name, VariableHandler.Named variableHandler) {
        if (this.variables.putIfAbsent(name, variableHandler) != null) {
            throw new IllegalArgumentException("Variable '" + name + "' is already defined in this scope");
        }
        return this;
    }

    public MutableScriptEnvironment addVariable(String name, InsnTree tree) {
        return this.addVariable(name, new VariableHandler.Named(tree.describe(), (parser, name1) -> tree));
    }

    public MutableScriptEnvironment addVariableLoad(String name, LazyVarInfo variable) {
        return this.addVariable(name, InsnTrees.load(variable));
    }

    public MutableScriptEnvironment addVariableLoad(LazyVarInfo variable) {
        return this.addVariable(variable.name, InsnTrees.load(variable));
    }

    public MutableScriptEnvironment addVariableLoad(String name, TypeInfo type) {
        return this.addVariable(name, InsnTrees.load(name, type));
    }

    public MutableScriptEnvironment addVariableRenamedGetField(InsnTree receiver, String name, FieldInfo field) {
        return this.addVariable(name, InsnTrees.getField(receiver, field));
    }

    public MutableScriptEnvironment addVariableGetField(InsnTree receiver, FieldInfo field) {
        return this.addVariable(field.name, InsnTrees.getField(receiver, field));
    }

    public MutableScriptEnvironment addVariableRenamedGetField(InsnTree receiver, String exposedName, Class<?> in, String actualName) {
        return this.addVariable(exposedName, InsnTrees.getField(receiver, FieldInfo.getField(in, actualName)));
    }

    public MutableScriptEnvironment addVariableGetField(InsnTree receiver, Class<?> in, String name) {
        return this.addVariable(name, InsnTrees.getField(receiver, FieldInfo.getField(in, name)));
    }

    public MutableScriptEnvironment addVariableGetFields(InsnTree receiver, Class<?> in, String ... names) {
        for (String name : names) {
            this.addVariableGetField(receiver, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addVariableGetStatic(String name, FieldInfo field) {
        return this.addVariable(name, InsnTrees.getStatic(field));
    }

    public MutableScriptEnvironment addVariableGetStatic(FieldInfo field) {
        return this.addVariableGetStatic(field.name, field);
    }

    public MutableScriptEnvironment addVariableGetStatic(Class<?> in, String name) {
        return this.addVariableGetStatic(name, FieldInfo.getField(in, name));
    }

    public MutableScriptEnvironment addVariableGetStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addVariableGetStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addVariableRenamedInvoke(InsnTree receiver, String name, MethodInfo method) {
        return this.addVariable(name, Handlers.builder(method).addImplicitArgument(receiver).buildVariable());
    }

    public MutableScriptEnvironment addVariableInvoke(InsnTree receiver, MethodInfo method) {
        return this.addVariableRenamedInvoke(receiver, method.name, method);
    }

    public MutableScriptEnvironment addVariableInvoke(InsnTree receiver, Class<?> in, String name) {
        return this.addVariable(name, Handlers.builder(in, name).addImplicitArgument(receiver).buildVariable());
    }

    public MutableScriptEnvironment addVariableInvokes(InsnTree receiver, Class<?> in, String ... names) {
        for (String name : names) {
            this.addVariableInvoke(receiver, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addVariableGetterSetter(InsnTree receiver, String name, MethodInfo getter, MethodInfo setter) {
        return this.addVariable(name, new GetterSetterInsnTree(receiver, getter, setter));
    }

    public MutableScriptEnvironment addVariableInvokeStatic(String name, MethodInfo method) {
        return this.addVariable(name, Handlers.builder(method).buildVariable());
    }

    public MutableScriptEnvironment addVariableInvokeStatic(MethodInfo method) {
        return this.addVariableInvokeStatic(method.name, method);
    }

    public MutableScriptEnvironment addVariableInvokeStatic(Class<?> in, String getterName) {
        return this.addVariableInvokeStatic(getterName, MethodInfo.getMethod(in, getterName, NO_ARGS.and(IS_STATIC)));
    }

    public MutableScriptEnvironment addVariableInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addVariableInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addVariableConstant(String name, ConstantValue constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, boolean constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, byte constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, char constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, short constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, int constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, long constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, float constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, double constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, String constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, TypeInfo constant) {
        return this.addVariable(name, InsnTrees.ldc(constant));
    }

    public MutableScriptEnvironment addVariableConstant(String name, Object constant, TypeInfo type) {
        return this.addVariable(name, InsnTrees.ldc(constant, type));
    }

    public MutableScriptEnvironment addField(TypeInfo owner, String name, FieldHandler.Named fieldHandler) {
        if (this.fields.putIfAbsent(new NamedType(owner, name), fieldHandler) != null) {
            throw new IllegalArgumentException("Field '" + String.valueOf(owner) + "." + name + "' is already defined in this scope");
        }
        return this;
    }

    public MutableScriptEnvironment addFieldGet(String name, FieldInfo field) {
        return this.addField(field.owner, name, new FieldHandler.Named(field.toString(), (parser, receiver, name1, mode) -> mode.makeField(parser, receiver, field)));
    }

    public MutableScriptEnvironment addFieldGet(FieldInfo field) {
        return this.addFieldGet(field.name, field);
    }

    public MutableScriptEnvironment addFieldGet(Class<?> in, String name) {
        return this.addFieldGet(name, FieldInfo.getField(in, name));
    }

    public MutableScriptEnvironment addFieldGets(Class<?> in, String ... names) {
        for (String name : names) {
            this.addFieldGet(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addFieldInvoke(String name, MethodInfo getter) {
        return this.addField(getter.owner, name, Handlers.builder(getter).addReceiverArgument(getter.owner).buildField());
    }

    public MutableScriptEnvironment addFieldInvoke(MethodInfo getter) {
        return this.addFieldInvoke(getter.name, getter);
    }

    public MutableScriptEnvironment addFieldRenamedInvoke(String exposedName, Class<?> in, String actualName) {
        return this.addFieldInvoke(exposedName, MethodInfo.getMethod(in, actualName, NO_ARGS.and(IS_INSTANCE)));
    }

    public MutableScriptEnvironment addFieldInvoke(Class<?> in, String name) {
        return this.addFieldRenamedInvoke(name, in, name);
    }

    public MutableScriptEnvironment addFieldInvokes(Class<?> in, String ... names) {
        for (String name : names) {
            this.addFieldInvoke(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addFieldInvokeStatic(String name, MethodInfo getter) {
        return this.addField(getter.paramTypes[0], name, Handlers.builder(getter).addReceiverArgument(getter.paramTypes[0]).buildField());
    }

    public MutableScriptEnvironment addFieldInvokeStatic(MethodInfo getter) {
        return this.addFieldInvokeStatic(getter.name, getter);
    }

    public MutableScriptEnvironment addFieldInvokeStatic(Class<?> in, String name) {
        return this.addFieldInvokeStatic(MethodInfo.getMethod(in, name, IS_STATIC));
    }

    public MutableScriptEnvironment addFieldInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addFieldInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addFieldGetterSetter(TypeInfo owner, String name, MethodInfo getter, MethodInfo setter) {
        return this.addField(owner, name, new FieldHandler.Named("getter: " + String.valueOf(getter) + ", setter: " + String.valueOf(setter), (parser, receiver, name1, mode) -> {
            if (getter.isDeprecated() || setter.isDeprecated()) {
                BigGlobeMod.LOGGER.warn("Deprecated field used: " + name + "\n" + parser.input.getSourceForError());
            }
            return mode.makeGetterSetter(parser, receiver, getter, setter);
        }));
    }

    public MutableScriptEnvironment addFieldGetterSetterInstance(Class<?> in, String exposedName, String internalName, Class<?> type) {
        MethodInfo getter = MethodInfo.findMethod(in, internalName, type, new Class[0]);
        MethodInfo setter = MethodInfo.findMethod(in, internalName, Void.TYPE, type);
        return this.addFieldGetterSetter(InsnTrees.type(in), exposedName, getter, setter);
    }

    public MutableScriptEnvironment addFieldGetterSetterInstance(Class<?> in, String name, Class<?> type) {
        return this.addFieldGetterSetterInstance(in, name, name, type);
    }

    public MutableScriptEnvironment addFieldGetterSetterStatic(Class<?> owner, Class<?> in, String exposedName, String internalName, Class<?> type) {
        MethodInfo getter = MethodInfo.findMethod(in, internalName, type, owner);
        MethodInfo setter = MethodInfo.findMethod(in, internalName, Void.TYPE, owner, type);
        return this.addFieldGetterSetter(InsnTrees.type(owner), exposedName, getter, setter);
    }

    public MutableScriptEnvironment addFieldGetterSetterStatic(Class<?> owner, Class<?> in, String name, Class<?> type) {
        return this.addFieldGetterSetterStatic(owner, in, name, name, type);
    }

    public MutableScriptEnvironment addFunction(String name, FunctionHandler.Named functionHandler) {
        this.functions.computeIfAbsent(name, $ -> new ArrayList(8)).add(functionHandler);
        return this;
    }

    public MutableScriptEnvironment addFunctionNoArgs(String name, InsnTree tree) {
        return this.addFunction(name, new FunctionHandler.Named("noArgs: " + tree.describe(), (parser, name1, arguments) -> arguments.length == 0 ? new CastResult(tree, false) : null));
    }

    public MutableScriptEnvironment addFunctionInvokeStatic(String name, MethodInfo method) {
        return this.addFunction(name, Handlers.builder(method).addArguments(method.paramTypes).buildFunction());
    }

    public MutableScriptEnvironment addFunctionInvokeStatic(MethodInfo method) {
        return this.addFunctionInvokeStatic(method.name, method);
    }

    public MutableScriptEnvironment addFunctionRenamedInvokeStatic(String exposedName, Class<?> in, String actualName) {
        return this.addFunctionInvokeStatic(exposedName, MethodInfo.getMethod(in, actualName, IS_STATIC));
    }

    public MutableScriptEnvironment addFunctionInvokeStatic(Class<?> in, String name) {
        return this.addFunctionInvokeStatic(MethodInfo.getMethod(in, name, IS_STATIC));
    }

    public MutableScriptEnvironment addFunctionInvokeStatic(Class<?> in, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return this.addFunctionInvokeStatic(MethodInfo.findMethod(in, name, returnType, parameterTypes));
    }

    public MutableScriptEnvironment addFunctionInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addFunctionInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addFunctionMultiInvokeStatic(Class<?> in, String name) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(name)) {
            this.addFunctionInvokeStatic(name, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addFunctionMultiInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addFunctionMultiInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addFunctionRenamedMultiInvokeStatic(String exposedName, Class<?> in, String actualName) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(actualName)) {
            this.addFunctionInvokeStatic(exposedName, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addFunctionInvoke(String name, InsnTree receiver, MethodInfo method) {
        return this.addFunction(name, Handlers.builder(method).addImplicitArgument(receiver).addArguments(method.paramTypes).buildFunction());
    }

    public MutableScriptEnvironment addFunctionInvoke(InsnTree receiver, MethodInfo method) {
        return this.addFunctionInvoke(method.name, receiver, method);
    }

    public MutableScriptEnvironment addFunctionInvoke(InsnTree receiver, Class<?> in, String name) {
        return this.addFunctionInvoke(name, receiver, MethodInfo.getMethod(in, name, IS_INSTANCE));
    }

    public MutableScriptEnvironment addFunctionInvoke(InsnTree receiver, Class<?> in, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addFunctionInvoke(name, receiver, MethodInfo.findMethod(in, name, returnType, paramTypes));
    }

    public MutableScriptEnvironment addFunctionInvokes(InsnTree receiver, Class<?> in, String ... names) {
        for (String name : names) {
            this.addFunctionInvoke(receiver, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addFunctionMultiInvoke(InsnTree receiver, Class<?> in, String name) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(name)) {
            this.addFunctionInvoke(receiver, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addFunctionMultiInvokes(InsnTree receiver, Class<?> in, String ... names) {
        for (String name : names) {
            this.addFunctionMultiInvoke(receiver, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addMethod(TypeInfo owner, String name, MethodHandler.Named methodHandler) {
        this.methods.computeIfAbsent(new NamedType(owner, name), $ -> new ArrayList(8)).add(methodHandler);
        return this;
    }

    public MutableScriptEnvironment addMethodInvoke(String name, MethodInfo method) {
        return this.addMethod(method.owner, name, Handlers.builder(method).addReceiverArgument(method.owner).addArguments(method.paramTypes).buildMethod());
    }

    public MutableScriptEnvironment addMethodInvoke(MethodInfo method) {
        return this.addMethodInvoke(method.name, method);
    }

    public MutableScriptEnvironment addMethodInvoke(Class<?> in, String name) {
        return this.addMethodInvoke(name, MethodInfo.getMethod(in, name, IS_INSTANCE));
    }

    public MutableScriptEnvironment addMethodRenamedInvoke(String exposedName, Class<?> in, String actualName) {
        return this.addMethodInvoke(exposedName, MethodInfo.getMethod(in, actualName, IS_INSTANCE));
    }

    public MutableScriptEnvironment addMethodRenamedInvokeSpecific(String exposedName, Class<?> in, String actualName, Class<?> returnType, Class<?> paramTypes) {
        return this.addMethodInvoke(exposedName, MethodInfo.findMethod(in, actualName, returnType, paramTypes));
    }

    public MutableScriptEnvironment addMethodInvokes(Class<?> in, String ... names) {
        for (String name : names) {
            this.addMethodInvoke(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addMethodMultiInvoke(Class<?> in, String name) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(name)) {
            this.addMethodInvoke(name, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addMethodMultiInvokes(Class<?> in, String ... names) {
        for (String name : names) {
            this.addMethodMultiInvoke(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addMethodInvokeSpecific(Class<?> in, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addMethodInvoke(name, MethodInfo.findMethod(in, name, returnType, paramTypes));
    }

    public MutableScriptEnvironment addMethodInvokeStatic(String name, MethodInfo method) {
        return this.addMethod(method.paramTypes[0], name, Handlers.builder(method).addReceiverArgument(method.paramTypes[0]).addArguments(Arrays.copyOfRange(method.paramTypes, 1, method.paramTypes.length)).buildMethod());
    }

    public MutableScriptEnvironment addMethodInvokeStatic(MethodInfo method) {
        return this.addMethodInvokeStatic(method.name, method);
    }

    public MutableScriptEnvironment addMethodRenamedInvokeStatic(String exposedName, Class<?> in, String actualName) {
        return this.addMethodInvokeStatic(exposedName, MethodInfo.getMethod(in, actualName, IS_STATIC));
    }

    public MutableScriptEnvironment addMethodInvokeStatic(Class<?> in, String name) {
        return this.addMethodRenamedInvokeStatic(name, in, name);
    }

    public MutableScriptEnvironment addMethodInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addMethodInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addMethodInvokeStaticSpecific(Class<?> in, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addMethodInvokeStatic(MethodInfo.findMethod(in, name, returnType, paramTypes));
    }

    public MutableScriptEnvironment addMethodRenamedMultiInvokeStatic(String exposedName, Class<?> in, String actualName) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(actualName)) {
            this.addMethodInvokeStatic(exposedName, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addMethodMultiInvokeStatic(Class<?> in, String name) {
        return this.addMethodRenamedMultiInvokeStatic(name, in, name);
    }

    public MutableScriptEnvironment addMethodMultiInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addMethodMultiInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addMethodRenamedInvokeStaticSpecific(String exposedName, Class<?> in, String actualName, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addMethodInvokeStatic(exposedName, MethodInfo.findMethod(in, actualName, returnType, paramTypes));
    }

    public MutableScriptEnvironment addType(String name, TypeInfo type) {
        if (this.types.putIfAbsent(name, type) != null) {
            throw new IllegalArgumentException("Type " + name + " is already defined in this scope");
        }
        return this;
    }

    public MutableScriptEnvironment addType(String name, Class<?> type) {
        return this.addType(name, TypeInfo.of(type));
    }

    public MutableScriptEnvironment addQualifiedVariable(TypeInfo owner, String name, VariableHandler variableHandler) {
        return this.addField(TypeInfos.CLASS, name, new FieldHandler.Named("qualifiedVariable on " + String.valueOf(owner) + ": " + String.valueOf(variableHandler), (parser, receiver, name1, mode) -> {
            ConstantValue constant = receiver.getConstantValue();
            if (constant.isConstant() && constant.asJavaObject().equals(owner)) {
                return variableHandler.create(parser, name1);
            }
            return null;
        }));
    }

    public MutableScriptEnvironment addQualifiedVariable(TypeInfo owner, String name, InsnTree tree) {
        return this.addQualifiedVariable(owner, name, new VariableHandler.Named(tree.describe(), (parser, name1) -> tree));
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatic(TypeInfo owner, String name, FieldInfo field) {
        return this.addQualifiedVariable(owner, name, InsnTrees.getStatic(field));
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatic(String name, FieldInfo field) {
        return this.addQualifiedVariable(field.owner, name, InsnTrees.getStatic(field));
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatic(TypeInfo owner, FieldInfo field) {
        return this.addQualifiedVariable(owner, field.name, InsnTrees.getStatic(field));
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatic(FieldInfo field) {
        return this.addQualifiedVariable(field.owner, field.name, InsnTrees.getStatic(field));
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatic(TypeInfo owner, Class<?> in, String name) {
        return this.addQualifiedVariableGetStatic(owner, name, FieldInfo.getField(in, name));
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatic(Class<?> in, String name) {
        return this.addQualifiedVariableGetStatic(TypeInfo.of(in), in, name);
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatics(TypeInfo owner, Class<?> in, String ... names) {
        for (String name : names) {
            this.addQualifiedVariableGetStatic(owner, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedVariableGetStatics(Class<?> in, String ... names) {
        return this.addQualifiedVariableGetStatics(TypeInfo.of(in), in, names);
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatic(TypeInfo owner, String name, MethodInfo method) {
        if (method.paramTypes.length != 0) {
            throw new IllegalArgumentException("Qualified static getter requires parameters");
        }
        return this.addQualifiedVariable(owner, name, InsnTrees.invokeStatic(method, new InsnTree[0]));
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatic(TypeInfo owner, MethodInfo method) {
        return this.addQualifiedVariableInvokeStatic(owner, method.name, method);
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatic(String name, MethodInfo method) {
        return this.addQualifiedVariableInvokeStatic(method.owner, name, method);
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatic(MethodInfo method) {
        return this.addQualifiedVariableInvokeStatic(method.owner, method.name, method);
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatic(TypeInfo owner, Class<?> in, String name) {
        return this.addQualifiedVariableInvokeStatic(owner, name, MethodInfo.getMethod(in, name, IS_STATIC));
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatic(Class<?> in, String name) {
        return this.addQualifiedVariableInvokeStatic(TypeInfo.of(in), in, name);
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatics(TypeInfo owner, Class<?> in, String ... names) {
        int n = 0;
        String[] stringArray = names;
        int n2 = stringArray.length;
        if (n < n2) {
            String name = stringArray[n];
            return this.addQualifiedVariableInvokeStatic(owner, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedVariableInvokeStatics(Class<?> in, String ... names) {
        return this.addQualifiedVariableInvokeStatics(TypeInfo.of(in), in, names);
    }

    public MutableScriptEnvironment addQualifiedFunction(TypeInfo owner, String name, FunctionHandler.Named functionHandler) {
        this.qualifiedFunctions.computeIfAbsent(new NamedType(owner, name), $ -> new ArrayList()).add(functionHandler);
        return this;
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(TypeInfo owner, String name, MethodInfo method) {
        return this.addQualifiedFunction(owner, name, new FunctionHandler.Named("invokeStatic: " + String.valueOf(method), (parser, name1, arguments) -> {
            InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, method, InsnTree.CastMode.IMPLICIT_NULL, arguments);
            return castArguments == null ? null : new CastResult(InsnTrees.invokeStatic(method, castArguments), castArguments != arguments);
        }));
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(String name, MethodInfo method) {
        return this.addQualifiedFunctionInvokeStatic(method.owner, name, method);
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(TypeInfo owner, MethodInfo method) {
        return this.addQualifiedFunctionInvokeStatic(owner, method.name, method);
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(MethodInfo method) {
        return this.addQualifiedFunctionInvokeStatic(method.owner, method.name, method);
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(TypeInfo owner, Class<?> in, String name) {
        return this.addQualifiedFunctionInvokeStatic(owner, MethodInfo.getMethod(in, name, IS_STATIC));
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(Class<?> in, String name) {
        return this.addQualifiedFunctionInvokeStatic(TypeInfo.of(in), MethodInfo.getMethod(in, name, IS_STATIC));
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(TypeInfo owner, Class<?> in, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addQualifiedFunctionInvokeStatic(owner, MethodInfo.findMethod(in, name, returnType, paramTypes));
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatic(Class<?> in, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addQualifiedFunctionInvokeStatic(TypeInfo.of(in), MethodInfo.findMethod(in, name, returnType, paramTypes));
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatics(TypeInfo owner, Class<?> in, String ... names) {
        for (String name : names) {
            this.addQualifiedFunctionInvokeStatic(owner, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedFunctionInvokeStatics(Class<?> in, String ... names) {
        for (String name : names) {
            this.addQualifiedFunctionInvokeStatic(in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedFunctionMultiInvokeStatic(TypeInfo owner, Class<?> in, String name) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(name)) {
            this.addQualifiedFunctionInvokeStatic(owner, name, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedFunctionMultiInvokeStatic(Class<?> in, String name) {
        return this.addQualifiedFunctionMultiInvokeStatic(TypeInfo.of(in), in, name);
    }

    public MutableScriptEnvironment addQualifiedFunctionMultiInvokeStatics(TypeInfo owner, Class<?> in, String ... names) {
        for (String name : names) {
            this.addQualifiedFunctionMultiInvokeStatic(owner, in, name);
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedFunctionMultiInvokeStatics(Class<?> in, String ... names) {
        return this.addQualifiedFunctionMultiInvokeStatics(TypeInfo.of(in), in, names);
    }

    public MutableScriptEnvironment addQualifiedFunctionRenamedMultiInvokeStatic(TypeInfo owner, Class<?> in, String exposedName, String internalName) {
        for (Method method : ReflectionData.forClass(in).getDeclaredMethods(internalName)) {
            this.addQualifiedFunctionInvokeStatic(owner, exposedName, MethodInfo.forMethod(method));
        }
        return this;
    }

    public MutableScriptEnvironment addQualifiedConstructor(MethodInfo constructor) {
        return this.addQualifiedFunction(constructor.owner, "new", new FunctionHandler.Named("constructor: " + String.valueOf(constructor), (parser, name, arguments) -> {
            InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, constructor, InsnTree.CastMode.IMPLICIT_NULL, arguments);
            return castArguments == null ? null : new CastResult(InsnTrees.newInstance(constructor, castArguments), castArguments != arguments);
        }));
    }

    public MutableScriptEnvironment addQualifiedConstructor(Class<?> in) {
        return this.addQualifiedConstructor(MethodInfo.getConstructor(in));
    }

    public MutableScriptEnvironment addQualifiedSpecificConstructor(Class<?> in, Class<?> ... parameterTypes) {
        return this.addQualifiedConstructor(MethodInfo.findConstructor(in, parameterTypes));
    }

    public MutableScriptEnvironment addQualifiedMultiConstructor(Class<?> in) {
        for (Constructor<?> constructor : ReflectionData.forClass(in).getConstructors()) {
            this.addQualifiedConstructor(MethodInfo.forConstructor(constructor));
        }
        return this;
    }

    public <E extends Enum<E>> MutableScriptEnvironment addEnum(Class<E> enumClass) {
        return this.addEnum(enumClass.getSimpleName(), enumClass, Enum::name);
    }

    public <E extends Enum<E>> MutableScriptEnvironment addEnum(String name, Class<E> enumClass) {
        return this.addEnum(name, enumClass, Enum::name);
    }

    public <E extends Enum<E>> MutableScriptEnvironment addEnum(String name, Class<E> enumClass, Function<E, String> nameGetter) {
        this.addType(name, enumClass);
        this.addCastConstant(FieldConstantFactory.forEnum(enumClass, nameGetter), true);
        return this;
    }

    public MutableScriptEnvironment addKeyword(String name, KeywordHandler.Named keywordHandler) {
        if (this.keywords.putIfAbsent(name, keywordHandler) != null) {
            throw new IllegalArgumentException("Keyword " + name + " is already defined in this scope");
        }
        return this;
    }

    public MutableScriptEnvironment addMemberKeyword(TypeInfo type, String name, MemberKeywordHandler.Named memberKeywordHandler) {
        this.memberKeywords.computeIfAbsent(new NamedType(type, name), namedType -> new ArrayList(1)).add(memberKeywordHandler);
        return this;
    }

    public MutableScriptEnvironment addCast(TypeInfo from, TypeInfo to, boolean implicit, CastHandler castHandler) {
        CastHandlerHolder holder;
        while (castHandler instanceof CastHandlerHolder) {
            holder = (CastHandlerHolder)castHandler;
            castHandler = holder.caster;
        }
        holder = new CastHandlerHolder(implicit, castHandler);
        if (this.casters.computeIfAbsent(from, $ -> new HashMap(8)).putIfAbsent(to, holder) != null) {
            throw new IllegalArgumentException("Caster " + String.valueOf(from) + " -> " + String.valueOf(to) + " is already present in this environment");
        }
        return this;
    }

    public MutableScriptEnvironment addCast(CastHandlerData caster) {
        return this.addCast(caster.from, caster.to, caster.implicit, caster);
    }

    public MutableScriptEnvironment addCasts(CastHandlerData ... casters) {
        return this.addCast(casters[0].from, casters[casters.length - 1].to, Arrays.stream(casters).allMatch(caster -> caster.implicit), CastingSupport.allOf(casters));
    }

    public MutableScriptEnvironment addCastInvoke(MethodInfo method, boolean implicit) {
        return this.addCast(method.owner, method.returnType, implicit, CastingSupport.invokeVirtual(method));
    }

    public MutableScriptEnvironment addCastInvoke(Class<?> in, String name, boolean implicit) {
        return this.addCastInvoke(MethodInfo.getMethod(in, name, IS_INSTANCE), implicit);
    }

    public MutableScriptEnvironment addCastInvokeStatic(MethodInfo method, boolean implicit) {
        return this.addCast(method.paramTypes[0], method.returnType, implicit, CastingSupport.invokeStatic(method));
    }

    public MutableScriptEnvironment addCastInvokeStatic(Class<?> in, String name, boolean implicit) {
        return this.addCastInvokeStatic(MethodInfo.getMethod(in, name, IS_STATIC), implicit);
    }

    public MutableScriptEnvironment addCastInvokeStatic(Class<?> in, String name, boolean implicit, Class<?> returnType, Class<?> ... paramTypes) {
        return this.addCastInvokeStatic(MethodInfo.findMethod(in, name, returnType, paramTypes), implicit);
    }

    public MutableScriptEnvironment addCastOpcode(TypeInfo from, TypeInfo to, boolean implicit, int opcode) {
        return this.addCast(from, to, implicit, (parser, value, to_, implicit_, nullable) -> new OpcodeCastInsnTree(value, opcode, to_));
    }

    public MutableScriptEnvironment addCastIdentity(TypeInfo from, TypeInfo to, boolean implicit) {
        return this.addCast(from, to, implicit, (parser, value, to_, implicit_, nullable) -> new IdentityCastInsnTree(value, to_));
    }

    public MutableScriptEnvironment addCastConstant(AbstractConstantFactory factory, boolean implicit) {
        return this.addCast(factory.inType, factory.outType, implicit, (parser, value, to, implicit_, nullable) -> factory.create((ExpressionParser)parser, (InsnTree)value, (boolean)implicit_, (boolean)nullable).tree);
    }

    @Override
    @Nullable
    public InsnTree getVariable(ExpressionParser parser, String name) throws ScriptParsingException {
        InsnTree result;
        VariableHandler handler = this.variables.get(name);
        if (handler != null && (result = handler.create(parser, name)) != null) {
            return result;
        }
        handler = this.variables.get(null);
        if (handler != null && (result = handler.create(parser, name)) != null) {
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getField(final ExpressionParser parser, final InsnTree receiver, final String name, final ScriptEnvironment.GetFieldMode mode) throws ScriptParsingException {
        class Accumulator {
            public final NamedType query = new NamedType();
            public InsnTree result;
            final /* synthetic */ MutableScriptEnvironment this$0;

            Accumulator() {
                this.this$0 = this$0;
            }

            public boolean update(String n, TypeInfo type) throws ScriptParsingException {
                this.query.name = n;
                this.query.owner = type;
                FieldHandler handler = this.this$0.fields.get(this.query);
                return handler != null && (this.result = handler.create(parser, receiver, name, mode)) != null;
            }
        }
        Accumulator accumulator = new Accumulator();
        for (TypeInfo owner : receiver.getTypeInfo().getAllAssignableTypes()) {
            if (accumulator.update(name, owner)) {
                return accumulator.result;
            }
            if (!accumulator.update(null, owner)) continue;
            return accumulator.result;
        }
        if (accumulator.update(name, null)) {
            return accumulator.result;
        }
        if (accumulator.update(null, null)) {
            return accumulator.result;
        }
        return accumulator.result;
    }

    @Override
    @Nullable
    public InsnTree getFunction(final ExpressionParser parser, final String name, final InsnTree ... arguments) throws ScriptParsingException {
        class Accumulator {
            public final List<InsnTreeSource> results = new ArrayList<InsnTreeSource>(8);
            public boolean exact;
            final /* synthetic */ MutableScriptEnvironment this$0;

            Accumulator() {
                this.this$0 = this$0;
            }

            public boolean update(String n) throws ScriptParsingException {
                List<FunctionHandler.Named> handlers = this.this$0.functions.get(n);
                if (handlers != null) {
                    boolean exact = false;
                    int size = handlers.size();
                    for (int index = 0; index < size; ++index) {
                        CastResult casted = handlers.get(index).create(parser, name, arguments);
                        if (casted == null) continue;
                        if (!this.exact && !casted.requiredCasting) {
                            this.results.clear();
                            this.exact = true;
                        }
                        if (this.exact && casted.requiredCasting) continue;
                        this.results.add(new InsnTreeSource(casted.tree, handlers.get(index)));
                    }
                }
                return !this.results.isEmpty();
            }

            public InsnTree result() throws ScriptParsingException {
                return InsnTreeSource.get(parser, arguments, this.results);
            }
        }
        Accumulator accumulator = new Accumulator();
        if (accumulator.update(name)) {
            return accumulator.result();
        }
        if (accumulator.update(null)) {
            return accumulator.result();
        }
        return accumulator.result();
    }

    public InsnTree tryGetQualifiedFunction(ExpressionParser parser, TypeInfo owner, String name, InsnTree ... arguments) throws ScriptParsingException {
        List<FunctionHandler.Named> list = this.qualifiedFunctions.get(new NamedType(owner, name));
        if (list != null) {
            ArrayList<InsnTreeSource> results = new ArrayList<InsnTreeSource>(8);
            boolean exact = false;
            int size = list.size();
            for (int index = 0; index < size; ++index) {
                FunctionHandler.Named handler = list.get(index);
                CastResult result = handler.create(parser, name, arguments);
                if (result == null) continue;
                if (!exact && !result.requiredCasting) {
                    results.clear();
                    exact = true;
                }
                if (exact && result.requiredCasting) continue;
                results.add(new InsnTreeSource(result.tree, handler));
            }
            return InsnTreeSource.get(parser, arguments, results);
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getMethod(final ExpressionParser parser, final InsnTree receiver, final String name, final ScriptEnvironment.GetMethodMode mode, final InsnTree ... arguments) throws ScriptParsingException {
        TypeInfo type;
        InsnTree result;
        Iterator<TypeInfo> iterator;
        ConstantValue constant = receiver.getConstantValue();
        if (constant.isConstant() && (iterator = constant.asJavaObject()) instanceof TypeInfo && (result = this.tryGetQualifiedFunction(parser, type = (TypeInfo)((Object)iterator), name, arguments)) != null) {
            return result;
        }
        class Accumulator {
            public final NamedType query = new NamedType();
            public final List<InsnTreeSource> results = new ArrayList<InsnTreeSource>(8);
            public boolean exact;
            final /* synthetic */ MutableScriptEnvironment this$0;

            Accumulator() {
                this.this$0 = this$0;
            }

            public boolean update(String n, TypeInfo type) throws ScriptParsingException {
                this.query.name = n;
                this.query.owner = type;
                List<MethodHandler.Named> handlers = this.this$0.methods.get(this.query);
                if (handlers != null) {
                    int size = handlers.size();
                    for (int index = 0; index < size; ++index) {
                        CastResult casted = handlers.get(index).create(parser, receiver, name, mode, arguments);
                        if (casted == null) continue;
                        if (!this.exact && !casted.requiredCasting) {
                            this.results.clear();
                            this.exact = true;
                        }
                        if (this.exact && casted.requiredCasting) continue;
                        this.results.add(new InsnTreeSource(casted.tree, handlers.get(index)));
                    }
                }
                return !this.results.isEmpty();
            }

            public InsnTree result() throws ScriptParsingException {
                return InsnTreeSource.get(parser, arguments, this.results);
            }
        }
        Accumulator accumulator = new Accumulator();
        for (TypeInfo owner : receiver.getTypeInfo().getAllAssignableTypes()) {
            if (accumulator.update(name, owner)) {
                return accumulator.result();
            }
            if (!accumulator.update(null, owner)) continue;
            return accumulator.result();
        }
        if (accumulator.update(name, null)) {
            return accumulator.result();
        }
        if (accumulator.update(null, null)) {
            return accumulator.result();
        }
        return accumulator.result();
    }

    @Override
    @Nullable
    public TypeInfo getType(ExpressionParser parser, String name) throws ScriptParsingException {
        return this.types.get(name);
    }

    @Override
    @Nullable
    public InsnTree parseKeyword(ExpressionParser parser, String name) throws ScriptParsingException {
        KeywordHandler handler = this.keywords.get(name);
        return handler == null ? null : handler.create(parser, name);
    }

    @Override
    @Nullable
    public InsnTree parseMemberKeyword(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.MemberKeywordMode mode) throws ScriptParsingException {
        NamedType query = new NamedType();
        query.name = name;
        Iterator<TypeInfo> iterator = receiver.getTypeInfo().getAllAssignableTypes().iterator();
        while (iterator.hasNext()) {
            TypeInfo owner;
            query.owner = owner = iterator.next();
            List<MemberKeywordHandler.Named> handlers = this.memberKeywords.get(query);
            if (handlers == null) continue;
            for (MemberKeywordHandler.Named handler : handlers) {
                InsnTree result = handler.create(parser, receiver, name, mode);
                if (result == null) continue;
                return result;
            }
        }
        query.owner = null;
        List<MemberKeywordHandler.Named> handlers = this.memberKeywords.get(query);
        if (handlers != null) {
            for (MemberKeywordHandler.Named handler : handlers) {
                InsnTree result = handler.create(parser, receiver, name, mode);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
        for (TypeInfo from : value.getTypeInfo().getAllAssignableTypes()) {
            for (Map.Entry entry : this.casters.getOrDefault(from, Collections.emptyMap()).entrySet()) {
                if (implicit && !((CastHandlerHolder)entry.getValue()).implicit || !((TypeInfo)entry.getKey()).extendsOrImplements(to)) continue;
                return ((CastHandlerHolder)entry.getValue()).cast(parser, value, to, implicit, nullable);
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface VariableHandler {
        @Nullable
        public InsnTree create(ExpressionParser var1, String var2) throws ScriptParsingException;

        public record Named(String name, VariableHandler handler) implements VariableHandler
        {
            @Override
            @Nullable
            public InsnTree create(ExpressionParser parser, String name) throws ScriptParsingException {
                return this.handler.create(parser, name);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    public static class NamedType {
        @Nullable
        public TypeInfo owner;
        @Nullable
        public String name;

        public NamedType() {
        }

        public NamedType(@Nullable TypeInfo owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public int hashCode() {
            return Objects.hashCode(this.owner) * 31 + Objects.hashCode(this.name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof NamedType)) return false;
            NamedType that = (NamedType)obj;
            if (!Objects.equals(this.owner, that.owner)) return false;
            if (!Objects.equals(this.name, that.name)) return false;
            return true;
        }

        public String toString() {
            return (this.owner != null ? this.owner.getClassName() : "<any type>") + "." + this.name;
        }
    }

    @FunctionalInterface
    public static interface FieldHandler {
        @Nullable
        public InsnTree create(ExpressionParser var1, InsnTree var2, String var3, ScriptEnvironment.GetFieldMode var4) throws ScriptParsingException;

        public record Named(String name, FieldHandler handler) implements FieldHandler
        {
            @Override
            @Nullable
            public InsnTree create(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.GetFieldMode mode) throws ScriptParsingException {
                return this.handler.create(parser, receiver, name, mode);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    @FunctionalInterface
    public static interface KeywordHandler {
        @Nullable
        public InsnTree create(ExpressionParser var1, String var2) throws ScriptParsingException;

        public record Named(String name, KeywordHandler handler) implements KeywordHandler
        {
            @Override
            @Nullable
            public InsnTree create(ExpressionParser parser, String name) throws ScriptParsingException {
                return this.handler.create(parser, name);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    public static class CastHandlerHolder
    implements CastHandler {
        public CastHandler caster;
        public boolean implicit;

        public CastHandlerHolder(boolean implicit, CastHandler caster) {
            this.caster = caster;
            this.implicit = implicit;
        }

        @Override
        public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
            return this.caster.cast(parser, value, to, implicit, nullable);
        }

        public int hashCode() {
            return this.caster.hashCode() + Boolean.hashCode(this.implicit);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof CastHandlerHolder)) return false;
            CastHandlerHolder that = (CastHandlerHolder)obj;
            if (!this.caster.equals(that.caster)) return false;
            if (this.implicit != that.implicit) return false;
            return true;
        }

        public String toString() {
            return String.valueOf(this.caster) + (this.implicit ? " (implicit)" : " (explicit)");
        }
    }

    @FunctionalInterface
    public static interface FunctionHandler {
        @Nullable
        public CastResult create(ExpressionParser var1, String var2, InsnTree ... var3) throws ScriptParsingException;

        public record Named(String name, FunctionHandler handler) implements FunctionHandler
        {
            @Override
            @Nullable
            public CastResult create(ExpressionParser parser, String name, InsnTree ... arguments) throws ScriptParsingException {
                return this.handler.create(parser, name, arguments);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    @FunctionalInterface
    public static interface MethodHandler {
        @Nullable
        public CastResult create(ExpressionParser var1, InsnTree var2, String var3, ScriptEnvironment.GetMethodMode var4, InsnTree ... var5) throws ScriptParsingException;

        public record Named(String name, MethodHandler handler) implements MethodHandler
        {
            @Override
            @Nullable
            public CastResult create(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.GetMethodMode mode, InsnTree ... arguments) throws ScriptParsingException {
                return this.handler.create(parser, receiver, name, mode, arguments);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    @FunctionalInterface
    public static interface CastHandler {
        public InsnTree cast(ExpressionParser var1, InsnTree var2, TypeInfo var3, boolean var4, boolean var5);

        public record Named(String name, CastHandler handler) implements CastHandler
        {
            @Override
            public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
                return this.handler.cast(parser, value, to, implicit, nullable);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    public static class CastHandlerData
    extends CastHandlerHolder {
        public TypeInfo from;
        public TypeInfo to;

        public CastHandlerData(TypeInfo from, TypeInfo to, boolean implicit, CastHandler caster) {
            super(implicit, caster);
            this.from = from;
            this.to = to;
        }

        public CastHandlerData changeInput(TypeInfo from) {
            return new CastHandlerData(from, this.to, this.implicit, this.caster);
        }

        public CastHandlerData changeOutput(TypeInfo to) {
            return new CastHandlerData(this.from, to, this.implicit, this.caster);
        }

        @Override
        public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
            if (!value.getTypeInfo().equals(this.from)) {
                throw new IllegalArgumentException(String.valueOf(this) + " attempting to cast value of type " + String.valueOf(value.getTypeInfo()));
            }
            if (!to.equals(this.to)) {
                throw new IllegalArgumentException(String.valueOf(this) + " attempting to cast value to type " + String.valueOf(to));
            }
            if (!(value = this.caster.cast(parser, value, to, implicit, nullable)).getTypeInfo().equals(this.to)) {
                throw new IllegalArgumentException(String.valueOf(this) + " cast value to incorrect type " + String.valueOf(value.getTypeInfo()));
            }
            return value;
        }

        @Override
        public int hashCode() {
            int hash = this.caster.hashCode();
            hash = hash * 31 + Boolean.hashCode(this.implicit);
            hash = hash * 31 + this.from.hashCode();
            hash = hash * 31 + this.to.hashCode();
            return hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof CastHandlerData)) return false;
            CastHandlerData that = (CastHandlerData)obj;
            if (!this.caster.equals(that.caster)) return false;
            if (this.implicit != that.implicit) return false;
            if (!this.from.equals(that.from)) return false;
            if (!this.to.equals(that.to)) return false;
            return true;
        }

        @Override
        public String toString() {
            return String.valueOf(this.caster) + ": " + String.valueOf(this.from) + " -> " + String.valueOf(this.to) + (this.implicit ? " (implicit)" : " (explicit)");
        }
    }

    public record CastResult(InsnTree tree, boolean requiredCasting) {
    }

    public record InsnTreeSource(InsnTree tree, Object source) {
        public static InsnTree get(ExpressionParser parser, InsnTree[] arguments, List<InsnTreeSource> sources) throws ScriptParsingException {
            return switch (sources.size()) {
                case 0 -> null;
                case 1 -> sources.get((int)0).tree;
                default -> throw new ScriptParsingException("Ambiguous call matches the following:\n\t" + sources.stream().map(InsnTreeSource::source).map(Object::toString).collect(Collectors.joining("\n\t")) + "\nActual form: " + Arrays.stream(arguments).map(InsnTree::describe).collect(Collectors.joining(", ", "(", ")")), parser.input);
            };
        }
    }

    @FunctionalInterface
    public static interface MemberKeywordHandler {
        @Nullable
        public InsnTree create(ExpressionParser var1, InsnTree var2, String var3, ScriptEnvironment.MemberKeywordMode var4) throws ScriptParsingException;

        public record Named(String name, MemberKeywordHandler handler) implements MemberKeywordHandler
        {
            @Override
            @Nullable
            public InsnTree create(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.MemberKeywordMode mode) throws ScriptParsingException {
                return this.handler.create(parser, receiver, name, mode);
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    public static class MultiCastHandler
    implements CastHandler {
        public CastHandlerData[] casters;

        public MultiCastHandler(CastHandlerData ... casters) {
            this.casters = casters;
        }

        @Override
        public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
            for (CastHandlerData caster : this.casters) {
                value = caster.cast(parser, value, caster.to, implicit, nullable);
            }
            return value;
        }
    }
}

