/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.optimization.ClassOptimizer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class JumpToNextInstructionOptimizer
implements ClassOptimizer.MethodOptimizer {
    public static final JumpToNextInstructionOptimizer INSTANCE = new JumpToNextInstructionOptimizer();

    @Override
    public boolean optimize(MethodNode method) {
        boolean changedAny = false;
        AbstractInsnNode instruction = method.instructions.getFirst();
        while (instruction != null) {
            JumpInsnNode jump;
            AbstractInsnNode next = instruction.getNext();
            if (instruction instanceof JumpInsnNode && JumpToNextInstructionOptimizer.isJumpToNextInstruction(jump = (JumpInsnNode)instruction)) {
                switch (jump.getOpcode()) {
                    case 167: {
                        method.instructions.remove((AbstractInsnNode)jump);
                        break;
                    }
                    case 168: 
                    case 169: {
                        throw new UnsupportedOperationException("JSR/RET not supported.");
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 198: 
                    case 199: {
                        method.instructions.set((AbstractInsnNode)jump, (AbstractInsnNode)new InsnNode(87));
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: {
                        method.instructions.set((AbstractInsnNode)jump, (AbstractInsnNode)new InsnNode(88));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Non-jump opcode for JumpInsnNode: " + jump.getOpcode());
                    }
                }
                changedAny = true;
            }
            instruction = next;
        }
        return changedAny;
    }

    public static boolean isJumpToNextInstruction(JumpInsnNode jump) {
        LabelNode node = jump.label;
        while (true) {
            if (node == jump) {
                return true;
            }
            if (!(node instanceof LabelNode) && !(node instanceof LineNumberNode)) break;
            node = node.getPrevious();
        }
        return false;
    }
}

