/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.optimization.ClassOptimizer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class LineNumberOptimizer
implements ClassOptimizer.MethodOptimizer {
    public static final LineNumberOptimizer INSTANCE = new LineNumberOptimizer();

    @Override
    public boolean optimize(MethodNode method) {
        boolean changedAny = false;
        LineNumberNode previous = null;
        for (AbstractInsnNode node = method.instructions.getFirst(); node != null; node = node.getNext()) {
            if (node instanceof LineNumberNode) {
                LineNumberNode lineNumberNode = (LineNumberNode)node;
                if (previous != null) {
                    method.instructions.remove((AbstractInsnNode)previous);
                    changedAny = true;
                }
                previous = lineNumberNode;
                continue;
            }
            if (node instanceof LabelNode) continue;
            previous = null;
        }
        return changedAny;
    }
}

