/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.optimization.ClassOptimizer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

public class UnreachableCodeOptimizer
implements ClassOptimizer.MethodOptimizer {
    public static final UnreachableCodeOptimizer INSTANCE = new UnreachableCodeOptimizer();

    @Override
    public boolean optimize(MethodNode method) {
        if (method.instructions.size() == 0) {
            return false;
        }
        Set<AbstractInsnNode> visited = Collections.newSetFromMap(new IdentityHashMap(method.instructions.size()));
        UnreachableCodeOptimizer.collectAt(method.instructions.getFirst(), visited);
        if (visited.size() == method.instructions.size()) {
            return false;
        }
        boolean changed = false;
        AbstractInsnNode node = method.instructions.getFirst();
        while (node != null) {
            AbstractInsnNode next = node.getNext();
            if (!(node instanceof LabelNode) && !visited.contains(node)) {
                method.instructions.remove(node);
                changed = true;
            }
            node = next;
        }
        return changed;
    }

    public static void collectAt(AbstractInsnNode node, Set<AbstractInsnNode> visited) {
        while (node != null) {
            if (!visited.add(node)) {
                return;
            }
            node = switch (node.getOpcode()) {
                case 172, 173, 174, 175, 176, 177 -> null;
                case 168, 169 -> throw new UnsupportedOperationException("JSR/RET not supported.");
                case 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 198, 199 -> {
                    UnreachableCodeOptimizer.collectAt((AbstractInsnNode)((JumpInsnNode)node).label, visited);
                    yield node.getNext();
                }
                case 171 -> {
                    LookupSwitchInsnNode lookup = (LookupSwitchInsnNode)node;
                    for (LabelNode label : lookup.labels) {
                        UnreachableCodeOptimizer.collectAt((AbstractInsnNode)label, visited);
                    }
                    UnreachableCodeOptimizer.collectAt((AbstractInsnNode)lookup.dflt, visited);
                    yield null;
                }
                case 170 -> {
                    TableSwitchInsnNode table = (TableSwitchInsnNode)node;
                    for (LabelNode label : table.labels) {
                        UnreachableCodeOptimizer.collectAt((AbstractInsnNode)label, visited);
                    }
                    UnreachableCodeOptimizer.collectAt((AbstractInsnNode)table.dflt, visited);
                    yield null;
                }
                case 167 -> ((JumpInsnNode)node).label;
                default -> node.getNext();
            };
        }
    }
}

