/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclareAssignInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.InnerMethodExpressionParser;
import builderb0y.scripting.parsing.ScriptParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.input.ScriptTemplate;
import builderb0y.scripting.parsing.input.ScriptUsage;
import builderb0y.scripting.util.ArrayBuilder;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class TemplateScriptParser<I>
extends ScriptParser<I> {
    public final ScriptUsage usage;

    public TemplateScriptParser(Class<I> implementingClass, ScriptUsage usage, int flags) {
        super(implementingClass, usage.getSource(), usage.debug_name, flags);
        this.usage = usage;
    }

    @Override
    public TemplateScriptParser<I> addEnvironment(ScriptEnvironment environment) {
        return (TemplateScriptParser)super.addEnvironment(environment);
    }

    @Override
    public TemplateScriptParser<I> configureEnvironment(Consumer<MutableScriptEnvironment> configurator) {
        return (TemplateScriptParser)super.configureEnvironment((Consumer)configurator);
    }

    @Override
    public InsnTree parseEntireInput() throws ScriptParsingException {
        if (this.usage.getTemplate() != null) {
            ArrayBuilder<InsnTree> initializers = TemplateScriptParser.parseInitializers(this, this.usage);
            initializers.add(super.parseEntireInput());
            return InsnTrees.seq((InsnTree[])initializers.toArray((IntFunction<T1[]>)InsnTree.ARRAY_FACTORY));
        }
        return super.parseEntireInput();
    }

    public static ArrayBuilder<InsnTree> parseInitializers(ExpressionParser parser, ScriptUsage usage) throws ScriptParsingException {
        ArrayBuilder<InsnTree> initializers = new ArrayBuilder<InsnTree>();
        for (ScriptTemplate.RequiredInput input : ((ScriptTemplate)usage.getTemplate().comp_349()).getInputs()) {
            String inputSource = usage.getInputs().getOrDefault(input.name(), input.fallback());
            if (inputSource == null) {
                throw new ScriptParsingException("Missing input " + input.name(), null);
            }
            TypeInfo type = parser.environment.getType(parser, input.type());
            if (type == null) {
                throw new ScriptParsingException("Unknown type: " + input.type(), null);
            }
            InnerMethodExpressionParser parserCopy = new InnerMethodExpressionParser(parser, inputSource, type);
            MutableScriptEnvironment.FunctionHandler.Named handler = new MutableScriptEnvironment.FunctionHandler.Named("invalid", (parser_, name, arguments) -> {
                throw new ScriptParsingException(name + " is not allowed in script inputs", parser_.input);
            });
            parserCopy.environment.mutable().functions.put("return", Collections.singletonList(handler));
            parser.environment.user().reserveVariable(input.name(), type);
            InsnTree inputTree = parserCopy.nextScript().cast(parserCopy, type, InsnTree.CastMode.IMPLICIT_THROW, false);
            parser.environment.user().assignVariable(input.name());
            LazyVarInfo declaration = new LazyVarInfo(input.name(), type);
            VariableDeclareAssignInsnTree initializer = new VariableDeclareAssignInsnTree(declaration, inputTree);
            parser.environment.mutable().addVariable(input.name(), InsnTrees.load(declaration)).addVariable("$" + input.name(), inputTree);
            initializers.add(initializer);
        }
        return initializers;
    }
}

