/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.input;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.MultiLine;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.annotations.UseVerifier;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.codecs.TypelessCoderRegistry;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.input.FileScriptTemplate;
import builderb0y.scripting.parsing.input.ScriptFileResolver;
import builderb0y.scripting.parsing.input.SourceScriptTemplate;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

@UseVerifier(name="verify", in=ScriptTemplate.class, usage=MemberUsage.METHOD_IS_HANDLER)
@UseCoder(name="CODER", in=ScriptTemplate.class, usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public abstract class ScriptTemplate
implements DependencyView.SimpleDependencyView {
    public static final TypelessCoderRegistry<ScriptTemplate> CODER = new TypelessCoderRegistry(ReifiedType.from(ScriptTemplate.class), BigGlobeAutoCodec.AUTO_CODEC);
    public final @VerifyNullable List<RequiredInput> inputs;
    public final @VerifyNullable ScriptFileResolver.ResolvedIncludes includes;

    public ScriptTemplate(@Nullable List<RequiredInput> inputs, @VerifyNullable ScriptFileResolver.ResolvedIncludes includes) {
        this.inputs = inputs;
        this.includes = includes;
    }

    public static <T_Encoded> void verify(VerifyContext<T_Encoded, ScriptTemplate> context) throws VerifyException {
        ScriptTemplate template = (ScriptTemplate)context.object;
        if (template == null || template.inputs == null || template.inputs.isEmpty()) {
            return;
        }
        ObjectOpenHashSet names = new ObjectOpenHashSet(template.inputs.size());
        for (RequiredInput input : template.inputs) {
            if (names.add(input.name())) continue;
            throw new VerifyException(() -> "Duplicate input name: " + input.name());
        }
    }

    public abstract String getRawSource();

    public String getSource() {
        return this.includes != null ? this.includes.assemble(this.getRawSource()) : this.getRawSource();
    }

    @Nullable
    public List<RequiredInput> getInputs() {
        return this.inputs;
    }

    @Override
    public Stream<? extends class_6880<? extends DependencyView>> streamDirectDependencies() {
        return this.includes != null ? this.includes.streamDirectDependencies() : Stream.empty();
    }

    static {
        CODER.register(SourceScriptTemplate.class);
        CODER.register(FileScriptTemplate.class);
    }

    public record RequiredInput(@ExpressionParser.IdentifierName String name, String type, @UseName(value="default") @MultiLine @VerifyNullable String fallback) {
    }
}

