/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.special;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.flow.compare.DoubleCompareInsnTree;
import builderb0y.scripting.bytecode.tree.flow.compare.FloatCompareInsnTree;
import builderb0y.scripting.bytecode.tree.flow.compare.IntCompareInsnTree;
import builderb0y.scripting.bytecode.tree.flow.compare.IntCompareZeroInsnTree;
import builderb0y.scripting.bytecode.tree.flow.compare.LongCompareInsnTree;
import builderb0y.scripting.bytecode.tree.flow.compare.ObjectCompareInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import builderb0y.scripting.util.TypeMerger;

public record CompareSyntax(InsnTree left, InsnTree right, TypeInfo inputType, InsnTree greaterThan, InsnTree lessThan, InsnTree equal, InsnTree incomparable, TypeInfo outputType) {
    public static CompareSyntax parse(ExpressionParser parser) throws ScriptParsingException {
        InsnTree right;
        parser.beginCodeBlock();
        InsnTree left = parser.nextScript();
        if (parser.input.hasOperatorAfterWhitespace(",")) {
            right = parser.nextScript();
            parser.input.expectOperatorAfterWhitespace(":");
        } else if (parser.input.hasOperatorAfterWhitespace(":")) {
            if (!left.getTypeInfo().isNumber()) {
                throw new ScriptParsingException("Implicit comparison to 0 requires value to be a number.", parser.input);
            }
            right = InsnTrees.ldc(0, left.getTypeInfo());
        } else {
            throw new ScriptParsingException("Expected ',' or ':'", parser.input);
        }
        TypeInfo inputType = TypeMerger.computeMostSpecificType(left.getTypeInfo(), right.getTypeInfo());
        if (!inputType.isNumber() && !inputType.extendsOrImplements(TypeInfos.COMPARABLE)) {
            throw new ScriptParsingException("Can't compare " + String.valueOf(left.getTypeInfo()) + " and " + String.valueOf(right.getTypeInfo()), parser.input);
        }
        left = left.cast(parser, inputType, InsnTree.CastMode.IMPLICIT_THROW, false);
        right = right.cast(parser, inputType, InsnTree.CastMode.IMPLICIT_THROW, false);
        boolean expectIncomparable = inputType.isFloat() || inputType.isObject();
        InsnTree greaterThan = null;
        InsnTree lessThan = null;
        InsnTree equalTo = null;
        InsnTree incomparable = null;
        while (parser.input.hasIdentifierAfterWhitespace("case")) {
            parser.beginCodeBlock();
            switch (parser.input.readAfterWhitespace()) {
                case '>': {
                    parser.input.expectOperatorAfterWhitespace(":");
                    if (greaterThan != null) {
                        throw new ScriptParsingException("Case '>' already specified", parser.input);
                    }
                    greaterThan = parser.nextScript();
                    break;
                }
                case '<': {
                    parser.input.expectOperatorAfterWhitespace(":");
                    if (lessThan != null) {
                        throw new ScriptParsingException("Case '<' already specified", parser.input);
                    }
                    lessThan = parser.nextScript();
                    break;
                }
                case '=': {
                    parser.input.expectOperatorAfterWhitespace(":");
                    if (equalTo != null) {
                        throw new ScriptParsingException("Case '=' already specified", parser.input);
                    }
                    equalTo = parser.nextScript();
                    break;
                }
                case '!': {
                    if (!expectIncomparable) {
                        throw new ScriptParsingException("Case '!' is unreachable for " + String.valueOf(left.getTypeInfo()), parser.input);
                    }
                    parser.input.expectOperatorAfterWhitespace(":");
                    if (incomparable != null) {
                        throw new ScriptParsingException("Case '!' already specified", parser.input);
                    }
                    incomparable = parser.nextScript();
                    break;
                }
                default: {
                    throw new ScriptParsingException(expectIncomparable ? "Expected '>', '<', '=', or '!'" : "Expected '>', '<', or '='", parser.input);
                }
            }
            parser.endCodeBlock();
        }
        parser.endCodeBlock();
        if (greaterThan == null) {
            throw new ScriptParsingException("Missing case '>'", parser.input);
        }
        if (lessThan == null) {
            throw new ScriptParsingException("Missing case '<'", parser.input);
        }
        if (equalTo == null) {
            throw new ScriptParsingException("Missing case '='", parser.input);
        }
        if (incomparable == null && expectIncomparable) {
            throw new ScriptParsingException("Missing case '!'", parser.input);
        }
        TypeInfo outputType = expectIncomparable ? TypeMerger.computeMostSpecificType(greaterThan.getTypeInfo(), lessThan.getTypeInfo(), equalTo.getTypeInfo(), incomparable.getTypeInfo()) : TypeMerger.computeMostSpecificType(greaterThan.getTypeInfo(), lessThan.getTypeInfo(), equalTo.getTypeInfo());
        greaterThan = greaterThan.cast(parser, outputType, InsnTree.CastMode.IMPLICIT_THROW, false);
        lessThan = lessThan.cast(parser, outputType, InsnTree.CastMode.IMPLICIT_THROW, false);
        equalTo = equalTo.cast(parser, outputType, InsnTree.CastMode.IMPLICIT_THROW, false);
        if (expectIncomparable) {
            incomparable = incomparable.cast(parser, outputType, InsnTree.CastMode.IMPLICIT_THROW, false);
        }
        return new CompareSyntax(left, right, inputType, greaterThan, lessThan, equalTo, incomparable, outputType);
    }

    public InsnTree buildInsnTree() {
        return switch (this.inputType.getSort()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeInfo.Sort.BYTE, TypeInfo.Sort.CHAR, TypeInfo.Sort.SHORT, TypeInfo.Sort.INT -> {
                if (this.right.getConstantValue().isConstant() && this.right.getConstantValue().asInt() == 0) {
                    yield new IntCompareZeroInsnTree(this.left, this.lessThan, this.equal, this.greaterThan, this.outputType);
                }
                yield new IntCompareInsnTree(this.left, this.right, this.lessThan, this.equal, this.greaterThan, this.outputType);
            }
            case TypeInfo.Sort.LONG -> new LongCompareInsnTree(this.left, this.right, this.lessThan, this.equal, this.greaterThan, this.outputType);
            case TypeInfo.Sort.FLOAT -> new FloatCompareInsnTree(this.left, this.right, this.lessThan, this.equal, this.greaterThan, this.incomparable, this.outputType);
            case TypeInfo.Sort.DOUBLE -> new DoubleCompareInsnTree(this.left, this.right, this.lessThan, this.equal, this.greaterThan, this.incomparable, this.outputType);
            case TypeInfo.Sort.OBJECT -> new ObjectCompareInsnTree(this.left, this.right, this.lessThan, this.equal, this.greaterThan, this.incomparable, this.outputType);
            case TypeInfo.Sort.BOOLEAN, TypeInfo.Sort.VOID, TypeInfo.Sort.ARRAY -> throw new IllegalStateException(this.inputType.toString());
        };
    }
}

