/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.special;

import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import java.util.ArrayList;

public record ConstantMapSyntax(ConstantValue[] keysAndValues) {
    public static ConstantMapSyntax parse(ExpressionParser parser) throws ScriptParsingException {
        parser.input.expectAfterWhitespace('(');
        if (parser.input.hasAfterWhitespace(')')) {
            return new ConstantMapSyntax(new ConstantValue[0]);
        }
        ArrayList<ConstantValue> keysAndValues = new ArrayList<ConstantValue>();
        do {
            InsnTree key;
            ConstantValue constantKey;
            if ((constantKey = (key = parser.nextScript()).getConstantValue()) == null) {
                throw new ScriptParsingException("Not a constant key: " + key.describe(), parser.input);
            }
            parser.input.expectOperatorAfterWhitespace(":");
            InsnTree value = parser.nextScript();
            ConstantValue constantValue = value.getConstantValue();
            if (!constantValue.isConstantOrDynamic()) {
                throw new ScriptParsingException("Not a constant value: " + value.describe(), parser.input);
            }
            keysAndValues.add(constantKey);
            keysAndValues.add(constantValue);
        } while (parser.input.hasOperatorAfterWhitespace(","));
        if (!parser.input.hasAfterWhitespace(')')) {
            throw new ScriptParsingException("Expected ',' or ')'", parser.input);
        }
        return new ConstantMapSyntax(keysAndValues.toArray(new ConstantValue[keysAndValues.size()]));
    }
}

