/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.special;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ExpressionReader;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.CodeBlock;
import builderb0y.scripting.parsing.special.NamedValues;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public record PrefixedNamedValues(@Nullable InsnTree prefix, NamedValues.NamedValue[] values, boolean hasNewVariables) implements CodeBlock
{
    /*
     * Enabled aggressive block sorting
     */
    public static PrefixedNamedValues parse(ExpressionParser parser, @Nullable TypeInfo prefixType, @Nullable TypeInfo valueType, @Nullable NameChecker nameChecker) throws ScriptParsingException {
        ArrayList<NamedValues.NamedValue> namedValues;
        InsnTree prefix;
        block15: {
            parser.beginCodeBlock();
            if (parser.input.peekAfterWhitespace() == ')') {
                parser.endCodeBlock();
                return new PrefixedNamedValues(null, NamedValues.NamedValue.EMPTY_ARRAY, false);
            }
            ExpressionReader.CursorPos cursor = parser.input.getCursor();
            String firstName = parser.input.readIdentifierOrNullAfterWhitespace();
            if (firstName != null && parser.input.hasOperatorAfterWhitespace(":")) {
                prefix = null;
                if (nameChecker != null) {
                    nameChecker.checkName(parser, firstName);
                }
                InsnTree value = parser.nextScript();
                if (valueType != null) {
                    value = value.cast(parser, valueType, InsnTree.CastMode.IMPLICIT_THROW, false);
                }
                if (parser.input.hasOperatorAfterWhitespace(",")) {
                    namedValues = new ArrayList(8);
                    namedValues.add(new NamedValues.NamedValue(firstName, value));
                    break block15;
                } else {
                    if (parser.input.peekAfterWhitespace() == ')') {
                        boolean hasNewVariables = parser.endCodeBlock();
                        return new PrefixedNamedValues(null, new NamedValues.NamedValue[]{new NamedValues.NamedValue(firstName, value)}, hasNewVariables);
                    }
                    throw new ScriptParsingException("Expected ',' or ')'", parser.input);
                }
            }
            parser.input.setCursor(cursor);
            prefix = parser.nextScript();
            if (prefixType != null) {
                prefix = prefix.cast(parser, prefixType, InsnTree.CastMode.IMPLICIT_THROW, false);
            }
            if (parser.input.hasOperatorAfterWhitespace(",")) {
                namedValues = new ArrayList<NamedValues.NamedValue>(8);
            } else {
                if (parser.input.peekAfterWhitespace() == ')') {
                    boolean hasNewVariables = parser.endCodeBlock();
                    return new PrefixedNamedValues(prefix, NamedValues.NamedValue.EMPTY_ARRAY, hasNewVariables);
                }
                throw new ScriptParsingException("Expected ',' or ')'", parser.input);
            }
        }
        do {
            String name = parser.input.expectIdentifierAfterWhitespace();
            if (nameChecker != null) {
                nameChecker.checkName(parser, name);
            }
            parser.input.expectOperatorAfterWhitespace(":");
            InsnTree value = parser.nextScript();
            if (valueType != null) {
                value = value.cast(parser, valueType, InsnTree.CastMode.IMPLICIT_THROW, false);
            }
            namedValues.add(new NamedValues.NamedValue(name, value));
        } while (parser.input.hasOperatorAfterWhitespace(","));
        if (parser.input.peekAfterWhitespace() == ')') {
            boolean hasNewVariables = parser.endCodeBlock();
            return new PrefixedNamedValues(prefix, namedValues.toArray(NamedValues.NamedValue.EMPTY_ARRAY), hasNewVariables);
        }
        throw new ScriptParsingException("Expected ',' or ')'", parser.input);
    }

    @FunctionalInterface
    public static interface NameChecker {
        public void checkName(ExpressionParser var1, String var2) throws ScriptParsingException;
    }
}

