/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.NoSuchElementException;

public class StackMap<K, V>
extends Object2ObjectLinkedOpenHashMap<K, V> {
    public IntArrayList sizes;

    public StackMap() {
        this.sizes = new IntArrayList(16);
    }

    public StackMap(int expected) {
        super(expected);
        this.sizes = new IntArrayList(16);
    }

    public StackMap(StackMap<? extends K, ? extends V> from) {
        super(from);
        this.sizes = new IntArrayList((IntList)from.sizes);
    }

    public void push() {
        this.sizes.add(this.size());
    }

    public void pop() {
        int size = this.sizes.removeInt(this.sizes.size() - 1);
        while (this.size() > size) {
            this.removeLast();
        }
    }

    public V removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.last;
        Object value = this.value[pos];
        this.value[pos] = null;
        --this.size;
        this.fixPointers(pos);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill >> 2 && this.n > 16) {
            this.rehash(this.n >> 1);
        }
        return (V)value;
    }

    public boolean hasNewElements() {
        return this.size() > this.sizes.getInt(this.sizes.size() - 1);
    }

    public void clear() {
        super.clear();
        this.sizes.clear();
    }
}

