/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.util;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.util.CollectionTransformer;
import builderb0y.scripting.util.TypeInfos;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TypeMerger {
    public static final Object2IntMap<TypeInfo> PRIMITIVE_WIDENING = new Object2IntOpenHashMap(8);
    public static final Object2ObjectMap<TypeInfo, TypeInfo> PRIMITIVE_WRAPPING;

    public static Set<TypeInfo> computeAllCommonTypes(TypeInfo ... types) {
        int length = types.length;
        if (length == 0) {
            return Collections.emptySet();
        }
        if (length == 1) {
            return types[0].getAllAssignableTypes();
        }
        HashSet<TypeInfo> set = new HashSet<TypeInfo>(types[0].getAllAssignableTypes());
        for (int index = 1; index < length; ++index) {
            set.retainAll(types[index].getAllAssignableTypes());
        }
        return set;
    }

    public static TypeInfo computeMostSpecificType(TypeInfo ... types) {
        if (types.length == 0) {
            throw new NoSuchElementException();
        }
        if (types.length == 1) {
            return types[0];
        }
        if (TypeMerger.tryAllSame(types)) {
            return types[0];
        }
        if (TypeMerger.tryVoid(types)) {
            return TypeInfos.VOID;
        }
        TypeInfo primitive = TypeMerger.tryPrimitive(types);
        if (primitive != null) {
            return primitive;
        }
        TypeInfo[] array = TypeMerger.extractComponents(types = TypeMerger.wrapAll(types));
        if (array != null) {
            return TypeInfo.makeArray(TypeMerger.computeMostSpecificType(array));
        }
        return TypeMerger.tryObject(types);
    }

    public static Set<TypeInfo> computeMostSpecificTypes(TypeInfo ... types) {
        if (types.length == 0) {
            throw new NoSuchElementException();
        }
        if (types.length == 1) {
            return Collections.singleton(types[0]);
        }
        if (TypeMerger.tryAllSame(types)) {
            return Collections.singleton(types[0]);
        }
        if (TypeMerger.tryVoid(types)) {
            return Collections.singleton(TypeInfos.VOID);
        }
        TypeInfo primitive = TypeMerger.tryPrimitive(types);
        if (primitive != null) {
            return Collections.singleton(primitive);
        }
        TypeInfo[] array = TypeMerger.extractComponents(types = TypeMerger.wrapAll(types));
        if (array != null) {
            return CollectionTransformer.convertCollection(TypeMerger.computeMostSpecificTypes(array), HashSet::new, TypeInfo::makeArray);
        }
        return TypeMerger.tryObjects(types);
    }

    public static boolean tryAllSame(TypeInfo ... types) {
        TypeInfo type = types[0];
        int length = types.length;
        for (int index = 1; index < length; ++index) {
            if (types[index].equals(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryVoid(TypeInfo ... types) {
        for (TypeInfo type : types) {
            if (!type.isVoid()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static TypeInfo tryPrimitive(TypeInfo ... types) {
        TypeInfo best = null;
        int bestValue = -1;
        for (TypeInfo type : types) {
            if (type.isPrimitive()) {
                int value = PRIMITIVE_WIDENING.getInt((Object)type);
                if (value <= bestValue) continue;
                best = type;
                bestValue = value;
                continue;
            }
            return null;
        }
        return best;
    }

    public static TypeInfo[] wrapAll(TypeInfo[] types) {
        TypeInfo[] result = types;
        int length = types.length;
        for (int index = 0; index < length; ++index) {
            TypeInfo newType = (TypeInfo)PRIMITIVE_WRAPPING.get((Object)types[index]);
            if (newType == null) continue;
            if (result == types) {
                result = (TypeInfo[])result.clone();
            }
            result[index] = newType;
        }
        return result;
    }

    public static TypeInfo @Nullable [] extractComponents(TypeInfo[] types) {
        for (TypeInfo type2 : types) {
            if (type2.isArray() && !type2.componentType.isPrimitive()) continue;
            return null;
        }
        return CollectionTransformer.convertArray(types, TypeInfo.ARRAY_FACTORY, type -> type.componentType);
    }

    public static Set<TypeInfo> tryObjects(TypeInfo[] types) {
        assert (types.length > 1);
        Set<TypeInfo> set = TypeMerger.computeAllCommonTypes(types);
        set.remove(TypeInfos.VOID);
        set.remove(TypeInfos.OBJECT);
        for (TypeInfo placeholder : set.toArray(new TypeInfo[set.size()])) {
            set.remove(placeholder.superClass);
            for (TypeInfo anInterface : placeholder.superInterfaces) {
                set.remove(anInterface);
            }
        }
        if (set.isEmpty()) {
            set.add(TypeInfos.OBJECT);
        }
        return set;
    }

    public static TypeInfo tryObject(TypeInfo[] types) {
        Set<TypeInfo> set = TypeMerger.tryObjects(types);
        return set.size() == 1 ? set.iterator().next() : set.stream().max(Comparator.comparingInt(placeholder -> placeholder.type.isInterface ? 0 : 1).thenComparing(TypeInfo::getInternalName)).orElseThrow();
    }

    static {
        PRIMITIVE_WIDENING.put((Object)TypeInfos.BOOLEAN, 0);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.BYTE, 1);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.CHAR, 2);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.SHORT, 3);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.INT, 4);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.LONG, 5);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.FLOAT, 6);
        PRIMITIVE_WIDENING.put((Object)TypeInfos.DOUBLE, 7);
        PRIMITIVE_WRAPPING = new Object2ObjectOpenHashMap(8);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.BOOLEAN, (Object)TypeInfos.BOOLEAN_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.BYTE, (Object)TypeInfos.BYTE_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.CHAR, (Object)TypeInfos.CHAR_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.SHORT, (Object)TypeInfos.SHORT_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.INT, (Object)TypeInfos.INT_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.LONG, (Object)TypeInfos.LONG_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.FLOAT, (Object)TypeInfos.FLOAT_WRAPPER);
        PRIMITIVE_WRAPPING.put((Object)TypeInfos.DOUBLE, (Object)TypeInfos.DOUBLE_WRAPPER);
    }
}

