/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe;

import builderb0y.autocodec.annotations.Hidden;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.annotations.Wrapper;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnEntryRegistry;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.VoronoiSettings;
import builderb0y.bigglobe.columns.scripted.decisionTrees.DecisionTreeSettings;
import builderb0y.bigglobe.columns.scripted.dependencies.IndirectDependencyCollector;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.columns.scripted.traits.WorldTrait;
import builderb0y.bigglobe.columns.scripted.traits.WorldTraitProvider;
import builderb0y.bigglobe.columns.scripted.traits.WorldTraits;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.dynamicRegistries.BigGlobeDynamicRegistries;
import builderb0y.bigglobe.hyperspace.PlayerWaypointManager;
import builderb0y.bigglobe.hyperspace.ServerPlayerWaypointManager;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.mixinInterfaces.DimensionalBlockView;
import builderb0y.bigglobe.networking.base.BigGlobeNetwork;
import builderb0y.bigglobe.networking.packets.DangerousRapidsPacket;
import builderb0y.bigglobe.networking.packets.SettingsSyncS2CPacketHandler;
import builderb0y.bigglobe.networking.packets.TimeSpeedS2CPacketHandler;
import builderb0y.bigglobe.rendering.lods.LodGenerator;
import builderb0y.bigglobe.scripting.environments.ColorScriptEnvironment;
import builderb0y.bigglobe.scripting.environments.MinecraftScriptEnvironment;
import builderb0y.bigglobe.scripting.environments.RandomScriptEnvironment;
import builderb0y.bigglobe.scripting.environments.StatelessRandomScriptEnvironment;
import builderb0y.bigglobe.util.ClientWorldEvents;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.environments.MathScriptEnvironment;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.input.FileScriptUsage;
import builderb0y.scripting.parsing.input.ScriptFileResolver;
import builderb0y.scripting.parsing.input.ScriptTemplate;
import builderb0y.scripting.parsing.input.ScriptUsage;
import builderb0y.scripting.util.InfoHolder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1163;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ClientState {
    public static final Map<class_5321<class_1937>, ClientState> INSTANCES = new HashMap<class_5321<class_1937>, ClientState>();
    public static final ReentrantReadWriteLock INSTANCE_LOCK = new ReentrantReadWriteLock();
    public ClientGeneratorParams generatorParams;
    public double timeSpeed = 1.0;
    public boolean dangerousRapids;

    @Nullable
    public static ClientState get(class_5321<class_1937> key) {
        INSTANCE_LOCK.readLock().lock();
        try {
            ClientState clientState = INSTANCES.get(key);
            return clientState;
        }
        finally {
            INSTANCE_LOCK.readLock().unlock();
        }
    }

    @Nullable
    public static ClientState get(class_1922 world) {
        return world != null ? ClientState.get(((DimensionalBlockView)world).bigglobe_getDimension()) : null;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static ClientState get() {
        return ClientState.get((class_1922)class_310.method_1551().field_1687);
    }

    @NotNull
    public static ClientState getOrCreate(class_5321<class_1937> key) {
        INSTANCE_LOCK.readLock().lock();
        try {
            ClientState clientState = INSTANCES.computeIfAbsent(key, key_ -> new ClientState());
            return clientState;
        }
        finally {
            INSTANCE_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public static ClientState getOrCreate(@NotNull class_1937 world) {
        return ClientState.getOrCreate((class_5321<class_1937>)world.method_27983());
    }

    public static void reset() {
        INSTANCE_LOCK.writeLock().lock();
        try {
            INSTANCES.clear();
        }
        finally {
            INSTANCE_LOCK.writeLock().unlock();
        }
    }

    public static void retain(Set<class_5321<class_1937>> worlds) {
        INSTANCE_LOCK.writeLock().lock();
        try {
            INSTANCES.keySet().retainAll(worlds);
            for (class_5321<class_1937> world : worlds) {
                INSTANCES.putIfAbsent(world, new ClientState());
            }
        }
        finally {
            INSTANCE_LOCK.writeLock().unlock();
        }
    }

    public static void forEach(Consumer<ClientState> action) {
        INSTANCE_LOCK.readLock().lock();
        try {
            INSTANCES.values().forEach(action);
        }
        finally {
            INSTANCE_LOCK.readLock().unlock();
        }
    }

    public static void sync(class_3218 world, class_3222 player) {
        BigGlobeNetwork.LOGGER.debug("Syncing ClientState to " + String.valueOf(player));
        SettingsSyncS2CPacketHandler.INSTANCE.send(world, player);
        TimeSpeedS2CPacketHandler.INSTANCE.send(player);
        DangerousRapidsPacket.INSTANCE.send(player);
        ClientState.syncWaypoints(world, player);
    }

    public static void syncWaypoints(class_3218 world, class_3222 player) {
        PlayerWaypointManager playerWaypointManager = PlayerWaypointManager.get((class_1657)player);
        if (playerWaypointManager instanceof ServerPlayerWaypointManager) {
            ServerPlayerWaypointManager manager = (ServerPlayerWaypointManager)playerWaypointManager;
            manager.updateOnWorldChange(world);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientWorldEvents.WORLD_CHANGED.register((oldWorld, newWorld) -> {
            if (newWorld == null) {
                BigGlobeMod.LOGGER.info("Resetting ClientState on disconnect.");
                ClientState.reset();
            }
        });
    }

    public static void overrideColor(class_1922 world, int x, int y, int z, class_6539 colorResolver, CallbackInfoReturnable<Integer> callback) {
        if (LodGenerator.RENDERING_LODS.get().booleanValue()) {
            return;
        }
        class_5321<class_1937> dimension = ((DimensionalBlockView)world).bigglobe_getDimension();
        if (dimension == null) {
            return;
        }
        ClientState state = ClientState.get(dimension);
        if (state == null) {
            return;
        }
        ClientGeneratorParams params = state.generatorParams;
        if (params != null) {
            if (colorResolver == class_1163.field_5665) {
                if (params.grassColor != null) {
                    callback.setReturnValue((Object)params.grassColor.getColor(params.getColumn(x, z), y));
                }
            } else if (colorResolver == class_1163.field_5664) {
                if (params.foliageColor != null) {
                    callback.setReturnValue((Object)params.foliageColor.getColor(params.getColumn(x, z), y));
                }
            } else if (colorResolver == class_1163.field_5666 && params.waterColor != null) {
                callback.setReturnValue((Object)params.waterColor.getColor(params.getColumn(x, z), y));
            }
        }
    }

    static {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientState.initClient();
        }
    }

    public static class ClientGeneratorParams {
        public static final AutoCoder<@Nullable ClientGeneratorParams> NULLABLE_CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder((ReifiedType)new ReifiedType<ClientGeneratorParams>(){});
        public final int minY;
        public final int maxY;
        public final @VerifyNullable Integer seaLevel;
        public final long columnSeed;
        public final @VerifyNullable ColorScript.Holder grassColor;
        public final @VerifyNullable ColorScript.Holder foliageColor;
        public final @VerifyNullable ColorScript.Holder waterColor;
        public final Map<class_6880<WorldTrait>, WorldTraitProvider> worldTraits;
        public final @VerifyNullable class_6880<Layer> layer;
        public transient ColumnEntryRegistry columnEntryRegistry;
        public transient WorldTraits compiledWorldTraits;
        public final transient ThreadLocal<ScriptedColumn> column;

        public ClientGeneratorParams(int minY, int maxY, @VerifyNullable Integer seaLevel, long columnSeed, @VerifyNullable ColorScript.Holder grassColor, @VerifyNullable ColorScript.Holder foliageColor, @VerifyNullable ColorScript.Holder waterColor, Map<class_6880<WorldTrait>, WorldTraitProvider> worldTraits, @VerifyNullable class_6880<Layer> layer) {
            this.minY = minY;
            this.maxY = maxY;
            this.seaLevel = seaLevel;
            this.columnSeed = columnSeed;
            this.grassColor = grassColor;
            this.foliageColor = foliageColor;
            this.waterColor = waterColor;
            this.worldTraits = worldTraits;
            this.layer = layer;
            this.column = ThreadLocal.withInitial(this::createColumn);
        }

        @Hidden
        public ClientGeneratorParams(BigGlobeScriptedChunkGenerator generator, Syncing syncing) {
            this.minY = generator.height.min_y();
            this.maxY = generator.height.max_y();
            this.seaLevel = generator.height.sea_level();
            this.columnSeed = generator.columnSeed;
            this.grassColor = generator.colors != null ? generator.colors.grass() : null;
            this.foliageColor = generator.colors != null ? generator.colors.foliage() : null;
            this.waterColor = generator.colors != null ? generator.colors.water() : null;
            this.worldTraits = new HashMap<class_6880<WorldTrait>, WorldTraitProvider>(generator.world_traits != null ? generator.loadedWorldTraits.size() : 0);
            if (generator.world_traits != null) {
                for (Map.Entry<class_6880<WorldTrait>, WorldTraitProvider> entry : generator.loadedWorldTraits.entrySet()) {
                    if (!syncing.worldTraits.containsKey(UnregisteredObjectException.getID(entry.getKey()))) continue;
                    this.worldTraits.put(entry.getKey(), entry.getValue());
                }
            }
            this.layer = syncing.containsLayers ? generator.layer : null;
            this.column = null;
        }

        public void compile(ColumnEntryRegistry.Loading loading) throws Exception {
            if (this.grassColor == null && this.foliageColor == null && this.waterColor == null && this.layer == null) {
                return;
            }
            loading.compile();
            this.columnEntryRegistry = loading.getRegistry();
            this.compiledWorldTraits = this.columnEntryRegistry.traitManager.createTraits(this.worldTraits);
        }

        public ScriptedColumn createColumn() {
            if (this.columnEntryRegistry == null) {
                throw new IllegalStateException("Not compiled");
            }
            return this.columnEntryRegistry.columnFactory.create(new ScriptedColumn.Params(this.columnSeed, 0, 0, this.minY, this.maxY, ScriptedColumn.ColumnUsage.GENERIC.normalHints(), this.compiledWorldTraits));
        }

        public ScriptedColumn getColumn(int x, int z) {
            ScriptedColumn column = this.column.get();
            column.setParams(column.params.at(x, z));
            return column;
        }
    }

    public static interface ColorScript
    extends ColumnScript {
        public static final Info INFO = new Info();

        public int getColor(ScriptedColumn var1, int var2);

        public static int getDefaultGrassColor(double temperature, double foliage) {
            return class_1933.method_8377((double)Interpolator.clamp(0.0, 1.0, temperature), (double)Interpolator.clamp(0.0, 1.0, foliage));
        }

        public static int getDefaultFoliageColor(double temperature, double foliage) {
            return class_1926.method_8344((double)Interpolator.clamp(0.0, 1.0, temperature), (double)Interpolator.clamp(0.0, 1.0, foliage));
        }

        public static class Info
        extends InfoHolder {
            public MethodInfo getDefaultGrassColor;
            public MethodInfo getDefaultFoliageColor;

            public void addAllTo(MutableScriptEnvironment environment) {
                environment.addFunctionInvokeStatic(this.getDefaultGrassColor).addFunctionInvokeStatic(this.getDefaultFoliageColor);
            }
        }

        @Wrapper
        public static class Holder
        extends ColumnScript.BaseHolder<ColorScript>
        implements ColorScript {
            public Holder(ScriptUsage usage) {
                super(usage);
            }

            @Override
            public int getColor(ScriptedColumn column, int y) {
                try {
                    return ((ColorScript)this.script).getColor(column, y) | 0xFF000000;
                }
                catch (Throwable throwable) {
                    this.onError(throwable);
                    return -16777216;
                }
            }

            @Override
            public Class<ColorScript> getScriptClass() {
                return ColorScript.class;
            }

            @Override
            public void addExtraFunctionsToEnvironment(ColumnScript.ImplParameters parameters, MutableScriptEnvironment environment) {
                environment.addAll(MathScriptEnvironment.INSTANCE).addAll(StatelessRandomScriptEnvironment.INSTANCE).configure(parameters.random != null ? MinecraftScriptEnvironment.createWithRandom(InsnTrees.load(parameters.random)) : MinecraftScriptEnvironment.create()).configure(ScriptedColumn.baseEnvironment(InsnTrees.load(parameters.actualColumn))).addAll(ColorScriptEnvironment.ENVIRONMENT);
                if (parameters.y != null) {
                    environment.addVariableLoad(parameters.y);
                }
                if (parameters.random != null) {
                    environment.configure(RandomScriptEnvironment.create(InsnTrees.load(parameters.random)));
                }
                INFO.addAllTo(environment);
            }
        }
    }

    public static class Syncing {
        public static final AutoCoder<Syncing> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(Syncing.class);
        public boolean containsLayers;
        public Map<class_2960, String> includes;
        public Map<class_2960, class_2520> templates;
        public Map<class_2960, class_2520> columnEntries;
        public Map<class_2960, class_2520> voronoiSettings;
        public Map<class_2960, class_2520> decisionTrees;
        public Map<class_2960, class_2520> worldTraits;
        public Map<class_2960, class_2520> layers;
        public transient class_2370<ScriptTemplate> templateRegistry = new class_2370(BigGlobeDynamicRegistries.SCRIPT_TEMPLATE_REGISTRY_KEY, Lifecycle.experimental());
        public transient class_2370<ColumnEntry> columnEntryRegistry = new class_2370(BigGlobeDynamicRegistries.COLUMN_ENTRY_REGISTRY_KEY, Lifecycle.experimental());
        public transient class_2370<VoronoiSettings> voronoiSettingsRegistry = new class_2370(BigGlobeDynamicRegistries.VORONOI_SETTINGS_REGISTRY_KEY, Lifecycle.experimental());
        public transient class_2370<DecisionTreeSettings> decisionTreeRegistry = new class_2370(BigGlobeDynamicRegistries.DECISION_TREE_SETTINGS_REGISTRY_KEY, Lifecycle.experimental());
        public transient class_2370<WorldTrait> worldTraitRegistry = new class_2370(BigGlobeDynamicRegistries.WORLD_TRAIT_REGISTRY_KEY, Lifecycle.experimental());
        public transient class_2370<Layer> layerRegistry = new class_2370(BigGlobeDynamicRegistries.LAYER_REGISTRY_KEY, Lifecycle.experimental());

        public Syncing(boolean containsLayers, Map<class_2960, String> includes, Map<class_2960, class_2520> templates, Map<class_2960, class_2520> columnEntries, Map<class_2960, class_2520> voronoiSettings, Map<class_2960, class_2520> decisionTrees, Map<class_2960, class_2520> worldTraits, Map<class_2960, class_2520> layers) {
            this.containsLayers = containsLayers;
            this.includes = includes;
            this.templates = templates;
            this.columnEntries = columnEntries;
            this.voronoiSettings = voronoiSettings;
            this.decisionTrees = decisionTrees;
            this.worldTraits = worldTraits;
            this.layers = layers;
        }

        @Hidden
        public Syncing(BigGlobeScriptedChunkGenerator generator) {
            this(BigGlobeConfig.INSTANCE.get().lodRendering.renderingEnabled(), new HashMap<class_2960, String>(), new HashMap<class_2960, class_2520>(), new HashMap<class_2960, class_2520>(), new HashMap<class_2960, class_2520>(), new HashMap<class_2960, class_2520>(), new HashMap<class_2960, class_2520>(), new HashMap<class_2960, class_2520>());
            if (generator.colors != null || this.containsLayers) {
                IndirectDependencyCollector collector = new IndirectDependencyCollector(generator);
                if (generator.colors != null) {
                    if (generator.colors.grass() != null) {
                        generator.colors.grass().streamDirectDependencies().forEach(collector);
                    }
                    if (generator.colors.foliage() != null) {
                        generator.colors.foliage().streamDirectDependencies().forEach(collector);
                    }
                    if (generator.colors.water() != null) {
                        generator.colors.water().streamDirectDependencies().forEach(collector);
                    }
                }
                if (this.containsLayers) {
                    collector.accept(generator.layer);
                }
                generator.columnEntryRegistry.registries.getRegistry(BigGlobeDynamicRegistries.VORONOI_SETTINGS_REGISTRY_KEY).streamEntries().filter(entry -> collector.contains(((VoronoiSettings)entry.comp_349()).owner())).forEach(collector);
                for (class_6880 entry2 : collector) {
                    Object object = entry2.comp_349();
                    if (object instanceof ScriptFileResolver.ResolvedInclude) {
                        ScriptFileResolver.ResolvedInclude include = (ScriptFileResolver.ResolvedInclude)object;
                        this.includes.put(include.id(), include.source());
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof FileScriptUsage) {
                        FileScriptUsage file = (FileScriptUsage)object;
                        this.includes.put(file.file, file.getSource());
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof ScriptTemplate) {
                        ScriptTemplate template = (ScriptTemplate)object;
                        class_2378.method_10230(this.templateRegistry, (class_2960)UnregisteredObjectException.getID(entry2), (Object)template);
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof ColumnEntry) {
                        ColumnEntry columnEntry = (ColumnEntry)object;
                        class_2378.method_10230(this.columnEntryRegistry, (class_2960)UnregisteredObjectException.getID(entry2), (Object)columnEntry);
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof VoronoiSettings) {
                        VoronoiSettings voronoiSettings = (VoronoiSettings)object;
                        class_2378.method_10230(this.voronoiSettingsRegistry, (class_2960)UnregisteredObjectException.getID(entry2), (Object)voronoiSettings);
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof DecisionTreeSettings) {
                        DecisionTreeSettings decisionTree = (DecisionTreeSettings)object;
                        class_2378.method_10230(this.decisionTreeRegistry, (class_2960)UnregisteredObjectException.getID(entry2), (Object)decisionTree);
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof WorldTrait) {
                        WorldTrait trait = (WorldTrait)object;
                        class_2378.method_10230(this.worldTraitRegistry, (class_2960)UnregisteredObjectException.getID(entry2), (Object)trait);
                        continue;
                    }
                    object = entry2.comp_349();
                    if (object instanceof Layer) {
                        Layer layer = (Layer)object;
                        class_2378.method_10230(this.layerRegistry, (class_2960)UnregisteredObjectException.getID(entry2), (Object)layer);
                        continue;
                    }
                    throw new IllegalStateException("Unhandled dependency view type: " + String.valueOf(entry2.comp_349()));
                }
                class_6903 ops = this.createOps((DynamicOps)class_2509.field_11560, false);
                for (Map.Entry entry3 : this.templateRegistry.method_29722()) {
                    this.templates.put(((class_5321)entry3.getKey()).method_29177(), (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(ScriptTemplate.CODER, (Object)((ScriptTemplate)entry3.getValue()), ops));
                }
                for (Map.Entry entry3 : this.columnEntryRegistry.method_29722()) {
                    this.columnEntries.put(((class_5321)entry3.getKey()).method_29177(), (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(ColumnEntry.REGISTRY, (Object)((ColumnEntry)entry3.getValue()), ops));
                }
                for (Map.Entry entry3 : this.voronoiSettingsRegistry.method_29722()) {
                    this.voronoiSettings.put(((class_5321)entry3.getKey()).method_29177(), (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(VoronoiSettings.CODER, (Object)((VoronoiSettings)entry3.getValue()), ops));
                }
                for (Map.Entry entry3 : this.decisionTreeRegistry.method_29722()) {
                    this.decisionTrees.put(((class_5321)entry3.getKey()).method_29177(), (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(DecisionTreeSettings.CODER, (Object)((DecisionTreeSettings)entry3.getValue()), ops));
                }
                for (Map.Entry entry3 : this.worldTraitRegistry.method_29722()) {
                    this.worldTraits.put(((class_5321)entry3.getKey()).method_29177(), (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(WorldTrait.CODER, (Object)((WorldTrait)entry3.getValue()), ops));
                }
                for (Map.Entry entry3 : this.layerRegistry.method_29722()) {
                    this.layers.put(((class_5321)entry3.getKey()).method_29177(), (class_2520)BigGlobeAutoCodec.AUTO_CODEC.encode(Layer.REGISTRY, (Object)((Layer)entry3.getValue()), ops));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() throws DecodeException {
            try {
                ScriptFileResolver.OVERRIDES.set(this.includes);
                class_6903 ops = this.createOps((DynamicOps)class_2509.field_11560, true);
                for (Map.Entry<class_2960, class_2520> entry : this.templates.entrySet()) {
                    class_2378.method_10230(this.templateRegistry, (class_2960)entry.getKey(), (Object)((ScriptTemplate)BigGlobeAutoCodec.AUTO_CODEC.decode(ScriptTemplate.CODER, (Object)entry.getValue(), ops)));
                }
                for (Map.Entry<class_2960, class_2520> entry : this.columnEntries.entrySet()) {
                    class_2378.method_10230(this.columnEntryRegistry, (class_2960)entry.getKey(), (Object)((ColumnEntry)BigGlobeAutoCodec.AUTO_CODEC.decode(ColumnEntry.REGISTRY, (Object)entry.getValue(), ops)));
                }
                for (Map.Entry<class_2960, class_2520> entry : this.voronoiSettings.entrySet()) {
                    class_2378.method_10230(this.voronoiSettingsRegistry, (class_2960)entry.getKey(), (Object)((VoronoiSettings)BigGlobeAutoCodec.AUTO_CODEC.decode(VoronoiSettings.CODER, (Object)entry.getValue(), ops)));
                }
                for (Map.Entry<class_2960, class_2520> entry : this.decisionTrees.entrySet()) {
                    class_2378.method_10230(this.decisionTreeRegistry, (class_2960)entry.getKey(), (Object)((DecisionTreeSettings)BigGlobeAutoCodec.AUTO_CODEC.decode(DecisionTreeSettings.CODER, (Object)entry.getValue(), ops)));
                }
                for (Map.Entry<class_2960, class_2520> entry : this.worldTraits.entrySet()) {
                    class_2378.method_10230(this.worldTraitRegistry, (class_2960)entry.getKey(), (Object)((WorldTrait)BigGlobeAutoCodec.AUTO_CODEC.decode(WorldTrait.CODER, (Object)entry.getValue(), ops)));
                }
                for (Map.Entry<class_2960, class_2520> entry : this.layers.entrySet()) {
                    class_2378.method_10230(this.layerRegistry, (class_2960)entry.getKey(), (Object)((Layer)BigGlobeAutoCodec.AUTO_CODEC.decode(Layer.REGISTRY, (Object)entry.getValue(), ops)));
                }
                this.templateRegistry.method_40276();
                this.columnEntryRegistry.method_40276();
                this.voronoiSettingsRegistry.method_40276();
                this.decisionTreeRegistry.method_40276();
                this.worldTraitRegistry.method_40276();
                this.layerRegistry.method_40276();
            }
            finally {
                ScriptFileResolver.OVERRIDES.set(null);
            }
        }

        @Nullable
        public <T_Element> class_2370<T_Element> getRegistry(class_5321<? extends class_2378<? extends T_Element>> key) {
            class_5321<? extends class_2378<? extends T_Element>> wildcard = key;
            Object registry = wildcard == BigGlobeDynamicRegistries.SCRIPT_TEMPLATE_REGISTRY_KEY ? this.templateRegistry : (wildcard == BigGlobeDynamicRegistries.COLUMN_ENTRY_REGISTRY_KEY ? this.columnEntryRegistry : (wildcard == BigGlobeDynamicRegistries.VORONOI_SETTINGS_REGISTRY_KEY ? this.voronoiSettingsRegistry : (wildcard == BigGlobeDynamicRegistries.DECISION_TREE_SETTINGS_REGISTRY_KEY ? this.decisionTreeRegistry : (wildcard == BigGlobeDynamicRegistries.WORLD_TRAIT_REGISTRY_KEY ? this.worldTraitRegistry : (wildcard == BigGlobeDynamicRegistries.LAYER_REGISTRY_KEY ? this.layerRegistry : null)))));
            return registry;
        }

        public <T_Encoded> class_6903<T_Encoded> createOps(DynamicOps<T_Encoded> delegate, final boolean mutable) {
            return class_6903.method_40414(delegate, (class_6903.class_7863)new class_6903.class_7863(){
                final /* synthetic */ Syncing this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public <T_Registry> Optional<class_6903.class_7862<T_Registry>> method_46623(class_5321<? extends class_2378<? extends T_Registry>> key) {
                    class_2370 simple;
                    class_2370 registry = this.this$0.getRegistry(key);
                    if (registry != null) return Optional.of(new class_6903.class_7862(registry.method_46770(), (class_7871)(mutable ? registry.method_46769() : registry.method_46771()), Lifecycle.experimental()));
                    BetterRegistry betterRegistry = BigGlobeMod.getClientRegistry(key);
                    if (!(betterRegistry instanceof BetterRegistry.BetterHardCodedRegistry)) return Optional.empty();
                    BetterRegistry.BetterHardCodedRegistry better = (BetterRegistry.BetterHardCodedRegistry)betterRegistry;
                    betterRegistry = better.registry;
                    if (!(betterRegistry instanceof class_2370)) return Optional.empty();
                    registry = simple = (class_2370)betterRegistry;
                    return Optional.of(new class_6903.class_7862(registry.method_46770(), (class_7871)(mutable ? registry.method_46769() : registry.method_46771()), Lifecycle.experimental()));
                }
            });
        }

        public BetterRegistry.Lookup lookup() {
            return new BetterRegistry.Lookup(){

                @Override
                public <T> BetterRegistry<T> getRegistry(class_5321<class_2378<T>> key) {
                    class_2370<T> registry = this.getRegistry(key);
                    if (registry != null) {
                        return new BetterRegistry.BetterHardCodedRegistry<T>(registry);
                    }
                    return BigGlobeMod.getClientRegistry(key);
                }
            };
        }
    }
}

