/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.blocks;

import builderb0y.bigglobe.blocks.BigGlobeBlockStateProperties;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.WeakHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class AutomataBlock
extends class_2248 {
    public static final MapCodec<AutomataBlock> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(AutomataBlock.class);
    public static final WeakHashMap<class_1922, Long2LongOpenHashMap> BURNOUT_MAP = new WeakHashMap();
    public static final int DELAY = 2;
    public final boolean natural;
    public final class_2680 full;
    public final class_2680 empty;

    public MapCodec method_53969() {
        return CODEC;
    }

    public AutomataBlock(class_4970.class_2251 settings, boolean natural) {
        super(settings);
        this.natural = natural;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BigGlobeBlockStateProperties.AUTOMATA_STATE, (Comparable)Integer.valueOf(0)));
        this.empty = this.method_9564();
        this.full = (class_2680)this.empty.method_11657((class_2769)BigGlobeBlockStateProperties.AUTOMATA_STATE, (Comparable)Integer.valueOf(2));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        class_3218 serverWorld;
        if (state == this.empty && world instanceof class_3218 && (serverWorld = (class_3218)world).method_49809(pos) > 0) {
            this.activate(serverWorld, pos, new class_2338.class_2339());
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (state == this.empty && random.method_43048(64) == 0) {
            this.activate(world, pos, new class_2338.class_2339());
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        this.tick(world, pos, state, random);
    }

    public void tick(class_3218 world, class_2338 pos, class_2680 state, class_5819 random) {
        switch ((Integer)state.method_11654((class_2769)BigGlobeBlockStateProperties.AUTOMATA_STATE)) {
            case 0: {
                class_2338.class_2339 mutablePos = new class_2338.class_2339();
                int count = this.countFull(world, pos, mutablePos);
                if (count != 1 && count != 2) break;
                this.activate(world, pos, mutablePos);
                break;
            }
            case 1: {
                this.changeState(world, pos, 0);
                break;
            }
            case 2: {
                this.changeState(world, pos, 1);
                world.method_39279(pos, (class_2248)this, 2);
            }
        }
    }

    public int countFull(class_3218 world, class_2338 pos, class_2338.class_2339 mutablePos) {
        int count = 0;
        block0: for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
            mutablePos.method_33099(pos.method_10260() + offsetZ);
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                mutablePos.method_33097(pos.method_10263() + offsetX);
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    class_2680 adjacent = world.method_8320((class_2338)mutablePos.method_33098(pos.method_10264() + offsetY));
                    class_2248 class_22482 = adjacent.method_26204();
                    if (!(class_22482 instanceof AutomataBlock)) continue;
                    AutomataBlock automata = (AutomataBlock)class_22482;
                    if (adjacent == automata.full && (this.natural || ++count >= 3)) break block0;
                }
            }
        }
        return count;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_39279(pos, (class_2248)this, 2);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        Long2LongOpenHashMap worldMap;
        super.method_9536(state, world, pos, newState, moved);
        if (this.natural && (worldMap = BURNOUT_MAP.get(world)) != null) {
            worldMap.remove(pos.method_10063());
        }
    }

    public void activate(class_3218 world, class_2338 pos, class_2338.class_2339 mutablePos) {
        if (this.natural) {
            Long2LongOpenHashMap worldMap = BURNOUT_MAP.computeIfAbsent((class_1922)world, $ -> new Long2LongOpenHashMap());
            long time = world.method_8510();
            long deadline = worldMap.put(pos.method_10063(), time + 20L);
            if (deadline > time) {
                return;
            }
        }
        this.changeState(world, pos, 2);
        world.method_39279(pos, (class_2248)this, 2);
        for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
            mutablePos.method_33099(pos.method_10260() + offsetZ);
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                mutablePos.method_33097(pos.method_10263() + offsetX);
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    class_2680 adjacent;
                    class_2248 class_22482;
                    if (offsetX == 0 && offsetY == 0 && offsetZ == 0 || !((class_22482 = (adjacent = world.method_8320((class_2338)mutablePos.method_33098(pos.method_10264() + offsetY))).method_26204()) instanceof AutomataBlock)) continue;
                    AutomataBlock automata = (AutomataBlock)class_22482;
                    if (adjacent != automata.empty) continue;
                    world.method_39279((class_2338)mutablePos, (class_2248)automata, 2);
                }
            }
        }
    }

    public void changeState(class_3218 world, class_2338 pos, int toState) {
        world.method_8427(pos, (class_2248)this, 0, toState);
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)BigGlobeBlockStateProperties.AUTOMATA_STATE, (Comparable)Integer.valueOf(data)), 2);
        return false;
    }

    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{BigGlobeBlockStateProperties.AUTOMATA_STATE});
    }
}

