/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.chunkgen;

import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.chunkgen.scripted.SegmentList;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.overriders.ColumnValueOverrider;
import builderb0y.bigglobe.structures.ScriptStructures;
import builderb0y.bigglobe.versions.BlockStateVersions;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2682;

public class QuadHolder<T> {
    public T object00;
    public T object01;
    public T object10;
    public T object11;

    public QuadHolder() {
    }

    public QuadHolder(T object00, T object01, T object10, T object11) {
        this.set(object00, object01, object10, object11);
    }

    public void set(T object00, T object01, T object10, T object11) {
        this.object00 = object00;
        this.object01 = object01;
        this.object10 = object10;
        this.object11 = object11;
    }

    public void loadFromArray(T[] array, int baseIndex, int zSkip) {
        this.object00 = array[baseIndex];
        this.object01 = array[baseIndex + 1];
        this.object10 = array[baseIndex + zSkip];
        this.object11 = array[baseIndex + zSkip + 1];
    }

    public void storeInArray(T[] array, int baseIndex, int zSkip) {
        array[baseIndex] = this.object00;
        array[baseIndex + 1] = this.object01;
        array[baseIndex + zSkip] = this.object10;
        array[baseIndex + zSkip + 1] = this.object11;
    }

    public boolean allNull() {
        return this.object00 == null && this.object01 == null && this.object10 == null && this.object11 == null;
    }

    public boolean anyNull() {
        return this.object00 == null || this.object01 == null || this.object10 == null || this.object11 == null;
    }

    public boolean allNotNull() {
        return this.object00 != null && this.object01 != null && this.object10 != null && this.object11 != null;
    }

    public boolean anyNotNull() {
        return this.object00 != null || this.object01 != null || this.object10 != null || this.object11 != null;
    }

    public static void generate(QuadColumn columns, QuadList lists, Layer layer) {
        layer.emitSegments((ScriptedColumn)columns.object00, (ScriptedColumn)columns.object01, (ScriptedColumn)columns.object10, (ScriptedColumn)columns.object11, (BlockSegmentList)((Object)lists.object00));
        layer.emitSegments((ScriptedColumn)columns.object01, (ScriptedColumn)columns.object00, (ScriptedColumn)columns.object11, (ScriptedColumn)columns.object10, (BlockSegmentList)((Object)lists.object01));
        layer.emitSegments((ScriptedColumn)columns.object10, (ScriptedColumn)columns.object11, (ScriptedColumn)columns.object00, (ScriptedColumn)columns.object01, (BlockSegmentList)((Object)lists.object10));
        layer.emitSegments((ScriptedColumn)columns.object11, (ScriptedColumn)columns.object10, (ScriptedColumn)columns.object01, (ScriptedColumn)columns.object00, (BlockSegmentList)((Object)lists.object11));
    }

    public static class QuadColumn
    extends QuadHolder<ScriptedColumn> {
        public QuadColumn() {
        }

        public QuadColumn(ScriptedColumn object00, ScriptedColumn object01, ScriptedColumn object10, ScriptedColumn object11) {
            super(object00, object01, object10, object11);
        }

        public void at(ScriptedColumn.Params params, int x, int z, int step) {
            ((ScriptedColumn)this.object00).setParamsUnchecked(params.at(x, z));
            ((ScriptedColumn)this.object01).setParamsUnchecked(params.at(x + step, z));
            ((ScriptedColumn)this.object10).setParamsUnchecked(params.at(x, z + step));
            ((ScriptedColumn)this.object11).setParamsUnchecked(params.at(x + step, z + step));
        }

        public void preComputeColumnValue(String name) throws Throwable {
            ((ScriptedColumn)this.object00).preComputeColumnValue(name);
            ((ScriptedColumn)this.object01).preComputeColumnValue(name);
            ((ScriptedColumn)this.object10).preComputeColumnValue(name);
            ((ScriptedColumn)this.object11).preComputeColumnValue(name);
        }

        public void override(ColumnValueOverrider.Holder overrider, ScriptStructures structures) {
            overrider.override((ScriptedColumn)this.object00, structures);
            overrider.override((ScriptedColumn)this.object01, structures);
            overrider.override((ScriptedColumn)this.object10, structures);
            overrider.override((ScriptedColumn)this.object11, structures);
        }
    }

    public static class QuadList
    extends QuadHolder<BlockSegmentList> {
        public QuadList() {
        }

        public QuadList(BlockSegmentList object00, BlockSegmentList object01, BlockSegmentList object10, BlockSegmentList object11) {
            super(object00, object01, object10, object11);
        }

        public void createNew(int minY, int maxY) {
            this.object00 = new BlockSegmentList(minY, maxY);
            this.object01 = new BlockSegmentList(minY, maxY);
            this.object10 = new BlockSegmentList(minY, maxY);
            this.object11 = new BlockSegmentList(minY, maxY);
        }

        public void computeLightLevels(byte topLightLevel) {
            ((BlockSegmentList)((Object)this.object00)).computeLightLevels(topLightLevel);
            ((BlockSegmentList)((Object)this.object01)).computeLightLevels(topLightLevel);
            ((BlockSegmentList)((Object)this.object10)).computeLightLevels(topLightLevel);
            ((BlockSegmentList)((Object)this.object11)).computeLightLevels(topLightLevel);
        }

        public void downscale(int deltaLod) {
            this.object00 = QuadList.downscaleColumn((BlockSegmentList)((Object)this.object00), deltaLod);
            this.object01 = QuadList.downscaleColumn((BlockSegmentList)((Object)this.object01), deltaLod);
            this.object10 = QuadList.downscaleColumn((BlockSegmentList)((Object)this.object10), deltaLod);
            this.object11 = QuadList.downscaleColumn((BlockSegmentList)((Object)this.object11), deltaLod);
        }

        public void downscaleKeepAir(int deltaLod) {
            this.object00 = QuadList.downscaleColumnKeepAir((BlockSegmentList)((Object)this.object00), deltaLod);
            this.object01 = QuadList.downscaleColumnKeepAir((BlockSegmentList)((Object)this.object01), deltaLod);
            this.object10 = QuadList.downscaleColumnKeepAir((BlockSegmentList)((Object)this.object10), deltaLod);
            this.object11 = QuadList.downscaleColumnKeepAir((BlockSegmentList)((Object)this.object11), deltaLod);
        }

        public static BlockSegmentList downscaleColumn(BlockSegmentList list, int deltaLod) {
            BlockSegmentList newList = new BlockSegmentList(list.minY >> deltaLod, (list.maxY >> deltaLod) + 1);
            ObjectListIterator objectListIterator = list.iterator();
            while (objectListIterator.hasNext()) {
                BlockSegmentList.LitSegment existing;
                BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)objectListIterator.next();
                int minY = segment.minY >> deltaLod;
                int maxY = segment.maxY >> deltaLod;
                if (((class_2680)segment.value).method_26215()) {
                    existing = (BlockSegmentList.LitSegment)newList.getOverlappingSegment(minY);
                    if (existing != null && !((class_2680)existing.value).method_26215()) {
                        minY = Math.max(minY, existing.maxY + 1);
                    }
                } else if (((class_2680)segment.value).method_26204() instanceof class_2404 && (existing = (BlockSegmentList.LitSegment)newList.getOverlappingSegment(minY)) != null && !((class_2680)existing.value).method_26215() && ((class_2680)existing.value).method_26227().method_15769()) {
                    minY = Math.min(Math.max(minY, existing.maxY + 1), maxY);
                }
                newList.addSegment(minY, maxY, (class_2680)segment.value);
            }
            return newList;
        }

        public BlockSegmentList merge() {
            BlockSegmentList result = new BlockSegmentList(((BlockSegmentList)((Object)this.object00)).minY(), ((BlockSegmentList)((Object)this.object00)).maxY());
            result.addAllSegments((SegmentList)((Object)this.object00));
            QuadList.copyAir((BlockSegmentList)((Object)this.object01), result);
            QuadList.copyAir((BlockSegmentList)((Object)this.object10), result);
            QuadList.copyAir((BlockSegmentList)((Object)this.object11), result);
            return result;
        }

        public static void copyAir(BlockSegmentList source, BlockSegmentList destination) {
            ObjectListIterator objectListIterator = source.iterator();
            while (objectListIterator.hasNext()) {
                BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)objectListIterator.next();
                if (BlockStateVersions.isOpaqueFullCube((class_2680)segment.value, (class_1922)class_2682.field_12294, class_2338.field_10980)) continue;
                destination.addSegment(segment.minY, segment.maxY, (class_2680)segment.value);
                BlockSegmentList.LitSegment newSegment = (BlockSegmentList.LitSegment)destination.getOverlappingSegment(segment.minY);
                newSegment.skylightLevel = (byte)Math.max(newSegment.skylightLevel, segment.skylightLevel);
            }
        }

        public static BlockSegmentList downscaleColumnKeepAir(BlockSegmentList list, int deltaLod) {
            BlockSegmentList newList = new BlockSegmentList(list.minY >> deltaLod, (list.maxY >> deltaLod) + 1);
            ObjectListIterator objectListIterator = list.iterator();
            while (objectListIterator.hasNext()) {
                BlockSegmentList.LitSegment newSegment;
                BlockSegmentList.LitSegment existing;
                BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)objectListIterator.next();
                int minY = segment.minY >> deltaLod;
                int maxY = segment.maxY >> deltaLod;
                if (BlockStateVersions.isOpaqueFullCube((class_2680)segment.value, (class_1922)class_2682.field_12294, class_2338.field_10980) && (existing = (BlockSegmentList.LitSegment)newList.getOverlappingSegment(minY)) != null) {
                    minY = Math.max(minY, existing.maxY + 1);
                }
                if ((newSegment = (BlockSegmentList.LitSegment)newList.addSegment(minY, maxY, (class_2680)segment.value)) == null) continue;
                newSegment.skylightLevel = segment.skylightLevel;
            }
            return newList;
        }
    }
}

