/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.chunkgen;

import builderb0y.bigglobe.chunkgen.perSection.SectionUtil;
import builderb0y.bigglobe.mixins.SingularPalette_EntryAccess;
import builderb0y.bigglobe.util.Tripwire;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_6490;

public class SectionGenerationContext {
    public final class_2791 chunk;
    public final class_2826 section;
    public final int sectionStartY;

    public SectionGenerationContext(class_2791 chunk, class_2826 section, int sectionStartY) {
        if ((sectionStartY & 0xF) != 0) {
            throw new IllegalArgumentException("sectionStartY should be divisible by 16");
        }
        this.chunk = chunk;
        this.section = section;
        this.sectionStartY = sectionStartY;
    }

    public static SectionGenerationContext forSectionIndex(class_2791 chunk, class_2826 section, int index) {
        return new SectionGenerationContext(chunk, section, chunk.method_31604(index) << 4);
    }

    public static SectionGenerationContext forSectionCoord(class_2791 chunk, class_2826 section, int sectionCoord) {
        return new SectionGenerationContext(chunk, section, sectionCoord << 4);
    }

    public static SectionGenerationContext forBlockCoord(class_2791 chunk, class_2826 section, int blockCoord) {
        return new SectionGenerationContext(chunk, section, blockCoord);
    }

    public class_2791 chunk() {
        return this.chunk;
    }

    public class_1923 chunkPos() {
        return this.chunk.method_12004();
    }

    public class_2826 section() {
        return this.section;
    }

    public class_2841<class_2680> container() {
        return this.section.method_12265();
    }

    public class_2837<class_2680> palette() {
        return SectionUtil.palette(this.container());
    }

    public class_6490 storage() {
        return SectionUtil.storage(this.container());
    }

    public int id(class_2680 state) {
        return SectionUtil.id(this.container(), state);
    }

    public int sectionX() {
        return this.chunkPos().field_9181;
    }

    public int sectionY() {
        return this.sectionStartY >> 4;
    }

    public int sectionZ() {
        return this.chunkPos().field_9180;
    }

    public int startX() {
        return this.chunkPos().method_8326();
    }

    public int startY() {
        return this.sectionStartY;
    }

    public int startZ() {
        return this.chunkPos().method_8328();
    }

    public int endX() {
        return this.startX() | 0xF;
    }

    public int endY() {
        return this.startY() | 0xF;
    }

    public int endZ() {
        return this.startZ() | 0xF;
    }

    public void setAllStates(class_2680 state, boolean distantHorizons) {
        class_2837<class_2680> class_28372 = this.palette();
        if (class_28372 instanceof SingularPalette_EntryAccess) {
            SingularPalette_EntryAccess singular = (SingularPalette_EntryAccess)class_28372;
            singular.bigglobe_setEntry(state);
        } else {
            if (Tripwire.isEnabled() && !distantHorizons) {
                Tripwire.logWithStackTrace(String.valueOf(this) + " does not have a SingularPalette.");
            }
            long payload = this.id(state);
            class_6490 storage = this.storage();
            for (int bits = storage.method_34896(); bits < 64; bits <<= 1) {
                payload |= payload << bits;
            }
            Arrays.fill(storage.method_15212(), payload);
        }
    }

    public void recalculateCounts() {
        this.section.method_12253();
    }

    public String toString() {
        return "SectionGenerationContext: { at: " + this.sectionX() + ", " + this.sectionY() + ", " + this.sectionZ() + " (world position: " + this.startX() + ", " + this.startY() + ", " + this.startZ() + " -> " + this.endX() + ", " + this.endY() + ", " + this.endZ() + "), chunk: " + String.valueOf(this.chunk()) + ", section: " + String.valueOf(this.section()) + ", palette: " + String.valueOf(this.palette()) + ", storage: " + String.valueOf(this.storage()) + " }";
    }
}

